/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.searchuser;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.FlexTable;
import com.openkm.frontend.client.Main;

public class ExtendedFlexTable
extends FlexTable {
    private int mouseX = 0;
    private int mouseY = 0;
    private boolean panelSelected = true;
    private int selectedRow = -1;

    public ExtendedFlexTable() {
        this.sinkEvents(126);
        this.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ExtendedFlexTable.this.markSelectedRow(ExtendedFlexTable.this.getCellForEvent(event).getRowIndex());
            }
        });
    }

    public void onBrowserEvent(Event event) {
        int selectedRow = 0;
        if (DOM.eventGetType((Event)event) == 2 || DOM.eventGetType((Event)event) == 4) {
            Element td = this.getMouseEventTargetCell(event);
            if (td == null) {
                return;
            }
            Element tr = DOM.getParent((Element)td);
            Element body = DOM.getParent((Element)tr);
            selectedRow = DOM.getChildIndex((Element)body, (Element)tr);
        }
        if (selectedRow >= 0) {
            this.mouseX = DOM.eventGetClientX((Event)event);
            this.mouseY = DOM.eventGetClientY((Event)event);
            if (DOM.eventGetType((Event)event) == 2) {
                DOM.eventCancelBubble((Event)event, (boolean)true);
                Main.get().mainPanel.search.historySearch.userNews.getSearch();
            } else if (DOM.eventGetType((Event)event) == 4) {
                switch (DOM.eventGetButton((Event)event)) {
                    case 2: {
                        this.markSelectedRow(selectedRow);
                        Main.get().mainPanel.search.historySearch.userNews.showMenu();
                        DOM.eventPreventDefault((Event)event);
                        break;
                    }
                }
            }
        }
        super.onBrowserEvent(event);
    }

    private void markSelectedRow(int row) {
        this.setSelectedPanel(true);
        if (row != this.selectedRow) {
            this.styleRow(this.selectedRow, false);
            this.styleRow(row, true);
            this.selectedRow = row;
        }
    }

    private Element getMouseEventTargetCell(Event event) {
        Element td = DOM.eventGetTarget((Event)event);
        while (!DOM.getElementProperty((Element)td, (String)"tagName").equalsIgnoreCase("td")) {
            if (td == null || td == this.getElement()) {
                return null;
            }
            td = DOM.getParent((Element)td);
        }
        Element tr = DOM.getParent((Element)td);
        Element body = DOM.getParent((Element)tr);
        if (body == this.getBodyElement()) {
            return td;
        }
        return null;
    }

    public void setSelectedPanel(boolean selected) {
        if (!this.isPanelSelected() && selected) {
            Main.get().mainPanel.search.searchBrowser.searchResult.setSelectedPanel(false);
        }
        if (selected) {
            Main.get().mainPanel.search.historySearch.scrollSearchSavedPanel.addStyleName("okm-PanelSelected");
            Main.get().mainPanel.search.historySearch.scrollUserNewsSavedPanel.addStyleName("okm-PanelSelected");
        } else {
            Main.get().mainPanel.search.historySearch.scrollSearchSavedPanel.removeStyleName("okm-PanelSelected");
            Main.get().mainPanel.search.historySearch.scrollUserNewsSavedPanel.removeStyleName("okm-PanelSelected");
        }
        this.panelSelected = selected;
    }

    public void styleRow(int row, boolean selected) {
        if (row >= 0) {
            if (selected) {
                this.getRowFormatter().addStyleName(row, "okm-SearchSaved-SelectedRow");
            } else {
                this.getRowFormatter().removeStyleName(row, "okm-SearchSaved-SelectedRow");
            }
        }
    }

    public void removeAllRows() {
        this.selectedRow = -1;
        super.removeAllRows();
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }

    public void setSelectedRow(int row) {
        if (row > 0 && row < this.getRowCount()) {
            if (this.selectedRow > 0) {
                this.styleRow(this.selectedRow, false);
            }
            this.styleRow(row, true);
            this.selectedRow = row;
        }
    }

    public void removeSelectedRow() {
        if (this.selectedRow > 0) {
            this.styleRow(this.selectedRow, false);
        }
        this.selectedRow = -1;
    }

    public void selectPrevRow() {
        if (this.getRowCount() > 1) {
            if (this.selectedRow > 1) {
                --this.selectedRow;
            }
            this.styleRow(this.selectedRow, true);
        } else {
            this.selectedRow = -1;
        }
    }

    public boolean isPanelSelected() {
        return this.panelSelected;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }
}

