/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.searchuser;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTQueryParams;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMDashboardService;
import com.openkm.frontend.client.service.OKMDashboardServiceAsync;
import com.openkm.frontend.client.service.OKMSearchService;
import com.openkm.frontend.client.service.OKMSearchServiceAsync;
import com.openkm.frontend.client.util.OKMBundleResources;
import com.openkm.frontend.client.widget.searchuser.ExtendedFlexTable;
import com.openkm.frontend.client.widget.searchuser.MenuPopup;
import com.openkm.frontend.client.widget.searchuser.Status;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UserNews
extends Composite {
    private final OKMDashboardServiceAsync dashboardService = (OKMDashboardServiceAsync)GWT.create(OKMDashboardService.class);
    private final OKMSearchServiceAsync searchService = (OKMSearchServiceAsync)GWT.create(OKMSearchService.class);
    private ExtendedFlexTable table;
    public MenuPopup menuPopup;
    private Status status;
    private boolean firstTime = true;
    public Map<Integer, GWTQueryParams> data;
    private int dataIndexValue = 0;
    private int searchIdToDelete = 0;
    final AsyncCallback<List<GWTQueryParams>> callbackGetUserSearchs = new AsyncCallback<List<GWTQueryParams>>(){

        public void onSuccess(List<GWTQueryParams> result) {
            UserNews.this.table.removeAllRows();
            Iterator<GWTQueryParams> it = result.iterator();
            while (it.hasNext()) {
                UserNews.this.addRow(it.next());
            }
            if (!UserNews.this.firstTime) {
                UserNews.this.status.unsetFlag_getUserNews();
            } else {
                UserNews.this.firstTime = false;
            }
        }

        public void onFailure(Throwable caught) {
            if (!UserNews.this.firstTime) {
                UserNews.this.status.unsetFlag_getUserNews();
            } else {
                UserNews.this.firstTime = false;
            }
            Main.get().showError("GetSearchs", caught);
        }
    };
    final AsyncCallback<Object> callbackDeleteSearch = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            UserNews.this.table.removeRow(UserNews.this.getSelectedRow());
            UserNews.this.table.selectPrevRow();
            UserNews.this.data.remove(new Integer(UserNews.this.searchIdToDelete));
            Main.get().mainPanel.dashboard.newsDashboard.getUserSearchs(true);
            UserNews.this.status.unsetFlag_deleteSearch();
        }

        public void onFailure(Throwable caught) {
            UserNews.this.status.unsetFlag_deleteSearch();
            Main.get().showError("DeleteSearch", caught);
        }
    };

    public UserNews() {
        this.data = new HashMap<Integer, GWTQueryParams>();
        this.table = new ExtendedFlexTable();
        this.menuPopup = new MenuPopup();
        this.menuPopup.setStyleName("okm-SearchSaved-MenuPopup");
        this.status = new Status();
        this.status.setStyleName("okm-StatusPopup");
        this.table.setBorderWidth(0);
        this.table.setCellSpacing(0);
        this.table.setCellSpacing(0);
        this.table.sinkEvents(6);
        this.initWidget((Widget)this.table);
    }

    public void init() {
        this.getUserSearchs();
    }

    public void showMenu() {
        this.menuPopup.setPopupPosition(this.table.getMouseX(), this.table.getMouseY());
        this.menuPopup.show();
    }

    public int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    public void addNewSavedSearch(GWTQueryParams search) {
        this.addRow(search);
    }

    public void addRow(GWTQueryParams search) {
        int rows = this.table.getRowCount();
        this.data.put(this.dataIndexValue, search);
        if (!search.isShared()) {
            this.table.setHTML(rows, 0, "&nbsp;");
        } else {
            this.table.setWidget(rows, 0, (Widget)new Image(OKMBundleResources.INSTANCE.sharedQuery()));
        }
        this.table.setHTML(rows, 1, search.getQueryName());
        this.table.setHTML(rows, 2, "" + this.dataIndexValue++);
        this.table.setHTML(rows, 3, "");
        this.table.getFlexCellFormatter().setVisible(rows, 2, false);
        HTMLTable.CellFormatter cellFormatter = this.table.getCellFormatter();
        cellFormatter.setWidth(rows, 0, "30");
        cellFormatter.setHeight(rows, 0, "20");
        cellFormatter.setHorizontalAlignment(rows, 0, HasAlignment.ALIGN_CENTER);
        cellFormatter.setVerticalAlignment(rows, 0, HasAlignment.ALIGN_MIDDLE);
        cellFormatter.setWidth(rows, 3, "100%");
        this.table.getRowFormatter().setStyleName(rows, "okm-userNews");
        this.setRowWordWarp(rows, 4, false);
    }

    private void setRowWordWarp(int row, int columns, boolean warp) {
        HTMLTable.CellFormatter cellFormatter = this.table.getCellFormatter();
        for (int i = 0; i < columns; ++i) {
            cellFormatter.setWordWrap(row, i, false);
        }
    }

    public void getUserSearchs() {
        if (!this.firstTime) {
            this.status.setFlag_getUserNews();
        }
        ServiceDefTarget endPoint = (ServiceDefTarget)this.dashboardService;
        endPoint.setServiceEntryPoint(RPCService.DashboardService);
        this.dashboardService.getUserSearchs(this.callbackGetUserSearchs);
    }

    public void getSearch() {
        if (this.getSelectedRow() >= 0) {
            int id = Integer.parseInt(this.table.getText(this.getSelectedRow(), 2));
            Main.get().mainPanel.search.searchBrowser.searchResult.getSearch(this.data.get(new Integer(id)));
        }
    }

    public GWTQueryParams getSavedSearch() {
        if (this.getSelectedRow() >= 0) {
            int id = Integer.parseInt(this.table.getText(this.getSelectedRow(), 2));
            return this.data.get(new Integer(id));
        }
        return null;
    }

    public void deleteSearch() {
        if (this.getSelectedRow() >= 0) {
            this.status.setFlag_deleteSearch();
            this.searchIdToDelete = Integer.parseInt(this.table.getText(this.getSelectedRow(), 2));
            ServiceDefTarget endPoint = (ServiceDefTarget)this.searchService;
            endPoint.setServiceEntryPoint(RPCService.SearchService);
            if (!this.getSavedSearch().isShared()) {
                this.searchService.deleteSearch(this.data.get(new Integer(this.searchIdToDelete)).getId(), this.callbackDeleteSearch);
            } else {
                this.searchService.unshare(this.data.get(new Integer(this.searchIdToDelete)).getId(), this.callbackDeleteSearch);
            }
        }
    }

    public void setSelectedPanel(boolean selected) {
        this.table.setSelectedPanel(selected);
    }

    public boolean isPanelSelected() {
        return this.table.isPanelSelected();
    }

    public void langRefresh() {
        this.menuPopup.langRefresh();
    }
}

