/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.security;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TabBar;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.widget.security.SecurityRole;
import com.openkm.frontend.client.widget.security.SecurityUser;
import com.openkm.frontend.client.widget.security.Status;

public class SecurityPopup
extends DialogBox
implements ClickHandler {
    private static final int TAB_USERS = 0;
    private static final int TAB_GROUPS = 1;
    public Status status = new Status();
    private VerticalPanel vPanel = new VerticalPanel();
    private TabPanel tabPanel;
    public SecurityUser securityUser = new SecurityUser();
    public SecurityRole securityRole = new SecurityRole();
    public CheckBox recursive;
    private Button button;
    private SimplePanel sp;
    private boolean filterView = false;
    private CheckBox checkBoxFilter;
    private TextBox filter;
    private HorizontalPanel filterPanel;
    private HTML filterText;
    private String usersFilter = "";
    private String groupsFilter = "";

    public SecurityPopup() {
        super(false, true);
        this.tabPanel = new TabPanel();
        this.sp = new SimplePanel();
        this.recursive = new CheckBox(Main.i18n("security.recursive"));
        this.button = new Button(Main.i18n("button.close"), (ClickHandler)this);
        this.vPanel.setWidth("600");
        this.vPanel.setHeight("400");
        this.sp.setHeight("4");
        this.tabPanel.add((Widget)this.securityUser, Main.i18n("security.users"));
        this.tabPanel.add((Widget)this.securityRole, Main.i18n("security.groups"));
        this.tabPanel.selectTab(0);
        this.tabPanel.setWidth("100%");
        this.tabPanel.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                switch ((Integer)event.getSelectedItem()) {
                    case 0: {
                        SecurityPopup.this.groupsFilter = SecurityPopup.this.filter.getText();
                        SecurityPopup.this.filter.setText(SecurityPopup.this.usersFilter);
                        SecurityPopup.this.filterText.setHTML(Main.i18n("security.filter.by.users"));
                        SecurityPopup.this.securityUser.fillWidth();
                        break;
                    }
                    case 1: {
                        SecurityPopup.this.usersFilter = SecurityPopup.this.filter.getText();
                        SecurityPopup.this.filter.setText(SecurityPopup.this.groupsFilter);
                        SecurityPopup.this.filterText.setHTML(Main.i18n("security.filter.by.groups"));
                        SecurityPopup.this.securityRole.fillWidth();
                    }
                }
            }
        });
        this.filterPanel = new HorizontalPanel();
        this.filterPanel.setVisible(false);
        this.checkBoxFilter = new CheckBox();
        this.checkBoxFilter.setValue(Boolean.valueOf(false));
        this.checkBoxFilter.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SecurityPopup.this.securityUser.resetUnassigned();
                SecurityPopup.this.securityRole.resetUnassigned();
                Widget sender = (Widget)event.getSource();
                if (((CheckBox)sender).getValue().booleanValue()) {
                    SecurityPopup.this.filter.setText("");
                    SecurityPopup.this.filter.setEnabled(true);
                } else {
                    SecurityPopup.this.filter.setText("");
                    SecurityPopup.this.filter.setEnabled(false);
                    SecurityPopup.this.usersFilter = "";
                    SecurityPopup.this.groupsFilter = "";
                    SecurityPopup.this.refreshUnassigned();
                }
            }
        });
        this.filter = new TextBox();
        this.filterText = new HTML(Main.i18n("security.filter.by.users"));
        this.filterPanel.add((Widget)this.checkBoxFilter);
        this.filterPanel.add((Widget)new HTML("&nbsp;"));
        this.filterPanel.add((Widget)this.filterText);
        this.filterPanel.add((Widget)new HTML("&nbsp;"));
        this.filterPanel.add((Widget)this.filter);
        this.filterPanel.add((Widget)new HTML("&nbsp;"));
        this.filterPanel.setCellVerticalAlignment((Widget)this.checkBoxFilter, HasAlignment.ALIGN_MIDDLE);
        this.filterPanel.setCellVerticalAlignment((Widget)this.filterText, HasAlignment.ALIGN_MIDDLE);
        this.filterPanel.setCellVerticalAlignment((Widget)this.filter, HasAlignment.ALIGN_MIDDLE);
        this.filter.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (SecurityPopup.this.filter.getText().length() >= 3) {
                    TabBar tabBar = SecurityPopup.this.tabPanel.getTabBar();
                    int selected = tabBar.getSelectedTab();
                    switch (selected) {
                        case 0: {
                            SecurityPopup.this.securityUser.getFilteredUngrantedUsers(SecurityPopup.this.filter.getText());
                            break;
                        }
                        case 1: {
                            SecurityPopup.this.securityRole.getFilteredUngrantedRoles(SecurityPopup.this.filter.getText());
                        }
                    }
                } else {
                    SecurityPopup.this.securityUser.resetUnassigned();
                    SecurityPopup.this.securityRole.resetUnassigned();
                }
            }
        });
        this.vPanel.add((Widget)this.sp);
        this.vPanel.add((Widget)this.filterPanel);
        this.vPanel.add((Widget)this.tabPanel);
        this.vPanel.add((Widget)this.recursive);
        this.vPanel.add((Widget)this.button);
        this.vPanel.setCellHeight((Widget)this.sp, "4");
        this.vPanel.setCellHeight((Widget)this.tabPanel, "365");
        this.vPanel.setCellHeight((Widget)this.recursive, "25");
        this.vPanel.setCellHeight((Widget)this.button, "25");
        this.vPanel.setCellHorizontalAlignment((Widget)this.filterPanel, VerticalPanel.ALIGN_RIGHT);
        this.vPanel.setCellHorizontalAlignment((Widget)this.tabPanel, VerticalPanel.ALIGN_CENTER);
        this.vPanel.setCellVerticalAlignment((Widget)this.tabPanel, VerticalPanel.ALIGN_TOP);
        this.vPanel.setCellHorizontalAlignment((Widget)this.button, VerticalPanel.ALIGN_CENTER);
        this.vPanel.setCellVerticalAlignment((Widget)this.button, VerticalPanel.ALIGN_MIDDLE);
        this.button.setStyleName("okm-Button");
        this.filter.setStyleName("okm-Input");
        this.status.setStyleName("okm-StatusPopup");
        super.hide();
        this.setWidget((Widget)this.vPanel);
    }

    public void onClick(ClickEvent event) {
        Main.get().mainPanel.desktop.browser.tabMultiple.securityRefresh();
        super.hide();
    }

    public void langRefresh() {
        this.setText(Main.i18n("security.label"));
        this.recursive.setText(Main.i18n("security.recursive"));
        this.button.setText(Main.i18n("button.close"));
        TabBar tabBar = this.tabPanel.getTabBar();
        int selected = tabBar.getSelectedTab();
        while (this.tabPanel.getWidgetCount() > 0) {
            this.tabPanel.remove(0);
        }
        this.tabPanel.add((Widget)this.securityUser, Main.i18n("security.users"));
        this.tabPanel.add((Widget)this.securityRole, Main.i18n("security.groups"));
        this.tabPanel.selectTab(selected);
        switch (selected) {
            case 0: {
                this.filterText.setHTML(Main.i18n("security.filter.by.users"));
                break;
            }
            case 1: {
                this.filterText.setHTML(Main.i18n("security.filter.by.groups"));
            }
        }
        this.securityUser.langRefresh();
        this.securityRole.langRefresh();
    }

    public void show(String path) {
        int left = (Window.getClientWidth() - 600) / 2;
        int top = (Window.getClientHeight() - 330) / 2;
        this.setPopupPosition(left, top);
        this.setText(Main.i18n("security.label"));
        Main.get().securityPopup.securityUser.setPath(path);
        Main.get().securityPopup.securityRole.setPath(path);
        this.securityUser.reset();
        this.securityRole.reset();
        this.filter.setText("");
        this.usersFilter = "";
        this.groupsFilter = "";
        this.securityUser.getGrantedUsers();
        this.securityRole.getGrantedRoles();
        if (!this.filterView) {
            this.securityUser.getUngrantedUsers();
            this.securityRole.getUngrantedRoles();
        }
        super.show();
        this.securityUser.fillWidth();
        this.securityRole.fillWidth();
    }

    public void refreshUnassigned() {
        this.securityUser.getUngrantedUsers();
        this.securityRole.getUngrantedRoles();
    }

    public void enableAdvancedFilter() {
        this.filterView = true;
        this.filterPanel.setVisible(true);
        this.checkBoxFilter.setValue(Boolean.valueOf(true));
    }
}

