/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.security;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMAuthService;
import com.openkm.frontend.client.service.OKMAuthServiceAsync;
import com.openkm.frontend.client.util.RoleComparator;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.widget.security.RoleScrollTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SecurityRole
extends Composite
implements HasWidgets {
    private final OKMAuthServiceAsync authService = (OKMAuthServiceAsync)GWT.create(OKMAuthService.class);
    public static final int ASSIGNED_ROLES_NUMBER_OF_COLUMNS = 5;
    public static final int UNASSIGNED_ROLES_NUMBER_OF_COLUMNS = 1;
    public RoleScrollTable assignedRole;
    public RoleScrollTable unassignedRole;
    private HorizontalPanel panel;
    private VerticalPanel buttonPanel;
    private SimplePanel spLeft;
    private SimplePanel spRight;
    private SimplePanel spHeight;
    private HTML addButton;
    private HTML removeButton;
    private String path = "";
    private String tmpRole = "";
    ClickHandler addButtonListener = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (SecurityRole.this.unassignedRole.getRole() != null) {
                SecurityRole.this.tmpRole = SecurityRole.this.unassignedRole.getRole();
                SecurityRole.this.addRole(SecurityRole.this.tmpRole, 1, Main.get().securityPopup.recursive.getValue());
            }
        }
    };
    ClickHandler removeButtonListener = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (SecurityRole.this.assignedRole.getRole() != null) {
                SecurityRole.this.tmpRole = SecurityRole.this.assignedRole.getRole();
                SecurityRole.this.revokeRole(SecurityRole.this.tmpRole, Main.get().securityPopup.recursive.getValue());
            }
        }
    };
    final AsyncCallback<Map<String, Byte>> callbackGetGrantedRoles = new AsyncCallback<Map<String, Byte>>(){

        public void onSuccess(Map<String, Byte> result) {
            ArrayList<String> rolesList = new ArrayList<String>();
            Iterator<String> it = result.keySet().iterator();
            while (it.hasNext()) {
                rolesList.add(it.next());
            }
            Collections.sort(rolesList, RoleComparator.getInstance());
            for (String groupName : rolesList) {
                Byte permission = result.get(groupName);
                SecurityRole.this.assignedRole.addRow(groupName, permission);
            }
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetGrantedRoles", caught);
        }
    };
    final AsyncCallback<List<String>> callbackGetUngrantedRoles = new AsyncCallback<List<String>>(){

        public void onSuccess(List<String> result) {
            for (String groupName : result) {
                SecurityRole.this.unassignedRole.addRow(groupName);
            }
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetUngrantedRoles", caught);
        }
    };
    final AsyncCallback<Object> callbackAddRole = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            SecurityRole.this.assignedRole.addRow(SecurityRole.this.tmpRole, new Byte(1));
            SecurityRole.this.unassignedRole.removeSelectedRow();
            SecurityRole.this.tmpRole = "";
            Main.get().securityPopup.status.unsetFlag_update();
        }

        public void onFailure(Throwable caught) {
            Main.get().securityPopup.status.unsetFlag_update();
            Main.get().showError("AddRole", caught);
        }
    };
    final AsyncCallback<Object> callbackRevokeRole = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            SecurityRole.this.unassignedRole.addRow(SecurityRole.this.tmpRole);
            SecurityRole.this.unassignedRole.selectLastRow();
            SecurityRole.this.assignedRole.removeSelectedRow();
            SecurityRole.this.tmpRole = "";
            Main.get().securityPopup.status.unsetFlag_update();
        }

        public void onFailure(Throwable caught) {
            Main.get().securityPopup.status.unsetFlag_update();
            Main.get().showError("RevokeRole", caught);
        }
    };

    public SecurityRole() {
        this.panel = new HorizontalPanel();
        this.buttonPanel = new VerticalPanel();
        this.assignedRole = new RoleScrollTable(true);
        this.unassignedRole = new RoleScrollTable(false);
        this.spLeft = new SimplePanel();
        this.spRight = new SimplePanel();
        this.spHeight = new SimplePanel();
        this.spLeft.setWidth("4");
        this.spRight.setWidth("1");
        this.spHeight.setHeight("30");
        this.addButton = new HTML(Util.imageHTML("img/icon/security/add.gif"));
        this.removeButton = new HTML(Util.imageHTML("img/icon/security/remove.gif"));
        this.buttonPanel.add((Widget)this.addButton);
        this.buttonPanel.add((Widget)this.spHeight);
        this.buttonPanel.add((Widget)this.removeButton);
        this.addButton.addClickHandler(this.addButtonListener);
        this.removeButton.addClickHandler(this.removeButtonListener);
        this.panel.add((Widget)this.spLeft);
        this.panel.add((Widget)this.assignedRole);
        this.panel.add((Widget)this.buttonPanel);
        this.panel.add((Widget)this.unassignedRole);
        this.panel.setCellWidth((Widget)this.buttonPanel, "20");
        this.panel.setCellWidth((Widget)this.spLeft, "4");
        this.panel.setCellVerticalAlignment((Widget)this.buttonPanel, HasAlignment.ALIGN_MIDDLE);
        this.panel.setCellHorizontalAlignment((Widget)this.buttonPanel, HasAlignment.ALIGN_CENTER);
        this.panel.setSize("593", "365");
        this.initWidget((Widget)this.panel);
    }

    public void langRefresh() {
        this.assignedRole.langRefresh();
        this.unassignedRole.langRefresh();
    }

    public void reset() {
        this.assignedRole.reset();
        this.unassignedRole.reset();
        this.assignedRole.getDataTable().resize(0, 5);
        this.unassignedRole.getDataTable().resize(0, 1);
    }

    public void resetUnassigned() {
        this.unassignedRole.reset();
        this.unassignedRole.getDataTable().resize(0, 1);
    }

    public void getGrantedRoles() {
        if (this.path != null) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.authService;
            endPoint.setServiceEntryPoint(RPCService.AuthService);
            this.authService.getGrantedRoles(this.path, this.callbackGetGrantedRoles);
        }
    }

    public void getUngrantedRoles() {
        if (this.path != null) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.authService;
            endPoint.setServiceEntryPoint(RPCService.AuthService);
            this.authService.getUngrantedRoles(this.path, this.callbackGetUngrantedRoles);
        }
    }

    public void getFilteredUngrantedRoles(String filter) {
        if (this.path != null) {
            this.resetUnassigned();
            ServiceDefTarget endPoint = (ServiceDefTarget)this.authService;
            endPoint.setServiceEntryPoint(RPCService.AuthService);
            this.authService.getFilteredUngrantedRoles(this.path, filter, this.callbackGetUngrantedRoles);
        }
    }

    public void addRole(String role, int permissions, boolean recursive) {
        if (this.path != null) {
            Main.get().securityPopup.status.setFlag_update();
            ServiceDefTarget endPoint = (ServiceDefTarget)this.authService;
            endPoint.setServiceEntryPoint(RPCService.AuthService);
            this.authService.grantRole(this.path, role, permissions, recursive, this.callbackAddRole);
        }
    }

    public void revokeRole(String role, boolean recursive) {
        if (this.path != null) {
            Main.get().securityPopup.status.setFlag_update();
            ServiceDefTarget endPoint = (ServiceDefTarget)this.authService;
            endPoint.setServiceEntryPoint(RPCService.AuthService);
            this.authService.revokeRole(this.path, role, recursive, this.callbackRevokeRole);
        }
    }

    public void setPath(String path) {
        this.assignedRole.setPath(path);
        this.path = path;
    }

    public void fillWidth() {
        this.assignedRole.fillWidth();
        this.unassignedRole.fillWidth();
    }

    public void add(Widget w) {
    }

    public void clear() {
    }

    public Iterator<Widget> iterator() {
        return null;
    }

    public boolean remove(Widget w) {
        return true;
    }
}

