/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.security;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMAuthService;
import com.openkm.frontend.client.service.OKMAuthServiceAsync;
import com.openkm.frontend.client.util.OKMBundleResources;
import com.openkm.frontend.client.util.UserComparator;
import com.openkm.frontend.client.widget.security.UserScrollTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SecurityUser
extends Composite
implements HasWidgets {
    private final OKMAuthServiceAsync authService = (OKMAuthServiceAsync)GWT.create(OKMAuthService.class);
    public static final int ASSIGNED_USER_NUMBER_OF_COLUMNS = 6;
    public static final int UNASSIGNED_USER_NUMBER_OF_COLUMNS = 2;
    public UserScrollTable assignedUser;
    public UserScrollTable unassignedUser;
    private HorizontalPanel panel;
    private VerticalPanel buttonPanel;
    private SimplePanel spLeft;
    private SimplePanel spRight;
    private SimplePanel spHeight;
    private Image addButton;
    private Image removeButton;
    private String path = "";
    private String tmpUser = "";
    ClickHandler addButtonHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (SecurityUser.this.unassignedUser.getUser() != null) {
                SecurityUser.this.tmpUser = SecurityUser.this.unassignedUser.getUser();
                SecurityUser.this.addUser(SecurityUser.this.tmpUser, 1, Main.get().securityPopup.recursive.getValue());
            }
        }
    };
    ClickHandler removeButtonHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (SecurityUser.this.assignedUser.getUser() != null) {
                SecurityUser.this.tmpUser = SecurityUser.this.assignedUser.getUser();
                SecurityUser.this.removeUser(SecurityUser.this.tmpUser, Main.get().securityPopup.recursive.getValue());
            }
        }
    };
    final AsyncCallback<Map<String, Byte>> callbackGetGrantedUsers = new AsyncCallback<Map<String, Byte>>(){

        public void onSuccess(Map<String, Byte> result) {
            ArrayList<String> usersList = new ArrayList<String>();
            Iterator<String> it = result.keySet().iterator();
            while (it.hasNext()) {
                usersList.add(it.next());
            }
            Collections.sort(usersList, UserComparator.getInstance());
            for (String userName : usersList) {
                Byte permission = result.get(userName);
                SecurityUser.this.assignedUser.addRow(userName, permission);
            }
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetGrantedUsers", caught);
        }
    };
    final AsyncCallback<List<String>> callbackGetUngrantedUsers = new AsyncCallback<List<String>>(){

        public void onSuccess(List<String> result) {
            for (String userName : result) {
                SecurityUser.this.unassignedUser.addRow(userName);
            }
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetUngrantedUsers", caught);
        }
    };
    final AsyncCallback<Object> callbackAddUser = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            SecurityUser.this.assignedUser.addRow(SecurityUser.this.tmpUser, new Byte(1));
            SecurityUser.this.unassignedUser.removeSelectedRow();
            SecurityUser.this.tmpUser = "";
            Main.get().securityPopup.status.unsetFlag_update();
        }

        public void onFailure(Throwable caught) {
            Main.get().securityPopup.status.unsetFlag_update();
            Main.get().showError("AddUser", caught);
        }
    };
    final AsyncCallback<Object> callbackRevokeUser = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            SecurityUser.this.unassignedUser.addRow(SecurityUser.this.tmpUser);
            SecurityUser.this.unassignedUser.selectLastRow();
            SecurityUser.this.assignedUser.removeSelectedRow();
            SecurityUser.this.tmpUser = "";
            Main.get().securityPopup.status.unsetFlag_update();
        }

        public void onFailure(Throwable caught) {
            Main.get().securityPopup.status.unsetFlag_update();
            Main.get().showError("RevokeUser", caught);
        }
    };

    public SecurityUser() {
        this.panel = new HorizontalPanel();
        this.buttonPanel = new VerticalPanel();
        this.assignedUser = new UserScrollTable(true);
        this.unassignedUser = new UserScrollTable(false);
        this.spLeft = new SimplePanel();
        this.spRight = new SimplePanel();
        this.spHeight = new SimplePanel();
        this.spLeft.setWidth("4");
        this.spRight.setWidth("1");
        this.spHeight.setHeight("30");
        this.addButton = new Image(OKMBundleResources.INSTANCE.add());
        this.removeButton = new Image(OKMBundleResources.INSTANCE.remove());
        this.buttonPanel.add((Widget)this.addButton);
        this.buttonPanel.add((Widget)this.spHeight);
        this.buttonPanel.add((Widget)this.removeButton);
        this.addButton.addClickHandler(this.addButtonHandler);
        this.removeButton.addClickHandler(this.removeButtonHandler);
        this.panel.add((Widget)this.spLeft);
        this.panel.add((Widget)this.assignedUser);
        this.panel.add((Widget)this.buttonPanel);
        this.panel.add((Widget)this.unassignedUser);
        this.panel.setCellWidth((Widget)this.buttonPanel, "20");
        this.panel.setCellWidth((Widget)this.spLeft, "4");
        this.panel.setCellVerticalAlignment((Widget)this.buttonPanel, HasAlignment.ALIGN_MIDDLE);
        this.panel.setCellHorizontalAlignment((Widget)this.buttonPanel, HasAlignment.ALIGN_CENTER);
        this.panel.setSize("593", "365");
        this.initWidget((Widget)this.panel);
    }

    public void langRefresh() {
        this.assignedUser.langRefresh();
        this.unassignedUser.langRefresh();
    }

    public void reset() {
        this.assignedUser.reset();
        this.unassignedUser.reset();
        this.assignedUser.getDataTable().resize(0, 6);
        this.unassignedUser.getDataTable().resize(0, 2);
    }

    public void resetUnassigned() {
        this.unassignedUser.reset();
        this.unassignedUser.getDataTable().resize(0, 2);
    }

    public void getGrantedUsers() {
        if (this.path != null) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.authService;
            endPoint.setServiceEntryPoint(RPCService.AuthService);
            this.authService.getGrantedUsers(this.path, this.callbackGetGrantedUsers);
        }
    }

    public void getUngrantedUsers() {
        if (this.path != null) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.authService;
            endPoint.setServiceEntryPoint(RPCService.AuthService);
            this.authService.getUngrantedUsers(this.path, this.callbackGetUngrantedUsers);
        }
    }

    public void getFilteredUngrantedUsers(String filter) {
        if (this.path != null) {
            this.resetUnassigned();
            ServiceDefTarget endPoint = (ServiceDefTarget)this.authService;
            endPoint.setServiceEntryPoint(RPCService.AuthService);
            this.authService.getFilteredUngrantedUsers(this.path, filter, this.callbackGetUngrantedUsers);
        }
    }

    public void addUser(String user, int permissions, boolean recursive) {
        if (this.path != null) {
            Main.get().securityPopup.status.setFlag_update();
            ServiceDefTarget endPoint = (ServiceDefTarget)this.authService;
            endPoint.setServiceEntryPoint(RPCService.AuthService);
            this.authService.grantUser(this.path, user, permissions, recursive, this.callbackAddUser);
        }
    }

    public void removeUser(String user, boolean recursive) {
        if (this.path != null) {
            Main.get().securityPopup.status.setFlag_update();
            ServiceDefTarget endPoint = (ServiceDefTarget)this.authService;
            endPoint.setServiceEntryPoint(RPCService.AuthService);
            this.authService.revokeUser(this.path, user, recursive, this.callbackRevokeUser);
        }
    }

    public void setPath(String path) {
        this.assignedUser.setPath(path);
        this.path = path;
    }

    public void fillWidth() {
        this.assignedUser.fillWidth();
        this.unassignedUser.fillWidth();
    }

    public void add(Widget w) {
    }

    public void clear() {
    }

    public Iterator<Widget> iterator() {
        return null;
    }

    public boolean remove(Widget w) {
        return true;
    }
}

