/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.startup;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.openkm.extension.frontend.client.Customization;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTFolder;
import com.openkm.frontend.client.bean.GWTUserConfig;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.extension.ExtensionManager;
import com.openkm.frontend.client.service.OKMAuthService;
import com.openkm.frontend.client.service.OKMAuthServiceAsync;
import com.openkm.frontend.client.service.OKMDocumentService;
import com.openkm.frontend.client.service.OKMDocumentServiceAsync;
import com.openkm.frontend.client.service.OKMFolderService;
import com.openkm.frontend.client.service.OKMFolderServiceAsync;
import com.openkm.frontend.client.service.OKMGeneralService;
import com.openkm.frontend.client.service.OKMGeneralServiceAsync;
import com.openkm.frontend.client.service.OKMRepositoryService;
import com.openkm.frontend.client.service.OKMRepositoryServiceAsync;
import com.openkm.frontend.client.service.OKMUserConfigService;
import com.openkm.frontend.client.service.OKMUserConfigServiceAsync;
import com.openkm.frontend.client.util.CommonUI;
import com.openkm.frontend.client.util.Util;
import java.util.List;
import java.util.Map;

public class StartUp {
    public static final int STARTUP_STARTING = 0;
    public static final int STARTUP_GET_USER_VALUES = 1;
    public static final int STARTUP_GET_TAXONOMY_ROOT = 2;
    public static final int STARTUP_GET_CATEGORIES_ROOT = 3;
    public static final int STARTUP_GET_THESAURUS_ROOT = 4;
    public static final int STARTUP_GET_TEMPLATE_ROOT = 5;
    public static final int STARTUP_GET_PERSONAL = 6;
    public static final int STARTUP_GET_MAIL = 7;
    public static final int STARTUP_GET_TRASH = 8;
    public static final int STARTUP_GET_USER_HOME = 9;
    public static final int STARTUP_GET_BOOKMARKS = 10;
    public static final int STARTUP_INIT_TREE_NODES = 11;
    public static final int STARTUP_LOADING_HISTORY_SEARCH = 12;
    public static final int STARTUP_LOADING_TAXONOMY_EVAL_PARAMS = 13;
    public static final int STARTUP_LOADING_OPEN_PATH = 14;
    private final OKMRepositoryServiceAsync repositoryService = (OKMRepositoryServiceAsync)GWT.create(OKMRepositoryService.class);
    private final OKMAuthServiceAsync authService = (OKMAuthServiceAsync)GWT.create(OKMAuthService.class);
    private final OKMUserConfigServiceAsync userConfigService = (OKMUserConfigServiceAsync)GWT.create(OKMUserConfigService.class);
    private final OKMGeneralServiceAsync generalService = (OKMGeneralServiceAsync)GWT.create(OKMGeneralService.class);
    private final OKMFolderServiceAsync folderService = (OKMFolderServiceAsync)GWT.create(OKMFolderService.class);
    private final OKMDocumentServiceAsync documentService = (OKMDocumentServiceAsync)GWT.create(OKMDocumentService.class);
    private boolean enabled = true;
    private boolean error = false;
    private int status = -1;
    private String docPath = null;
    private String fldPath = null;
    private String taskInstanceId = null;
    private String refreshTasks = null;
    public Timer keepAlive;
    final AsyncCallback<GWTFolder> callbackGetRootFolder = new AsyncCallback<GWTFolder>(){

        public void onSuccess(GWTFolder result) {
            Main.get().taxonomyRootFolder = result;
            Main.get().mainPanel.desktop.browser.fileBrowser.table.fillWidth();
            StartUp.this.nextStatus(3);
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetRootFolder", caught);
        }
    };
    final AsyncCallback<GWTFolder> callbackGetTemplatesFolder = new AsyncCallback<GWTFolder>(){

        public void onSuccess(GWTFolder result) {
            Main.get().templatesRootFolder = result;
            StartUp.this.nextStatus(6);
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetTemplatesFolder", caught);
        }
    };
    final AsyncCallback<GWTFolder> callbackGetMailFolder = new AsyncCallback<GWTFolder>(){

        public void onSuccess(GWTFolder result) {
            Main.get().mailRootFolder = result;
            StartUp.this.nextStatus(8);
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetMailFolder", caught);
        }
    };
    final AsyncCallback<GWTFolder> callbackGetThesaurusFolder = new AsyncCallback<GWTFolder>(){

        public void onSuccess(GWTFolder result) {
            Main.get().thesaurusRootFolder = result;
            StartUp.this.nextStatus(5);
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetThesaurusFolder", caught);
        }
    };
    final AsyncCallback<GWTFolder> callbackGetCategoriesFolder = new AsyncCallback<GWTFolder>(){

        public void onSuccess(GWTFolder result) {
            Main.get().categoriesRootFolder = result;
            StartUp.this.nextStatus(4);
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetCategoriesFolder", caught);
        }
    };
    final AsyncCallback<GWTUserConfig> callbackGetUserHome = new AsyncCallback<GWTUserConfig>(){

        public void onSuccess(GWTUserConfig result) {
            Main.get().userHome = result;
            StartUp.this.nextStatus(10);
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetUserHome", caught);
        }
    };
    final AsyncCallback<GWTFolder> callbackGetPersonalFolder = new AsyncCallback<GWTFolder>(){

        public void onSuccess(GWTFolder result) {
            Main.get().personalRootFolder = result;
            StartUp.this.nextStatus(7);
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetPersonalFolder", caught);
        }
    };
    final AsyncCallback<GWTFolder> callbackGetTrashFolder = new AsyncCallback<GWTFolder>(){

        public void onSuccess(GWTFolder result) {
            Main.get().trashRootFolder = result;
            StartUp.this.nextStatus(9);
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetTrashFolder", caught);
        }
    };
    final AsyncCallback<Object> callbackKeepAlive = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.bottomPanel.setStatus("status.keep.alive.error", true);
        }
    };
    final AsyncCallback<Map<String, String>> callbackGetPropertyGroupTranslations = new AsyncCallback<Map<String, String>>(){

        public void onSuccess(Map<String, String> result) {
            Main.get().hPropertyGroupI18n = result;
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetPropertyGroupTranslations", caught);
        }
    };

    public void init() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.generalService;
        endPoint.setServiceEntryPoint(RPCService.GeneralService);
        this.generalService.getEnabledExtensions(new AsyncCallback<List<String>>(){

            public void onSuccess(List<String> result) {
                Main.get().setExtensionUuidList(result);
                ExtensionManager.start(Customization.getExtensionWidgets(result));
                StartUp.this.nextStatus(0);
            }

            public void onFailure(Throwable caught) {
                Main.get().showError("getEnabledExtensions", caught);
                StartUp.this.nextStatus(0);
            }
        });
    }

    public void getTrash() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.repositoryService;
        endPoint.setServiceEntryPoint(RPCService.RepositoryService);
        this.repositoryService.getTrashFolder(this.callbackGetTrashFolder);
    }

    public void getPersonal() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.repositoryService;
        endPoint.setServiceEntryPoint(RPCService.RepositoryService);
        this.repositoryService.getPersonalFolder(this.callbackGetPersonalFolder);
    }

    public void getUserHome() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.userConfigService;
        endPoint.setServiceEntryPoint(RPCService.UserConfigService);
        this.userConfigService.getUserHome(this.callbackGetUserHome);
    }

    public void getTemplate() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.repositoryService;
        endPoint.setServiceEntryPoint(RPCService.RepositoryService);
        this.repositoryService.getTemplatesFolder(this.callbackGetTemplatesFolder);
    }

    public void getMail() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.repositoryService;
        endPoint.setServiceEntryPoint(RPCService.RepositoryService);
        this.repositoryService.getMailFolder(this.callbackGetMailFolder);
    }

    public void getThesaurus() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.repositoryService;
        endPoint.setServiceEntryPoint(RPCService.RepositoryService);
        this.repositoryService.getThesaurusFolder(this.callbackGetThesaurusFolder);
    }

    public void getCategories() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.repositoryService;
        endPoint.setServiceEntryPoint(RPCService.RepositoryService);
        this.repositoryService.getCategoriesFolder(this.callbackGetCategoriesFolder);
    }

    public void getRoot() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.repositoryService;
        endPoint.setServiceEntryPoint(RPCService.RepositoryService);
        this.repositoryService.getRootFolder(this.callbackGetRootFolder);
    }

    public void startKeepAlive(double scheduleTime) {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.authService;
        endPoint.setServiceEntryPoint(RPCService.AuthService);
        this.keepAlive = new Timer(){

            public void run() {
                StartUp.this.authService.keepAlive(StartUp.this.callbackKeepAlive);
            }
        };
        this.keepAlive.scheduleRepeating(new Double(scheduleTime).intValue());
    }

    private void openDocumentByBrowserURLParam() {
        Main.get().startUp.nextStatus(13);
        this.fldPath = Main.get().fldPath;
        this.docPath = Main.get().docPath;
        this.taskInstanceId = Main.get().taskInstanceId;
        this.refreshTasks = Main.get().refreshTasks;
        Main.get().docPath = null;
        Main.get().fldPath = null;
        Main.get().taskInstanceId = null;
        Main.get().refreshTasks = null;
        if (this.fldPath == null || this.fldPath.equals("")) {
            if (Main.get().userHome.getHomeType().equals("okm:document")) {
                this.docPath = Main.get().userHome.getHomePath();
                this.fldPath = Util.getParent(Main.get().userHome.getHomePath());
            } else if (Main.get().userHome.getHomeType().equals("okm:folder")) {
                this.fldPath = Main.get().userHome.getHomePath();
            }
        }
        if (this.docPath != null && !this.docPath.equals("")) {
            this.documentService.isValid(this.docPath, new AsyncCallback<Boolean>(){

                public void onSuccess(Boolean result) {
                    if (result.booleanValue()) {
                        CommonUI.openAllFolderPath(StartUp.this.fldPath, StartUp.this.docPath);
                    }
                    if ("true".equalsIgnoreCase(StartUp.this.refreshTasks)) {
                        CommonUI.refreshAllTasks();
                    } else {
                        CommonUI.openUserTaskInstance(StartUp.this.taskInstanceId);
                    }
                    Main.get().startUp.nextStatus(14);
                }

                public void onFailure(Throwable caught) {
                    Main.get().showError("isValid", caught);
                    Main.get().startUp.nextStatus(14);
                }
            });
        } else if (this.fldPath != null && !this.fldPath.equals("")) {
            this.folderService.isValid(this.fldPath, new AsyncCallback<Boolean>(){

                public void onSuccess(Boolean result) {
                    if (result.booleanValue()) {
                        CommonUI.openAllFolderPath(StartUp.this.fldPath, "");
                    }
                    if ("true".equalsIgnoreCase(StartUp.this.refreshTasks)) {
                        CommonUI.refreshAllTasks();
                    } else {
                        CommonUI.openUserTaskInstance(StartUp.this.taskInstanceId);
                    }
                    Main.get().startUp.nextStatus(14);
                }

                public void onFailure(Throwable caught) {
                    Main.get().showError("isValid", caught);
                    Main.get().startUp.nextStatus(14);
                }
            });
        } else {
            Main.get().startUp.nextStatus(14);
        }
    }

    public void nextStatus(int status) {
        if (this.enabled && this.status < status) {
            this.status = status;
            switch (status) {
                case 0: {
                    Main.get().startUpPopup.addStatus(Main.i18n("startup.starting.loading"), 0);
                    this.nextStatus(1);
                    break;
                }
                case 1: {
                    Main.get().startUpPopup.addStatus(Main.i18n("startup.loading.user.values"), 1);
                    Main.get().workspaceUserProperties.init();
                    break;
                }
                case 2: {
                    Main.get().startUpPopup.addStatus(Main.i18n("startup.taxonomy"), 2);
                    this.getRoot();
                    break;
                }
                case 3: {
                    Main.get().startUpPopup.addStatus(Main.i18n("startup.categories"), 3);
                    this.getCategories();
                    break;
                }
                case 4: {
                    Main.get().startUpPopup.addStatus(Main.i18n("startup.thesaurus"), 4);
                    this.getThesaurus();
                    break;
                }
                case 5: {
                    Main.get().startUpPopup.addStatus(Main.i18n("startup.template"), 5);
                    this.getTemplate();
                    break;
                }
                case 6: {
                    Main.get().startUpPopup.addStatus(Main.i18n("startup.personal"), 6);
                    this.getPersonal();
                    break;
                }
                case 7: {
                    Main.get().startUpPopup.addStatus(Main.i18n("startup.mail"), 7);
                    this.getMail();
                    break;
                }
                case 8: {
                    Main.get().startUpPopup.addStatus(Main.i18n("startup.trash"), 8);
                    this.getTrash();
                    break;
                }
                case 9: {
                    Main.get().startUpPopup.addStatus(Main.i18n("startup.user.home"), 9);
                    this.getUserHome();
                    break;
                }
                case 10: {
                    Main.get().startUpPopup.addStatus(Main.i18n("startup.bookmarks"), 10);
                    Main.get().mainPanel.topPanel.mainMenu.bookmark.getAll();
                    Main.get().mainPanel.desktop.browser.tabMultiple.init();
                    break;
                }
                case 11: {
                    Main.get().startUpPopup.addStatus(Main.i18n("startup.init.tree.nodes"), 11);
                    Main.get().mainPanel.desktop.navigator.taxonomyTree.init();
                    Main.get().mainPanel.desktop.navigator.categoriesTree.init();
                    Main.get().mainPanel.desktop.navigator.thesaurusTree.init();
                    Main.get().mainPanel.desktop.navigator.templateTree.init();
                    Main.get().mainPanel.desktop.navigator.personalTree.init();
                    Main.get().mainPanel.desktop.navigator.mailTree.init();
                    Main.get().mainPanel.desktop.navigator.trashTree.init();
                    Main.get().startUp.nextStatus(12);
                    break;
                }
                case 12: {
                    Main.get().startUpPopup.addStatus(Main.i18n("startup.loading.history.search"), 12);
                    Main.get().mainPanel.search.historySearch.searchSaved.init();
                    Main.get().mainPanel.search.historySearch.userNews.init();
                    Main.get().mainPanel.setVisible(true);
                    Main.get().workspaceUserProperties.setAvailableAction();
                    Main.get().startUp.nextStatus(13);
                    break;
                }
                case 13: {
                    Main.get().startUpPopup.addStatus(Main.i18n("startup.loading.taxonomy.eval.params"), 13);
                    this.openDocumentByBrowserURLParam();
                    break;
                }
                case 14: {
                    Main.get().startUpPopup.addStatus(Main.i18n("startup.loading.taxonomy.open.path"), 14);
                    this.enabled = false;
                    if (this.error) break;
                    Main.get().startUpPopup.hide();
                }
            }
        }
    }

    public void disable() {
        this.enabled = false;
    }

    public void recoverFromError() {
        this.error = true;
        Main.get().startUpPopup.button.setVisible(true);
        if (this.status < 14) {
            if (this.status < 11) {
                this.nextStatus(this.status + 1);
            } else {
                this.nextStatus(this.status + 1);
            }
        } else {
            this.enabled = false;
        }
    }

    public String getStatusMsg(int status) {
        String msg = "";
        switch (status) {
            case 0: {
                msg = Main.i18n("startup.starting.loading");
                break;
            }
            case 1: {
                msg = Main.i18n("startup.loading.user.values");
                break;
            }
            case 2: {
                msg = Main.i18n("startup.taxonomy");
                break;
            }
            case 3: {
                msg = Main.i18n("startup.categories");
                break;
            }
            case 4: {
                msg = Main.i18n("startup.thesaurus");
                break;
            }
            case 5: {
                msg = Main.i18n("startup.template");
                break;
            }
            case 6: {
                msg = Main.i18n("startup.personal");
                break;
            }
            case 7: {
                msg = Main.i18n("startup.mail");
                break;
            }
            case 8: {
                msg = Main.i18n("startup.trash");
                break;
            }
            case 9: {
                msg = Main.i18n("startup.user.home");
                this.getUserHome();
                break;
            }
            case 10: {
                msg = Main.i18n("startup.bookmarks");
                break;
            }
            case 11: {
                msg = Main.i18n("startup.loading.taxonomy");
                break;
            }
            case 12: {
                msg = Main.i18n("startup.loading.history.search");
                break;
            }
            case 13: {
                msg = Main.i18n("startup.loading.taxonomy.eval.params");
                break;
            }
            case 14: {
                msg = Main.i18n("startup.loading.taxonomy.open.path");
            }
        }
        return msg;
    }

    public int getStatus() {
        return this.status;
    }
}

