/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.test;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTDocument;
import com.openkm.frontend.client.bean.GWTFolder;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMTestService;
import com.openkm.frontend.client.service.OKMTestServiceAsync;
import java.util.Date;
import java.util.List;

public class TestPopup
extends DialogBox {
    private final OKMTestServiceAsync testService = (OKMTestServiceAsync)GWT.create(OKMTestService.class);
    VerticalPanel vPanel;
    HorizontalPanel hPanel;
    ScrollPanel scroll;
    FlexTable table;
    Button clean;
    Button run;
    Button close;
    TextBox sizeTest;
    TextBox cyclesTest;
    TextBox numThreads;
    ListBox type;
    String runnningTest = "";
    int selectedTest = 0;
    int actualCycle = 0;
    int maxCycle = 0;
    int textSize = 0;

    public TestPopup() {
        super(false, true);
        this.setText("GWT Testing");
        this.vPanel = new VerticalPanel();
        this.hPanel = new HorizontalPanel();
        this.hPanel.add((Widget)new HTML("&nbsp;Type:"));
        this.type = new ListBox();
        this.type.addItem("String", "String");
        this.type.addItem("GWTFolder", "GWTFolder");
        this.type.addItem("GWTDocument", "GWTDocument");
        this.type.setStyleName("okm-Input");
        this.hPanel.add((Widget)this.type);
        this.hPanel.add((Widget)new HTML("&nbsp;Elements:"));
        this.sizeTest = new TextBox();
        this.sizeTest.setSize("60", "20");
        this.sizeTest.setText("2000");
        this.sizeTest.setStyleName("okm-Input");
        this.hPanel.add((Widget)this.sizeTest);
        this.hPanel.add((Widget)new HTML("&nbsp;Cycles:"));
        this.cyclesTest = new TextBox();
        this.cyclesTest.setText("100");
        this.cyclesTest.setSize("60", "20");
        this.cyclesTest.setStyleName("okm-Input");
        this.hPanel.add((Widget)this.cyclesTest);
        this.hPanel.add((Widget)new HTML("&nbsp;Threads:"));
        this.numThreads = new TextBox();
        this.numThreads.setText("1");
        this.numThreads.setSize("60", "20");
        this.numThreads.setStyleName("okm-Input");
        this.hPanel.add((Widget)this.numThreads);
        this.hPanel.add((Widget)new HTML("&nbsp;"));
        this.clean = new Button("Clean");
        this.clean.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TestPopup.this.table.removeAllRows();
            }
        });
        this.clean.setStyleName("okm-Input");
        this.hPanel.add((Widget)this.clean);
        this.hPanel.add((Widget)new HTML("&nbsp;"));
        this.run = new Button("run");
        this.run.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TestPopup.this.run();
            }
        });
        this.run.setStyleName("okm-Input");
        this.hPanel.add((Widget)this.run);
        this.hPanel.add((Widget)new HTML("&nbsp;"));
        this.table = new FlexTable();
        this.scroll = new ScrollPanel((Widget)this.table);
        this.scroll.setSize("600", "450");
        this.table.setWidth("100%");
        this.table.setCellPadding(5);
        this.table.setCellSpacing(0);
        this.close = new Button("close");
        this.close.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TestPopup.this.hide();
            }
        });
        this.close.setStyleName("okm-Input");
        this.vPanel.add((Widget)this.hPanel);
        this.vPanel.add((Widget)this.scroll);
        this.vPanel.add((Widget)this.close);
        this.vPanel.setCellHeight((Widget)this.hPanel, "30");
        this.vPanel.setCellHeight((Widget)this.scroll, "450");
        this.vPanel.setCellHeight((Widget)this.close, "20");
        this.vPanel.setCellHorizontalAlignment((Widget)this.close, HasAlignment.ALIGN_CENTER);
        super.hide();
        this.setWidget((Widget)this.vPanel);
    }

    public void run() {
        this.runnningTest = "Test " + this.type.getValue(this.type.getSelectedIndex()) + " > ";
        this.selectedTest = this.type.getSelectedIndex();
        this.actualCycle = 0;
        this.maxCycle = Integer.parseInt(this.cyclesTest.getText());
        this.textSize = Integer.parseInt(this.sizeTest.getText());
        this.log(this.runnningTest, "Starting");
        int thread = Integer.parseInt(this.numThreads.getText());
        for (int count = 0; count < thread; ++count) {
            this.controller();
        }
    }

    private void controller() {
        if (this.actualCycle < this.maxCycle) {
            switch (this.selectedTest) {
                case 0: {
                    this.stringTest(this.actualCycle);
                    ++this.actualCycle;
                    break;
                }
                case 1: {
                    this.folderTest(this.actualCycle);
                    ++this.actualCycle;
                    break;
                }
                case 2: {
                    this.documentTest(this.actualCycle);
                    ++this.actualCycle;
                }
            }
        } else {
            this.log(this.runnningTest, "Finished");
        }
    }

    private void stringTest(final int cycle) {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.testService;
        endPoint.setServiceEntryPoint(RPCService.TestService);
        this.log(this.runnningTest, "Calling RPC: " + cycle);
        this.testService.StringTest(this.textSize, new AsyncCallback<String>(){

            public void onSuccess(String result) {
                TestPopup.this.log(TestPopup.this.runnningTest, "Finished RPC: " + cycle + ", Result length: " + result.length());
                TestPopup.this.controller();
            }

            public void onFailure(Throwable caught) {
                Main.get().showError("StringTest", caught);
            }
        });
    }

    private void folderTest(final int cycle) {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.testService;
        endPoint.setServiceEntryPoint(RPCService.TestService);
        this.log(this.runnningTest, "Calling RPC: " + cycle);
        this.testService.folderText(this.textSize, new AsyncCallback<List<GWTFolder>>(){

            public void onSuccess(List<GWTFolder> result) {
                TestPopup.this.log(TestPopup.this.runnningTest, "Finished RPC: " + cycle + ", Result size: " + result.size());
                TestPopup.this.controller();
            }

            public void onFailure(Throwable caught) {
                Main.get().showError("folderText", caught);
            }
        });
    }

    private void documentTest(final int cycle) {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.testService;
        endPoint.setServiceEntryPoint(RPCService.TestService);
        this.log(this.runnningTest, "Calling RPC: " + cycle);
        this.testService.documentText(this.textSize, new AsyncCallback<List<GWTDocument>>(){

            public void onSuccess(List<GWTDocument> result) {
                TestPopup.this.log(TestPopup.this.runnningTest, "Finished RPC: " + cycle + ", Result size: " + result.size());
                TestPopup.this.controller();
            }

            public void onFailure(Throwable caught) {
                Main.get().showError("folderText", caught);
            }
        });
    }

    private void log(String value, String value2) {
        DateTimeFormat dtf = DateTimeFormat.getFormat((String)Main.i18n("general.date.pattern"));
        int row = this.table.getRowCount();
        this.table.setHTML(row, 0, dtf.format(new Date()) + " " + value);
        this.table.setHTML(row, 1, value2);
        this.table.getCellFormatter().setHeight(row, 0, "20");
        this.table.getCellFormatter().setWidth(row, 0, "250");
    }
}

