/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.thesaurus;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TabBar;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMThesaurusService;
import com.openkm.frontend.client.service.OKMThesaurusServiceAsync;
import com.openkm.frontend.client.widget.thesaurus.FolderSelectTree;
import com.openkm.frontend.client.widget.thesaurus.Status;
import java.util.Iterator;
import java.util.List;

public class ThesaurusSelectPopup
extends DialogBox {
    private final OKMThesaurusServiceAsync thesaurusService = (OKMThesaurusServiceAsync)GWT.create(OKMThesaurusService.class);
    public static final int NONE = -1;
    public static final int DOCUMENT_PROPERTIES = 0;
    public static final int WIZARD = 1;
    private final int TAB_TREE = 0;
    private final int TAB_KEYWORDS = 1;
    private VerticalPanel vPanel;
    private HorizontalPanel hPanel;
    public ScrollPanel scrollDirectoryPanel;
    public ScrollPanel scrollKeywordPanel;
    private VerticalPanel verticalDirectoryPanel;
    private FolderSelectTree folderSelectTree;
    private Button cancelButton;
    private Button actionButton;
    public Status status;
    private TextBox keyword;
    private VerticalPanel vPanelKeyword;
    private FlexTable keywordTable;
    public TabPanel tabPanel;
    private int selectedRow = -1;
    private int selectedTab = 0;
    private int selectedFrom = -1;
    final AsyncCallback<List<String>> callbackGetKeywords = new AsyncCallback<List<String>>(){

        public void onSuccess(List<String> result) {
            ThesaurusSelectPopup.this.removeAllRows();
            Iterator<String> it = result.iterator();
            while (it.hasNext()) {
                ThesaurusSelectPopup.this.keywordTable.setHTML(ThesaurusSelectPopup.this.keywordTable.getRowCount(), 0, it.next());
            }
            ThesaurusSelectPopup.this.status.unsetFlagKeywords();
        }

        public void onFailure(Throwable caught) {
            ThesaurusSelectPopup.this.status.unsetFlagKeywords();
            Main.get().showError("getKeywords", caught);
        }
    };

    public ThesaurusSelectPopup() {
        super(false, true);
        this.status = new Status();
        this.status.setStyleName("okm-StatusPopup");
        this.tabPanel = new TabPanel();
        this.tabPanel.setSize("290", "175");
        this.tabPanel.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                ThesaurusSelectPopup.this.selectedTab = (Integer)event.getSelectedItem();
                ThesaurusSelectPopup.this.evaluateEnableAction();
            }
        });
        this.vPanel = new VerticalPanel();
        this.vPanel.setWidth("300");
        this.vPanel.setHeight("225");
        this.hPanel = new HorizontalPanel();
        this.scrollDirectoryPanel = new ScrollPanel();
        this.scrollDirectoryPanel.setSize("100%", "100%");
        this.scrollDirectoryPanel.setStyleName("okm-Popup-text");
        this.scrollKeywordPanel = new ScrollPanel();
        this.scrollKeywordPanel.setStyleName("okm-Popup-text");
        this.verticalDirectoryPanel = new VerticalPanel();
        this.folderSelectTree = new FolderSelectTree();
        this.folderSelectTree.setSize("100%", "100%");
        this.verticalDirectoryPanel.add((Widget)this.folderSelectTree);
        this.scrollDirectoryPanel.add((Widget)this.verticalDirectoryPanel);
        this.cancelButton = new Button(Main.i18n("button.close"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ThesaurusSelectPopup.this.hide();
            }
        });
        this.actionButton = new Button(Main.i18n("button.add"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ThesaurusSelectPopup.this.selectedTab == 0) {
                    ThesaurusSelectPopup.this.executeAction(ThesaurusSelectPopup.this.folderSelectTree.getActualPath());
                } else {
                    ThesaurusSelectPopup.this.executeAction(ThesaurusSelectPopup.this.keywordTable.getText(ThesaurusSelectPopup.this.selectedRow, 0));
                }
            }
        });
        this.keyword = new TextBox();
        this.keyword.setWidth("292");
        this.keyword.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (ThesaurusSelectPopup.this.keyword.getText().length() >= 3) {
                    ThesaurusSelectPopup.this.getKeywords(ThesaurusSelectPopup.this.keyword.getText().toLowerCase());
                } else {
                    ThesaurusSelectPopup.this.removeAllRows();
                }
            }
        });
        this.keywordTable = new FlexTable();
        this.keywordTable.setWidth("100%");
        this.keywordTable.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ThesaurusSelectPopup.this.markSelectedRow(ThesaurusSelectPopup.this.keywordTable.getCellForEvent(event).getRowIndex());
                ThesaurusSelectPopup.this.evaluateEnableAction();
            }
        });
        this.scrollKeywordPanel.add((Widget)this.keywordTable);
        this.vPanelKeyword = new VerticalPanel();
        this.vPanelKeyword.add((Widget)this.keyword);
        this.vPanelKeyword.add((Widget)this.scrollKeywordPanel);
        this.vPanelKeyword.setCellHeight((Widget)this.keyword, "25");
        this.vPanelKeyword.setCellVerticalAlignment((Widget)this.keyword, HasAlignment.ALIGN_MIDDLE);
        this.tabPanel.add((Widget)this.scrollDirectoryPanel, Main.i18n("thesaurus.tab.tree"));
        this.tabPanel.add((Widget)this.vPanelKeyword, Main.i18n("thesaurus.tab.keywords"));
        this.tabPanel.selectTab(0);
        this.scrollDirectoryPanel.setPixelSize(290, 175);
        this.scrollKeywordPanel.setPixelSize(290, 150);
        this.vPanel.add((Widget)this.tabPanel);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.hPanel.add((Widget)this.cancelButton);
        HTML space = new HTML();
        space.setWidth("50");
        this.hPanel.add((Widget)space);
        this.hPanel.add((Widget)this.actionButton);
        this.vPanel.add((Widget)this.hPanel);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.setCellHorizontalAlignment((Widget)this.tabPanel, HasAlignment.ALIGN_CENTER);
        this.vPanel.setCellHorizontalAlignment((Widget)this.hPanel, HasAlignment.ALIGN_CENTER);
        this.vPanel.setCellHeight((Widget)this.tabPanel, "150");
        this.cancelButton.setStyleName("okm-Button");
        this.actionButton.setStyleName("okm-Button");
        this.keyword.setStyleName("okm-Input");
        this.keywordTable.setStyleName("okm-NoWrap");
        this.keywordTable.addStyleName("okm-Table-Row");
        super.hide();
        this.setWidget((Widget)this.vPanel);
    }

    public void executeAction(String actualPath) {
        String keyword = actualPath.substring(actualPath.lastIndexOf("/") + 1).replace(" ", "_");
        switch (this.selectedFrom) {
            case 0: {
                Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.document.addKeywordToPendinList(keyword);
                Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.document.addPendingKeyWordsList();
                break;
            }
            case 1: {
                Main.get().wizardPopup.keywordsWidget.addKeywordToPendinList(keyword);
                Main.get().wizardPopup.keywordsWidget.addPendingKeyWordsList();
            }
        }
    }

    public void langRefresh() {
        TabBar tabBar = this.tabPanel.getTabBar();
        this.selectedTab = tabBar.getSelectedTab();
        while (this.tabPanel.getWidgetCount() > 0) {
            this.tabPanel.remove(0);
        }
        this.tabPanel.add((Widget)this.scrollDirectoryPanel, Main.i18n("thesaurus.tab.tree"));
        this.tabPanel.add((Widget)this.scrollKeywordPanel, Main.i18n("thesaurus.tab.keywords"));
        this.tabPanel.selectTab(this.selectedTab);
        this.scrollDirectoryPanel.setPixelSize(290, 175);
        this.scrollKeywordPanel.setPixelSize(290, 150);
        this.setText(Main.i18n("thesaurus.directory.select.label"));
        this.cancelButton.setText(Main.i18n("button.close"));
        this.actionButton.setText(Main.i18n("button.add"));
    }

    public void show(int selectedFrom) {
        this.selectedFrom = selectedFrom;
        this.initButtons();
        int left = (Window.getClientWidth() - 300) / 2;
        int top = (Window.getClientHeight() - 225) / 2;
        this.setPopupPosition(left, top);
        this.setText(Main.i18n("thesaurus.directory.select.label"));
        this.folderSelectTree.reset();
        this.removeAllRows();
        this.keyword.setText("");
        this.evaluateEnableAction();
        this.center();
    }

    public void enable(boolean enable) {
        this.actionButton.setEnabled(enable);
    }

    private void initButtons() {
        this.cancelButton.setEnabled(true);
        this.actionButton.setEnabled(false);
    }

    public void getKeywords(String filter) {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.thesaurusService;
        endPoint.setServiceEntryPoint(RPCService.ThesaurusService);
        this.status.setFlagKeywords();
        this.thesaurusService.getKeywords(filter, this.callbackGetKeywords);
    }

    private void removeAllRows() {
        this.selectedRow = -1;
        this.evaluateEnableAction();
        while (this.keywordTable.getRowCount() > 0) {
            this.keywordTable.removeRow(0);
        }
    }

    private void markSelectedRow(int row) {
        if (row != this.selectedRow) {
            this.styleRow(this.selectedRow, false);
            this.styleRow(row, true);
            this.selectedRow = row;
        }
    }

    private void styleRow(int row, boolean selected) {
        if (row >= 0) {
            if (selected) {
                this.keywordTable.getRowFormatter().addStyleName(row, "okm-Table-SelectedRow");
            } else {
                this.keywordTable.getRowFormatter().removeStyleName(row, "okm-Table-SelectedRow");
            }
        }
    }

    private void evaluateEnableAction() {
        switch (this.selectedTab) {
            case 0: {
                this.enable(this.folderSelectTree.evaluateEnableActionButton());
                break;
            }
            case 1: {
                this.enable(this.selectedRow >= 0);
            }
        }
    }
}

