/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.toolbar;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.bean.FileToUpload;
import com.openkm.frontend.client.bean.GWTDocument;
import com.openkm.frontend.client.bean.GWTFolder;
import com.openkm.frontend.client.bean.GWTMail;
import com.openkm.frontend.client.bean.GWTProfileToolbar;
import com.openkm.frontend.client.bean.GWTPropertyGroup;
import com.openkm.frontend.client.bean.ToolBarOption;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.extension.event.HasToolBarEvent;
import com.openkm.frontend.client.extension.event.handler.ToolBarHandlerExtension;
import com.openkm.frontend.client.extension.event.hashandler.HasToolBarHandlerExtension;
import com.openkm.frontend.client.extension.widget.toolbar.ToolBarButtonExtension;
import com.openkm.frontend.client.service.OKMDocumentService;
import com.openkm.frontend.client.service.OKMDocumentServiceAsync;
import com.openkm.frontend.client.service.OKMFolderService;
import com.openkm.frontend.client.service.OKMFolderServiceAsync;
import com.openkm.frontend.client.service.OKMPropertyGroupService;
import com.openkm.frontend.client.service.OKMPropertyGroupServiceAsync;
import com.openkm.frontend.client.util.OKMBundleResources;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.widget.OriginPanel;
import com.openkm.frontend.client.widget.toolbar.ToolBarButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ToolBar
extends Composite
implements OriginPanel,
HasToolBarEvent,
HasToolBarHandlerExtension {
    private final OKMDocumentServiceAsync documentService = (OKMDocumentServiceAsync)GWT.create(OKMDocumentService.class);
    private final OKMFolderServiceAsync folderService = (OKMFolderServiceAsync)GWT.create(OKMFolderService.class);
    private final OKMPropertyGroupServiceAsync propertyGroupService = (OKMPropertyGroupServiceAsync)GWT.create(OKMPropertyGroupService.class);
    private HorizontalPanel panel;
    private ToolBarButton createFolder;
    private ToolBarButton findFolder;
    private ToolBarButton lock;
    private ToolBarButton unlock;
    private ToolBarButton addDocument;
    private ToolBarButton delete;
    private ToolBarButton checkout;
    private ToolBarButton checkin;
    private ToolBarButton cancelCheckout;
    private ToolBarButton download;
    private ToolBarButton downloadPdf;
    private ToolBarButton addPropertyGroup;
    private ToolBarButton removePropertyGroup;
    private ToolBarButton startWorkflow;
    private ToolBarButton addSubscription;
    private ToolBarButton removeSubscription;
    private ToolBarButton home;
    private ToolBarButton refresh;
    private ToolBarButton scanner;
    private ToolBarButton uploader;
    private Object node;
    private boolean enabled = true;
    private boolean propertyGroupEnabled = false;
    private ToolBarOption toolBarOption;
    private int actualView = 0;
    private HashMap<String, ToolBarOption> viewValues;
    private List<ToolBarButtonExtension> widgetExtensionList;
    private List<ToolBarHandlerExtension> toolBarHandlerExtensionList;
    private MouseOverHandler mouseOverHandler = new MouseOverHandler(){

        public void onMouseOver(MouseOverEvent event) {
            Widget sender = (Widget)event.getSource();
            sender.addStyleName("okm-ToolBar-selected");
        }
    };
    private MouseOutHandler mouseOutHandler = new MouseOutHandler(){

        public void onMouseOut(MouseOutEvent event) {
            Widget sender = (Widget)event.getSource();
            sender.removeStyleName("okm-ToolBar-selected");
        }
    };
    ClickHandler createFolderHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (((ToolBar)ToolBar.this).toolBarOption.createFolderOption) {
                ToolBar.this.executeFolderDirectory();
                ToolBar.this.fireEvent(HasToolBarEvent.EXECUTE_CREATE_FOLDER);
            }
        }
    };
    ClickHandler findFolderHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (((ToolBar)ToolBar.this).toolBarOption.findFolderOption) {
                Main.get().findFolderSelectPopup.show();
                ToolBar.this.fireEvent(HasToolBarEvent.EXECUTE_FIND_FOLDER);
            }
        }
    };
    ClickHandler lockHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (((ToolBar)ToolBar.this).toolBarOption.lockOption) {
                ToolBar.this.executeLock();
            }
        }
    };
    ClickHandler unLockHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (((ToolBar)ToolBar.this).toolBarOption.unLockOption) {
                GWTDocument doc = Main.get().mainPanel.desktop.browser.fileBrowser.getDocument();
                if (doc.getLockInfo().getOwner().equals(Main.get().workspaceUserProperties.getUser())) {
                    ToolBar.this.executeUnlock();
                } else if (Main.get().workspaceUserProperties.getWorkspace().isAdminRole()) {
                    Main.get().confirmPopup.setConfirm(15);
                    Main.get().confirmPopup.show();
                }
            }
        }
    };
    ClickHandler addDocumentHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (((ToolBar)ToolBar.this).toolBarOption.addDocumentOption) {
                if (Main.get().mainPanel.bottomPanel.userInfo.isQuotaExceed()) {
                    Main.get().showError("UserQuotaExceed", new OKMException("OKM-018023", ""));
                } else {
                    ToolBar.this.executeAddDocument();
                }
            }
        }
    };
    ClickHandler deleteHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (((ToolBar)ToolBar.this).toolBarOption.deleteOption) {
                ToolBar.this.executeDelete();
            }
        }
    };
    ClickHandler editHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (((ToolBar)ToolBar.this).toolBarOption.checkoutOption) {
                if (Main.get().mainPanel.bottomPanel.userInfo.isQuotaExceed()) {
                    Main.get().showError("UserQuotaExceed", new OKMException("OKM-018023", ""));
                } else {
                    ToolBar.this.executeCheckout();
                }
            }
        }
    };
    ClickHandler checkinHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (((ToolBar)ToolBar.this).toolBarOption.checkinOption) {
                ToolBar.this.exectuteCheckin();
            }
        }
    };
    ClickHandler cancelCheckoutHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (((ToolBar)ToolBar.this).toolBarOption.cancelCheckoutOption) {
                GWTDocument doc = Main.get().mainPanel.desktop.browser.fileBrowser.getDocument();
                if (doc.getLockInfo().getOwner().equals(Main.get().workspaceUserProperties.getUser())) {
                    ToolBar.this.executeCancelCheckout();
                } else if (Main.get().workspaceUserProperties.getWorkspace().isAdminRole()) {
                    Main.get().confirmPopup.setConfirm(16);
                    Main.get().confirmPopup.show();
                }
            }
        }
    };
    ClickHandler downloadHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (((ToolBar)ToolBar.this).toolBarOption.downloadOption) {
                ToolBar.this.executeDownload();
            }
        }
    };
    ClickHandler downloadPdfHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (((ToolBar)ToolBar.this).toolBarOption.downloadPdfOption) {
                ToolBar.this.executeDownloadPdf();
            }
        }
    };
    ClickHandler addPropertyGroupHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (((ToolBar)ToolBar.this).toolBarOption.addPropertyGroupOption) {
                ToolBar.this.executeAddPropertyGroup();
            }
        }
    };
    ClickHandler removePropertyGroupHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (((ToolBar)ToolBar.this).toolBarOption.removePropertyGroupOption && ((ToolBar)ToolBar.this).toolBarOption.firedRemovePropertyGroupOption) {
                ToolBar.this.executeRemovePropertyGroup();
            }
        }
    };
    ClickHandler startWorkflowHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (((ToolBar)ToolBar.this).toolBarOption.workflowOption) {
                ToolBar.this.executeAddWorkflow();
            }
        }
    };
    ClickHandler addSubscriptionHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (((ToolBar)ToolBar.this).toolBarOption.addSubscription) {
                ToolBar.this.executeAddSubscription();
            }
        }
    };
    ClickHandler removeSubscriptionHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (((ToolBar)ToolBar.this).toolBarOption.removeSubscription) {
                ToolBar.this.executeRemoveSubscription();
            }
        }
    };
    ClickHandler arrowRefreshHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (((ToolBar)ToolBar.this).toolBarOption.refreshOption) {
                ToolBar.this.executeRefresh();
            }
        }
    };
    ClickHandler scannerHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            ToolBar.this.executeScanner();
        }
    };
    ClickHandler uploaderHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            ToolBar.this.executeUploader();
        }
    };
    ClickHandler arrowHomeHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (((ToolBar)ToolBar.this).toolBarOption.homeOption) {
                ToolBar.this.executeGoToUserHome();
            }
        }
    };
    final AsyncCallback<Boolean> callbackIsValidDocument = new AsyncCallback<Boolean>(){

        public void onSuccess(Boolean result) {
            if (result.booleanValue()) {
                String path = Main.get().userHome.getHomePath().substring(0, Main.get().userHome.getHomePath().lastIndexOf("/"));
                Main.get().activeFolderTree.openAllPathFolder(path, Main.get().userHome.getHomePath());
            }
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("isValid", caught);
        }
    };
    final AsyncCallback<Boolean> callbackIsValidFolder = new AsyncCallback<Boolean>(){

        public void onSuccess(Boolean result) {
            if (result.booleanValue()) {
                Main.get().activeFolderTree.openAllPathFolder(Main.get().userHome.getHomePath(), "");
            }
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("isValid", caught);
        }
    };
    final AsyncCallback<List<GWTPropertyGroup>> callbackGetAllGroups = new AsyncCallback<List<GWTPropertyGroup>>(){

        public void onSuccess(List<GWTPropertyGroup> result) {
            if (!result.isEmpty()) {
                ToolBar.this.enableAddPropertyGroup();
            } else {
                ToolBar.this.disableAddPropertyGroup();
            }
        }

        public void onFailure(Throwable caught) {
            ToolBar.this.disableAddPropertyGroup();
            Main.get().showError("GetAllGroups", caught);
        }
    };

    public void executeFolderDirectory() {
        Main.get().activeFolderTree.addTmpFolderCreate();
    }

    public void executeLock() {
        Main.get().mainPanel.desktop.browser.fileBrowser.lock();
        this.fireEvent(HasToolBarEvent.EXECUTE_LOCK);
    }

    public void executeUnlock() {
        Main.get().mainPanel.desktop.browser.fileBrowser.unlock();
        this.fireEvent(HasToolBarEvent.EXECUTE_UNLOCK);
    }

    public void executeAddDocument() {
        FileToUpload fileToUpload = new FileToUpload();
        fileToUpload.setFileUpload(new FileUpload());
        fileToUpload.setPath(Main.get().activeFolderTree.getActualPath());
        fileToUpload.setAction(0);
        Main.get().fileUpload.enqueueFileToUpload(new ArrayList<FileToUpload>(Arrays.asList(fileToUpload)));
        this.fireEvent(HasToolBarEvent.EXECUTE_ADD_DOCUMENT);
    }

    public void executeDelete() {
        if (Main.get().mainPanel.desktop.browser.fileBrowser.isPanelSelected()) {
            Main.get().mainPanel.desktop.browser.fileBrowser.confirmDelete();
        } else if (Main.get().activeFolderTree.isPanelSelected()) {
            Main.get().activeFolderTree.confirmDelete();
        }
        this.fireEvent(HasToolBarEvent.EXECUTE_DELETE);
    }

    public void executeCopy() {
        if (Main.get().mainPanel.desktop.browser.fileBrowser.isPanelSelected()) {
            Main.get().mainPanel.desktop.browser.fileBrowser.copy();
        } else if (Main.get().activeFolderTree.isPanelSelected()) {
            Main.get().activeFolderTree.copy();
        }
        this.fireEvent(HasToolBarEvent.EXECUTE_COPY);
    }

    public void executeMove() {
        if (Main.get().mainPanel.desktop.browser.fileBrowser.isPanelSelected()) {
            Main.get().mainPanel.desktop.browser.fileBrowser.move();
        } else if (Main.get().activeFolderTree.isPanelSelected()) {
            Main.get().activeFolderTree.move();
        }
        this.fireEvent(HasToolBarEvent.EXECUTE_MOVE);
    }

    public void executeRename() {
        if (Main.get().mainPanel.desktop.browser.fileBrowser.isPanelSelected()) {
            Main.get().mainPanel.desktop.browser.fileBrowser.rename();
        } else if (Main.get().activeFolderTree.isPanelSelected()) {
            Main.get().activeFolderTree.rename();
        }
        this.fireEvent(HasToolBarEvent.EXECUTE_RENAME);
    }

    public void executeCheckout() {
        Main.get().mainPanel.desktop.browser.fileBrowser.checkout();
        this.fireEvent(HasToolBarEvent.EXECUTE_CHECKOUT);
    }

    public void exectuteCheckin() {
        FileToUpload fileToUpload = new FileToUpload();
        fileToUpload.setFileUpload(new FileUpload());
        fileToUpload.setPath(Main.get().mainPanel.desktop.browser.fileBrowser.getPath());
        fileToUpload.setAction(1);
        fileToUpload.setEnableAddButton(false);
        fileToUpload.setEnableImport(false);
        Main.get().fileUpload.enqueueFileToUpload(new ArrayList<FileToUpload>(Arrays.asList(fileToUpload)));
        this.fireEvent(HasToolBarEvent.EXECUTE_CHECKIN);
    }

    public void executeCancelCheckout() {
        Main.get().mainPanel.desktop.browser.fileBrowser.cancelCheckout();
        this.fireEvent(HasToolBarEvent.EXECUTE_CANCEL_CHECKOUT);
    }

    public void executeDownload() {
        Main.get().mainPanel.desktop.browser.fileBrowser.table.downloadDocument(false);
        this.fireEvent(HasToolBarEvent.EXECUTE_DOWNLOAD_DOCUMENT);
    }

    public void executeDownloadPdf() {
        Main.get().mainPanel.desktop.browser.fileBrowser.table.downloadDocumentPdf();
        this.fireEvent(HasToolBarEvent.EXECUTE_DOWNLOAD_PDF_DOCUMENT);
    }

    public void executePrint() {
        Main.get().mainPanel.desktop.browser.fileBrowser.table.print();
    }

    public void executeAddPropertyGroup() {
        Main.get().propertyGroupPopup.show();
        this.fireEvent(HasToolBarEvent.EXECUTE_ADD_PROPERTY_GROUP);
    }

    public void executeAddWorkflow() {
        Main.get().workflowPopup.show();
        this.fireEvent(HasToolBarEvent.EXECUTE_ADD_WORKFLOW);
    }

    public void executeRemovePropertyGroup() {
        Main.get().confirmPopup.setConfirm(6);
        Main.get().confirmPopup.show();
        this.fireEvent(HasToolBarEvent.EXECUTE_REMOVE_PROPERTY_GROUP);
    }

    public void executeAddSubscription() {
        if (Main.get().mainPanel.desktop.browser.fileBrowser.isPanelSelected()) {
            Main.get().mainPanel.desktop.browser.fileBrowser.addSubscription();
        } else if (Main.get().activeFolderTree.isPanelSelected()) {
            Main.get().activeFolderTree.addSubscription();
        }
        this.fireEvent(HasToolBarEvent.EXECUTE_ADD_SUBSCRIPTION);
    }

    public void executeRemoveSubscription() {
        if (Main.get().mainPanel.desktop.browser.fileBrowser.isPanelSelected()) {
            Main.get().mainPanel.desktop.browser.fileBrowser.removeSubscription();
        } else if (Main.get().activeFolderTree.isPanelSelected()) {
            Main.get().activeFolderTree.removeSubscription();
        }
        this.fireEvent(HasToolBarEvent.EXECUTE_REMOVE_SUBSCRIPTION);
    }

    public void executeScanner() {
        if (this.toolBarOption.scannerOption) {
            this.setScannerApplet(Main.get().workspaceUserProperties.getWorkspace().getToken(), Main.get().activeFolderTree.getActualPath());
            this.fireEvent(HasToolBarEvent.EXECUTE_SCANNER);
        }
    }

    public void executeUploader() {
        if (this.toolBarOption.uploaderOption) {
            this.setUploaderApplet(Main.get().workspaceUserProperties.getWorkspace().getToken(), Main.get().activeFolderTree.getActualPath());
            this.fireEvent(HasToolBarEvent.EXECUTE_UPLOADER);
        }
    }

    public void executeRefresh() {
        switch (Main.get().mainPanel.topPanel.tabWorkspace.getSelectedWorkspace()) {
            case 0: {
                int actualView = Main.get().mainPanel.desktop.navigator.stackPanel.getStackIndex();
                switch (actualView) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        Main.get().activeFolderTree.refresh(false);
                        break;
                    }
                    case 6: {
                        Main.get().activeFolderTree.refresh(false);
                    }
                }
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                Main.get().mainPanel.dashboard.refreshAll();
            }
        }
        this.fireEvent(HasToolBarEvent.EXECUTE_REFRESH);
    }

    public void executeGoToUserHome() {
        if (Main.get().userHome != null && !Main.get().userHome.getHomePath().equals("")) {
            if (Main.get().userHome.getHomeType().equals("okm:document")) {
                ServiceDefTarget endPoint = (ServiceDefTarget)this.documentService;
                endPoint.setServiceEntryPoint(RPCService.DocumentService);
                this.documentService.isValid(Main.get().userHome.getHomePath(), this.callbackIsValidDocument);
            } else if (Main.get().userHome.getHomeType().equals("okm:folder")) {
                ServiceDefTarget endPoint = (ServiceDefTarget)this.folderService;
                endPoint.setServiceEntryPoint(RPCService.FolderService);
                this.folderService.isValid(Main.get().userHome.getHomePath(), this.callbackIsValidFolder);
            }
        }
        this.fireEvent(HasToolBarEvent.EXECUTE_GO_HOME);
    }

    public void executeExport() {
        if (Main.get().mainPanel.desktop.browser.fileBrowser.isPanelSelected()) {
            Main.get().mainPanel.desktop.browser.fileBrowser.exportFolderToFile();
        } else if (Main.get().activeFolderTree.isPanelSelected()) {
            Main.get().activeFolderTree.exportFolderToFile();
        }
        this.fireEvent(HasToolBarEvent.EXECUTE_EXPORT_TO_ZIP);
    }

    private HTML space() {
        HTML space = new HTML(" ");
        space.setStyleName("okm-ToolBar-space");
        return space;
    }

    public ToolBar() {
        this.viewValues = new HashMap();
        this.toolBarOption = this.getDefaultRootToolBar();
        this.widgetExtensionList = new ArrayList<ToolBarButtonExtension>();
        this.toolBarHandlerExtensionList = new ArrayList<ToolBarHandlerExtension>();
        this.createFolder = new ToolBarButton(new Image(OKMBundleResources.INSTANCE.createFolder()), Main.i18n("tree.menu.directory.create"), this.createFolderHandler);
        this.findFolder = new ToolBarButton(new Image(OKMBundleResources.INSTANCE.findFolder()), Main.i18n("tree.menu.directory.find.folder"), this.findFolderHandler);
        this.lock = new ToolBarButton(new Image(OKMBundleResources.INSTANCE.lockDisabled()), Main.i18n("general.menu.file.lock"), this.lockHandler);
        this.unlock = new ToolBarButton(new Image(OKMBundleResources.INSTANCE.lockDisabled()), Main.i18n("general.menu.file.unlock"), this.unLockHandler);
        this.addDocument = new ToolBarButton(new Image(OKMBundleResources.INSTANCE.addDocument()), Main.i18n("general.menu.file.add.document"), this.addDocumentHandler);
        this.delete = new ToolBarButton(new Image(OKMBundleResources.INSTANCE.deleteDisabled()), Main.i18n("general.menu.file.delete"), this.deleteHandler);
        this.checkout = new ToolBarButton(new Image(OKMBundleResources.INSTANCE.checkoutDisabled()), Main.i18n("general.menu.file.checkout"), this.editHandler);
        this.checkin = new ToolBarButton(new Image(OKMBundleResources.INSTANCE.checkinDisabled()), Main.i18n("general.menu.file.checkin"), this.checkinHandler);
        this.cancelCheckout = new ToolBarButton(new Image(OKMBundleResources.INSTANCE.cancelCheckoutDisabled()), Main.i18n("general.menu.file.cancel.checkout"), this.cancelCheckoutHandler);
        this.download = new ToolBarButton(new Image(OKMBundleResources.INSTANCE.downloadDisabled()), Main.i18n("general.menu.file.download.document"), this.downloadHandler);
        this.downloadPdf = new ToolBarButton(new Image(OKMBundleResources.INSTANCE.downloadPdfDisabled()), Main.i18n("general.menu.file.download.document.pdf"), this.downloadPdfHandler);
        this.addPropertyGroup = new ToolBarButton(new Image(OKMBundleResources.INSTANCE.addPropertyGroupDisabled()), Main.i18n("filebrowser.menu.add.property.group"), this.addPropertyGroupHandler);
        this.removePropertyGroup = new ToolBarButton(new Image(OKMBundleResources.INSTANCE.removePropertyGroupDisabled()), Main.i18n("filebrowser.menu.remove.property.group"), this.removePropertyGroupHandler);
        this.startWorkflow = new ToolBarButton(new Image(OKMBundleResources.INSTANCE.startWorkflowDisabled()), Main.i18n("filebrowser.menu.start.workflow"), this.startWorkflowHandler);
        this.addSubscription = new ToolBarButton(new Image(OKMBundleResources.INSTANCE.addSubscriptionDisabled()), Main.i18n("filebrowser.menu.add.subscription"), this.addSubscriptionHandler);
        this.removeSubscription = new ToolBarButton(new Image(OKMBundleResources.INSTANCE.removeSubscriptionDisabled()), Main.i18n("filebrowser.menu.remove.subscription"), this.removeSubscriptionHandler);
        this.home = new ToolBarButton(new Image(OKMBundleResources.INSTANCE.home()), Main.i18n("general.menu.bookmark.home"), this.arrowHomeHandler);
        this.refresh = new ToolBarButton(new Image(OKMBundleResources.INSTANCE.refresh()), Main.i18n("general.menu.file.refresh"), this.arrowRefreshHandler);
        this.scanner = new ToolBarButton(new Image(OKMBundleResources.INSTANCE.scanner()), Main.i18n("general.menu.file.scanner"), this.scannerHandler);
        this.uploader = new ToolBarButton(new Image(OKMBundleResources.INSTANCE.uploader()), Main.i18n("general.menu.file.uploader"), this.uploaderHandler);
        this.createFolder.addMouseOverHandler(this.mouseOverHandler);
        this.createFolder.addMouseOutHandler(this.mouseOutHandler);
        this.findFolder.addMouseOverHandler(this.mouseOverHandler);
        this.findFolder.addMouseOutHandler(this.mouseOutHandler);
        this.lock.addMouseOverHandler(this.mouseOverHandler);
        this.lock.addMouseOutHandler(this.mouseOutHandler);
        this.unlock.addMouseOverHandler(this.mouseOverHandler);
        this.unlock.addMouseOutHandler(this.mouseOutHandler);
        this.addDocument.addMouseOverHandler(this.mouseOverHandler);
        this.addDocument.addMouseOutHandler(this.mouseOutHandler);
        this.delete.addMouseOverHandler(this.mouseOverHandler);
        this.delete.addMouseOutHandler(this.mouseOutHandler);
        this.checkout.addMouseOverHandler(this.mouseOverHandler);
        this.checkout.addMouseOutHandler(this.mouseOutHandler);
        this.checkin.addMouseOverHandler(this.mouseOverHandler);
        this.checkin.addMouseOutHandler(this.mouseOutHandler);
        this.cancelCheckout.addMouseOverHandler(this.mouseOverHandler);
        this.cancelCheckout.addMouseOutHandler(this.mouseOutHandler);
        this.download.addMouseOverHandler(this.mouseOverHandler);
        this.download.addMouseOutHandler(this.mouseOutHandler);
        this.downloadPdf.addMouseOverHandler(this.mouseOverHandler);
        this.downloadPdf.addMouseOutHandler(this.mouseOutHandler);
        this.addPropertyGroup.addMouseOverHandler(this.mouseOverHandler);
        this.addPropertyGroup.addMouseOutHandler(this.mouseOutHandler);
        this.removePropertyGroup.addMouseOverHandler(this.mouseOverHandler);
        this.removePropertyGroup.addMouseOutHandler(this.mouseOutHandler);
        this.startWorkflow.addMouseOverHandler(this.mouseOverHandler);
        this.startWorkflow.addMouseOutHandler(this.mouseOutHandler);
        this.addSubscription.addMouseOverHandler(this.mouseOverHandler);
        this.addSubscription.addMouseOutHandler(this.mouseOutHandler);
        this.removeSubscription.addMouseOverHandler(this.mouseOverHandler);
        this.removeSubscription.addMouseOutHandler(this.mouseOutHandler);
        this.home.addMouseOverHandler(this.mouseOverHandler);
        this.home.addMouseOutHandler(this.mouseOutHandler);
        this.refresh.addMouseOverHandler(this.mouseOverHandler);
        this.refresh.addMouseOutHandler(this.mouseOutHandler);
        this.scanner.addMouseOverHandler(this.mouseOverHandler);
        this.scanner.addMouseOutHandler(this.mouseOutHandler);
        this.uploader.addMouseOverHandler(this.mouseOverHandler);
        this.uploader.addMouseOutHandler(this.mouseOutHandler);
        this.createFolder.setStyleName("okm-ToolBar-button");
        this.findFolder.setStyleName("okm-ToolBar-button");
        this.lock.setStyleName("okm-ToolBar-button");
        this.unlock.setStyleName("okm-ToolBar-button");
        this.addDocument.setStyleName("okm-ToolBar-button");
        this.delete.setStyleName("okm-ToolBar-button-disabled");
        this.checkout.setStyleName("okm-ToolBar-button-disabled");
        this.checkin.setStyleName("okm-ToolBar-button-disabled");
        this.cancelCheckout.setStyleName("okm-ToolBar-button-disabled");
        this.download.setStyleName("okm-ToolBar-button-disabled");
        this.downloadPdf.setStyleName("okm-ToolBar-button-disabled");
        this.addPropertyGroup.setStyleName("okm-ToolBar-button-disabled");
        this.removePropertyGroup.setStyleName("okm-ToolBar-button-disabled");
        this.startWorkflow.setStyleName("okm-ToolBar-button-disabled");
        this.addSubscription.setStyleName("okm-ToolBar-button-disabled");
        this.removeSubscription.setStyleName("okm-ToolBar-button-disabled");
        this.home.setStyleName("okm-ToolBar-button-disabled");
        this.refresh.setStyleName("okm-ToolBar-button-disabled");
        this.scanner.setStyleName("okm-ToolBar-button-disabled");
        this.uploader.setStyleName("okm-ToolBar-button-disabled");
        this.panel = new HorizontalPanel();
        this.panel.setVerticalAlignment(HorizontalPanel.ALIGN_MIDDLE);
        this.panel.setHorizontalAlignment(HorizontalPanel.ALIGN_LEFT);
        this.panel.addStyleName("okm-ToolBar");
        this.panel.add((Widget)this.space());
        this.panel.add((Widget)this.createFolder);
        this.panel.add((Widget)this.space());
        this.panel.add((Widget)this.findFolder);
        this.panel.add((Widget)this.space());
        this.panel.add((Widget)this.download);
        this.panel.add((Widget)this.space());
        this.panel.add((Widget)this.downloadPdf);
        this.panel.add((Widget)this.space());
        this.panel.add((Widget)new Image(OKMBundleResources.INSTANCE.separator()));
        this.panel.add((Widget)this.lock);
        this.panel.add((Widget)this.space());
        this.panel.add((Widget)this.unlock);
        this.panel.add((Widget)this.space());
        this.panel.add((Widget)new Image(OKMBundleResources.INSTANCE.separator()));
        this.panel.add((Widget)this.addDocument);
        this.panel.add((Widget)this.space());
        this.panel.add((Widget)this.checkout);
        this.panel.add((Widget)this.space());
        this.panel.add((Widget)this.checkin);
        this.panel.add((Widget)this.space());
        this.panel.add((Widget)this.cancelCheckout);
        this.panel.add((Widget)this.space());
        this.panel.add((Widget)this.delete);
        this.panel.add((Widget)this.space());
        this.panel.add((Widget)new Image(OKMBundleResources.INSTANCE.separator()));
        this.panel.add((Widget)this.addPropertyGroup);
        this.panel.add((Widget)this.space());
        this.panel.add((Widget)this.removePropertyGroup);
        this.panel.add((Widget)this.space());
        this.panel.add((Widget)new Image(OKMBundleResources.INSTANCE.separator()));
        this.panel.add((Widget)this.startWorkflow);
        this.panel.add((Widget)this.space());
        this.panel.add((Widget)new Image(OKMBundleResources.INSTANCE.separator()));
        this.panel.add((Widget)this.addSubscription);
        this.panel.add((Widget)this.space());
        this.panel.add((Widget)this.removeSubscription);
        this.panel.add((Widget)this.space());
        this.panel.add((Widget)new Image(OKMBundleResources.INSTANCE.separator()));
        this.panel.add((Widget)this.refresh);
        this.panel.add((Widget)this.space());
        this.panel.add((Widget)this.home);
        this.panel.add((Widget)this.space());
        this.panel.add((Widget)new Image(OKMBundleResources.INSTANCE.separator()));
        this.panel.add((Widget)this.scanner);
        this.panel.add((Widget)this.space());
        this.panel.add((Widget)this.uploader);
        this.panel.add((Widget)this.space());
        for (int i = 0; i < this.panel.getWidgetCount(); ++i) {
            this.panel.getWidget(i).setVisible(false);
        }
        this.initWidget((Widget)this.panel);
    }

    public void checkToolButtonPermissions(GWTFolder folder, GWTFolder folderParent, int originPanel) {
        boolean isRoot;
        this.node = folder;
        Main.get().mainPanel.topPanel.mainMenu.disableAllOptions();
        Main.get().mainPanel.desktop.browser.fileBrowser.disableAllOptions();
        Main.get().activeFolderTree.menuPopup.disableAllOptions();
        boolean bl = isRoot = Main.get().taxonomyRootFolder.getPath().equals(folder.getPath()) || Main.get().thesaurusRootFolder.getPath().equals(folder.getPath()) || Main.get().categoriesRootFolder.getPath().equals(folder.getPath()) || Main.get().templatesRootFolder.getPath().equals(folder.getPath()) || Main.get().personalRootFolder.getPath().equals(folder.getPath()) || Main.get().trashRootFolder.getPath().equals(folder.getPath()) || Main.get().mailRootFolder.getPath().equals(folder.getPath());
        if (this.isEnabled()) {
            this.disableCreateFolder();
            this.disableAddNote();
            this.disableAddDocument();
            this.disableDownload();
            this.disableDownloadPdf();
            this.disableSendDocumentLink();
            this.disableSendDocumentAttachment();
            this.disableCheckout();
            this.disableLock();
            this.disableCheckin();
            this.disableCancelCheckout();
            this.disableUnlock();
            this.disableWorkflow();
            this.disableRename();
            this.disableCopy();
            this.disableMove();
            this.disableAddNote();
            this.disableScanner();
            this.disableUploader();
            if (isRoot) {
                this.disableAddSubscription();
                this.disableRemoveSubscription();
                this.disableExport();
            } else if (folder.isSubscribed()) {
                this.disableAddSubscription();
                this.enableRemoveSubscription();
            } else {
                this.enableAddSubscription();
                this.disableRemoveSubscription();
            }
            if (!isRoot && (folderParent.getPermissions() & 4) == 4 && (folder.getPermissions() & 4) == 4) {
                this.enableDelete();
            } else {
                this.disableDelete();
            }
            if ((folder.getPermissions() & 2) == 2) {
                this.enableAddNote();
                if (originPanel != 2) {
                    this.enableAddDocument();
                    this.enableCreateFolder();
                }
                if (!isRoot) {
                    this.enableRename();
                    this.enableCopy();
                    this.enableMove();
                    this.enableExport();
                }
                if (Main.get().mainPanel.desktop.navigator.getStackIndex() == 0 || Main.get().mainPanel.desktop.navigator.getStackIndex() == 3 || Main.get().mainPanel.desktop.navigator.getStackIndex() == 4) {
                    this.enableAddDocument();
                    this.enableCreateFolder();
                    this.enableScanner();
                    this.enableUploader();
                }
                if (Main.get().mainPanel.desktop.navigator.getStackIndex() != 2 || Main.get().mainPanel.desktop.navigator.getStackIndex() != 1) {
                    this.enableWorkflow();
                }
                if ((folderParent.getPermissions() & 2) == 2 && (folder.getPermissions() & 2) == 2) {
                    this.enableRemovePropertyGroup();
                    if (Main.get().mainPanel.desktop.navigator.getStackIndex() != 1 && Main.get().mainPanel.desktop.navigator.getStackIndex() != 2 && Main.get().mainPanel.desktop.navigator.getStackIndex() != 4 && Main.get().mainPanel.desktop.navigator.getStackIndex() != 6 && Main.get().mainPanel.desktop.navigator.getStackIndex() != 5) {
                        this.getAllGroups();
                    }
                } else {
                    this.disableAddPropertyGroup();
                    this.disableRemovePropertyGroup();
                }
            } else {
                this.disableAddPropertyGroup();
                this.disableRemovePropertyGroup();
            }
            if (Main.get().mainPanel.desktop.navigator.getStackIndex() == 4 || Main.get().mainPanel.desktop.navigator.getStackIndex() == 6 || Main.get().mainPanel.desktop.navigator.getStackIndex() == 5) {
                this.disableAddPropertyGroup();
                this.disableRemovePropertyGroup();
                this.disableFiredRemovePropertyGroup();
                this.disableAddSubscription();
                this.disableRemoveSubscription();
            }
            if (Main.get().mainPanel.desktop.navigator.getStackIndex() == 3) {
                this.disableAddSubscription();
                this.disableRemoveSubscription();
            }
            if (Main.get().mainPanel.desktop.navigator.getStackIndex() == 2 || Main.get().mainPanel.desktop.navigator.getStackIndex() == 1) {
                this.disableAddDocument();
                this.disableAddSubscription();
                if (Main.get().mainPanel.desktop.navigator.getStackIndex() == 2) {
                    this.disableCreateFolder();
                    this.disableDelete();
                }
            }
            if (Main.get().mainPanel.topPanel.tabWorkspace.getSelectedWorkspace() == 0) {
                this.enableFindFolder();
            } else {
                this.disableFindFolder();
            }
            this.evaluateRemovePropertyGroup(false);
            if (Main.get().mainPanel.topPanel.tabWorkspace.getSelectedWorkspace() == 0) {
                this.enableRefresh();
                this.enableHome();
            } else if (Main.get().mainPanel.topPanel.tabWorkspace.getSelectedWorkspace() == 2) {
                this.enableRefresh();
            }
        } else if (Main.get().mainPanel.desktop.navigator.getStackIndex() == 6) {
            this.enablePurgeTrash();
            if (isRoot) {
                this.disablePurge();
                this.disableRestore();
            } else {
                this.enablePurge();
                this.enableRestore();
            }
        }
        Iterator<ToolBarButtonExtension> it = this.widgetExtensionList.iterator();
        while (it.hasNext()) {
            it.next().checkPermissions(folder, folderParent, originPanel);
        }
        this.fireEvent(HasToolBarEvent.EXECUTE_CHECK_FOLDER_PERMISSION);
        Main.get().mainPanel.desktop.browser.tabMultiple.tabFolder.notes.setVisibleAddNote(this.toolBarOption.addNoteOption);
        Main.get().mainPanel.topPanel.mainMenu.setOptions(this.toolBarOption);
        Main.get().mainPanel.desktop.browser.fileBrowser.setOptions(this.toolBarOption);
        Main.get().activeFolderTree.menuPopup.setOptions(this.toolBarOption);
    }

    public void checkToolButtonPermissions(GWTDocument doc, GWTFolder folder) {
        this.node = doc;
        Main.get().mainPanel.topPanel.mainMenu.disableAllOptions();
        Main.get().mainPanel.desktop.browser.fileBrowser.disableAllOptions();
        Main.get().activeFolderTree.menuPopup.disableAllOptions();
        if (this.isEnabled()) {
            boolean disable = false;
            String user = Main.get().workspaceUserProperties.getUser();
            this.disableAddNote();
            this.enableDownload();
            this.disableRename();
            this.disableCopy();
            this.disableMove();
            this.disableExport();
            this.disableAddNote();
            this.disableScanner();
            this.disableUploader();
            this.disableAddSubscription();
            this.disableRemoveSubscription();
            if (doc.isConvertibleToPdf()) {
                this.enableDownloadPdf();
            } else {
                this.disableDownloadPdf();
            }
            if ((doc.getPermissions() & 4) == 4 && (folder.getPermissions() & 4) == 4 && !doc.isCheckedOut() && !doc.isLocked() && Main.get().mainPanel.desktop.navigator.getStackIndex() != 2 && Main.get().mainPanel.desktop.navigator.getStackIndex() != 1) {
                this.enableDelete();
            } else {
                this.disableDelete();
            }
            if ((folder.getPermissions() & 2) == 2 && (Main.get().mainPanel.desktop.navigator.getStackIndex() == 0 || Main.get().mainPanel.desktop.navigator.getStackIndex() == 3 || Main.get().mainPanel.desktop.navigator.getStackIndex() == 4)) {
                this.enableAddDocument();
                this.enableCreateFolder();
                this.enableScanner();
                this.enableUploader();
            }
            if ((doc.getPermissions() & 2) == 2) {
                if (!doc.isCheckedOut() && !doc.isLocked()) {
                    this.enableCheckout();
                    this.enableLock();
                    this.disableCheckin();
                    this.disableCancelCheckout();
                    this.disableUnlock();
                    this.enableAddNote();
                    if (doc.isSubscribed()) {
                        this.enableRemoveSubscription();
                    } else if (!doc.isLocked()) {
                        this.enableAddSubscription();
                    }
                    if ((folder.getPermissions() & 2) == 2 || Main.get().mainPanel.desktop.navigator.getStackIndex() != 2 || Main.get().mainPanel.desktop.navigator.getStackIndex() != 1) {
                        this.enableRename();
                        this.enableCopy();
                        this.enableMove();
                        this.enableRemovePropertyGroup();
                        this.enableWorkflow();
                        if (Main.get().mainPanel.desktop.navigator.getStackIndex() != 1 && Main.get().mainPanel.desktop.navigator.getStackIndex() != 2 && Main.get().mainPanel.desktop.navigator.getStackIndex() != 4 && Main.get().mainPanel.desktop.navigator.getStackIndex() != 6 && Main.get().mainPanel.desktop.navigator.getStackIndex() != 5) {
                            this.getAllGroups();
                        }
                    } else {
                        this.disableAddPropertyGroup();
                        this.disableRemovePropertyGroup();
                    }
                } else if (doc.isCheckedOut()) {
                    if (doc.getLockInfo().getOwner().equals(user) || Main.get().workspaceUserProperties.getWorkspace().isAdminRole()) {
                        if (doc.getLockInfo().getOwner().equals(user)) {
                            this.enableCheckin();
                            this.enableAddPropertyGroup();
                            this.enableRemovePropertyGroup();
                            this.enableAddNote();
                        } else {
                            this.disableCheckin();
                            this.disableAddPropertyGroup();
                            this.disableRemovePropertyGroup();
                            this.disableAddNote();
                        }
                        this.enableCancelCheckout();
                        this.disableCheckout();
                        this.disableLock();
                        this.disableUnlock();
                    } else {
                        disable = true;
                    }
                } else if (doc.getLockInfo().getOwner().equals(user) || Main.get().workspaceUserProperties.getWorkspace().isAdminRole()) {
                    this.enableUnlock();
                    this.disableCheckin();
                    this.disableCancelCheckout();
                    this.disableCheckout();
                    this.disableLock();
                    this.enableAddPropertyGroup();
                    this.enableRemovePropertyGroup();
                    this.enableAddNote();
                    if (doc.isSubscribed()) {
                        this.enableRemoveSubscription();
                    } else if (!doc.isLocked()) {
                        this.enableAddSubscription();
                    }
                } else {
                    disable = true;
                }
            } else {
                disable = true;
            }
            if (disable) {
                this.disableLock();
                this.disableUnlock();
                this.disableCheckout();
                this.disableCheckin();
                this.disableCancelCheckout();
                this.disableAddPropertyGroup();
                this.disableRemovePropertyGroup();
                this.disableWorkflow();
            }
            if (Main.get().mainPanel.desktop.navigator.getStackIndex() == 0 || Main.get().mainPanel.desktop.navigator.getStackIndex() != 2 || Main.get().mainPanel.desktop.navigator.getStackIndex() != 1) {
                this.enableSendDocumentLink();
                this.enableSendDocumentAttachment();
            } else {
                this.disableSendDocumentLink();
                this.disableSendDocumentAttachment();
            }
            if (Main.get().mainPanel.desktop.navigator.getStackIndex() == 4 || Main.get().mainPanel.desktop.navigator.getStackIndex() == 6 || Main.get().mainPanel.desktop.navigator.getStackIndex() == 5) {
                this.disableAddPropertyGroup();
                this.disableRemovePropertyGroup();
                this.disableFiredRemovePropertyGroup();
                this.disableAddSubscription();
                this.disableRemoveSubscription();
            }
            if (Main.get().mainPanel.desktop.navigator.getStackIndex() == 3) {
                this.disableAddSubscription();
                this.disableRemoveSubscription();
            }
            if (Main.get().mainPanel.topPanel.tabWorkspace.getSelectedWorkspace() == 0) {
                this.enableFindFolder();
            } else {
                this.disableFindFolder();
            }
            if (Main.get().mainPanel.topPanel.tabWorkspace.getSelectedWorkspace() == 0) {
                this.enableRefresh();
                this.enableHome();
            } else if (Main.get().mainPanel.topPanel.tabWorkspace.getSelectedWorkspace() == 2) {
                this.enableRefresh();
            }
        } else if (Main.get().mainPanel.desktop.navigator.getStackIndex() == 6) {
            this.enablePurgeTrash();
            this.enablePurge();
            this.enableRestore();
        }
        Iterator<ToolBarButtonExtension> it = this.widgetExtensionList.iterator();
        while (it.hasNext()) {
            it.next().checkPermissions(doc, folder);
        }
        this.fireEvent(HasToolBarEvent.EXECUTE_CHECK_DOCUMENT_PERMISSION);
        Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.notes.setVisibleAddNote(this.toolBarOption.addNoteOption);
        Main.get().mainPanel.topPanel.mainMenu.setOptions(this.toolBarOption);
        Main.get().mainPanel.desktop.browser.fileBrowser.setOptions(this.toolBarOption);
        Main.get().activeFolderTree.menuPopup.setOptions(this.toolBarOption);
    }

    public void checkToolButtonPermissions(GWTMail mail, GWTFolder folder) {
        this.node = mail;
        Main.get().mainPanel.topPanel.mainMenu.disableAllOptions();
        Main.get().mainPanel.desktop.browser.fileBrowser.disableAllOptions();
        Main.get().activeFolderTree.menuPopup.disableAllOptions();
        if (this.isEnabled()) {
            this.disableAddNote();
            this.disableDownload();
            this.disableRename();
            this.disableCopy();
            this.disableMove();
            this.disableExport();
            this.disableDownloadPdf();
            this.disableAddSubscription();
            this.disableRemoveSubscription();
            this.disableCheckout();
            this.disableLock();
            this.disableUnlock();
            this.disableCheckout();
            this.disableCheckin();
            this.disableCancelCheckout();
            this.disableWorkflow();
            this.disableAddDocument();
            this.disableAddNote();
            this.disableScanner();
            this.disableUploader();
            if ((mail.getPermissions() & 4) == 4 && (folder.getPermissions() & 4) == 4) {
                this.enableDelete();
            } else {
                this.disableDelete();
            }
            if ((folder.getPermissions() & 2) == 2 && (Main.get().mainPanel.desktop.navigator.getStackIndex() == 0 || Main.get().mainPanel.desktop.navigator.getStackIndex() == 3 || Main.get().mainPanel.desktop.navigator.getStackIndex() == 4)) {
                this.enableAddDocument();
                this.enableCreateFolder();
                this.enableScanner();
                this.enableUploader();
            }
            if ((mail.getPermissions() & 2) == 2 && (folder.getPermissions() & 2) == 2) {
                if ((folder.getPermissions() & 2) == 2 || Main.get().mainPanel.desktop.navigator.getStackIndex() != 2 || Main.get().mainPanel.desktop.navigator.getStackIndex() != 1) {
                    this.enableWorkflow();
                }
                this.enableAddNote();
                this.enableRename();
                this.enableCopy();
                this.enableMove();
                this.enableRemovePropertyGroup();
                if (Main.get().mainPanel.desktop.navigator.getStackIndex() != 1 && Main.get().mainPanel.desktop.navigator.getStackIndex() != 2 && Main.get().mainPanel.desktop.navigator.getStackIndex() != 4 && Main.get().mainPanel.desktop.navigator.getStackIndex() != 6 && Main.get().mainPanel.desktop.navigator.getStackIndex() != 5) {
                    this.getAllGroups();
                }
                if (Main.get().mainPanel.desktop.navigator.getStackIndex() != 5) {
                    this.enableAddDocument();
                }
            } else {
                this.disableAddPropertyGroup();
                this.disableRemovePropertyGroup();
            }
            if (Main.get().mainPanel.desktop.navigator.getStackIndex() == 0) {
                this.enableSendDocumentLink();
                this.enableSendDocumentAttachment();
            } else {
                this.disableSendDocumentLink();
                this.disableSendDocumentAttachment();
            }
            if (Main.get().mainPanel.desktop.navigator.getStackIndex() == 4 || Main.get().mainPanel.desktop.navigator.getStackIndex() == 6 || Main.get().mainPanel.desktop.navigator.getStackIndex() == 5) {
                this.disableAddPropertyGroup();
                this.disableRemovePropertyGroup();
                this.disableFiredRemovePropertyGroup();
                this.disableAddSubscription();
                this.disableRemoveSubscription();
            }
            if (Main.get().mainPanel.desktop.navigator.getStackIndex() == 3) {
                this.disableAddSubscription();
                this.disableRemoveSubscription();
            }
            if (Main.get().mainPanel.topPanel.tabWorkspace.getSelectedWorkspace() == 0) {
                this.enableRefresh();
                this.enableHome();
            } else if (Main.get().mainPanel.topPanel.tabWorkspace.getSelectedWorkspace() == 2) {
                this.enableRefresh();
            }
        } else if (Main.get().mainPanel.desktop.navigator.getStackIndex() == 6) {
            this.enablePurgeTrash();
            this.enablePurge();
            this.enableRestore();
        }
        Iterator<ToolBarButtonExtension> it = this.widgetExtensionList.iterator();
        while (it.hasNext()) {
            it.next().checkPermissions(mail, folder);
        }
        this.fireEvent(HasToolBarEvent.EXECUTE_CHECK_MAIL_PERMISSION);
        Main.get().mainPanel.topPanel.mainMenu.setOptions(this.toolBarOption);
        Main.get().mainPanel.desktop.browser.fileBrowser.setOptions(this.toolBarOption);
        Main.get().activeFolderTree.menuPopup.setOptions(this.toolBarOption);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void enableCreateFolder() {
        this.toolBarOption.createFolderOption = true;
        this.createFolder.setStyleName("okm-ToolBar-button");
        this.createFolder.setResource(OKMBundleResources.INSTANCE.createFolder());
        this.createFolder.setTitle(Main.i18n("tree.menu.directory.create"));
    }

    public void disableCreateFolder() {
        this.toolBarOption.createFolderOption = false;
        this.createFolder.setStyleName("okm-ToolBar-button-disabled");
        this.createFolder.setResource(OKMBundleResources.INSTANCE.createFolderDisabled());
        this.createFolder.setTitle(Main.i18n("tree.menu.directory.create"));
    }

    public void enableFindFolder() {
        this.toolBarOption.findFolderOption = true;
        this.findFolder.setStyleName("okm-ToolBar-button");
        this.findFolder.setResource(OKMBundleResources.INSTANCE.findFolder());
        this.findFolder.setTitle(Main.i18n("tree.menu.directory.find.folder"));
    }

    public void disableFindFolder() {
        this.toolBarOption.findFolderOption = false;
        this.findFolder.setStyleName("okm-ToolBar-button-disabled");
        this.findFolder.setResource(OKMBundleResources.INSTANCE.findFolderDisabled());
        this.findFolder.setTitle(Main.i18n("tree.menu.directory.find.folder"));
    }

    public void enableCheckout() {
        this.toolBarOption.checkoutOption = true;
        this.checkout.setStyleName("okm-ToolBar-button");
        this.checkout.setResource(OKMBundleResources.INSTANCE.checkout());
        this.checkout.setTitle(Main.i18n("general.menu.file.checkout"));
    }

    public void disableCheckout() {
        this.toolBarOption.checkoutOption = false;
        this.checkout.setStyleName("okm-ToolBar-button-disabled");
        this.checkout.setResource(OKMBundleResources.INSTANCE.checkoutDisabled());
        this.checkout.setTitle(Main.i18n("general.menu.file.checkout"));
    }

    public void enableCheckin() {
        this.toolBarOption.checkinOption = true;
        this.checkin.setStyleName("okm-ToolBar-button");
        this.checkin.setResource(OKMBundleResources.INSTANCE.checkin());
        this.checkin.setTitle(Main.i18n("general.menu.file.checkin"));
    }

    public void disableCheckin() {
        this.toolBarOption.checkinOption = false;
        this.checkin.setStyleName("okm-ToolBar-button-disabled");
        this.checkin.setResource(OKMBundleResources.INSTANCE.checkinDisabled());
        this.checkin.setTitle(Main.i18n("general.menu.file.checkin"));
    }

    public void enableCancelCheckout() {
        this.toolBarOption.cancelCheckoutOption = true;
        this.cancelCheckout.setStyleName("okm-ToolBar-button");
        this.cancelCheckout.setResource(OKMBundleResources.INSTANCE.cancelCheckout());
        this.cancelCheckout.setTitle(Main.i18n("general.menu.file.cancel.checkout"));
    }

    public void disableCancelCheckout() {
        this.toolBarOption.cancelCheckoutOption = false;
        this.cancelCheckout.setStyleName("okm-ToolBar-button-disabled");
        this.cancelCheckout.setResource(OKMBundleResources.INSTANCE.cancelCheckoutDisabled());
        this.cancelCheckout.setTitle(Main.i18n("general.menu.file.cancel.checkout"));
    }

    public void disableLock() {
        this.toolBarOption.lockOption = false;
        this.lock.setStyleName("okm-ToolBar-button-disabled");
        this.lock.setResource(OKMBundleResources.INSTANCE.lockDisabled());
        this.lock.setTitle(Main.i18n("general.menu.file.lock"));
    }

    public void enableLock() {
        this.toolBarOption.lockOption = true;
        this.lock.setStyleName("okm-ToolBar-button");
        this.lock.setResource(OKMBundleResources.INSTANCE.lock());
        this.lock.setTitle(Main.i18n("general.menu.file.lock"));
    }

    public void disableUnlock() {
        this.toolBarOption.unLockOption = false;
        this.unlock.setStyleName("okm-ToolBar-button-disabled");
        this.unlock.setResource(OKMBundleResources.INSTANCE.unLockDisabled());
        this.unlock.setTitle(Main.i18n("general.menu.file.unlock"));
    }

    public void enableUnlock() {
        this.toolBarOption.unLockOption = true;
        this.unlock.setStyleName("okm-ToolBar-button");
        this.unlock.setResource(OKMBundleResources.INSTANCE.unLock());
        this.unlock.setTitle(Main.i18n("general.menu.file.unlock"));
    }

    public void disableDownload() {
        this.toolBarOption.downloadOption = false;
        this.download.setStyleName("okm-ToolBar-button-disabled");
        this.download.setResource(OKMBundleResources.INSTANCE.downloadDisabled());
        this.download.setTitle(Main.i18n("general.menu.file.download.document"));
    }

    public void enableDownload() {
        this.toolBarOption.downloadOption = true;
        this.download.setStyleName("okm-ToolBar-button");
        this.download.setResource(OKMBundleResources.INSTANCE.download());
        this.download.setTitle(Main.i18n("general.menu.file.download.document"));
    }

    public void disableDownloadPdf() {
        this.toolBarOption.downloadPdfOption = false;
        this.downloadPdf.setStyleName("okm-ToolBar-button-disabled");
        this.downloadPdf.setResource(OKMBundleResources.INSTANCE.downloadPdfDisabled());
        this.downloadPdf.setTitle(Main.i18n("general.menu.file.download.document.pdf"));
    }

    public void enableDownloadPdf() {
        this.toolBarOption.downloadPdfOption = true;
        this.downloadPdf.setStyleName("okm-ToolBar-button");
        this.downloadPdf.setResource(OKMBundleResources.INSTANCE.downloadPdf());
        this.downloadPdf.setTitle(Main.i18n("general.menu.file.download.document.pdf"));
    }

    public void disableSendDocumentLink() {
        this.toolBarOption.sendDocumentLinkOption = false;
    }

    public void enableSendDocumentLink() {
        this.toolBarOption.sendDocumentLinkOption = true;
    }

    public void disableSendDocumentAttachment() {
        this.toolBarOption.sendDocumentAttachmentOption = false;
    }

    public void enableSendDocumentAttachment() {
        this.toolBarOption.sendDocumentAttachmentOption = true;
    }

    public void disableDelete() {
        this.toolBarOption.deleteOption = false;
        this.delete.setStyleName("okm-ToolBar-button-disabled");
        this.delete.setResource(OKMBundleResources.INSTANCE.deleteDisabled());
        this.delete.setTitle(Main.i18n("general.menu.file.delete"));
    }

    public void enableDelete() {
        this.toolBarOption.deleteOption = true;
        this.delete.setStyleName("okm-ToolBar-button");
        this.delete.setResource(OKMBundleResources.INSTANCE.delete());
        this.delete.setTitle(Main.i18n("general.menu.file.delete"));
    }

    public void disableRefresh() {
        this.toolBarOption.refreshOption = false;
        this.refresh.setStyleName("okm-ToolBar-button-disabled");
        this.refresh.setResource(OKMBundleResources.INSTANCE.refreshDisabled());
        this.refresh.setTitle(Main.i18n("general.menu.file.refresh"));
    }

    public void enableRefresh() {
        this.toolBarOption.refreshOption = true;
        this.refresh.setStyleName("okm-ToolBar-button");
        this.refresh.setResource(OKMBundleResources.INSTANCE.refresh());
        this.refresh.setTitle(Main.i18n("general.menu.file.refresh"));
    }

    public void disableAddDocument() {
        this.toolBarOption.addDocumentOption = false;
        this.addDocument.setStyleName("okm-ToolBar-button-disabled");
        this.addDocument.setResource(OKMBundleResources.INSTANCE.addDocumentDisabled());
        this.addDocument.setTitle(Main.i18n("general.menu.file.add.document"));
    }

    public void enableAddDocument() {
        this.toolBarOption.addDocumentOption = true;
        this.addDocument.setStyleName("okm-ToolBar-button");
        this.addDocument.setResource(OKMBundleResources.INSTANCE.addDocument());
        this.addDocument.setTitle(Main.i18n("general.menu.file.add.document"));
    }

    public void disableAddPropertyGroup() {
        this.toolBarOption.addPropertyGroupOption = false;
        this.addPropertyGroup.setStyleName("okm-ToolBar-button-disabled");
        this.addPropertyGroup.setResource(OKMBundleResources.INSTANCE.addPropertyGroupDisabled());
        this.addPropertyGroup.setTitle(Main.i18n("filebrowser.menu.add.property.group"));
    }

    public void enableAddPropertyGroup() {
        this.toolBarOption.addPropertyGroupOption = true;
        this.addPropertyGroup.setStyleName("okm-ToolBar-button");
        this.addPropertyGroup.setResource(OKMBundleResources.INSTANCE.addPropertyGroup());
        this.addPropertyGroup.setTitle(Main.i18n("filebrowser.menu.add.property.group"));
    }

    public void disableAddSubscription() {
        this.toolBarOption.addSubscription = false;
        this.addSubscription.setStyleName("okm-ToolBar-button-disabled");
        this.addSubscription.setResource(OKMBundleResources.INSTANCE.addSubscriptionDisabled());
        this.addSubscription.setTitle(Main.i18n("filebrowser.menu.add.subscription"));
    }

    public void enableAddSubscription() {
        this.toolBarOption.addSubscription = true;
        this.addSubscription.setStyleName("okm-ToolBar-button");
        this.addSubscription.setResource(OKMBundleResources.INSTANCE.addSubscription());
        this.addSubscription.setTitle(Main.i18n("filebrowser.menu.add.subscription"));
    }

    public void disableRemoveSubscription() {
        this.toolBarOption.removeSubscription = false;
        this.removeSubscription.setStyleName("okm-ToolBar-button-disabled");
        this.removeSubscription.setResource(OKMBundleResources.INSTANCE.removeSubscriptionDisabled());
        this.removeSubscription.setTitle(Main.i18n("filebrowser.menu.remove.subscription"));
    }

    public void enableRemoveSubscription() {
        this.toolBarOption.removeSubscription = true;
        this.removeSubscription.setStyleName("okm-ToolBar-button");
        this.removeSubscription.setResource(OKMBundleResources.INSTANCE.removeSubscription());
        this.removeSubscription.setTitle(Main.i18n("filebrowser.menu.remove.subscription"));
    }

    public void disableHome() {
        this.toolBarOption.homeOption = false;
        this.home.setStyleName("okm-ToolBar-button-disabled");
        this.home.setResource(OKMBundleResources.INSTANCE.homeDisabled());
        this.home.setTitle(Main.i18n("general.menu.bookmark.home"));
    }

    public void enableHome() {
        this.toolBarOption.homeOption = true;
        this.home.setStyleName("okm-ToolBar-button");
        this.home.setResource(OKMBundleResources.INSTANCE.home());
        this.home.setTitle(Main.i18n("general.menu.bookmark.home"));
    }

    public void enableRestore() {
        this.toolBarOption.restore = true;
    }

    public void disableRestore() {
        this.toolBarOption.restore = false;
    }

    public void enablePurge() {
        this.toolBarOption.purge = true;
    }

    public void disablePurge() {
        this.toolBarOption.purge = false;
    }

    public void enablePurgeTrash() {
        this.toolBarOption.purgeTrash = true;
    }

    public void disablePurgeTrash() {
        this.toolBarOption.purgeTrash = false;
    }

    public void disableRemovePropertyGroup() {
        this.toolBarOption.removePropertyGroupOption = false;
    }

    public void enableRemovePropertyGroup() {
        this.toolBarOption.removePropertyGroupOption = true;
    }

    public void disableWorkflow() {
        this.toolBarOption.workflowOption = false;
        this.startWorkflow.setStyleName("okm-ToolBar-button-disabled");
        this.startWorkflow.setResource(OKMBundleResources.INSTANCE.startWorkflowDisabled());
        this.startWorkflow.setTitle(Main.i18n("filebrowser.menu.start.workflow"));
    }

    public void enableWorkflow() {
        this.toolBarOption.workflowOption = true;
        this.startWorkflow.setStyleName("okm-ToolBar-button");
        this.startWorkflow.setResource(OKMBundleResources.INSTANCE.startWorkflow());
        this.startWorkflow.setTitle(Main.i18n("filebrowser.menu.start.workflow"));
    }

    public void disableScanner() {
        this.toolBarOption.scannerOption = false;
        this.scanner.setStyleName("okm-ToolBar-button-disabled");
        this.scanner.setResource(OKMBundleResources.INSTANCE.scannerDisabled());
        this.scanner.setTitle(Main.i18n("general.menu.file.scanner"));
    }

    public void enableScanner() {
        this.toolBarOption.scannerOption = true;
        this.scanner.setStyleName("okm-ToolBar-button");
        this.scanner.setResource(OKMBundleResources.INSTANCE.scanner());
        this.scanner.setTitle(Main.i18n("general.menu.file.scanner"));
    }

    public void disableUploader() {
        this.toolBarOption.uploaderOption = false;
        this.uploader.setStyleName("okm-ToolBar-button-disabled");
        this.uploader.setResource(OKMBundleResources.INSTANCE.uploaderDisabled());
        this.uploader.setTitle(Main.i18n("general.menu.file.uploader"));
    }

    public void enableUploader() {
        this.toolBarOption.uploaderOption = true;
        this.uploader.setStyleName("okm-ToolBar-button");
        this.uploader.setResource(OKMBundleResources.INSTANCE.uploader());
        this.uploader.setTitle(Main.i18n("general.menu.file.uploader"));
    }

    public void disableFiredRemovePropertyGroup() {
        this.toolBarOption.firedRemovePropertyGroupOption = false;
    }

    public void enableFiredRemovePropertyGroup() {
        this.toolBarOption.firedRemovePropertyGroupOption = true;
    }

    public void enableRename() {
        this.toolBarOption.renameOption = true;
    }

    public void disableRename() {
        this.toolBarOption.renameOption = false;
    }

    public void enableCopy() {
        this.toolBarOption.copyOption = true;
    }

    public void disableCopy() {
        this.toolBarOption.copyOption = false;
    }

    public void enableMove() {
        this.toolBarOption.moveOption = true;
    }

    public void disableMove() {
        this.toolBarOption.moveOption = false;
    }

    public void enableExport() {
        this.toolBarOption.exportOption = true;
    }

    public void disableExport() {
        this.toolBarOption.exportOption = false;
    }

    public void enableAddNote() {
        this.toolBarOption.addNoteOption = true;
    }

    public void disableAddNote() {
        this.toolBarOption.addNoteOption = false;
    }

    public ToolBarOption getDefaultRootToolBar() {
        ToolBarOption tmpToolBarOption = new ToolBarOption();
        tmpToolBarOption.createFolderOption = true;
        tmpToolBarOption.findFolderOption = true;
        tmpToolBarOption.addDocumentOption = true;
        tmpToolBarOption.checkoutOption = false;
        tmpToolBarOption.checkinOption = false;
        tmpToolBarOption.cancelCheckoutOption = false;
        tmpToolBarOption.lockOption = false;
        tmpToolBarOption.unLockOption = false;
        tmpToolBarOption.downloadOption = false;
        tmpToolBarOption.downloadPdfOption = false;
        tmpToolBarOption.deleteOption = false;
        tmpToolBarOption.addPropertyGroupOption = false;
        tmpToolBarOption.removePropertyGroupOption = false;
        tmpToolBarOption.addSubscription = false;
        tmpToolBarOption.removeSubscription = false;
        tmpToolBarOption.firedRemovePropertyGroupOption = false;
        tmpToolBarOption.homeOption = true;
        tmpToolBarOption.refreshOption = true;
        tmpToolBarOption.renameOption = false;
        tmpToolBarOption.copyOption = false;
        tmpToolBarOption.moveOption = false;
        tmpToolBarOption.exportOption = false;
        tmpToolBarOption.workflowOption = false;
        tmpToolBarOption.addNoteOption = false;
        tmpToolBarOption.scannerOption = true;
        tmpToolBarOption.uploaderOption = true;
        tmpToolBarOption.bookmarkOption = true;
        tmpToolBarOption.goOption = false;
        tmpToolBarOption.createFromTemplateOption = false;
        tmpToolBarOption.restore = false;
        tmpToolBarOption.purge = false;
        tmpToolBarOption.purgeTrash = true;
        return tmpToolBarOption;
    }

    public ToolBarOption getDefaultCategoriesToolBar() {
        ToolBarOption tmpToolBarOption = new ToolBarOption();
        tmpToolBarOption.createFolderOption = true;
        tmpToolBarOption.findFolderOption = true;
        tmpToolBarOption.addDocumentOption = false;
        tmpToolBarOption.checkoutOption = false;
        tmpToolBarOption.checkinOption = false;
        tmpToolBarOption.cancelCheckoutOption = false;
        tmpToolBarOption.lockOption = false;
        tmpToolBarOption.unLockOption = false;
        tmpToolBarOption.downloadOption = false;
        tmpToolBarOption.downloadPdfOption = false;
        tmpToolBarOption.deleteOption = false;
        tmpToolBarOption.addPropertyGroupOption = false;
        tmpToolBarOption.removePropertyGroupOption = false;
        tmpToolBarOption.addSubscription = false;
        tmpToolBarOption.removeSubscription = false;
        tmpToolBarOption.firedRemovePropertyGroupOption = false;
        tmpToolBarOption.homeOption = false;
        tmpToolBarOption.refreshOption = true;
        tmpToolBarOption.renameOption = false;
        tmpToolBarOption.copyOption = false;
        tmpToolBarOption.moveOption = false;
        tmpToolBarOption.exportOption = false;
        tmpToolBarOption.workflowOption = false;
        tmpToolBarOption.addNoteOption = false;
        tmpToolBarOption.scannerOption = false;
        tmpToolBarOption.uploaderOption = false;
        tmpToolBarOption.bookmarkOption = false;
        tmpToolBarOption.goOption = false;
        tmpToolBarOption.createFromTemplateOption = false;
        tmpToolBarOption.restore = false;
        tmpToolBarOption.purge = false;
        tmpToolBarOption.purgeTrash = true;
        return tmpToolBarOption;
    }

    public ToolBarOption getDefaultThesaurusToolBar() {
        ToolBarOption tmpToolBarOption = new ToolBarOption();
        tmpToolBarOption.createFolderOption = false;
        tmpToolBarOption.findFolderOption = true;
        tmpToolBarOption.addDocumentOption = false;
        tmpToolBarOption.checkoutOption = false;
        tmpToolBarOption.checkinOption = false;
        tmpToolBarOption.cancelCheckoutOption = false;
        tmpToolBarOption.lockOption = false;
        tmpToolBarOption.unLockOption = false;
        tmpToolBarOption.downloadOption = false;
        tmpToolBarOption.downloadPdfOption = false;
        tmpToolBarOption.deleteOption = false;
        tmpToolBarOption.addPropertyGroupOption = false;
        tmpToolBarOption.removePropertyGroupOption = false;
        tmpToolBarOption.addSubscription = false;
        tmpToolBarOption.removeSubscription = false;
        tmpToolBarOption.firedRemovePropertyGroupOption = false;
        tmpToolBarOption.homeOption = false;
        tmpToolBarOption.refreshOption = true;
        tmpToolBarOption.renameOption = false;
        tmpToolBarOption.copyOption = false;
        tmpToolBarOption.moveOption = false;
        tmpToolBarOption.exportOption = false;
        tmpToolBarOption.workflowOption = false;
        tmpToolBarOption.addNoteOption = false;
        tmpToolBarOption.scannerOption = false;
        tmpToolBarOption.uploaderOption = false;
        tmpToolBarOption.bookmarkOption = false;
        tmpToolBarOption.goOption = false;
        tmpToolBarOption.createFromTemplateOption = false;
        tmpToolBarOption.restore = false;
        tmpToolBarOption.purge = false;
        tmpToolBarOption.purgeTrash = true;
        return tmpToolBarOption;
    }

    public ToolBarOption getDefaultTrashToolBar() {
        ToolBarOption tmpToolBarOption = new ToolBarOption();
        tmpToolBarOption.createFolderOption = false;
        tmpToolBarOption.findFolderOption = true;
        tmpToolBarOption.addDocumentOption = false;
        tmpToolBarOption.checkoutOption = false;
        tmpToolBarOption.checkinOption = false;
        tmpToolBarOption.cancelCheckoutOption = false;
        tmpToolBarOption.lockOption = false;
        tmpToolBarOption.unLockOption = false;
        tmpToolBarOption.downloadOption = false;
        tmpToolBarOption.downloadPdfOption = false;
        tmpToolBarOption.deleteOption = false;
        tmpToolBarOption.addPropertyGroupOption = false;
        tmpToolBarOption.removePropertyGroupOption = false;
        tmpToolBarOption.addSubscription = false;
        tmpToolBarOption.removeSubscription = false;
        tmpToolBarOption.firedRemovePropertyGroupOption = false;
        tmpToolBarOption.homeOption = false;
        tmpToolBarOption.refreshOption = true;
        tmpToolBarOption.renameOption = false;
        tmpToolBarOption.copyOption = false;
        tmpToolBarOption.moveOption = false;
        tmpToolBarOption.exportOption = false;
        tmpToolBarOption.workflowOption = false;
        tmpToolBarOption.addNoteOption = false;
        tmpToolBarOption.scannerOption = false;
        tmpToolBarOption.uploaderOption = false;
        tmpToolBarOption.bookmarkOption = false;
        tmpToolBarOption.goOption = false;
        tmpToolBarOption.createFromTemplateOption = false;
        tmpToolBarOption.restore = false;
        tmpToolBarOption.purge = false;
        tmpToolBarOption.purgeTrash = true;
        return tmpToolBarOption;
    }

    public ToolBarOption getDefaultTemplatesToolBar() {
        ToolBarOption tmpToolBarOption = new ToolBarOption();
        tmpToolBarOption.createFolderOption = true;
        tmpToolBarOption.findFolderOption = true;
        tmpToolBarOption.addDocumentOption = true;
        tmpToolBarOption.checkoutOption = false;
        tmpToolBarOption.checkinOption = false;
        tmpToolBarOption.cancelCheckoutOption = false;
        tmpToolBarOption.lockOption = false;
        tmpToolBarOption.unLockOption = false;
        tmpToolBarOption.downloadOption = false;
        tmpToolBarOption.downloadPdfOption = false;
        tmpToolBarOption.deleteOption = false;
        tmpToolBarOption.addPropertyGroupOption = false;
        tmpToolBarOption.removePropertyGroupOption = false;
        tmpToolBarOption.addSubscription = false;
        tmpToolBarOption.removeSubscription = false;
        tmpToolBarOption.firedRemovePropertyGroupOption = false;
        tmpToolBarOption.homeOption = false;
        tmpToolBarOption.refreshOption = true;
        tmpToolBarOption.renameOption = false;
        tmpToolBarOption.copyOption = false;
        tmpToolBarOption.moveOption = false;
        tmpToolBarOption.exportOption = false;
        tmpToolBarOption.workflowOption = false;
        tmpToolBarOption.addNoteOption = false;
        tmpToolBarOption.scannerOption = false;
        tmpToolBarOption.uploaderOption = false;
        tmpToolBarOption.bookmarkOption = false;
        tmpToolBarOption.goOption = false;
        tmpToolBarOption.createFromTemplateOption = false;
        tmpToolBarOption.restore = false;
        tmpToolBarOption.purge = false;
        tmpToolBarOption.purgeTrash = true;
        return tmpToolBarOption;
    }

    public ToolBarOption getDefaultMyDocumentsToolBar() {
        ToolBarOption tmpToolBarOption = new ToolBarOption();
        tmpToolBarOption.createFolderOption = true;
        tmpToolBarOption.findFolderOption = true;
        tmpToolBarOption.addDocumentOption = true;
        tmpToolBarOption.checkoutOption = false;
        tmpToolBarOption.checkinOption = false;
        tmpToolBarOption.cancelCheckoutOption = false;
        tmpToolBarOption.lockOption = false;
        tmpToolBarOption.unLockOption = false;
        tmpToolBarOption.downloadOption = false;
        tmpToolBarOption.downloadPdfOption = false;
        tmpToolBarOption.deleteOption = false;
        tmpToolBarOption.addPropertyGroupOption = false;
        tmpToolBarOption.removePropertyGroupOption = false;
        tmpToolBarOption.addSubscription = false;
        tmpToolBarOption.removeSubscription = false;
        tmpToolBarOption.firedRemovePropertyGroupOption = false;
        tmpToolBarOption.homeOption = false;
        tmpToolBarOption.refreshOption = true;
        tmpToolBarOption.renameOption = false;
        tmpToolBarOption.copyOption = false;
        tmpToolBarOption.moveOption = false;
        tmpToolBarOption.exportOption = false;
        tmpToolBarOption.workflowOption = false;
        tmpToolBarOption.addNoteOption = false;
        tmpToolBarOption.scannerOption = true;
        tmpToolBarOption.uploaderOption = true;
        tmpToolBarOption.bookmarkOption = false;
        tmpToolBarOption.goOption = false;
        tmpToolBarOption.createFromTemplateOption = false;
        tmpToolBarOption.restore = false;
        tmpToolBarOption.purge = false;
        tmpToolBarOption.purgeTrash = true;
        return tmpToolBarOption;
    }

    public ToolBarOption getDefaultMailToolBar() {
        ToolBarOption tmpToolBarOption = new ToolBarOption();
        tmpToolBarOption.createFolderOption = true;
        tmpToolBarOption.findFolderOption = true;
        tmpToolBarOption.addDocumentOption = true;
        tmpToolBarOption.checkoutOption = false;
        tmpToolBarOption.checkinOption = false;
        tmpToolBarOption.cancelCheckoutOption = false;
        tmpToolBarOption.lockOption = false;
        tmpToolBarOption.unLockOption = false;
        tmpToolBarOption.downloadOption = false;
        tmpToolBarOption.downloadPdfOption = false;
        tmpToolBarOption.deleteOption = false;
        tmpToolBarOption.addPropertyGroupOption = false;
        tmpToolBarOption.removePropertyGroupOption = false;
        tmpToolBarOption.addSubscription = false;
        tmpToolBarOption.removeSubscription = false;
        tmpToolBarOption.firedRemovePropertyGroupOption = false;
        tmpToolBarOption.homeOption = true;
        tmpToolBarOption.refreshOption = true;
        tmpToolBarOption.renameOption = false;
        tmpToolBarOption.copyOption = false;
        tmpToolBarOption.moveOption = false;
        tmpToolBarOption.exportOption = false;
        tmpToolBarOption.workflowOption = false;
        tmpToolBarOption.addNoteOption = false;
        tmpToolBarOption.scannerOption = true;
        tmpToolBarOption.uploaderOption = true;
        tmpToolBarOption.bookmarkOption = false;
        tmpToolBarOption.goOption = false;
        tmpToolBarOption.createFromTemplateOption = false;
        tmpToolBarOption.restore = false;
        tmpToolBarOption.purge = false;
        tmpToolBarOption.purgeTrash = true;
        return tmpToolBarOption;
    }

    public ToolBarOption getDefaultSearchToolBar() {
        ToolBarOption tmpToolBarOption = new ToolBarOption();
        tmpToolBarOption.createFolderOption = false;
        tmpToolBarOption.findFolderOption = false;
        tmpToolBarOption.addDocumentOption = false;
        tmpToolBarOption.checkoutOption = false;
        tmpToolBarOption.checkinOption = false;
        tmpToolBarOption.cancelCheckoutOption = false;
        tmpToolBarOption.lockOption = false;
        tmpToolBarOption.unLockOption = false;
        tmpToolBarOption.downloadOption = false;
        tmpToolBarOption.downloadPdfOption = false;
        tmpToolBarOption.deleteOption = false;
        tmpToolBarOption.addPropertyGroupOption = false;
        tmpToolBarOption.removePropertyGroupOption = false;
        tmpToolBarOption.addSubscription = false;
        tmpToolBarOption.removeSubscription = false;
        tmpToolBarOption.firedRemovePropertyGroupOption = false;
        tmpToolBarOption.homeOption = false;
        tmpToolBarOption.refreshOption = false;
        tmpToolBarOption.renameOption = false;
        tmpToolBarOption.copyOption = false;
        tmpToolBarOption.moveOption = false;
        tmpToolBarOption.exportOption = false;
        tmpToolBarOption.workflowOption = false;
        tmpToolBarOption.addNoteOption = false;
        tmpToolBarOption.scannerOption = false;
        tmpToolBarOption.uploaderOption = false;
        tmpToolBarOption.bookmarkOption = false;
        tmpToolBarOption.goOption = false;
        tmpToolBarOption.createFromTemplateOption = false;
        tmpToolBarOption.restore = false;
        tmpToolBarOption.purge = false;
        tmpToolBarOption.purgeTrash = true;
        return tmpToolBarOption;
    }

    public ToolBarOption getDefaultDashboardToolBar() {
        ToolBarOption tmpToolBarOption = new ToolBarOption();
        tmpToolBarOption.createFolderOption = false;
        tmpToolBarOption.findFolderOption = false;
        tmpToolBarOption.addDocumentOption = false;
        tmpToolBarOption.checkoutOption = false;
        tmpToolBarOption.checkinOption = false;
        tmpToolBarOption.cancelCheckoutOption = false;
        tmpToolBarOption.lockOption = false;
        tmpToolBarOption.unLockOption = false;
        tmpToolBarOption.downloadOption = false;
        tmpToolBarOption.downloadPdfOption = false;
        tmpToolBarOption.deleteOption = false;
        tmpToolBarOption.addPropertyGroupOption = false;
        tmpToolBarOption.removePropertyGroupOption = false;
        tmpToolBarOption.addSubscription = false;
        tmpToolBarOption.removeSubscription = false;
        tmpToolBarOption.firedRemovePropertyGroupOption = false;
        tmpToolBarOption.homeOption = false;
        tmpToolBarOption.refreshOption = true;
        tmpToolBarOption.renameOption = false;
        tmpToolBarOption.copyOption = false;
        tmpToolBarOption.moveOption = false;
        tmpToolBarOption.exportOption = false;
        tmpToolBarOption.workflowOption = false;
        tmpToolBarOption.addNoteOption = false;
        tmpToolBarOption.scannerOption = false;
        tmpToolBarOption.uploaderOption = false;
        tmpToolBarOption.bookmarkOption = false;
        tmpToolBarOption.goOption = false;
        tmpToolBarOption.createFromTemplateOption = false;
        tmpToolBarOption.restore = false;
        tmpToolBarOption.purge = false;
        tmpToolBarOption.purgeTrash = true;
        return tmpToolBarOption;
    }

    public ToolBarOption getDefaultAdministrationToolBar() {
        ToolBarOption tmpToolBarOption = new ToolBarOption();
        tmpToolBarOption.createFolderOption = false;
        tmpToolBarOption.findFolderOption = false;
        tmpToolBarOption.addDocumentOption = false;
        tmpToolBarOption.checkoutOption = false;
        tmpToolBarOption.checkinOption = false;
        tmpToolBarOption.cancelCheckoutOption = false;
        tmpToolBarOption.lockOption = false;
        tmpToolBarOption.unLockOption = false;
        tmpToolBarOption.downloadOption = false;
        tmpToolBarOption.downloadPdfOption = false;
        tmpToolBarOption.deleteOption = false;
        tmpToolBarOption.addPropertyGroupOption = false;
        tmpToolBarOption.removePropertyGroupOption = false;
        tmpToolBarOption.addSubscription = false;
        tmpToolBarOption.removeSubscription = false;
        tmpToolBarOption.firedRemovePropertyGroupOption = false;
        tmpToolBarOption.homeOption = false;
        tmpToolBarOption.refreshOption = false;
        tmpToolBarOption.renameOption = false;
        tmpToolBarOption.copyOption = false;
        tmpToolBarOption.moveOption = false;
        tmpToolBarOption.exportOption = false;
        tmpToolBarOption.workflowOption = false;
        tmpToolBarOption.addNoteOption = false;
        tmpToolBarOption.scannerOption = false;
        tmpToolBarOption.uploaderOption = false;
        tmpToolBarOption.bookmarkOption = false;
        tmpToolBarOption.goOption = false;
        tmpToolBarOption.createFromTemplateOption = false;
        tmpToolBarOption.restore = false;
        tmpToolBarOption.purge = false;
        tmpToolBarOption.purgeTrash = true;
        return tmpToolBarOption;
    }

    public ToolBarOption getDefaultExtensionsToolBar() {
        ToolBarOption tmpToolBarOption = new ToolBarOption();
        tmpToolBarOption.createFolderOption = false;
        tmpToolBarOption.findFolderOption = false;
        tmpToolBarOption.addDocumentOption = false;
        tmpToolBarOption.checkoutOption = false;
        tmpToolBarOption.checkinOption = false;
        tmpToolBarOption.cancelCheckoutOption = false;
        tmpToolBarOption.lockOption = false;
        tmpToolBarOption.unLockOption = false;
        tmpToolBarOption.downloadOption = false;
        tmpToolBarOption.downloadPdfOption = false;
        tmpToolBarOption.deleteOption = false;
        tmpToolBarOption.addPropertyGroupOption = false;
        tmpToolBarOption.removePropertyGroupOption = false;
        tmpToolBarOption.addSubscription = false;
        tmpToolBarOption.removeSubscription = false;
        tmpToolBarOption.firedRemovePropertyGroupOption = false;
        tmpToolBarOption.homeOption = false;
        tmpToolBarOption.refreshOption = false;
        tmpToolBarOption.renameOption = false;
        tmpToolBarOption.copyOption = false;
        tmpToolBarOption.moveOption = false;
        tmpToolBarOption.exportOption = false;
        tmpToolBarOption.workflowOption = false;
        tmpToolBarOption.addNoteOption = false;
        tmpToolBarOption.scannerOption = false;
        tmpToolBarOption.uploaderOption = false;
        tmpToolBarOption.bookmarkOption = false;
        tmpToolBarOption.goOption = false;
        tmpToolBarOption.createFromTemplateOption = false;
        tmpToolBarOption.restore = false;
        tmpToolBarOption.purge = false;
        tmpToolBarOption.purgeTrash = true;
        return tmpToolBarOption;
    }

    public void evaluateShowIcons() {
        if (this.toolBarOption.createFolderOption) {
            this.enableCreateFolder();
        } else {
            this.disableCreateFolder();
        }
        if (this.toolBarOption.findFolderOption) {
            this.enableFindFolder();
        } else {
            this.disableFindFolder();
        }
        if (this.toolBarOption.addDocumentOption) {
            this.enableAddDocument();
        } else {
            this.disableAddDocument();
        }
        if (this.toolBarOption.checkoutOption) {
            this.enableCheckout();
        } else {
            this.disableCheckout();
        }
        if (this.toolBarOption.checkinOption) {
            this.enableCheckin();
        } else {
            this.disableCheckin();
        }
        if (this.toolBarOption.cancelCheckoutOption) {
            this.enableCancelCheckout();
        } else {
            this.disableCancelCheckout();
        }
        if (this.toolBarOption.lockOption) {
            this.enableLock();
        } else {
            this.disableLock();
        }
        if (this.toolBarOption.unLockOption) {
            this.enableUnlock();
        } else {
            this.disableUnlock();
        }
        if (this.toolBarOption.downloadOption) {
            this.enableDownload();
        } else {
            this.disableDownload();
        }
        if (this.toolBarOption.downloadPdfOption) {
            this.enableDownloadPdf();
        } else {
            this.disableDownloadPdf();
        }
        if (this.toolBarOption.deleteOption) {
            this.enableDelete();
        } else {
            this.disableDelete();
        }
        if (this.toolBarOption.addPropertyGroupOption) {
            this.enableAddPropertyGroup();
        } else {
            this.disableAddPropertyGroup();
        }
        if (!this.toolBarOption.removePropertyGroupOption) {
            this.removePropertyGroup.setStyleName("okm-ToolBar-button-disabled");
            this.removePropertyGroup.setResource(OKMBundleResources.INSTANCE.removePropertyGroupDisabled());
            this.removePropertyGroup.setTitle(Main.i18n("filebrowser.menu.remove.property.group"));
        }
        if (this.toolBarOption.workflowOption) {
            this.enableWorkflow();
        } else {
            this.disableWorkflow();
        }
        if (this.toolBarOption.addSubscription) {
            this.enableAddSubscription();
        } else {
            this.disableAddSubscription();
        }
        if (this.toolBarOption.removeSubscription) {
            this.enableRemoveSubscription();
        } else {
            this.disableRemoveSubscription();
        }
        if (this.toolBarOption.homeOption) {
            this.enableHome();
        } else {
            this.disableHome();
        }
        if (this.toolBarOption.refreshOption) {
            this.enableRefresh();
        } else {
            this.disableRefresh();
        }
        if (this.toolBarOption.scannerOption) {
            this.enableScanner();
        } else {
            this.disableScanner();
        }
        if (this.toolBarOption.uploaderOption) {
            this.enableUploader();
        } else {
            this.disableUploader();
        }
        for (ToolBarButtonExtension button : this.widgetExtensionList) {
            button.enable(button.isEnabled());
        }
    }

    public void evaluateRemovePropertyGroup(boolean propertyGroupEnabled) {
        this.propertyGroupEnabled = propertyGroupEnabled;
        if (propertyGroupEnabled) {
            this.enableFiredRemovePropertyGroup();
        } else {
            this.disableFiredRemovePropertyGroup();
        }
        if (this.toolBarOption.removePropertyGroupOption && this.toolBarOption.firedRemovePropertyGroupOption) {
            this.removePropertyGroup.setStyleName("okm-ToolBar-button");
            this.removePropertyGroup.setResource(OKMBundleResources.INSTANCE.removePropertyGroup());
            this.removePropertyGroup.setTitle(Main.i18n("filebrowser.menu.remove.property.group"));
        } else {
            this.removePropertyGroup.setStyleName("okm-ToolBar-button-disabled");
            this.removePropertyGroup.setResource(OKMBundleResources.INSTANCE.removePropertyGroupDisabled());
            this.removePropertyGroup.setTitle(Main.i18n("filebrowser.menu.remove.property.group"));
        }
    }

    public void changeView(int view, int newMainPanelView) {
        boolean toolBarEnabled = true;
        int mainPanelView = Main.get().mainPanel.getActualView();
        switch (mainPanelView) {
            case 0: {
                switch (this.actualView) {
                    case 0: {
                        this.viewValues.put("view_root:option", this.toolBarOption);
                        break;
                    }
                    case 1: {
                        this.viewValues.put("view_categories:option", this.toolBarOption);
                        break;
                    }
                    case 2: {
                        this.viewValues.put("view_thesaurus:option", this.toolBarOption);
                        break;
                    }
                    case 6: {
                        this.viewValues.put("view_trash:option", this.toolBarOption);
                        break;
                    }
                    case 3: {
                        this.viewValues.put("view_templates:option", this.toolBarOption);
                        break;
                    }
                    case 4: {
                        this.viewValues.put("view_my_documents:option", this.toolBarOption);
                        break;
                    }
                    case 5: {
                        this.viewValues.put("view_mail:option", this.toolBarOption);
                    }
                }
                break;
            }
            case 1: {
                this.viewValues.put("view_search:option", this.toolBarOption);
                break;
            }
            case 2: {
                this.viewValues.put("view_dashboard:option", this.toolBarOption);
                break;
            }
            case 3: {
                this.viewValues.put("view_administration:option", this.toolBarOption);
                break;
            }
            case 4: {
                this.viewValues.put("view_extension:option", this.toolBarOption);
            }
        }
        switch (newMainPanelView) {
            case 0: {
                switch (view) {
                    case 0: {
                        if (this.viewValues.containsKey("view_root:option")) {
                            this.toolBarOption = this.viewValues.get("view_root:option");
                        }
                        toolBarEnabled = true;
                        break;
                    }
                    case 1: {
                        this.toolBarOption = this.viewValues.containsKey("view_categories:option") ? this.viewValues.get("view_categories:option") : this.getDefaultCategoriesToolBar();
                        toolBarEnabled = true;
                        break;
                    }
                    case 2: {
                        this.toolBarOption = this.viewValues.containsKey("view_thesaurus:option") ? this.viewValues.get("view_thesaurus:option") : this.getDefaultThesaurusToolBar();
                        toolBarEnabled = true;
                        break;
                    }
                    case 6: {
                        this.toolBarOption = this.viewValues.containsKey("view_trash:option") ? this.viewValues.get("view_trash:option") : this.getDefaultTrashToolBar();
                        toolBarEnabled = false;
                        break;
                    }
                    case 3: {
                        this.toolBarOption = this.viewValues.containsKey("view_templates:option") ? this.viewValues.get("view_templates:option") : this.getDefaultTemplatesToolBar();
                        toolBarEnabled = true;
                        break;
                    }
                    case 4: {
                        this.toolBarOption = this.viewValues.containsKey("view_my_documents:option") ? this.viewValues.get("view_my_documents:option") : this.getDefaultMyDocumentsToolBar();
                        toolBarEnabled = true;
                        break;
                    }
                    case 5: {
                        this.toolBarOption = this.viewValues.containsKey("view_mail:option") ? this.viewValues.get("view_mail:option") : this.getDefaultMailToolBar();
                        toolBarEnabled = true;
                    }
                }
                break;
            }
            case 1: {
                this.toolBarOption = this.viewValues.containsKey("view_search:option") ? this.viewValues.get("view_search:option") : this.getDefaultSearchToolBar();
                toolBarEnabled = false;
                break;
            }
            case 2: {
                this.toolBarOption = this.viewValues.containsKey("view_dashboard:option") ? this.viewValues.get("view_dashboard:option") : this.getDefaultDashboardToolBar();
                toolBarEnabled = false;
                break;
            }
            case 3: {
                this.toolBarOption = this.viewValues.containsKey("view_administration:option") ? this.viewValues.get("view_administration:option") : this.getDefaultAdministrationToolBar();
                toolBarEnabled = false;
                break;
            }
            case 4: {
                this.toolBarOption = this.viewValues.containsKey("view_extension:option") ? this.viewValues.get("view_extension:option") : this.getDefaultExtensionsToolBar();
                toolBarEnabled = false;
            }
        }
        this.enabled = true;
        this.evaluateShowIcons();
        this.enabled = toolBarEnabled;
        this.actualView = view;
        Main.get().mainPanel.topPanel.mainMenu.setOptions(this.toolBarOption);
        this.fireEvent(HasToolBarEvent.EXECUTE_CHANGED_VIEW);
    }

    private void getAllGroups() {
        String path = this.getActualNodePath();
        if (!path.equals("")) {
            this.propertyGroupService.getAllGroups(path, this.callbackGetAllGroups);
        }
    }

    public String getActualNodePath() {
        String path = "";
        if (this.node instanceof GWTDocument) {
            path = ((GWTDocument)this.node).getPath();
        } else if (this.node instanceof GWTFolder) {
            path = ((GWTFolder)this.node).getPath();
        } else if (this.node instanceof GWTMail) {
            path = ((GWTMail)this.node).getPath();
        }
        return path;
    }

    public Object getActualNode() {
        return this.node;
    }

    public boolean isNodeDocument() {
        return this.node != null && this.node instanceof GWTDocument;
    }

    public boolean isNodeFolder() {
        return this.node != null && this.node instanceof GWTFolder;
    }

    public boolean isNodeMail() {
        return this.node != null && this.node instanceof GWTMail;
    }

    public void setUserHome(String user, String Uuid, String path, String type) {
        Main.get().userHome.setHomeUuid(Uuid);
        Main.get().userHome.setUser(user);
        Main.get().userHome.setHomePath(path);
        Main.get().userHome.setHomeType(type);
        this.fireEvent(HasToolBarEvent.EXECUTE_SET_USER_HOME);
    }

    public void setScannerApplet(String token, String path) {
        if (Util.isJREInstalled()) {
            RootPanel scannerApplet = RootPanel.get((String)"scannerApplet");
            scannerApplet.setSize("1", "1");
            this.panel.add((Widget)scannerApplet);
            scannerApplet.getElement().setInnerHTML("<applet code=\"com.openkm.applet.Scanner\" name=\"Scanner\" width=\"1\" height=\"1\" mayscript archive=\"../scanner.jar\"><param name=\"token\" value=\"" + token + "\">" + "<param name=\"path\" value=\"" + path + "\">" + "<param name=\"lang\" value=\"" + Main.get().getLang() + "\">" + "</applet>");
        } else {
            Main.get().showError("setScannerApplet", new OKMException(ErrorCode.get("018", "022"), "JRE support not detected in your browser"));
        }
    }

    public void setUploaderApplet(String token, String path) {
        if (Util.isJREInstalled()) {
            RootPanel uploaderApplet = RootPanel.get((String)"uploaderApplet");
            uploaderApplet.setSize("1", "1");
            this.panel.add((Widget)uploaderApplet);
            uploaderApplet.getElement().setInnerHTML("<applet code=\"com.openkm.applet.Uploader\" name=\"Uploader\" width=\"1\" height=\"1\" mayscript archive=\"../uploader.jar\"><param name=\"token\" value=\"" + token + "\">" + "<param name=\"path\" value=\"" + path + "\">" + "<param name=\"lang\" value=\"" + Main.get().getLang() + "\">" + "</applet>");
        } else {
            Main.get().showError("setUploaderApplet", new OKMException(ErrorCode.get("018", "022"), "JRE support not detected in your browser"));
        }
    }

    public void destroyScannerApplet() {
        RootPanel scannerApplet = RootPanel.get((String)"scannerApplet");
        this.panel.remove((Widget)scannerApplet);
        scannerApplet.getElement().setInnerHTML("");
    }

    public void destroyUploaderApplet() {
        RootPanel uploadApplet = RootPanel.get((String)"uploaderApplet");
        this.panel.remove((Widget)uploadApplet);
        uploadApplet.getElement().setInnerHTML("");
    }

    public void langRefresh() {
        this.evaluateShowIcons();
        this.evaluateRemovePropertyGroup(this.propertyGroupEnabled);
    }

    public ToolBarOption getToolBarOption() {
        return this.toolBarOption;
    }

    public void setToolBarOption(ToolBarOption toolBarOption) {
        this.toolBarOption = toolBarOption;
        this.propagateToolBarOptions();
    }

    private void propagateToolBarOptions() {
        Main.get().mainPanel.topPanel.mainMenu.setOptions(this.toolBarOption);
        Main.get().mainPanel.desktop.browser.fileBrowser.setOptions(this.toolBarOption);
        Main.get().activeFolderTree.menuPopup.setOptions(this.toolBarOption);
        if (this.node instanceof GWTFolder) {
            Main.get().mainPanel.desktop.browser.tabMultiple.tabFolder.notes.setVisibleAddNote(this.toolBarOption.addNoteOption);
        } else if (this.node instanceof GWTDocument) {
            Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.notes.setVisibleAddNote(this.toolBarOption.addNoteOption);
        }
    }

    public void setAvailableOption(GWTProfileToolbar option) {
        this.createFolder.setVisible(option.isCreateFolderVisible());
        this.panel.getWidget(2).setVisible(option.isCreateFolderVisible());
        this.findFolder.setVisible(option.isCreateFolderVisible());
        this.panel.getWidget(4).setVisible(option.isCreateFolderVisible());
        this.download.setVisible(option.isDownloadVisible());
        this.panel.getWidget(6).setVisible(option.isDownloadVisible());
        this.downloadPdf.setVisible(option.isDownloadPdfVisible());
        this.panel.getWidget(8).setVisible(option.isDownloadPdfVisible());
        this.panel.getWidget(9).setVisible(option.isCreateFolderVisible() || option.isFindFolderVisible() || option.isDownloadVisible() || option.isDownloadPdfVisible());
        this.lock.setVisible(option.isLockVisible());
        this.panel.getWidget(11).setVisible(option.isLockVisible());
        this.unlock.setVisible(option.isUnlockVisible());
        this.panel.getWidget(13).setVisible(option.isUnlockVisible());
        this.panel.getWidget(14).setVisible(option.isLockVisible() || option.isUnlockVisible());
        this.addDocument.setVisible(option.isAddDocumentVisible());
        this.panel.getWidget(16).setVisible(option.isAddDocumentVisible());
        this.checkout.setVisible(option.isCheckoutVisible());
        this.panel.getWidget(18).setVisible(option.isCheckoutVisible());
        this.checkin.setVisible(option.isCheckinVisible());
        this.panel.getWidget(20).setVisible(option.isCheckinVisible());
        this.cancelCheckout.setVisible(option.isCancelCheckoutVisible());
        this.panel.getWidget(22).setVisible(option.isCancelCheckoutVisible());
        this.delete.setVisible(option.isDeleteVisible());
        this.panel.getWidget(24).setVisible(option.isDeleteVisible());
        this.panel.getWidget(25).setVisible(option.isAddDocumentVisible() || option.isCheckoutVisible() || option.isCheckinVisible() || option.isCancelCheckoutVisible() || option.isDeleteVisible());
        this.addPropertyGroup.setVisible(option.isAddPropertyGroupVisible());
        this.panel.getWidget(27).setVisible(option.isAddPropertyGroupVisible());
        this.removePropertyGroup.setVisible(option.isRemovePropertyGroupVisible());
        this.panel.getWidget(29).setVisible(option.isRemovePropertyGroupVisible());
        this.panel.getWidget(30).setVisible(option.isAddPropertyGroupVisible() || option.isRemovePropertyGroupVisible());
        this.startWorkflow.setVisible(option.isStartWorkflowVisible());
        this.panel.getWidget(32).setVisible(option.isStartWorkflowVisible());
        this.panel.getWidget(33).setVisible(option.isStartWorkflowVisible());
        this.addSubscription.setVisible(option.isAddSubscriptionVisible());
        this.panel.getWidget(35).setVisible(option.isAddSubscriptionVisible());
        this.removeSubscription.setVisible(option.isRemoveSubscriptionVisible());
        this.panel.getWidget(37).setVisible(option.isRemoveSubscriptionVisible());
        this.panel.getWidget(38).setVisible(option.isAddSubscriptionVisible() || option.isRemoveSubscriptionVisible());
        this.home.setVisible(option.isHomeVisible());
        this.panel.getWidget(40).setVisible(option.isHomeVisible());
        this.refresh.setVisible(option.isRefreshVisible());
        this.panel.getWidget(42).setVisible(option.isRefreshVisible());
        this.panel.getWidget(43).setVisible(option.isHomeVisible() || option.isRefreshVisible());
        this.scanner.setVisible(option.isScannerVisible());
        this.panel.getWidget(45).setVisible(option.isScannerVisible());
        this.uploader.setVisible(option.isUploaderVisible());
        this.panel.getWidget(47).setVisible(option.isUploaderVisible());
        ImageResource separator = OKMBundleResources.INSTANCE.separator();
        for (int i = 0; i < this.panel.getWidgetCount(); ++i) {
            Image image;
            Widget widget = this.panel.getWidget(i);
            if (!(widget instanceof Image) || !(image = (Image)widget).getUrl().equals(separator.getURL())) continue;
            image.setVisible(false);
        }
    }

    public void addToolBarButtonExtension(ToolBarButtonExtension extension) {
        extension.addMouseOverHandler(this.mouseOverHandler);
        extension.addMouseOutHandler(this.mouseOutHandler);
        extension.setStyleName("okm-ToolBar-button");
        this.widgetExtensionList.add(extension);
        this.panel.add((Widget)extension);
    }

    @Override
    public void addToolBarHandlerExtension(ToolBarHandlerExtension handlerExtension) {
        this.toolBarHandlerExtensionList.add(handlerExtension);
    }

    @Override
    public void fireEvent(HasToolBarEvent.ToolBarEventConstant event) {
        Iterator<ToolBarHandlerExtension> it = this.toolBarHandlerExtensionList.iterator();
        while (it.hasNext()) {
            it.next().onChange(event);
        }
    }

    public native void initJavaScriptApi(ToolBar var1);
}

