/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.trash;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTAvailableOption;
import com.openkm.frontend.client.bean.ToolBarOption;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.widget.MenuBase;

public class TrashMenu
extends MenuBase {
    private ToolBarOption toolBarOption;
    private MenuBar dirMenu;
    private MenuItem restore;
    private MenuItem purge;
    private MenuItem purgeTrash;
    Command restoreFolder = new Command(){

        public void execute() {
            if (((TrashMenu)TrashMenu.this).toolBarOption.restore) {
                Main.get().activeFolderTree.restore();
                Main.get().activeFolderTree.hideMenuPopup();
            }
        }
    };
    Command purgeFolder = new Command(){

        public void execute() {
            if (((TrashMenu)TrashMenu.this).toolBarOption.purge) {
                Main.get().activeFolderTree.confirmPurge();
                Main.get().activeFolderTree.hideMenuPopup();
            }
        }
    };
    Command purgeTrashFolder = new Command(){

        public void execute() {
            if (((TrashMenu)TrashMenu.this).toolBarOption.purgeTrash) {
                Main.get().activeFolderTree.confirmPurgeTrash();
                Main.get().activeFolderTree.hideMenuPopup();
            }
        }
    };

    public TrashMenu() {
        this.toolBarOption = new ToolBarOption();
        this.dirMenu = new MenuBar(true);
        this.restore = new MenuItem(Util.menuHTML("img/icon/actions/restore.gif", Main.i18n("trash.menu.directory.restore")), true, this.restoreFolder);
        this.restore.addStyleName("okm-MenuItem");
        this.dirMenu.addItem(this.restore);
        this.purge = new MenuItem(Util.menuHTML("img/icon/actions/purge.gif", Main.i18n("trash.menu.directory.purge")), true, this.purgeFolder);
        this.purge.addStyleName("okm-MenuItem");
        this.dirMenu.addItem(this.purge);
        this.purgeTrash = new MenuItem(Util.menuHTML("img/icon/actions/purge_trash.gif", Main.i18n("trash.menu.directory.purge.trash")), true, this.purgeTrashFolder);
        this.purgeTrash.addStyleName("okm-MenuItem");
        this.dirMenu.addItem(this.purgeTrash);
        this.dirMenu.setStyleName("okm-MenuBar");
        this.initWidget((Widget)this.dirMenu);
    }

    @Override
    public void langRefresh() {
        this.restore.setHTML(Util.menuHTML("img/icon/actions/restore.gif", Main.i18n("trash.menu.directory.restore")));
        this.purge.setHTML(Util.menuHTML("img/icon/actions/purge.gif", Main.i18n("trash.menu.directory.purge")));
        this.purgeTrash.setHTML(Util.menuHTML("img/icon/actions/purge_trash.gif", Main.i18n("trash.menu.directory.purge.trash")));
    }

    @Override
    public void evaluateMenuOptions() {
        if (this.toolBarOption.restore) {
            this.enable(this.restore);
        } else {
            this.disable(this.restore);
        }
        if (this.toolBarOption.purge) {
            this.enable(this.purge);
        } else {
            this.disable(this.purge);
        }
        if (this.toolBarOption.purgeTrash) {
            this.enable(this.purgeTrash);
        } else {
            this.disable(this.purgeTrash);
        }
    }

    @Override
    public void setAvailableOption(GWTAvailableOption option) {
        if (!option.isRestoreOption()) {
            this.dirMenu.removeItem(this.restore);
        }
        if (!option.isPurgeOption()) {
            this.dirMenu.removeItem(this.purge);
        }
        if (!option.isPurgeTrashOption()) {
            this.dirMenu.removeItem(this.purgeTrash);
        }
    }

    @Override
    public void setOptions(ToolBarOption toolBarOption) {
        this.toolBarOption = toolBarOption;
        this.evaluateMenuOptions();
    }

    @Override
    public void disableAllOptions() {
        this.toolBarOption = new ToolBarOption();
        this.evaluateMenuOptions();
    }
}

