/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.upload;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasChangeHandlers;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.widgetideas.client.ProgressBar;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.FileToUpload;
import com.openkm.frontend.client.bean.GWTFileUploadingStatus;
import com.openkm.frontend.client.service.OKMGeneralService;
import com.openkm.frontend.client.service.OKMGeneralServiceAsync;
import com.openkm.frontend.client.service.OKMRepositoryService;
import com.openkm.frontend.client.service.OKMRepositoryServiceAsync;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.widget.notify.NotifyPanel;
import com.openkm.frontend.client.widget.upload.FileUploadForm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FancyFileUpload
extends Composite
implements HasText,
HasChangeHandlers {
    private final OKMGeneralServiceAsync generalService = (OKMGeneralServiceAsync)GWT.create(OKMGeneralService.class);
    private final OKMRepositoryServiceAsync repositoryService = (OKMRepositoryServiceAsync)GWT.create(OKMRepositoryService.class);
    public static final int EMPTY_STATE = 1;
    public static final int PENDING_STATE = 2;
    public static final int UPLOADING_STATE = 3;
    public static final int UPLOADED_STATE = 4;
    public static final int FAILED_STATE = 5;
    private static final String returnOKMessage = "OKM_OK";
    private static final String returnErrorMessage = "OKM-";
    private static final int PENDING_UPDATE_DELAY = 1000;
    private static final int REFRESH_STATUS_DELAY = 250;
    private int widgetState = 1;
    private VerticalPanel mainPanel = new VerticalPanel();
    public CheckBox notifyToUser = new CheckBox();
    private CheckBox importZip = new CheckBox();
    private CheckBox digitalSignature = new CheckBox();
    private HTML versionCommentText = new HTML();
    private HTML notifyToUserText = new HTML();
    private HTML importZipText = new HTML();
    private HTML digitalSignatureText = new HTML();
    private HorizontalPanel hNotifyPanel = new HorizontalPanel();
    private HorizontalPanel hUnzipPanel = new HorizontalPanel();
    private HorizontalPanel hDigitalSignaturePanel = new HorizontalPanel();
    public NotifyPanel notifyPanel = new NotifyPanel();
    private HTML versionHTMLBR;
    private TextArea versionComment;
    private ScrollPanel versionCommentScrollPanel;
    public TextBox users;
    public TextBox roles;
    private TextArea message;
    private VerticalPanel vNotifyPanel = new VerticalPanel();
    private VerticalPanel vVersionCommentPanel = new VerticalPanel();
    private HTML commentTXT;
    private ScrollPanel messageScroll;
    public HTML errorNotify;
    private ProgressBar progressBar;
    private ProgressBar.TextFormatter progressiveFormater;
    private ProgressBar.TextFormatter finalFormater;
    private boolean wizard = false;
    private int action = -1;
    private FileUploadForm uploadForm;
    private List<FileToUpload> filesToUpload = new ArrayList<FileToUpload>();
    private FileToUpload actualFileToUpload;
    private List<FileToUpload> uploadedWorkflowFiles = new ArrayList<FileToUpload>();
    private Timer p;
    private UploadDisplay uploadItem;
    String fileName = "";
    private GWTFileUploadingStatus fileUploadingStatus = new GWTFileUploadingStatus();
    private boolean fileUplodingStartedFlag = false;
    final AsyncCallback<GWTFileUploadingStatus> callbackGetFileUploadStatus = new AsyncCallback<GWTFileUploadingStatus>(){

        public void onSuccess(GWTFileUploadingStatus result) {
            FancyFileUpload.this.fileUploadingStatus = result;
            if (FancyFileUpload.this.fileUplodingStartedFlag) {
                if (result.isStarted()) {
                    if (result.getContentLength() != 0L && result.getContentLength() == result.getBytesRead()) {
                        result.setUploadFinish(true);
                        FancyFileUpload.this.uploadItem.setIndexing();
                    }
                    if (result.isUploadFinish()) {
                        FancyFileUpload.this.progressBar.setTextFormatter(FancyFileUpload.this.finalFormater);
                    }
                    FancyFileUpload.this.progressBar.setMaxProgress((double)FancyFileUpload.this.fileUploadingStatus.getContentLength());
                    FancyFileUpload.this.progressBar.setProgress((double)FancyFileUpload.this.fileUploadingStatus.getBytesRead());
                }
                if (!result.isUploadFinish()) {
                    FancyFileUpload.this.refreshStatus();
                }
            }
        }

        public void onFailure(Throwable caught) {
            FancyFileUpload.this.refreshStatus();
        }
    };

    public void refresh() {
        if (this.importZip.getValue().booleanValue()) {
            Main.get().activeFolderTree.refresh(true);
        } else {
            Main.get().mainPanel.desktop.browser.fileBrowser.refresh(Main.get().activeFolderTree.getActualPath());
        }
    }

    private void uploadFiles() {
        this.fileName = this.uploadForm.getFileName();
        this.uploadForm.setNotifyToUser(this.notifyToUser.getValue());
        this.uploadForm.setImportZip(this.importZip.getValue());
        this.uploadForm.setDigitalSignature(this.digitalSignature.getValue());
        this.uploadForm.setVersionCommnent(this.versionComment.getText());
        this.uploadForm.setUsers(this.users.getText());
        this.uploadForm.setRoles(this.roles.getText());
        this.uploadForm.setMessage(this.message.getText());
        this.uploadItem.setLoading();
        this.uploadForm.submit();
    }

    public void pendingUpload() {
        this.uploadItem.setPending();
        this.p = new Timer(){

            public void run() {
                FancyFileUpload.this.uploadFiles();
            }
        };
        this.p.schedule(1000);
    }

    public FancyFileUpload() {
        this.uploadItem = new UploadDisplay();
        this.mainPanel.add((Widget)this.uploadItem);
        this.errorNotify = new HTML(Main.i18n("fileupload.label.must.select.users"));
        this.errorNotify.setWidth("370");
        this.errorNotify.setVisible(false);
        this.errorNotify.setStyleName("fancyfileupload-failed");
        this.mainPanel.add((Widget)this.errorNotify);
        this.versionHTMLBR = new HTML("<br>");
        this.mainPanel.add((Widget)this.versionHTMLBR);
        this.versionComment = new TextArea();
        this.versionComment.setWidth("375");
        this.versionComment.setHeight("50");
        this.versionComment.setName("comment");
        this.versionComment.setStyleName("okm-TextArea");
        this.versionCommentText = new HTML(Main.i18n("fileupload.label.comment"));
        this.versionCommentScrollPanel = new ScrollPanel((Widget)this.versionComment);
        this.versionCommentScrollPanel.setAlwaysShowScrollBars(false);
        this.versionCommentScrollPanel.setSize("100%", "100%");
        this.vVersionCommentPanel.add((Widget)this.versionCommentText);
        this.vVersionCommentPanel.add((Widget)this.versionCommentScrollPanel);
        this.mainPanel.add((Widget)this.vVersionCommentPanel);
        this.importZip = new CheckBox();
        this.importZip.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (FancyFileUpload.this.importZip.getValue().booleanValue()) {
                    FancyFileUpload.this.notifyToUser.setValue(Boolean.valueOf(false));
                    FancyFileUpload.this.vNotifyPanel.setVisible(false);
                    FancyFileUpload.this.digitalSignature.setValue(Boolean.valueOf(false));
                    FancyFileUpload.this.hDigitalSignaturePanel.setVisible(false);
                } else {
                    FancyFileUpload.this.hDigitalSignaturePanel.setVisible(true);
                }
            }
        });
        this.importZip.setName("importZip");
        this.importZipText = new HTML(Main.i18n("fileupload.label.importZip"));
        this.hUnzipPanel = new HorizontalPanel();
        this.hUnzipPanel.add((Widget)this.importZip);
        this.hUnzipPanel.add((Widget)this.importZipText);
        this.hUnzipPanel.setCellVerticalAlignment((Widget)this.importZip, VerticalPanel.ALIGN_MIDDLE);
        this.hUnzipPanel.setCellVerticalAlignment((Widget)this.importZipText, VerticalPanel.ALIGN_MIDDLE);
        this.mainPanel.add((Widget)new HTML("<br>"));
        this.mainPanel.add((Widget)this.hUnzipPanel);
        this.digitalSignature = new CheckBox();
        this.digitalSignature.setName("digitalSignature");
        this.digitalSignatureText = new HTML(Main.i18n("fileupload.digital.signature"));
        this.hDigitalSignaturePanel = new HorizontalPanel();
        this.mainPanel.add((Widget)this.hDigitalSignaturePanel);
        this.users = new TextBox();
        this.users.setName("users");
        this.users.setVisible(false);
        this.roles = new TextBox();
        this.roles.setName("roles");
        this.roles.setVisible(false);
        this.notifyToUser = new CheckBox();
        this.notifyToUser.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (FancyFileUpload.this.notifyToUser.getValue().booleanValue()) {
                    FancyFileUpload.this.vNotifyPanel.setVisible(true);
                    FancyFileUpload.this.importZip.setValue(Boolean.valueOf(false));
                    FancyFileUpload.this.hDigitalSignaturePanel.setVisible(true);
                } else {
                    FancyFileUpload.this.errorNotify.setVisible(false);
                    FancyFileUpload.this.vNotifyPanel.setVisible(false);
                }
            }
        });
        this.notifyToUser.setName("notify");
        this.notifyToUserText = new HTML(Main.i18n("fileupload.label.users.notify"));
        this.hNotifyPanel = new HorizontalPanel();
        this.hNotifyPanel.add((Widget)this.notifyToUser);
        this.hNotifyPanel.add((Widget)this.notifyToUserText);
        this.hNotifyPanel.setCellVerticalAlignment((Widget)this.notifyToUser, VerticalPanel.ALIGN_MIDDLE);
        this.hNotifyPanel.setCellVerticalAlignment((Widget)this.notifyToUserText, VerticalPanel.ALIGN_MIDDLE);
        this.mainPanel.add((Widget)this.hNotifyPanel);
        this.mainPanel.add((Widget)new HTML("<br>"));
        this.message = new TextArea();
        this.commentTXT = new HTML(Main.i18n("fileupload.label.notify.comment"));
        this.message.setName("message");
        this.message.setSize("375", "60");
        this.message.setStyleName("okm-TextArea");
        this.vNotifyPanel = new VerticalPanel();
        this.vNotifyPanel.add((Widget)this.commentTXT);
        this.messageScroll = new ScrollPanel((Widget)this.message);
        this.messageScroll.setAlwaysShowScrollBars(false);
        this.vNotifyPanel.add((Widget)this.messageScroll);
        this.vNotifyPanel.add((Widget)new HTML("<br>"));
        this.vNotifyPanel.add((Widget)this.notifyPanel);
        this.vNotifyPanel.add((Widget)new HTML("<br>"));
        this.mainPanel.add((Widget)this.users);
        this.mainPanel.add((Widget)this.roles);
        this.mainPanel.add((Widget)this.vNotifyPanel);
        this.mainPanel.setCellHorizontalAlignment((Widget)this.hNotifyPanel, HorizontalPanel.ALIGN_LEFT);
        this.mainPanel.setCellHorizontalAlignment((Widget)this.hUnzipPanel, HorizontalPanel.ALIGN_LEFT);
        this.mainPanel.setCellHorizontalAlignment((Widget)this.hDigitalSignaturePanel, HorizontalPanel.ALIGN_LEFT);
        this.mainPanel.setCellHorizontalAlignment((Widget)this.vNotifyPanel, HorizontalPanel.ALIGN_CENTER);
        this.mainPanel.setCellHorizontalAlignment((Widget)this.vVersionCommentPanel, HorizontalPanel.ALIGN_CENTER);
        this.getAllUsers();
        this.initWidget((Widget)this.mainPanel);
    }

    public void reset(boolean enableImport, boolean enableNotifyButton) {
        this.uploadItem.reset(enableImport, enableNotifyButton);
    }

    public void init() {
        this.uploadItem.init();
    }

    public String getText() {
        return this.uploadItem.status.getText();
    }

    public void setText(String text) {
        throw new RuntimeException("Cannot set text of a FileUpload Widget");
    }

    public int getUploadState() {
        return this.widgetState;
    }

    public boolean isWizard() {
        return this.wizard;
    }

    private void fireChange() {
        NativeEvent nativeEvent = Document.get().createChangeEvent();
        ChangeEvent.fireNativeEvent((NativeEvent)nativeEvent, (HasHandlers)this);
    }

    public HandlerRegistration addChangeHandler(ChangeHandler handler) {
        return this.addDomHandler((EventHandler)handler, ChangeEvent.getType());
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
        switch (action) {
            case 0: {
                this.versionComment.setVisible(false);
                this.versionCommentText.setVisible(false);
                this.versionHTMLBR.setVisible(false);
                break;
            }
            case 1: {
                this.versionComment.setVisible(true);
                this.versionCommentText.setVisible(true);
                this.versionHTMLBR.setVisible(true);
            }
        }
        this.uploadForm.setAction("" + action);
    }

    public void setPath(String path) {
        this.uploadForm.setPath(path);
    }

    public void setRename(String rename) {
        this.uploadForm.setRename(rename);
    }

    public void langRefresh() {
        this.notifyToUserText.setHTML(Main.i18n("fileupload.label.users.notify"));
        this.importZipText.setHTML(Main.i18n("fileupload.label.importZip"));
        this.digitalSignatureText.setHTML(Main.i18n("fileupload.digital.signature"));
        this.versionCommentText.setHTML(Main.i18n("fileupload.label.comment"));
        this.commentTXT.setHTML(Main.i18n("fileupload.label.notify.comment"));
        this.notifyPanel.langRefresh();
    }

    private void refreshStatus() {
        Timer refreshStatus = new Timer(){

            public void run() {
                FancyFileUpload.this.getFileUploadStatus();
            }
        };
        refreshStatus.schedule(250);
    }

    private void resetProgressBar() {
        this.fileUplodingStartedFlag = false;
        this.fileUploadingStatus = new GWTFileUploadingStatus();
        this.progressBar.setMinProgress(0.0);
        this.progressBar.setMaxProgress(0.0);
        this.progressBar.setProgress(0.0);
        this.progressBar.setTextFormatter(this.progressiveFormater);
    }

    private void getAllUsers() {
        this.notifyPanel.getAll();
    }

    private void getFileUploadStatus() {
        this.generalService.getFileUploadStatus(this.callbackGetFileUploadStatus);
    }

    public void disableErrorNotify() {
        this.errorNotify.setVisible(false);
    }

    public void enableAdvancedFilter() {
        this.notifyPanel.enableAdvancedFilter();
    }

    public boolean isDigitalSignature() {
        return this.uploadForm != null ? this.uploadForm.isDigitalSignature() : false;
    }

    public void showDigitalSignature() {
        this.hDigitalSignaturePanel.add((Widget)this.digitalSignature);
        this.hDigitalSignaturePanel.add((Widget)this.digitalSignatureText);
        this.hDigitalSignaturePanel.setCellVerticalAlignment((Widget)this.digitalSignature, VerticalPanel.ALIGN_MIDDLE);
        this.hDigitalSignaturePanel.setCellVerticalAlignment((Widget)this.digitalSignatureText, VerticalPanel.ALIGN_MIDDLE);
    }

    public String getFilename() {
        return this.uploadForm.getFileName();
    }

    public void enqueueFileToUpload(Collection<FileToUpload> filesToUpload) {
        this.filesToUpload.addAll(filesToUpload);
        if (this.actualFileToUpload == null) {
            this.uploadNewPendingFile();
        }
    }

    public void uploadNewPendingFile() {
        if (this.actualFileToUpload != null && this.actualFileToUpload.getWorkflow() != null && this.actualFileToUpload.isLastToBeUploaded()) {
            this.uploadedWorkflowFiles.add(this.actualFileToUpload.clone());
            this.executeWorkflow(this.actualFileToUpload.getWorkflowTaskId());
        }
        if (!this.filesToUpload.isEmpty()) {
            this.actualFileToUpload = this.filesToUpload.remove(0);
            this.uploadForm = new FileUploadForm(this.actualFileToUpload.getFileUpload(), "45");
            this.uploadItem.hFileUpload.clear();
            this.uploadItem.hFileUpload.add((Widget)this.uploadForm);
            this.setPath(this.actualFileToUpload.getPath());
            this.setAction(this.actualFileToUpload.getAction());
            this.setRename(this.actualFileToUpload.getDesiredDocumentName());
            this.addSubmitCompleteHandler();
            Main.get().fileUpload.showPopup(this.actualFileToUpload.isEnableAddButton(), this.actualFileToUpload.isEnableImport(), this.actualFileToUpload.getWorkflow() == null);
            if (this.actualFileToUpload.getWorkflow() != null) {
                Main.get().fileUpload.executeSend();
            }
        } else {
            if (this.actualFileToUpload != null && this.actualFileToUpload.getWorkflow() != null) {
                Main.get().fileUpload.executeCancel();
            }
            this.actualFileToUpload = null;
        }
    }

    private void executeWorkflow(double taskId) {
        ArrayList<FileToUpload> uploadedFiles = new ArrayList<FileToUpload>();
        for (FileToUpload uploaded : this.uploadedWorkflowFiles) {
            if (uploaded.getWorkflowTaskId() != taskId) continue;
            uploadedFiles.add(uploaded);
        }
        this.actualFileToUpload.getWorkflow().setTaskInstanceValues(this.actualFileToUpload.getWorkflowTaskId(), this.actualFileToUpload.getWorkflowTransition(), uploadedFiles);
    }

    public void cancel() {
        this.actualFileToUpload = null;
        this.filesToUpload = new ArrayList<FileToUpload>();
    }

    private void addSubmitCompleteHandler() {
        this.uploadForm.addSubmitCompleteHandler(new FormPanel.SubmitCompleteHandler(){

            public void onSubmitComplete(FormPanel.SubmitCompleteEvent event) {
                FancyFileUpload.this.fireChange();
                FancyFileUpload.this.p.cancel();
                FancyFileUpload.this.uploadForm.setEncoding("multipart/form-data");
                String msg = event.getResults();
                if (msg.contains(FancyFileUpload.returnOKMessage)) {
                    String docPath = "";
                    if (msg.indexOf("path[") > 0 && msg.indexOf("]path") > 0) {
                        docPath = msg.substring(msg.indexOf("path[") + 5, msg.indexOf("]path"));
                        docPath = URL.decodeQueryString((String)docPath);
                    }
                    if (FancyFileUpload.this.actualFileToUpload.getWorkflow() == null) {
                        if (!FancyFileUpload.this.uploadForm.isImportZip() && FancyFileUpload.this.action == 0 && (Main.get().workspaceUserProperties.getWorkspace().isWizardPropertyGroups() || Main.get().workspaceUserProperties.getWorkspace().isWizardWorkflows() || Main.get().workspaceUserProperties.getWorkspace().isWizardCategories() || Main.get().workspaceUserProperties.getWorkspace().isWizardKeywords())) {
                            FancyFileUpload.this.wizard = true;
                        } else {
                            FancyFileUpload.this.wizard = FancyFileUpload.this.uploadForm.isDigitalSignature();
                        }
                        if (FancyFileUpload.this.wizard) {
                            Main.get().wizardPopup.start(docPath);
                        }
                        if (!docPath.equals("")) {
                            Main.get().mainPanel.desktop.browser.fileBrowser.mantainSelectedRowByPath(docPath);
                        }
                        FancyFileUpload.this.uploadItem.setLoaded();
                    } else {
                        FancyFileUpload.this.actualFileToUpload.setDocumentPath(docPath);
                        FancyFileUpload.this.repositoryService.getUUIDByPath(docPath, new AsyncCallback<String>(){

                            public void onSuccess(String result) {
                                FancyFileUpload.this.actualFileToUpload.setDocumentUUID(result);
                                FancyFileUpload.this.uploadItem.setLoaded();
                            }

                            public void onFailure(Throwable caught) {
                                Main.get().showError("getUUIDByPath", caught);
                            }
                        });
                    }
                } else {
                    FancyFileUpload.this.uploadItem.setFailed(msg);
                }
            }
        });
    }

    public void setUploadNotifyUsers(boolean visible) {
        if (!visible) {
            this.mainPanel.remove((Widget)this.hNotifyPanel);
        }
    }

    protected class UploadDisplay
    extends Composite {
        HTML status = new HTML();
        HTML statusZipNotify;
        ScrollPanel statusZipNotifyScroll;
        FlowPanel mainPanel = new FlowPanel();
        VerticalPanel pendingPanel = new VerticalPanel();
        HorizontalPanel hFileUpload = new HorizontalPanel();

        public UploadDisplay() {
            this.hFileUpload.setWidth("350");
            this.status.setWidth("100%");
            this.status.setWordWrap(true);
            this.status.setHorizontalAlignment(HasAlignment.ALIGN_CENTER);
            this.statusZipNotify = new HTML();
            this.statusZipNotify.setSize("100%", "100%");
            this.statusZipNotify.setVisible(true);
            this.statusZipNotifyScroll = new ScrollPanel((Widget)this.statusZipNotify);
            this.statusZipNotifyScroll.setAlwaysShowScrollBars(false);
            this.statusZipNotifyScroll.setVisible(false);
            this.statusZipNotifyScroll.setSize("375", "100");
            this.statusZipNotifyScroll.setStyleName("okm-Bookmark-Panel");
            this.statusZipNotifyScroll.addStyleName("okm-Input");
            FancyFileUpload.this.progressiveFormater = new ProgressBar.TextFormatter(){

                protected String getText(ProgressBar bar, double curProgress) {
                    String text = "";
                    text = text + Util.formatSize(curProgress);
                    text = text + " " + Main.i18n("fileupload.status.of") + " ";
                    text = text + Util.formatSize(FancyFileUpload.this.progressBar.getMaxProgress());
                    text = text + " " + (int)(100.0 * FancyFileUpload.this.progressBar.getPercent()) + "% ";
                    return text;
                }
            };
            FancyFileUpload.this.finalFormater = new ProgressBar.TextFormatter(){

                protected String getText(ProgressBar bar, double curProgress) {
                    String text = " " + (int)(100.0 * FancyFileUpload.this.progressBar.getPercent()) + "% ";
                    return text;
                }
            };
            FancyFileUpload.this.progressBar = new ProgressBar();
            FancyFileUpload.this.progressBar.setTextFormatter(FancyFileUpload.this.progressiveFormater);
            HorizontalPanel hPBPanel = new HorizontalPanel();
            hPBPanel.add((Widget)FancyFileUpload.this.progressBar);
            hPBPanel.setCellVerticalAlignment((Widget)FancyFileUpload.this.progressBar, HasAlignment.ALIGN_MIDDLE);
            hPBPanel.setCellHorizontalAlignment((Widget)FancyFileUpload.this.progressBar, HasAlignment.ALIGN_LEFT);
            FancyFileUpload.this.progressBar.setSize("360", "20");
            this.pendingPanel.setWidth("375");
            this.pendingPanel.setVisible(true);
            this.pendingPanel.add((Widget)this.status);
            this.pendingPanel.add((Widget)hPBPanel);
            this.pendingPanel.setCellHorizontalAlignment((Widget)hPBPanel, HasAlignment.ALIGN_CENTER);
            this.mainPanel.add((Widget)this.hFileUpload);
            this.mainPanel.add((Widget)this.pendingPanel);
            this.mainPanel.add((Widget)this.statusZipNotifyScroll);
            this.initWidget((Widget)this.mainPanel);
        }

        private void setPending() {
            this.status.setHTML(Main.i18n("fileupload.status.sending"));
            this.pendingPanel.setStyleName("fancyfileupload-pending");
            FancyFileUpload.this.widgetState = 2;
            FancyFileUpload.this.fireChange();
        }

        public void setLoading() {
            this.pendingPanel.setStyleName("fancyfileupload-loading");
            this.hFileUpload.setVisible(false);
            this.pendingPanel.setVisible(true);
            FancyFileUpload.this.widgetState = 3;
            FancyFileUpload.this.fileUplodingStartedFlag = true;
            FancyFileUpload.this.getFileUploadStatus();
            FancyFileUpload.this.fireChange();
        }

        private void setIndexing() {
            this.status.setHTML(Main.i18n("fileupload.status.indexing"));
        }

        private void setLoaded() {
            if (FancyFileUpload.this.fileUploadingStatus.getContentLength() == 0L) {
                FancyFileUpload.this.progressBar.setTextFormatter(FancyFileUpload.this.finalFormater);
                FancyFileUpload.this.progressBar.setMaxProgress(100.0);
                FancyFileUpload.this.progressBar.setProgress(100.0);
            }
            this.pendingPanel.setStyleName("fancyfileupload-loaded");
            this.status.setHTML(Main.i18n("fileupload.status.ok"));
            FancyFileUpload.this.widgetState = 4;
            FancyFileUpload.this.fileUplodingStartedFlag = false;
            if (!FancyFileUpload.this.wizard && FancyFileUpload.this.actualFileToUpload.getWorkflow() == null) {
                FancyFileUpload.this.refresh();
            }
            FancyFileUpload.this.fireChange();
            Main.get().mainPanel.dashboard.userDashboard.getUserLastModifiedDocuments();
            Main.get().mainPanel.dashboard.userDashboard.getUserCheckedOutDocuments();
            Main.get().mainPanel.dashboard.userDashboard.getUserLastUploadedDocuments();
            Main.get().workspaceUserProperties.getUserDocumentsSize();
            FancyFileUpload.this.uploadNewPendingFile();
        }

        private void setFailed(String msg) {
            if (FancyFileUpload.this.fileUploadingStatus.getContentLength() == 0L) {
                FancyFileUpload.this.progressBar.setTextFormatter(FancyFileUpload.this.finalFormater);
                FancyFileUpload.this.progressBar.setMaxProgress(100.0);
                FancyFileUpload.this.progressBar.setProgress(100.0);
            }
            if (FancyFileUpload.this.importZip.getValue().booleanValue()) {
                this.statusZipNotify.setHTML(msg.replaceAll("\n", "<br/>"));
                this.statusZipNotifyScroll.setVisible(true);
                this.pendingPanel.setVisible(true);
                this.status.setText(Main.i18n("fileupload.label.error.importing.zip"));
            } else if (msg.contains(FancyFileUpload.returnErrorMessage)) {
                this.status.setHTML(Main.i18n(msg.substring(msg.indexOf("OKM"), msg.indexOf("OKM") + 10)));
            } else {
                this.status.setHTML(msg);
            }
            this.pendingPanel.setStyleName("fancyfileupload-failed");
            FancyFileUpload.this.widgetState = 5;
            FancyFileUpload.this.fileUplodingStartedFlag = false;
            FancyFileUpload.this.refresh();
            FancyFileUpload.this.fireChange();
        }

        private void reset(boolean enableImport, boolean enableNotifyButton) {
            FancyFileUpload.this.widgetState = 1;
            FancyFileUpload.this.fireChange();
            FancyFileUpload.this.fileName = "";
            this.status.setText("");
            this.statusZipNotify.setText("");
            this.statusZipNotifyScroll.setVisible(false);
            FancyFileUpload.this.message.setText("");
            FancyFileUpload.this.versionComment.setText("");
            FancyFileUpload.this.users.setText("");
            FancyFileUpload.this.roles.setText("");
            FancyFileUpload.this.notifyPanel.reset();
            FancyFileUpload.this.getAllUsers();
            if (Main.get().mainPanel.desktop.navigator.getStackIndex() != 0) {
                FancyFileUpload.this.hNotifyPanel.setVisible(enableNotifyButton);
            } else {
                FancyFileUpload.this.hNotifyPanel.setVisible(enableNotifyButton);
            }
            FancyFileUpload.this.errorNotify.setVisible(false);
            FancyFileUpload.this.vNotifyPanel.setVisible(false);
            FancyFileUpload.this.notifyToUser.setValue(Boolean.valueOf(false));
            FancyFileUpload.this.importZip.setValue(Boolean.valueOf(false));
            FancyFileUpload.this.digitalSignature.setValue(Boolean.valueOf(false));
            this.hFileUpload.setVisible(true);
            this.pendingPanel.setVisible(false);
            FancyFileUpload.this.hUnzipPanel.setVisible(enableImport);
            FancyFileUpload.this.hDigitalSignaturePanel.setVisible(true);
            FancyFileUpload.this.resetProgressBar();
        }

        private void init() {
            FancyFileUpload.this.vNotifyPanel.setVisible(true);
        }
    }
}

