/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.upload;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.bean.FileToUpload;
import com.openkm.frontend.client.bean.GWTDocument;
import com.openkm.frontend.client.widget.upload.FancyFileUpload;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class FileUploadPopup
extends DialogBox {
    private Button closeButton;
    private Button addButton;
    private Button sendButton;
    private VerticalPanel vPanel;
    private HorizontalPanel vButtonPanel;
    private FancyFileUpload ffUpload = new FancyFileUpload();
    private int popupWidth = 415;
    private int popupHeight = 125;
    private boolean enableAddButton = false;
    private boolean enableImport = true;
    private boolean enableNotifyButton = true;

    public FileUploadPopup() {
        super(false, true);
        this.vPanel = new VerticalPanel();
        this.vButtonPanel = new HorizontalPanel();
        this.closeButton = new Button(Main.i18n("fileupload.button.close"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                FileUploadPopup.this.executeCancel();
            }
        });
        this.addButton = new Button(Main.i18n("fileupload.button.add.other.file"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                FileUploadPopup.this.ffUpload.reset(FileUploadPopup.this.enableImport, FileUploadPopup.this.enableNotifyButton);
                FileUploadPopup.this.addButton.setVisible(false);
                FileUploadPopup.this.sendButton.setVisible(true);
                FileToUpload fileToUpload = new FileToUpload();
                fileToUpload.setFileUpload(new FileUpload());
                fileToUpload.setPath(Main.get().activeFolderTree.getActualPath());
                fileToUpload.setAction(0);
                FileUploadPopup.this.enqueueFileToUpload(new ArrayList<FileToUpload>(Arrays.asList(fileToUpload)));
            }
        });
        this.addButton.setVisible(false);
        this.sendButton = new Button();
        this.sendButton.setText(Main.i18n("fileupload.send"));
        this.sendButton.setStyleName("okm-Button");
        this.sendButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                FileUploadPopup.this.executeSend();
            }
        });
        this.vPanel.setWidth("415px");
        this.vPanel.setHeight("100px");
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.add((Widget)this.ffUpload);
        this.ffUpload.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (FileUploadPopup.this.ffUpload.getUploadState() == 2 || FileUploadPopup.this.ffUpload.getUploadState() == 3) {
                    FileUploadPopup.this.closeButton.setEnabled(false);
                    FileUploadPopup.this.addButton.setVisible(false);
                    FileUploadPopup.this.sendButton.setVisible(false);
                } else if (FileUploadPopup.this.ffUpload.getUploadState() == 1 || FileUploadPopup.this.ffUpload.getUploadState() == 5 || FileUploadPopup.this.ffUpload.getUploadState() == 4) {
                    FileUploadPopup.this.closeButton.setEnabled(true);
                    if (FileUploadPopup.this.ffUpload.getUploadState() != 1 && FileUploadPopup.this.enableAddButton) {
                        if (FileUploadPopup.this.ffUpload.getUploadState() == 4) {
                            boolean visible = !FileUploadPopup.this.ffUpload.isWizard();
                            FileUploadPopup.this.closeButton.setVisible(visible);
                            FileUploadPopup.this.sendButton.setVisible(false);
                            FileUploadPopup.this.addButton.setVisible(visible);
                        } else {
                            FileUploadPopup.this.addButton.setVisible(true);
                            FileUploadPopup.this.sendButton.setVisible(false);
                        }
                    } else if (FileUploadPopup.this.ffUpload.getAction() == 1 && FileUploadPopup.this.ffUpload.getUploadState() != 1) {
                        FileUploadPopup.this.sendButton.setVisible(false);
                    } else {
                        FileUploadPopup.this.sendButton.setVisible(true);
                    }
                }
            }
        });
        this.vButtonPanel.add((Widget)this.closeButton);
        this.vButtonPanel.add((Widget)new HTML("&nbsp;&nbsp;"));
        this.vButtonPanel.add((Widget)this.addButton);
        this.vButtonPanel.add((Widget)new HTML("&nbsp;&nbsp;"));
        this.vButtonPanel.add((Widget)this.sendButton);
        this.vPanel.add((Widget)this.vButtonPanel);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.setCellHorizontalAlignment((Widget)this.ffUpload, VerticalPanel.ALIGN_CENTER);
        this.vPanel.setCellHorizontalAlignment((Widget)this.vButtonPanel, VerticalPanel.ALIGN_CENTER);
        this.closeButton.setStyleName("okm-Button");
        this.addButton.setStyleName("okm-Button");
        this.setWidget((Widget)this.vPanel);
    }

    protected void executeCancel() {
        this.hide();
        this.addButton.setVisible(false);
        this.ffUpload.cancel();
    }

    protected void executeSend() {
        if (Main.get().mainPanel.bottomPanel.userInfo.isQuotaExceed()) {
            Main.get().showError("UserQuotaExceed", new OKMException("OKM-018023", ""));
        } else {
            this.ffUpload.users.setText(this.ffUpload.notifyPanel.getUsersToNotify());
            this.ffUpload.roles.setText(this.ffUpload.notifyPanel.getRolesToNotify());
            if (this.ffUpload.notifyToUser.getValue().booleanValue() && this.ffUpload.users.getText().equals("") && this.ffUpload.roles.getText().equals("")) {
                this.ffUpload.errorNotify.setVisible(true);
            } else if (this.ffUpload.getFilename() != null && !this.ffUpload.getFilename().equals("")) {
                this.ffUpload.pendingUpload();
            }
        }
    }

    public void langRefresh() {
        this.closeButton.setHTML(Main.i18n("button.close"));
        this.addButton.setHTML(Main.i18n("fileupload.button.add.other.file"));
        this.sendButton.setText(Main.i18n("fileupload.send"));
        if (this.ffUpload.getAction() == 0) {
            this.setText(Main.i18n("fileupload.label.insert"));
        } else {
            this.setText(Main.i18n("fileupload.label.update"));
        }
        this.ffUpload.langRefresh();
    }

    protected void showPopup(boolean enableAddButton, boolean enableImport, boolean enableNotifyButton) {
        this.enableNotifyButton = enableNotifyButton;
        this.enableAddButton = enableAddButton;
        this.enableImport = enableImport;
        this.setWidth("" + this.popupWidth);
        this.setHeight("" + this.popupHeight);
        this.ffUpload.init();
        this.center();
        this.langRefresh();
        this.ffUpload.reset(enableImport, enableNotifyButton);
    }

    public void hide() {
        if (this.ffUpload.getAction() == 1 && Main.get().mainPanel.desktop.browser.fileBrowser.table.isDocumentSelected()) {
            GWTDocument doc = Main.get().mainPanel.desktop.browser.fileBrowser.table.getDocument();
            Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.setProperties(doc);
        }
        super.hide();
    }

    public void resetAfterWizardFinished() {
        this.ffUpload.refresh();
        this.closeButton.setVisible(true);
        this.addButton.setVisible(true);
        super.show();
    }

    public void setPath(String path) {
        this.ffUpload.setPath(path);
    }

    public void disableErrorNotify() {
        this.ffUpload.disableErrorNotify();
    }

    public void enableAdvancedFilter() {
        this.ffUpload.enableAdvancedFilter();
    }

    public void showDigitalSignature() {
        this.ffUpload.showDigitalSignature();
    }

    public boolean isDigitalSignature() {
        return this.ffUpload.isDigitalSignature();
    }

    public void enqueueFileToUpload(Collection<FileToUpload> filesToUpload) {
        this.ffUpload.enqueueFileToUpload(filesToUpload);
    }

    public void setUploadNotifyUsers(boolean visible) {
        this.ffUpload.setUploadNotifyUsers(visible);
    }
}

