/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.wizard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTFolder;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMPropertyService;
import com.openkm.frontend.client.service.OKMPropertyServiceAsync;
import com.openkm.frontend.client.util.CommonUI;
import com.openkm.frontend.client.util.OKMBundleResources;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.widget.wizard.FolderSelectTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class CategoriesWidget
extends Composite {
    private final OKMPropertyServiceAsync propertyService = (OKMPropertyServiceAsync)GWT.create(OKMPropertyService.class);
    private FlexTable table;
    private String docPath;
    private HTMLTable.CellFormatter cellFormatter;
    private VerticalPanel vPanel;
    private ScrollPanel scrollDirectoryPanel;
    private VerticalPanel verticalDirectoryPanel;
    private FolderSelectTree folderSelectTree;
    private Button actionButton;
    private FlexTable tableSubscribedCategories;
    private Collection<GWTFolder> docCategories;
    private boolean remove = true;
    final AsyncCallback<Object> callbackAddCategory = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("AddCategory", caught);
        }
    };
    final AsyncCallback<Object> callbackRemoveCategory = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("RemoveCategory", caught);
        }
    };

    public CategoriesWidget(String docPath, Widget widget) {
        this.table = new FlexTable();
        this.tableSubscribedCategories = new FlexTable();
        this.docCategories = new ArrayList<GWTFolder>();
        this.docPath = docPath;
        this.cellFormatter = this.table.getCellFormatter();
        this.table.setWidth("100%");
        this.table.setCellPadding(0);
        this.table.setCellSpacing(2);
        this.table.setWidget(0, 0, widget);
        this.table.getFlexCellFormatter().setColSpan(0, 0, 2);
        this.cellFormatter.addStyleName(0, 0, "okm-Security-Title-RightBorder");
        HTMLTable.RowFormatter rowFormatter = this.table.getRowFormatter();
        rowFormatter.setStyleName(0, "okm-Security-Title");
        this.cellFormatter.setHorizontalAlignment(0, 0, HasAlignment.ALIGN_CENTER);
        this.cellFormatter.setVerticalAlignment(0, 0, HasAlignment.ALIGN_MIDDLE);
        this.vPanel = new VerticalPanel();
        this.vPanel.setWidth("390");
        this.vPanel.setHeight("175");
        this.scrollDirectoryPanel = new ScrollPanel();
        this.scrollDirectoryPanel.setSize("380", "150");
        this.scrollDirectoryPanel.setStyleName("okm-Popup-text");
        this.verticalDirectoryPanel = new VerticalPanel();
        this.verticalDirectoryPanel.setSize("100%", "100%");
        this.folderSelectTree = new FolderSelectTree();
        this.folderSelectTree.setSize("100%", "100%");
        this.verticalDirectoryPanel.add((Widget)this.folderSelectTree);
        this.scrollDirectoryPanel.add((Widget)this.verticalDirectoryPanel);
        this.actionButton = new Button(Main.i18n("button.add"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                Main.get().wizardPopup.categoriesWidget.addCategory(CategoriesWidget.this.folderSelectTree.getCategory());
            }
        });
        this.actionButton.setEnabled(false);
        this.vPanel.add((Widget)this.scrollDirectoryPanel);
        this.vPanel.add((Widget)this.actionButton);
        this.vPanel.setCellHorizontalAlignment((Widget)this.scrollDirectoryPanel, HasAlignment.ALIGN_CENTER);
        this.vPanel.setCellHorizontalAlignment((Widget)this.actionButton, HasAlignment.ALIGN_CENTER);
        this.vPanel.setCellVerticalAlignment((Widget)this.actionButton, HasAlignment.ALIGN_MIDDLE);
        this.vPanel.setCellHeight((Widget)this.scrollDirectoryPanel, "150");
        this.vPanel.setCellHeight((Widget)this.actionButton, "25");
        this.table.setWidget(1, 0, (Widget)this.vPanel);
        this.table.getFlexCellFormatter().setColSpan(1, 0, 2);
        this.cellFormatter.setHorizontalAlignment(1, 0, HasAlignment.ALIGN_CENTER);
        this.table.setHTML(2, 0, "&nbsp;<b>" + Main.i18n("document.categories") + "</b>");
        this.table.getFlexCellFormatter().setColSpan(2, 0, 2);
        this.cellFormatter.setHorizontalAlignment(2, 0, HasAlignment.ALIGN_LEFT);
        this.table.setWidget(3, 0, (Widget)this.tableSubscribedCategories);
        this.table.getFlexCellFormatter().setColSpan(3, 0, 2);
        this.cellFormatter.setHorizontalAlignment(3, 0, HasAlignment.ALIGN_LEFT);
        this.setRowWordWarp(0, 0, true, this.tableSubscribedCategories);
        this.table.setStyleName("okm-DisableSelect");
        this.actionButton.setStyleName("okm-Button");
        this.tableSubscribedCategories.setStyleName("okm-DisableSelect");
        this.folderSelectTree.reset();
        this.initWidget((Widget)this.table);
    }

    public void enable(boolean enable) {
        this.actionButton.setEnabled(enable);
    }

    public void addCategory(GWTFolder category) {
        if (!this.existCategory(category.getUuid())) {
            this.docCategories.add(category);
            this.drawCategory(category, this.remove);
            ServiceDefTarget endPoint = (ServiceDefTarget)this.propertyService;
            endPoint.setServiceEntryPoint(RPCService.PropertyService);
            this.propertyService.addCategory(this.docPath, category.getUuid(), this.callbackAddCategory);
        }
    }

    public void removeCategory(String UUID2) {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.propertyService;
        endPoint.setServiceEntryPoint(RPCService.PropertyService);
        this.propertyService.removeCategory(this.docPath, UUID2, this.callbackRemoveCategory);
    }

    private boolean existCategory(String Uuid) {
        boolean found = false;
        Iterator<GWTFolder> it = this.docCategories.iterator();
        while (it.hasNext()) {
            if (!it.next().getUuid().equals(Uuid)) continue;
            found = true;
            break;
        }
        return found;
    }

    private void drawCategory(final GWTFolder category, boolean remove) {
        int row = this.tableSubscribedCategories.getRowCount();
        Anchor anchor = new Anchor();
        String path = category.getPath().substring(16);
        if (category.getHasChilds()) {
            anchor.setHTML(Util.imageItemHTML("img/menuitem_childs.gif", path, "top"));
        } else {
            anchor.setHTML(Util.imageItemHTML("img/menuitem_empty.gif", path, "top"));
        }
        anchor.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                CommonUI.openAllFolderPath(category.getPath(), null);
            }
        });
        anchor.setStyleName("okm-KeyMap-ImageHover");
        Image delete = new Image(OKMBundleResources.INSTANCE.deleteIcon());
        delete.setStyleName("okm-KeyMap-ImageHover");
        delete.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CategoriesWidget.this.removeCategory(category.getUuid());
                CategoriesWidget.this.tableSubscribedCategories.removeRow(CategoriesWidget.this.tableSubscribedCategories.getCellForEvent(event).getRowIndex());
            }
        });
        this.tableSubscribedCategories.setWidget(row, 0, (Widget)anchor);
        if (remove) {
            this.tableSubscribedCategories.setWidget(row, 1, (Widget)delete);
        } else {
            this.tableSubscribedCategories.setWidget(row, 1, (Widget)new HTML(""));
        }
        this.setRowWordWarp(row, 1, true, this.tableSubscribedCategories);
    }

    private void setRowWordWarp(int row, int columns, boolean warp, FlexTable table) {
        HTMLTable.CellFormatter cellFormatter = table.getCellFormatter();
        for (int i = 0; i < columns; ++i) {
            cellFormatter.setWordWrap(row, i, warp);
        }
    }
}

