/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.wizard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTKeyword;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMPropertyService;
import com.openkm.frontend.client.service.OKMPropertyServiceAsync;
import com.openkm.frontend.client.util.OKMBundleResources;
import com.openkm.frontend.client.widget.dashboard.ImageHover;
import com.openkm.frontend.client.widget.dashboard.keymap.TagCloud;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class KeywordsWidget
extends Composite {
    private final OKMPropertyServiceAsync propertyService = (OKMPropertyServiceAsync)GWT.create(OKMPropertyService.class);
    private FlexTable table;
    private String docPath;
    private HTMLTable.CellFormatter cellFormatter;
    private HorizontalPanel keywordPanel;
    private SuggestBox suggestKey;
    private MultiWordSuggestOracle multiWordkSuggestKey;
    private List<String> keywordList;
    private List<String> keyWordsListPending;
    private TagCloud keywordsCloud;
    private Map<String, Widget> keywordMap;
    private FlowPanel hKeyPanel;
    private Collection<String> docKeywords;
    private boolean remove = true;
    private Image thesaurusImage;
    final AsyncCallback<Object> callbackAddKeywords = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            if (KeywordsWidget.this.keyWordsListPending.isEmpty()) {
                KeywordsWidget.this.drawTagCloud(KeywordsWidget.this.docKeywords);
            } else {
                KeywordsWidget.this.addPendingKeyWordsList();
            }
        }

        public void onFailure(Throwable caught) {
            if (KeywordsWidget.this.keyWordsListPending.isEmpty()) {
                KeywordsWidget.this.drawTagCloud(KeywordsWidget.this.docKeywords);
            } else {
                KeywordsWidget.this.addPendingKeyWordsList();
            }
            Main.get().showError("AddKeyword", caught);
        }
    };
    final AsyncCallback<Object> callbackRemoveKeywords = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("RemoveKeyword", caught);
        }
    };

    public KeywordsWidget(String docPath, Widget widget) {
        this.table = new FlexTable();
        this.docPath = docPath;
        this.docKeywords = new ArrayList<String>();
        this.keywordMap = new HashMap<String, Widget>();
        this.keyWordsListPending = new ArrayList<String>();
        this.keywordsCloud = new TagCloud();
        this.keywordsCloud.setWidth("350");
        this.keywordPanel = new HorizontalPanel();
        this.multiWordkSuggestKey = new MultiWordSuggestOracle();
        this.keywordList = new ArrayList<String>();
        this.suggestKey = new SuggestBox((SuggestOracle)this.multiWordkSuggestKey);
        this.suggestKey.setHeight("20");
        this.suggestKey.setText(Main.i18n("dashboard.keyword.suggest"));
        this.suggestKey.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (13 == event.getNativeKeyCode() && KeywordsWidget.this.keyWordsListPending.isEmpty()) {
                    Main.get().mainPanel.enableKeyShorcuts();
                    String[] keys = KeywordsWidget.this.suggestKey.getText().split(" ");
                    for (int i = 0; i < keys.length; ++i) {
                        KeywordsWidget.this.keyWordsListPending.add(keys[i]);
                    }
                    KeywordsWidget.this.addPendingKeyWordsList();
                    KeywordsWidget.this.suggestKey.setText("");
                }
            }
        });
        this.suggestKey.getTextBox().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (KeywordsWidget.this.suggestKey.getText().equals(Main.i18n("dashboard.keyword.suggest"))) {
                    KeywordsWidget.this.suggestKey.setText("");
                }
                Main.get().mainPanel.disableKeyShorcuts();
            }
        });
        this.thesaurusImage = new Image(OKMBundleResources.INSTANCE.bookOpenIcon());
        this.thesaurusImage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Main.get().mainPanel.desktop.navigator.thesaurusTree.thesaurusSelectPopup.show(1);
            }
        });
        VerticalPanel vPanel = new VerticalPanel();
        HorizontalPanel hPanel = new HorizontalPanel();
        hPanel.add((Widget)this.suggestKey);
        hPanel.add((Widget)new HTML("&nbsp;"));
        hPanel.add((Widget)this.thesaurusImage);
        this.hKeyPanel = new FlowPanel();
        HTML space = new HTML("");
        vPanel.add((Widget)hPanel);
        vPanel.add((Widget)space);
        vPanel.add((Widget)this.hKeyPanel);
        this.hKeyPanel.setWidth("250");
        vPanel.setCellHeight((Widget)space, "5");
        this.keywordPanel.add((Widget)vPanel);
        this.cellFormatter = this.table.getCellFormatter();
        this.table.setWidth("100%");
        this.table.setWidget(0, 0, widget);
        this.table.getFlexCellFormatter().setColSpan(0, 0, 2);
        this.cellFormatter.addStyleName(0, 0, "okm-Security-Title-RightBorder");
        HTMLTable.RowFormatter rowFormatter = this.table.getRowFormatter();
        rowFormatter.setStyleName(0, "okm-Security-Title");
        this.cellFormatter.setHorizontalAlignment(0, 0, HasAlignment.ALIGN_CENTER);
        this.cellFormatter.setVerticalAlignment(0, 0, HasAlignment.ALIGN_MIDDLE);
        this.table.setHTML(1, 0, "<b>" + Main.i18n("document.keywords") + "</b>");
        this.table.setWidget(1, 1, (Widget)this.keywordPanel);
        this.cellFormatter.setVerticalAlignment(1, 0, HasAlignment.ALIGN_TOP);
        this.table.setHTML(2, 0, "");
        this.table.getFlexCellFormatter().setHeight(2, 0, "5");
        this.table.setHTML(3, 0, "<b>" + Main.i18n("document.keywords.cloud") + "</b>");
        this.table.getFlexCellFormatter().setColSpan(3, 0, 2);
        this.table.setWidget(4, 0, (Widget)this.keywordsCloud);
        this.table.getFlexCellFormatter().setColSpan(4, 0, 2);
        this.cellFormatter.setHorizontalAlignment(4, 0, HasAlignment.ALIGN_CENTER);
        this.multiWordkSuggestKey.clear();
        this.keywordList = new ArrayList<String>();
        Iterator<GWTKeyword> it = Main.get().mainPanel.dashboard.keyMapDashboard.getAllKeywordList().iterator();
        while (it.hasNext()) {
            String keyword = it.next().getKeyword();
            this.multiWordkSuggestKey.add(keyword);
            this.keywordList.add(keyword);
        }
        this.table.setStyleName("okm-DisableSelect");
        this.suggestKey.setStyleName("okm-KeyMap-Suggest");
        this.suggestKey.addStyleName("okm-Input");
        this.hKeyPanel.setStylePrimaryName("okm-cloudWrap");
        this.keywordsCloud.setStylePrimaryName("okm-cloudWrap");
        this.thesaurusImage.addStyleName("okm-Hyperlink");
        this.initWidget((Widget)this.table);
    }

    public void removeKey(String keyword) {
        if (this.keywordMap.containsKey(keyword)) {
            this.keywordMap.remove(keyword);
            this.docKeywords.remove(keyword);
            this.removeKeyword(keyword);
            Main.get().mainPanel.dashboard.keyMapDashboard.decreaseKeywordRate(keyword);
            this.drawTagCloud(this.docKeywords);
        }
    }

    public void addKeywordToPendinList(String key) {
        this.keyWordsListPending.add(key);
    }

    public void addPendingKeyWordsList() {
        if (!this.keyWordsListPending.isEmpty()) {
            String keyword = this.keyWordsListPending.remove(0);
            if (!this.keywordMap.containsKey(keyword) && keyword.length() > 0) {
                for (String key : this.keywordMap.keySet()) {
                    if (this.keywordList.contains(key)) continue;
                    this.multiWordkSuggestKey.add(key);
                    this.keywordList.add(key);
                }
                HorizontalPanel keywordButton = this.getKeyWidget(keyword, this.remove);
                this.keywordMap.put(keyword, (Widget)keywordButton);
                this.hKeyPanel.add((Widget)keywordButton);
                this.docKeywords.add(keyword);
                this.addKeyword(keyword);
                Main.get().mainPanel.dashboard.keyMapDashboard.increaseKeywordRate(keyword);
            } else if (this.keyWordsListPending.isEmpty()) {
                this.drawTagCloud(this.docKeywords);
            }
        }
    }

    private HorizontalPanel getKeyWidget(final String keyword, boolean remove) {
        final HorizontalPanel externalPanel = new HorizontalPanel();
        HorizontalPanel hPanel = new HorizontalPanel();
        HTML space = new HTML();
        ImageHover delete = new ImageHover("img/icon/actions/delete_disabled.gif", "img/icon/actions/delete.gif");
        delete.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                KeywordsWidget.this.removeKey(keyword);
                KeywordsWidget.this.hKeyPanel.remove((Widget)externalPanel);
            }
        });
        delete.setStyleName("okm-KeyMap-ImageHover");
        hPanel.add((Widget)new HTML(keyword));
        hPanel.add((Widget)space);
        if (remove) {
            hPanel.add((Widget)delete);
        }
        hPanel.setCellWidth((Widget)space, "6");
        hPanel.setStyleName("okm-KeyMap-Gray");
        HTML space1 = new HTML();
        externalPanel.add((Widget)hPanel);
        externalPanel.add((Widget)space1);
        externalPanel.setCellWidth((Widget)space1, "6");
        externalPanel.setStylePrimaryName("okm-cloudTags");
        return externalPanel;
    }

    private void drawTagCloud(Collection<String> keywords) {
        this.keywordsCloud.clear();
        this.keywordsCloud.setMinFrequency(Main.get().mainPanel.dashboard.keyMapDashboard.getTotalMinFrequency());
        this.keywordsCloud.setMaxFrequency(Main.get().mainPanel.dashboard.keyMapDashboard.getTotalMaxFrequency());
        for (String keyword : keywords) {
            HTML tagKey = new HTML(keyword);
            tagKey.setStyleName("okm-cloudTags");
            Style linkStyle = tagKey.getElement().getStyle();
            int fontSize = this.keywordsCloud.getLabelSize(Main.get().mainPanel.dashboard.keyMapDashboard.getKeywordRate(keyword));
            linkStyle.setProperty("fontSize", fontSize + "pt");
            linkStyle.setProperty("color", this.keywordsCloud.getColor(fontSize));
            if (fontSize > 0) {
                linkStyle.setProperty("top", (this.keywordsCloud.getMaxFontSize() - fontSize) / 2 + "px");
            }
            this.keywordsCloud.add((Widget)tagKey);
        }
    }

    public void addKeyword(String keyword) {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.propertyService;
        endPoint.setServiceEntryPoint(RPCService.PropertyService);
        this.propertyService.addKeyword(this.docPath, keyword, this.callbackAddKeywords);
    }

    public void removeKeyword(String keyword) {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.propertyService;
        endPoint.setServiceEntryPoint(RPCService.PropertyService);
        this.propertyService.removeKeyword(this.docPath, keyword, this.callbackRemoveKeywords);
    }
}

