/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.wizard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTPropertyGroup;
import com.openkm.frontend.client.bean.form.GWTFormElement;
import com.openkm.frontend.client.service.OKMDocumentService;
import com.openkm.frontend.client.service.OKMDocumentServiceAsync;
import com.openkm.frontend.client.service.OKMPropertyGroupService;
import com.openkm.frontend.client.service.OKMPropertyGroupServiceAsync;
import com.openkm.frontend.client.widget.propertygroup.PropertyGroupWidget;
import com.openkm.frontend.client.widget.propertygroup.PropertyGroupWidgetToFire;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TemplateWizardPopup
extends DialogBox {
    private final OKMPropertyGroupServiceAsync propertyGroupService = (OKMPropertyGroupServiceAsync)GWT.create(OKMPropertyGroupService.class);
    private final OKMDocumentServiceAsync documentService = (OKMDocumentServiceAsync)GWT.create(OKMDocumentService.class);
    private static final int STATUS_NONE = -1;
    private static final int STATUS_PROPERTY_GROUPS = 0;
    private static final int STATUS_FINISH = 1;
    private FiredVerticalPanel vPanelFired;
    private String docPath = "";
    private String destinationPath = "";
    private List<GWTPropertyGroup> groupsList = null;
    private List<GWTFormElement> formElementList = null;
    private Map<String, List<Map<String, String>>> tableProperties = new HashMap<String, List<Map<String, String>>>();
    private int groupIndex = 0;
    private PropertyGroupWidget propertyGroupWidget = null;
    private int status = -1;
    public Button actualButton = new Button("");

    public TemplateWizardPopup() {
        super(false, true);
        this.vPanelFired = new FiredVerticalPanel();
        this.vPanelFired.setSize("100%", "20");
        this.setText(Main.i18n("template.wizard.creation"));
        this.actualButton.setStyleName("okm-Button");
        super.hide();
        this.setWidget((Widget)this.vPanelFired);
    }

    public void start(String docPath, String destinationPath) {
        this.groupsList = new ArrayList<GWTPropertyGroup>();
        this.formElementList = new ArrayList<GWTFormElement>();
        this.tableProperties = new HashMap<String, List<Map<String, String>>>();
        this.vPanelFired.clear();
        this.actualButton = new Button("");
        this.actualButton.setEnabled(false);
        this.docPath = docPath;
        this.destinationPath = destinationPath;
        this.status = 0;
        this.groupIndex = 0;
        this.propertyGroupService.getGroups(docPath, new AsyncCallback<List<GWTPropertyGroup>>(){

            public void onSuccess(List<GWTPropertyGroup> result) {
                for (GWTPropertyGroup group : result) {
                    TemplateWizardPopup.this.groupsList.add(group);
                }
                TemplateWizardPopup.this.showNextWizard();
            }

            public void onFailure(Throwable caught) {
                Main.get().showError("getGroups", caught);
            }
        });
    }

    private void getProperties() {
        HorizontalPanel hPanel = new HorizontalPanel();
        HTML space = new HTML("");
        hPanel.add((Widget)this.actualButton);
        hPanel.add((Widget)space);
        hPanel.setCellWidth((Widget)space, "3");
        this.propertyGroupWidget = new PropertyGroupWidget(this.docPath, this.groupsList.get(this.groupIndex), (Widget)new HTML(this.groupsList.get(this.groupIndex).getLabel()), this.vPanelFired);
        this.vPanelFired.clear();
        this.vPanelFired.add((Widget)this.propertyGroupWidget);
        this.vPanelFired.add((Widget)hPanel);
        HTML space2 = new HTML("");
        this.vPanelFired.add((Widget)space2);
        this.vPanelFired.setCellVerticalAlignment((Widget)this.propertyGroupWidget, HasAlignment.ALIGN_TOP);
        this.vPanelFired.setCellHorizontalAlignment((Widget)hPanel, HasAlignment.ALIGN_RIGHT);
        this.vPanelFired.setCellHeight((Widget)space2, "5");
        this.propertyGroupWidget.getProperties();
    }

    public void showNextWizard() {
        switch (this.status) {
            case 0: {
                if (this.groupsList != null && this.groupsList.size() > this.groupIndex) {
                    this.actualButton = this.groupsList.size() == this.groupIndex + 1 ? this.acceptButton() : this.nextButton();
                    this.getProperties();
                    ++this.groupIndex;
                    break;
                }
                this.documentService.createFromTemplate(this.docPath, this.destinationPath, this.formElementList, this.tableProperties, new AsyncCallback<String>(){

                    public void onSuccess(String result) {
                        TemplateWizardPopup.this.destinationPath = result;
                        TemplateWizardPopup.this.status = 1;
                        TemplateWizardPopup.this.showNextWizard();
                    }

                    public void onFailure(Throwable caught) {
                        Main.get().showError("createFromTemplate", caught);
                        TemplateWizardPopup.this.status = 1;
                        TemplateWizardPopup.this.showNextWizard();
                    }
                });
                break;
            }
            case 1: {
                this.hide();
                String path = this.destinationPath.substring(0, this.destinationPath.lastIndexOf("/"));
                switch (Main.get().activeFolderTree.folderSelectPopup.getSelectedIndex()) {
                    case 0: {
                        Main.get().mainPanel.desktop.navigator.stackPanel.showStack(0, false);
                        Main.get().mainPanel.desktop.browser.fileBrowser.setFlagCreatedFromTemplate();
                        Main.get().activeFolderTree.openAllPathFolder(path, this.destinationPath);
                        break;
                    }
                    case 4: {
                        Main.get().mainPanel.desktop.navigator.stackPanel.showStack(4, false);
                        Main.get().mainPanel.desktop.browser.fileBrowser.setFlagCreatedFromTemplate();
                        Main.get().activeFolderTree.openAllPathFolder(path, this.destinationPath);
                        break;
                    }
                    case 5: {
                        Main.get().mainPanel.desktop.navigator.stackPanel.showStack(5, false);
                        Main.get().mainPanel.desktop.browser.fileBrowser.setFlagCreatedFromTemplate();
                        Main.get().activeFolderTree.openAllPathFolder(path, this.destinationPath);
                    }
                }
                Main.get().workspaceUserProperties.getUserDocumentsSize();
            }
        }
    }

    private Button acceptButton() {
        Button button = new Button(Main.i18n("button.accept"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                TemplateWizardPopup.this.actualButton.setEnabled(false);
                TemplateWizardPopup.this.executeActionButton();
            }
        });
        button.setStyleName("okm-Button");
        button.setEnabled(false);
        return button;
    }

    private Button nextButton() {
        Button button = new Button(Main.i18n("button.next"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                TemplateWizardPopup.this.actualButton.setEnabled(false);
                TemplateWizardPopup.this.executeActionButton();
            }
        });
        button.setStyleName("okm-Button");
        button.setEnabled(false);
        return button;
    }

    private void executeActionButton() {
        switch (this.status) {
            case 0: {
                if (this.propertyGroupWidget == null) break;
                this.formElementList.addAll(this.propertyGroupWidget.updateFormElementsValuesWithNewer());
                this.showNextWizard();
            }
        }
    }

    public void changeView() {
        Main.get().activeFolderTree.folderSelectPopup.hide();
        this.center();
    }

    public void langRefresh() {
        this.setText(Main.i18n("template.wizard.creation"));
    }

    private class FiredVerticalPanel
    extends Composite
    implements PropertyGroupWidgetToFire {
        private VerticalPanel vPanel = new VerticalPanel();

        public FiredVerticalPanel() {
            this.initWidget((Widget)this.vPanel);
        }

        @Override
        public void finishedGetProperties() {
            if (TemplateWizardPopup.this.propertyGroupWidget != null) {
                TemplateWizardPopup.this.propertyGroupWidget.edit();
                TemplateWizardPopup.this.actualButton.setEnabled(true);
            }
            TemplateWizardPopup.this.changeView();
        }

        @Override
        public void finishedSetProperties() {
            TemplateWizardPopup.this.showNextWizard();
        }

        public void setCellHorizontalAlignment(Widget w, HasHorizontalAlignment.HorizontalAlignmentConstant align) {
            this.vPanel.setCellHorizontalAlignment(w, align);
        }

        public void setCellHeight(Widget w, String height) {
            this.vPanel.setCellHeight(w, height);
        }

        public void setCellVerticalAlignment(Widget w, HasVerticalAlignment.VerticalAlignmentConstant align) {
            this.vPanel.setCellVerticalAlignment(w, align);
        }

        public void clear() {
            this.vPanel.clear();
        }

        public void add(Widget widget) {
            this.vPanel.add(widget);
        }
    }
}

