/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.wizard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTDocument;
import com.openkm.frontend.client.bean.GWTPropertyGroup;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMDocumentService;
import com.openkm.frontend.client.service.OKMDocumentServiceAsync;
import com.openkm.frontend.client.service.OKMPropertyGroupService;
import com.openkm.frontend.client.service.OKMPropertyGroupServiceAsync;
import com.openkm.frontend.client.widget.propertygroup.PropertyGroupWidget;
import com.openkm.frontend.client.widget.propertygroup.PropertyGroupWidgetToFire;
import com.openkm.frontend.client.widget.wizard.CategoriesWidget;
import com.openkm.frontend.client.widget.wizard.KeywordsWidget;
import com.openkm.frontend.client.widget.wizard.WorkflowWidget;
import com.openkm.frontend.client.widget.wizard.WorkflowWidgetToFire;
import java.util.HashMap;
import java.util.List;

public class WizardPopup
extends DialogBox {
    private final OKMPropertyGroupServiceAsync propertyGroupService = (OKMPropertyGroupServiceAsync)GWT.create(OKMPropertyGroupService.class);
    private final OKMDocumentServiceAsync documentService = (OKMDocumentServiceAsync)GWT.create(OKMDocumentService.class);
    private static final int STATUS_NONE = -1;
    private static final int STATUS_ADD_PROPERTY_GROUPS = 0;
    private static final int STATUS_PROPERTY_GROUPS = 1;
    private static final int STATUS_WORKFLOWS = 2;
    private static final int STATUS_CATEGORIES = 3;
    private static final int STATUS_KEYWORDS = 4;
    private static final int STATUS_FINISH = 5;
    private FiredVerticalPanel vPanelFired;
    private String docPath = "";
    private List<GWTPropertyGroup> groupsList = null;
    private List<String> workflowsList = null;
    private int groupIndex = 0;
    private int workflowIndex = 0;
    private PropertyGroupWidget propertyGroupWidget = null;
    private WorkflowWidget workflowWidget = null;
    private int status = -1;
    public Button actualButton;
    public KeywordsWidget keywordsWidget;
    public CategoriesWidget categoriesWidget;
    public GWTDocument docToSign = null;
    public String uuid = "";
    final AsyncCallback<Object> callbackAddGroup = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            WizardPopup.this.groupIndex++;
            if (WizardPopup.this.groupsList.size() > WizardPopup.this.groupIndex) {
                WizardPopup.this.addPropertyGroups();
            } else {
                WizardPopup.this.groupIndex = 0;
                WizardPopup.this.showNextWizard();
            }
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("AddGroup", caught);
        }
    };

    public WizardPopup() {
        super(false, true);
        this.actualButton = new Button("");
        this.vPanelFired = new FiredVerticalPanel();
        this.vPanelFired.setSize("100%", "20");
        this.setText(Main.i18n("wizard.document.uploading"));
        this.actualButton.setStyleName("okm-Button");
        super.hide();
        this.setWidget((Widget)this.vPanelFired);
    }

    public void start(String docPath) {
        this.vPanelFired.clear();
        this.actualButton = new Button("");
        this.actualButton.setEnabled(false);
        this.docPath = docPath;
        this.docToSign = null;
        this.status = 0;
        this.groupIndex = 0;
        this.groupsList = Main.get().workspaceUserProperties.getWorkspace().getWizardPropertyGroupList();
        this.workflowIndex = 0;
        this.workflowsList = Main.get().workspaceUserProperties.getWorkspace().getWizardWorkflowList();
        this.documentService.get(docPath, new AsyncCallback<GWTDocument>(){

            public void onSuccess(GWTDocument result) {
                WizardPopup.this.uuid = result.getUuid();
                WizardPopup.this.addPropertyGroups();
            }

            public void onFailure(Throwable caught) {
                Main.get().showError("get", caught);
            }
        });
    }

    private void addPropertyGroups() {
        if (this.groupsList != null && this.groupsList.size() > this.groupIndex) {
            this.status = 1;
            ServiceDefTarget endPoint = (ServiceDefTarget)this.propertyGroupService;
            endPoint.setServiceEntryPoint(RPCService.PropertyGroupService);
            this.propertyGroupService.addGroup(this.docPath, this.groupsList.get(this.groupIndex).getName(), this.callbackAddGroup);
        } else if (this.groupsList == null || this.groupsList != null && this.groupsList.isEmpty()) {
            this.status = 2;
            this.showNextWizard();
        } else if (this.groupsList.size() == 0) {
            this.status = 2;
            this.showNextWizard();
        }
    }

    private void getProperties() {
        HorizontalPanel hPanel = new HorizontalPanel();
        HTML space = new HTML("");
        hPanel.add((Widget)this.actualButton);
        hPanel.add((Widget)space);
        hPanel.setCellWidth((Widget)space, "3");
        this.propertyGroupWidget = new PropertyGroupWidget(this.docPath, this.groupsList.get(this.groupIndex), (Widget)new HTML(this.groupsList.get(this.groupIndex).getLabel()), this.vPanelFired);
        this.vPanelFired.clear();
        this.vPanelFired.add((Widget)this.propertyGroupWidget);
        this.vPanelFired.add((Widget)hPanel);
        HTML space2 = new HTML("");
        this.vPanelFired.add((Widget)space2);
        this.vPanelFired.setCellVerticalAlignment((Widget)this.propertyGroupWidget, HasAlignment.ALIGN_TOP);
        this.vPanelFired.setCellHorizontalAlignment((Widget)hPanel, HasAlignment.ALIGN_RIGHT);
        this.vPanelFired.setCellHeight((Widget)space2, "5");
        this.propertyGroupWidget.getProperties();
    }

    public void getWorkflows() {
        HorizontalPanel hPanel = new HorizontalPanel();
        HTML space = new HTML("");
        hPanel.add((Widget)this.actualButton);
        hPanel.add((Widget)space);
        hPanel.setCellWidth((Widget)space, "3");
        this.workflowWidget = new WorkflowWidget(this.workflowsList.get(this.workflowIndex), this.uuid, this.vPanelFired, new HashMap<String, Object>());
        this.vPanelFired.clear();
        this.vPanelFired.add((Widget)this.workflowWidget);
        this.vPanelFired.add((Widget)hPanel);
        HTML space2 = new HTML("");
        this.vPanelFired.add((Widget)space2);
        this.vPanelFired.setCellVerticalAlignment((Widget)this.workflowWidget, HasAlignment.ALIGN_TOP);
        this.vPanelFired.setCellHorizontalAlignment((Widget)hPanel, HasAlignment.ALIGN_RIGHT);
        this.vPanelFired.setCellHeight((Widget)space2, "5");
        this.workflowWidget.runProcessDefinition();
    }

    public void showNextWizard() {
        switch (this.status) {
            case 1: {
                if (this.groupsList != null && this.groupsList.size() > this.groupIndex) {
                    this.actualButton = this.groupsList.size() == this.groupIndex + 1 ? (!(Main.get().workspaceUserProperties.getWorkspace().isWizardWorkflows() || Main.get().workspaceUserProperties.getWorkspace().isWizardCategories() || Main.get().workspaceUserProperties.getWorkspace().isWizardKeywords()) ? this.acceptButton() : this.nextButton()) : this.nextButton();
                    this.getProperties();
                    ++this.groupIndex;
                    break;
                }
                this.status = 2;
                this.showNextWizard();
                break;
            }
            case 2: {
                if (this.workflowsList != null && this.workflowsList.size() > this.workflowIndex) {
                    this.actualButton = this.workflowsList.size() == this.workflowIndex + 1 ? (!Main.get().workspaceUserProperties.getWorkspace().isWizardCategories() && !Main.get().workspaceUserProperties.getWorkspace().isWizardKeywords() ? this.acceptButton() : this.nextButton()) : this.nextButton();
                    this.getWorkflows();
                    ++this.workflowIndex;
                    break;
                }
                this.status = 3;
                this.showNextWizard();
                break;
            }
            case 3: {
                if (Main.get().workspaceUserProperties.getWorkspace().isWizardCategories()) {
                    this.actualButton = !Main.get().workspaceUserProperties.getWorkspace().isWizardKeywords() ? this.acceptButton() : this.nextButton();
                    this.setCategories();
                    break;
                }
                this.status = 4;
                this.showNextWizard();
                break;
            }
            case 4: {
                if (Main.get().workspaceUserProperties.getWorkspace().isWizardKeywords()) {
                    this.actualButton = this.acceptButton();
                    this.setKeywords();
                    break;
                }
                this.status = 5;
                this.showNextWizard();
                break;
            }
            case 5: {
                this.hide();
                Main.get().fileUpload.resetAfterWizardFinished();
            }
        }
    }

    private Button acceptButton() {
        Button button = new Button(Main.i18n("button.accept"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                WizardPopup.this.actualButton.setEnabled(false);
                WizardPopup.this.executeActionButton();
            }
        });
        button.setStyleName("okm-Button");
        button.setEnabled(false);
        return button;
    }

    private Button nextButton() {
        Button button = new Button(Main.i18n("button.next"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                WizardPopup.this.actualButton.setEnabled(false);
                WizardPopup.this.executeActionButton();
            }
        });
        button.setStyleName("okm-Button");
        button.setEnabled(false);
        return button;
    }

    private void executeActionButton() {
        switch (this.status) {
            case 1: {
                if (this.propertyGroupWidget == null) break;
                this.propertyGroupWidget.setProperties();
                break;
            }
            case 2: {
                if (this.workflowWidget == null) break;
                this.workflowWidget.runProcessDefinition();
                break;
            }
            case 3: {
                this.status = 4;
                this.showNextWizard();
                break;
            }
            case 4: {
                this.status = 5;
                this.showNextWizard();
            }
        }
    }

    private void setCategories() {
        this.categoriesWidget = new CategoriesWidget(this.docPath, (Widget)new HTML(Main.i18n("document.categories")));
        HorizontalPanel hPanel = new HorizontalPanel();
        HTML space = new HTML("");
        hPanel.add((Widget)this.actualButton);
        hPanel.add((Widget)space);
        hPanel.setCellWidth((Widget)space, "3");
        this.vPanelFired.clear();
        this.vPanelFired.add((Widget)this.categoriesWidget);
        this.vPanelFired.add((Widget)hPanel);
        HTML space2 = new HTML("");
        this.vPanelFired.add((Widget)space2);
        this.vPanelFired.setCellVerticalAlignment((Widget)this.categoriesWidget, HasAlignment.ALIGN_TOP);
        this.vPanelFired.setCellHorizontalAlignment((Widget)hPanel, HasAlignment.ALIGN_RIGHT);
        this.vPanelFired.setCellHeight((Widget)space2, "5");
        this.actualButton.setEnabled(true);
        this.changeView();
    }

    private void setKeywords() {
        this.keywordsWidget = new KeywordsWidget(this.docPath, (Widget)new HTML(Main.i18n("document.keywords")));
        HorizontalPanel hPanel = new HorizontalPanel();
        HTML space = new HTML("");
        hPanel.add((Widget)this.actualButton);
        hPanel.add((Widget)space);
        hPanel.setCellWidth((Widget)space, "3");
        this.vPanelFired.clear();
        this.vPanelFired.add((Widget)this.keywordsWidget);
        this.vPanelFired.add((Widget)hPanel);
        HTML space2 = new HTML("");
        this.vPanelFired.add((Widget)space2);
        this.vPanelFired.setCellVerticalAlignment((Widget)this.keywordsWidget, HasAlignment.ALIGN_TOP);
        this.vPanelFired.setCellHorizontalAlignment((Widget)hPanel, HasAlignment.ALIGN_RIGHT);
        this.vPanelFired.setCellHeight((Widget)space2, "5");
        this.actualButton.setEnabled(true);
        this.changeView();
    }

    public void changeView() {
        Main.get().fileUpload.hide();
        this.center();
    }

    public void langRefresh() {
        this.setText(Main.i18n("wizard.document.uploading"));
    }

    public GWTDocument getDocumentToSign() {
        return this.docToSign;
    }

    private class FiredVerticalPanel
    extends Composite
    implements PropertyGroupWidgetToFire,
    WorkflowWidgetToFire {
        private VerticalPanel vPanel = new VerticalPanel();

        public FiredVerticalPanel() {
            this.initWidget((Widget)this.vPanel);
        }

        @Override
        public void finishedGetProperties() {
            if (WizardPopup.this.propertyGroupWidget != null) {
                WizardPopup.this.propertyGroupWidget.edit();
                WizardPopup.this.actualButton.setEnabled(true);
            }
            WizardPopup.this.changeView();
        }

        @Override
        public void finishedSetProperties() {
            WizardPopup.this.showNextWizard();
        }

        @Override
        public void finishedRunProcessDefinition() {
            WizardPopup.this.showNextWizard();
        }

        @Override
        public void hasPendingProcessDefinitionForms() {
            WizardPopup.this.changeView();
            WizardPopup.this.actualButton.setEnabled(true);
        }

        public void setCellHorizontalAlignment(Widget w, HasHorizontalAlignment.HorizontalAlignmentConstant align) {
            this.vPanel.setCellHorizontalAlignment(w, align);
        }

        public void setCellHeight(Widget w, String height) {
            this.vPanel.setCellHeight(w, height);
        }

        public void setCellVerticalAlignment(Widget w, HasVerticalAlignment.VerticalAlignmentConstant align) {
            this.vPanel.setCellVerticalAlignment(w, align);
        }

        public void clear() {
            this.vPanel.clear();
        }

        public void add(Widget widget) {
            this.vPanel.add(widget);
        }
    }
}

