/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.jcr;

import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.RepositoryException;
import com.openkm.dao.LockTokenDAO;
import com.openkm.dao.bean.LockToken;
import com.openkm.module.direct.DirectAuthModule;
import com.openkm.module.direct.DirectRepositoryModule;
import com.openkm.util.PrincipalUtils;
import com.openkm.util.StackTraceUtils;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.Workspace;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.api.jsr283.security.AccessControlList;
import org.apache.jackrabbit.api.jsr283.security.AccessControlManager;
import org.apache.jackrabbit.api.jsr283.security.AccessControlPolicy;
import org.apache.jackrabbit.api.jsr283.security.AccessControlPolicyIterator;
import org.apache.jackrabbit.api.jsr283.security.Privilege;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.RepositoryCopier;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.lock.LockManager;
import org.apache.jackrabbit.core.lock.LockManagerImpl;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRUtils {
    private static Logger log = LoggerFactory.getLogger(JCRUtils.class);
    private static long activeSessions = 0L;
    private static long sessionCreationCount = 0L;
    private static long sessionDestroyCount = 0L;

    public static String getParent(String path) {
        log.debug("getParent({})", (Object)path);
        int lastSlash = path.lastIndexOf(47);
        String ret = lastSlash > 0 ? path.substring(0, lastSlash) : "";
        log.debug("getParent: {}", (Object)ret);
        return ret;
    }

    public static String getName(String path) {
        log.debug("getName({})", (Object)path);
        String ret = path.substring(path.lastIndexOf(47) + 1);
        log.debug("getName: {}", (Object)ret);
        return ret;
    }

    public static String escape(String name) {
        log.debug("escape({})", (Object)name);
        String ret = name.replace('/', ' ');
        ret = ret.replace(':', ' ');
        ret = ret.replace('[', ' ');
        ret = ret.replace(']', ' ');
        ret = ret.replace('*', ' ');
        ret = ret.replace('\'', ' ');
        ret = ret.replace('\"', ' ');
        ret = ret.replace('|', ' ');
        ret = ret.trim();
        log.debug("escape: {}", (Object)ret);
        return ret;
    }

    public static String[] usrValue2String(Value[] values, String usrId) throws ValueFormatException, IllegalStateException, javax.jcr.RepositoryException {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            if (values[i].getString().equals(Config.SYSTEM_USER) || values[i].getString().equals(Config.ADMIN_USER)) continue;
            list.add(values[i].getString());
        }
        if (Config.USER_ASSIGN_DOCUMENT_CREATION && !list.contains(usrId)) {
            list.add(usrId);
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] rolValue2String(Value[] values) throws ValueFormatException, IllegalStateException, javax.jcr.RepositoryException {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            if (values[i].getString().equals(Config.DEFAULT_ADMIN_ROLE)) continue;
            list.add(values[i].getString());
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] value2String(Value[] values) throws ValueFormatException, IllegalStateException, javax.jcr.RepositoryException {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            list.add(values[i].getString());
        }
        return list.toArray(new String[list.size()]);
    }

    public static void discardsPendingChanges(Node node) {
        try {
            if (node != null) {
                node.refresh(false);
            } else {
                log.warn("node == NULL");
            }
        }
        catch (javax.jcr.RepositoryException e1) {
            e1.printStackTrace();
        }
    }

    public static void discardsPendingChanges(Session session) {
        try {
            if (session != null) {
                session.refresh(false);
            } else {
                log.warn("session == NULL");
            }
        }
        catch (javax.jcr.RepositoryException e1) {
            e1.printStackTrace();
        }
    }

    public static void logout(Session session) {
        if (session != null && session.isLive()) {
            for (String lt : session.getLockTokens()) {
                log.debug("Remove LockToken: {}", (Object)lt);
                session.removeLockToken(lt);
            }
            session.logout();
            log.debug("#{} - {} Destroy session {} from {}", new Object[]{++sessionDestroyCount, --activeSessions, session, StackTraceUtils.whoCalledMe()});
        }
    }

    public static void loadLockToken(Session session, String nodeUuid) throws DatabaseException, javax.jcr.RepositoryException {
        String token = JCRUtils.getLockToken(nodeUuid);
        LockToken lt = LockTokenDAO.findByUserAndToken(session.getUserID(), token);
        if (lt != null) {
            session.addLockToken(lt.getToken());
        }
    }

    public static void addLockToken(Session session, Node node) throws DatabaseException, javax.jcr.RepositoryException {
        log.debug("addLockToken({}, {})", (Object)session, (Object)node);
        LockToken lt = new LockToken();
        lt.setUser(session.getUserID());
        lt.setToken(JCRUtils.getLockToken(node.getUUID()));
        LockTokenDAO.add(lt);
        log.debug("addLockToken: void");
    }

    public static void removeLockToken(Session session, Node node) throws DatabaseException, javax.jcr.RepositoryException {
        log.debug("removeLockToken({}, {})", (Object)session, (Object)node);
        LockTokenDAO.remove(session.getUserID(), JCRUtils.getLockToken(node.getUUID()));
        log.debug("removeLockToken: void");
    }

    public static String getLockToken(Session session, Node node) throws LockException, javax.jcr.RepositoryException {
        LockManager lm = ((SessionImpl)session).getLockManager();
        Lock lock = ((LockManagerImpl)lm).getLock((NodeImpl)node);
        if (lock != null) {
            return lock.getLockToken();
        }
        return null;
    }

    public static String getLockToken(String id) {
        StringBuffer buf = new StringBuffer();
        buf.append(id.toString());
        buf.append('-');
        buf.append(JCRUtils.getCheckDigit(id.toString()));
        return buf.toString();
    }

    private static char getCheckDigit(String uuid) {
        int result = 0;
        int multiplier = 36;
        for (int i = 0; i < uuid.length(); ++i) {
            int num;
            char c = uuid.charAt(i);
            if (c >= '0' && c <= '9') {
                num = c - 48;
                result += multiplier * num;
                --multiplier;
                continue;
            }
            if (c >= 'A' && c <= 'F') {
                num = c - 65 + 10;
                result += multiplier * num;
                --multiplier;
                continue;
            }
            if (c < 'a' || c > 'f') continue;
            num = c - 97 + 10;
            result += multiplier * num;
            --multiplier;
        }
        int rem = result % 37;
        if (rem != 0) {
            rem = 37 - rem;
        }
        if (rem >= 0 && rem <= 9) {
            return (char)(48 + rem);
        }
        if (rem >= 10 && rem <= 35) {
            return (char)(65 + rem - 10);
        }
        return '+';
    }

    public static void grant(Session session, String path, String principal, String privilege) throws javax.jcr.RepositoryException {
        AccessControlManager acm = ((SessionImpl)session).getAccessControlManager();
        AccessControlPolicyIterator acpi = acm.getApplicablePolicies(path);
        AccessControlPolicy acp = acpi.nextAccessControlPolicy();
        Privilege[] privileges = new Privilege[]{acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}all")};
        ((AccessControlList)acp).addAccessControlEntry((Principal)new PrincipalImpl(principal), privileges);
        session.save();
    }

    public static File hotBackup(String base) throws RepositoryException, IOException {
        log.debug("hotBackup({})", (Object)base);
        String date = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String backDirName = Config.CONTEXT + "_" + date;
        File backDir = null;
        backDir = base == null || base.equals("") ? new File(System.getProperty("java.io.tmpdir") + File.separator + backDirName) : new File(base, backDirName);
        FileUtils.deleteQuietly((File)backDir);
        backDir.mkdir();
        boolean oldSystemReadonly = Config.SYSTEM_READONLY;
        try {
            Config.SYSTEM_READONLY = true;
            RepositoryCopier.copy((RepositoryImpl)((RepositoryImpl)DirectRepositoryModule.getRepository()), (File)backDir);
        }
        catch (javax.jcr.RepositoryException e) {
            FileUtils.deleteQuietly((File)backDir);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            Config.SYSTEM_READONLY = oldSystemReadonly;
        }
        log.debug("hotBackup: {}", (Object)backDir);
        return backDir;
    }

    public static Session getSession() throws LoginException, javax.jcr.RepositoryException, DatabaseException {
        Object obj = null;
        try {
            Subject subject = PrincipalUtils.getSubject();
            obj = Subject.doAs(subject, new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Session s = null;
                    try {
                        s = DirectRepositoryModule.getRepository().login();
                    }
                    catch (LoginException e) {
                        return e;
                    }
                    catch (javax.jcr.RepositoryException e) {
                        return e;
                    }
                    return s;
                }
            });
        }
        catch (NamingException e) {
            throw new LoginException(e.getMessage());
        }
        if (obj instanceof LoginException) {
            throw (LoginException)((Object)obj);
        }
        if (obj instanceof javax.jcr.RepositoryException) {
            throw (javax.jcr.RepositoryException)((Object)obj);
        }
        if (obj instanceof Session) {
            Session session = (Session)obj;
            String sessionHex = Integer.toHexString(System.identityHashCode(session));
            String userIdHex = Integer.toHexString(System.identityHashCode(session.getUserID()));
            log.debug("#{} - {} Create session {} (session={}, userId={}) from {}", new Object[]{++sessionCreationCount, ++activeSessions, session, sessionHex, userIdHex, StackTraceUtils.whoCalledMe()});
            DirectAuthModule.loadUserData(session);
            return session;
        }
        return null;
    }

    public static String getNodeType(Node node) throws javax.jcr.RepositoryException {
        String ret = "unknown";
        if (node.isNodeType("okm:document")) {
            ret = "okm:document";
        } else if (node.isNodeType("okm:folder")) {
            ret = "okm:folder";
        } else if (node.isNodeType("okm:mail")) {
            ret = "okm:mail";
        }
        return ret;
    }

    public static String getUUID(Session session, String path) throws javax.jcr.RepositoryException {
        Node rootNode = session.getRootNode();
        Node node = rootNode.getNode(path.substring(1));
        return node.getUUID();
    }

    public static String getPath(Session session, String uuid) throws javax.jcr.RepositoryException {
        Node node = session.getNodeByUUID(uuid);
        return node.getPath();
    }

    public static long calculateQuota(Session session) throws javax.jcr.RepositoryException {
        String qs = "/jcr:root//element(*, okm:document)[okm:content/@okm:author='" + session.getUserID() + "']";
        Workspace workspace = session.getWorkspace();
        QueryManager queryManager = workspace.getQueryManager();
        Query query = queryManager.createQuery(qs, "xpath");
        QueryResult result = query.execute();
        long size = 0L;
        NodeIterator nit = result.getNodes();
        while (nit.hasNext()) {
            Node node = nit.nextNode();
            Node contentNode = node.getNode("okm:content");
            size += contentNode.getProperty("okm:size").getLong();
        }
        return size;
    }
}

