/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.kea;

import com.openkm.bean.kea.Term;
import com.openkm.core.Config;
import com.openkm.frontend.client.util.StringIgnoreCaseComparator;
import com.openkm.kea.metadata.WorkspaceHelper;
import com.openkm.kea.tree.TermComparator;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrdf.model.Resource;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFREpository {
    private static Logger log = LoggerFactory.getLogger(RDFREpository.class);
    private static Repository SKOSRepository = null;
    private static Repository OWLRepository = null;
    private static RDFREpository instance;
    private static List<Term> terms;
    private static List<String> keywords;

    public RepositoryConnection getSKOSConnection() throws RepositoryException {
        if (SKOSRepository != null) {
            return SKOSRepository.getConnection();
        }
        throw new RepositoryException("SKOS Repository not started");
    }

    public RepositoryConnection getOWLConnection() throws RepositoryException {
        if (OWLRepository != null) {
            return OWLRepository.getConnection();
        }
        throw new RepositoryException("OWL Repository not started");
    }

    private RDFREpository() {
        if (!Config.KEA_THESAURUS_SKOS_FILE.equals("")) {
            SKOSRepository = this.getSKOSMemStoreRepository();
            this.loadTerms();
        }
        if (!Config.KEA_THESAURUS_OWL_FILE.equals("")) {
            OWLRepository = this.getOWLMemStoreRepository();
        }
    }

    public static synchronized RDFREpository getInstance() {
        if (instance == null) {
            instance = new RDFREpository();
        }
        return instance;
    }

    public List<Term> getTerms() {
        if (terms == null || keywords == null) {
            this.loadTerms();
        }
        return terms;
    }

    public List<String> getKeywords() {
        if (terms == null || keywords == null) {
            this.loadTerms();
        }
        return keywords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTerms() {
        terms = new ArrayList<Term>();
        keywords = new ArrayList<String>();
        RepositoryConnection con = null;
        log.info("Loading skos terms in memory");
        if (SKOSRepository != null) {
            try {
                con = SKOSRepository.getConnection();
                TupleQuery query = con.prepareTupleQuery(QueryLanguage.SERQL, Config.KEA_THESAURUS_VOCABULARY_SERQL);
                log.info("query:" + Config.KEA_THESAURUS_VOCABULARY_SERQL);
                TupleQueryResult result = query.evaluate();
                while (result.hasNext()) {
                    BindingSet bindingSet = (BindingSet)result.next();
                    Term term = new Term(bindingSet.getValue("UID").stringValue(), "");
                    terms.add(term);
                    keywords.add(term.getUid());
                }
            }
            catch (RepositoryException e) {
                log.error("could not obtain connection to respository", (Throwable)e);
            }
            catch (MalformedQueryException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (QueryEvaluationException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    con.close();
                }
                catch (Throwable e) {
                    log.error("Could not close connection....", e);
                }
            }
        }
        Collections.sort(terms, new TermComparator());
        Collections.sort(keywords, new StringIgnoreCaseComparator());
        log.info("Finished loading skos terms in memory");
    }

    private Repository getSKOSMemStoreRepository() {
        SailRepository repository = null;
        String baseURL = Config.KEA_THESAURUS_BASE_URL;
        log.info("Loading skos file in memory");
        try {
            log.info(WorkspaceHelper.RDF_SKOS_VOVABULARY_PATH);
            FileInputStream is = new FileInputStream(WorkspaceHelper.RDF_SKOS_VOVABULARY_PATH);
            repository = new SailRepository((Sail)new MemoryStore());
            repository.initialize();
            RepositoryConnection con = repository.getConnection();
            con.add((InputStream)is, baseURL, RDFFormat.RDFXML, new Resource[0]);
            con.close();
            log.info("New SAIL memstore created for SKOS RDF");
        }
        catch (RepositoryException e) {
            log.error("Cannot make connection to RDF repository.", (Throwable)e);
        }
        catch (IOException e) {
            log.error("cannot locate/read file", (Throwable)e);
            e.printStackTrace();
        }
        catch (RDFParseException e) {
            log.error("Cannot parse file", (Throwable)e);
        }
        catch (Throwable t) {
            log.error("Unexpected exception loading repository", t);
        }
        log.info("Finished loading skos file in memory");
        return repository;
    }

    private Repository getOWLMemStoreRepository() {
        SailRepository repository = null;
        String baseURL = Config.KEA_THESAURUS_BASE_URL;
        log.info("Loading owl file in memory");
        try {
            log.info(WorkspaceHelper.RDF_OWL_VOVABULARY_PATH);
            FileInputStream is = new FileInputStream(WorkspaceHelper.RDF_OWL_VOVABULARY_PATH);
            repository = new SailRepository((Sail)new MemoryStore());
            repository.initialize();
            RepositoryConnection con = repository.getConnection();
            con.add((InputStream)is, baseURL, RDFFormat.RDFXML, new Resource[0]);
            con.close();
            log.info("New SAIL memstore created for OWL RDF");
        }
        catch (RepositoryException e) {
            log.error("Cannot make connection to RDF repository.", (Throwable)e);
        }
        catch (IOException e) {
            log.error("cannot locate/read file", (Throwable)e);
            e.printStackTrace();
        }
        catch (RDFParseException e) {
            log.error("Cannot parse file", (Throwable)e);
        }
        catch (Throwable t) {
            log.error("Unexpected exception loading repository", t);
        }
        log.info("Finished loading owl file in memory");
        return repository;
    }

    static {
        terms = null;
        keywords = null;
    }
}

