/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.kea.metadata;

import com.openkm.kea.filter.KEAFilter;
import com.openkm.kea.metadata.MetadataExtractionException;
import com.openkm.kea.metadata.WorkspaceHelper;
import com.openkm.kea.stemmers.SremovalStemmer;
import com.openkm.kea.stemmers.Stemmer;
import com.openkm.kea.stopwords.Stopwords;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KEAFilterBank {
    private static Logger log = LoggerFactory.getLogger(KEAFilterBank.class);
    private static KEAFilterBank instance;
    private KEAFilter filter;

    public static synchronized KEAFilterBank getInstance() throws MetadataExtractionException {
        if (instance == null) {
            instance = new KEAFilterBank();
        }
        return instance;
    }

    private KEAFilterBank() throws MetadataExtractionException {
        Date start = new Date();
        String modelPath = WorkspaceHelper.KEA_MODEL_PATH;
        String vocabularyPath = WorkspaceHelper.RDF_SKOS_VOVABULARY_PATH;
        int numPhrases = 5;
        String className = WorkspaceHelper.KEA_STOPWORDS_CLASSNAME;
        Stopwords stopwords = null;
        if (className != null) {
            try {
                Class<?> clazz = Class.forName(className);
                stopwords = (Stopwords)clazz.newInstance();
            }
            catch (Exception e) {
                log.error("Error creating class instance", (Throwable)e);
            }
        }
        this.filter = this.buildFilter(modelPath, vocabularyPath, "skos", WorkspaceHelper.KEA_LANGUAGE, new SremovalStemmer(), stopwords, numPhrases);
        Date stop = new Date();
        long time = stop.getTime() - start.getTime();
        log.info("KEA filters built in " + time + "ms");
    }

    public static KEAFilter getFilter() throws MetadataExtractionException {
        return KEAFilterBank.getInstance().filter;
    }

    private KEAFilter buildFilter(String modelPath, String vocabularyPath, String vocabularyFormat, String language, Stemmer stemmer, Stopwords stopwords, int numPhrases) throws MetadataExtractionException {
        KEAFilter newFilter = null;
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(modelPath));
            ObjectInputStream ois = new ObjectInputStream(bis);
            newFilter = (KEAFilter)((Object)ois.readObject());
            newFilter.setVocabulary(vocabularyPath);
            newFilter.setVocabularyFormat(vocabularyFormat);
            newFilter.setDocumentLanguage(language);
            newFilter.setStemmer(stemmer);
            newFilter.setStopwords(stopwords);
            newFilter.loadThesaurus(stemmer, stopwords);
            newFilter.setNumPhrases(numPhrases);
            return newFilter;
        }
        catch (FileNotFoundException e) {
            log.error("Unable to find KEA model file");
            log.error(e.getMessage(), (Throwable)e);
            throw new MetadataExtractionException("Subject Extraction failed (see trace for details.");
        }
        catch (IOException e) {
            log.error("Cannot read KEA model from stream");
            log.error(e.getMessage(), (Throwable)e);
            throw new MetadataExtractionException("Subject Extraction failed (see trace for source.");
        }
        catch (ClassNotFoundException e) {
            log.error("Class cast- KEA model.", (Throwable)e);
            log.error(e.getMessage(), (Throwable)e);
            throw new MetadataExtractionException("Subject Extraction failed (see trace for source.");
        }
        catch (Throwable e) {
            log.error("Unexpected error with model");
            log.error(e.getMessage(), e);
            throw new MetadataExtractionException("Subject Extraction failed (see trace for source.");
        }
    }
}

