/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.kea.metadata;

import com.openkm.bean.kea.MetadataDTO;
import com.openkm.kea.metadata.MetadataExtractionException;
import com.openkm.kea.metadata.SubjectExtractor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ontoware.rdf2go.RDF2Go;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.extractor.ExtractorFactory;
import org.semanticdesktop.aperture.extractor.impl.DefaultExtractorRegistry;
import org.semanticdesktop.aperture.mime.identifier.magic.MagicMimeTypeIdentifier;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.impl.RDFContainerImpl;
import org.semanticdesktop.aperture.util.IOUtil;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataExtractor {
    private static Logger log = LoggerFactory.getLogger(MetadataExtractor.class);
    private MetadataDTO mdDTO = new MetadataDTO();
    private File tempFile;
    private RDFContainer rdf;
    private SubjectExtractor subjectExtractor;
    private boolean se = true;

    public MetadataExtractor(boolean se) throws MetadataExtractionException {
        this.se = se;
        if (se) {
            this.subjectExtractor = new SubjectExtractor();
        }
    }

    public MetadataExtractor(int subjectLimit) throws MetadataExtractionException {
        this.subjectExtractor = new SubjectExtractor(subjectLimit);
    }

    public File getTempFile() {
        return this.tempFile;
    }

    public String getOriginalFileName() {
        return this.mdDTO.getFileName();
    }

    public MetadataDTO getMdDTO() {
        return this.mdDTO;
    }

    public MetadataDTO extract(File tempFile) throws MetadataExtractionException {
        try {
            this.tempFile = tempFile;
            this.loadRDF();
            this.extractMetadataFromRDF();
            if (this.se) {
                this.extractSuggestedSubjects();
            }
            this.rdf.dispose();
            return this.mdDTO;
        }
        catch (MetadataExtractionException e) {
            log.error("Metadata Extraction error: ");
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void loadRDF() {
        MagicMimeTypeIdentifier identifier = new MagicMimeTypeIdentifier();
        DefaultExtractorRegistry extractorRegistry = new DefaultExtractorRegistry();
        try {
            FileInputStream fis = new FileInputStream(this.tempFile);
            BufferedInputStream bis = new BufferedInputStream(fis);
            byte[] bytes = IOUtil.readBytes((InputStream)bis, (int)identifier.getMinArrayLength());
            bis.close();
            String mimeType = identifier.identify(bytes, this.tempFile.getPath(), null);
            if (mimeType == null) {
                throw new MetadataExtractionException("Unable to extract MimeType for: " + this.mdDTO.getFileName());
            }
            this.mdDTO.setMimeType(mimeType);
            URIImpl uri = new URIImpl(this.tempFile.toURI().toString());
            Model rdfModel = RDF2Go.getModelFactory().createModel();
            rdfModel.open();
            this.rdf = new RDFContainerImpl(rdfModel, (URI)uri);
            Set factories = extractorRegistry.getExtractorFactories(mimeType);
            if (factories == null || factories.isEmpty()) {
                throw new MetadataExtractionException("Unable to find extractor factory for: " + mimeType);
            }
            ExtractorFactory extractorFactory = (ExtractorFactory)factories.iterator().next();
            Extractor extractor = extractorFactory.get();
            fis = new FileInputStream(this.tempFile);
            bis = new BufferedInputStream(fis, 8192);
            extractor.extract((URI)uri, (InputStream)bis, null, mimeType, this.rdf);
        }
        catch (FileNotFoundException e) {
            log.error("Unable to locate the workspace file for: " + this.mdDTO.getFileName(), (Throwable)e);
        }
        catch (IOException e) {
            log.error("Unable to read workspace file for: " + this.mdDTO.getFileName(), (Throwable)e);
        }
        catch (MetadataExtractionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExtractorException e) {
            log.error("Aperture extraction error: " + e.getMessage(), (Throwable)e);
        }
    }

    private void extractMetadataFromRDF() {
        String creator = "";
        Collection creators = this.rdf.getAll(NCO.creator);
        for (Node node : creators) {
            RDFContainerImpl container = new RDFContainerImpl(this.rdf.getModel(), node.asURI());
            creator = container.getString(NCO.fullname);
            if (creator == null || creator.equals("")) continue;
            break;
        }
        this.mdDTO.setTitle(this.rdf.getString(NIE.title));
        this.mdDTO.setCreator(creator);
        this.mdDTO.addSubject(this.rdf.getString(NIE.subject));
        this.mdDTO.setGenerator(this.rdf.getString(NIE.generator));
        this.mdDTO.setContentCreated(this.rdf.getDate(NIE.contentCreated));
        this.mdDTO.setContentLastModified(this.rdf.getDate(NIE.contentLastModified));
        this.mdDTO.setPageCount(this.rdf.getInteger(NFO.pageCount));
        this.mdDTO.setKeyword(this.rdf.getString(NIE.keyword));
    }

    private void extractSuggestedSubjects() throws MetadataExtractionException {
        List<String> sugSubjects = this.subjectExtractor.extractSuggestedSubjects(this.rdf.getString(NIE.plainTextContent));
        Iterator<String> iter = sugSubjects.iterator();
        while (iter.hasNext()) {
            this.mdDTO.addSubject(iter.next());
        }
    }
}

