/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.kea.metadata;

import com.openkm.kea.filter.KEAFilter;
import com.openkm.kea.metadata.KEAFilterBank;
import com.openkm.kea.metadata.MetadataExtractionException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class SubjectExtractor {
    private static Logger log = LoggerFactory.getLogger(SubjectExtractor.class);
    private String modelName = "model";
    private String vocabulary;
    private String vocabularyFormat = "skos";
    private String language = "en";
    private String encoding = "UTF-8";
    private boolean debug = true;
    private int subjectNumLimit = 12;
    private double subjectRelLimit = 1.2;
    private boolean additionalInfo = false;
    private KEAFilter filter = null;

    public SubjectExtractor() throws MetadataExtractionException {
        this.filter = KEAFilterBank.getFilter();
    }

    public SubjectExtractor(int limit) throws MetadataExtractionException {
        this.subjectNumLimit = limit;
        this.filter = KEAFilterBank.getFilter();
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getVocabulary() {
        return this.vocabulary;
    }

    public void setVocabulary(String vocabulary) {
        this.vocabulary = vocabulary;
    }

    public String getVocabularyFormat() {
        return this.vocabularyFormat;
    }

    public void setVocabularyFormat(String vocabularyFormat) {
        this.vocabularyFormat = vocabularyFormat;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public int getSubjectNumLimit() {
        return this.subjectNumLimit;
    }

    public void setSubjectNumLimit(int subjectNumLimit) {
        this.subjectNumLimit = subjectNumLimit;
    }

    public double getSubjectRelLimit() {
        return this.subjectRelLimit;
    }

    public void setSubjectRelLimit(double subjectRelLimit) {
        this.subjectRelLimit = subjectRelLimit;
    }

    public boolean isAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(boolean additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> extractSuggestedSubjects(String documentText) {
        Date start = new Date();
        ArrayList<String> subjects = new ArrayList<String>();
        FastVector atts = new FastVector(3);
        atts.addElement((Object)new Attribute("doc", (FastVector)null));
        atts.addElement((Object)new Attribute("keyphrases", (FastVector)null));
        atts.addElement((Object)new Attribute("filename", (String)null));
        Instances unknownDataStructure = new Instances("keyphrase_training_data", atts, 0);
        try {
            Instance subject;
            double[] unknownStructure = new double[]{unknownDataStructure.attribute(0).addStringValue(documentText), Instance.missingValue()};
            unknownDataStructure.add(new Instance(1.0, unknownStructure));
            this.filter.input(unknownDataStructure.instance(0));
            unknownDataStructure.stringFreeStructure();
            Instance[] rankedSubjects = new Instance[this.subjectNumLimit];
            while ((subject = this.filter.output()) != null) {
                int index = (int)subject.value(this.filter.getRankIndex()) - 1;
                if (index >= this.subjectNumLimit) continue;
                rankedSubjects[index] = subject;
            }
            for (int i = 0; i < this.subjectNumLimit; ++i) {
                if (rankedSubjects[i] == null) continue;
                subjects.add(rankedSubjects[i].stringValue(this.filter.getUnstemmedPhraseIndex()));
            }
        }
        catch (Exception e) {
            log.error("problem in subject extraction: ", (Throwable)e);
        }
        finally {
            Date stop = new Date();
            long time = stop.getTime() - start.getTime();
            log.info("Subject extraction completed in " + time + "ms");
        }
        return subjects;
    }
}

