/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.kea.stemmers;

import com.openkm.kea.stemmers.SpanishStemmerSB;
import com.openkm.kea.stemmers.Stemmer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpanishStemmer
extends Stemmer {
    private static Logger log = LoggerFactory.getLogger(SpanishStemmer.class);
    private static final long serialVersionUID = 1L;
    private SpanishStemmerSB stemmer = new SpanishStemmerSB();

    public String stemSB(String str) {
        this.stemmer.setCurrent(str);
        this.stemmer.stem();
        return this.stemmer.getCurrent();
    }

    @Override
    public String stem(String word) {
        int len = word.length() - 1;
        if (len > 3) {
            if ((word = this.removeSpanishAccent(word)).endsWith("eses")) {
                word = word.substring(0, len - 1);
                return word;
            }
            if (word.endsWith("ces")) {
                word = word.substring(0, len - 2);
                word = word + 'z';
                return word;
            }
            if (word.endsWith("os") || word.endsWith("as") || word.endsWith("es")) {
                word = word.substring(0, len - 1);
                return word;
            }
            if (word.endsWith("o") || word.endsWith("a") || word.endsWith("e")) {
                word = word.substring(0, len - 1);
                return word;
            }
        }
        return word;
    }

    private String removeSpanishAccent(String word) {
        word = word.replaceAll("\u00e0|\u00e1|\u00e2|\u00e4", "a");
        word = word.replaceAll("\u00f2|\u00f3|\u00f4|\u00f6", "o");
        word = word.replaceAll("\u00e8|\u00e9|\u00ea|\u00eb", "e");
        word = word.replaceAll("\u00f9|\u00fa|\u00fb|\u00fc", "a");
        word = word.replaceAll("\u00ec|\u00ed|\u00ee|\u00ef", "a");
        return word;
    }

    public static void main(String[] ops) {
        SpanishStemmer s = new SpanishStemmer();
        log.info(s.stem("veces"));
    }
}

