/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.kea.tree;

import com.openkm.api.OKMFolder;
import com.openkm.bean.Folder;
import com.openkm.bean.kea.Term;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.ItemExistsException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.extension.core.ExtensionException;
import com.openkm.kea.RDFREpository;
import com.openkm.kea.tree.QueryBank;
import com.openkm.kea.tree.TermComparator;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KEATree {
    private static Logger log = LoggerFactory.getLogger(KEATree.class);

    public static void generateTree(String token, int levelToDraw, String parentPath, Vector<String> parentUIDs, Writer out) throws IOException {
        KEATree.gnerateTreeHelper(token, null, 0, levelToDraw, parentPath, parentUIDs, out);
    }

    private static void gnerateTreeHelper(String token, String termID, int level, int levelToDraw, String parentPath, Vector<String> parentUIDs, Writer out) throws IOException {
        List<Term> lisTerms = KEATree.getParentTerms(termID);
        if (level <= levelToDraw) {
            out.write("Founded " + lisTerms.size() + " terms in level " + level + "<br>");
            out.flush();
        }
        ListIterator<Term> it = lisTerms.listIterator();
        while (it.hasNext()) {
            try {
                Vector newParentUIDs = (Vector)parentUIDs.clone();
                String path = parentPath;
                Term term = it.next();
                if (level <= levelToDraw) {
                    KEATree.drawTerm(term, level, out);
                }
                path = path + "/" + term.getText();
                Folder folder = new Folder();
                folder.setPath(path);
                OKMFolder.getInstance().create(token, folder);
                if (newParentUIDs.contains(term.getUid())) continue;
                newParentUIDs.add(term.getUid());
                KEATree.gnerateTreeHelper(token, term.getUid(), level + 1, levelToDraw, path, newParentUIDs, out);
            }
            catch (PathNotFoundException e) {
                log.error("path not found", (Throwable)e);
            }
            catch (ItemExistsException e) {
            }
            catch (AccessDeniedException e) {
                log.error("access denied", (Throwable)e);
            }
            catch (RepositoryException e) {
                log.error("openkm repository exception", (Throwable)e);
            }
            catch (DatabaseException e) {
                log.error("database error", (Throwable)e);
            }
            catch (ExtensionException e) {
                log.error("extension error", (Throwable)e);
            }
        }
    }

    private static void drawTerm(Term term, int level, Writer out) throws IOException {
        String levelSeparator = "";
        for (int i = 0; i < level; ++i) {
            levelSeparator = levelSeparator + "-";
        }
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dtf = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss");
        out.write(dtf.format(cal.getTime()) + " Creating term " + levelSeparator + "> [" + term.getText() + "] - with uid:" + term.getUid() + "<br>");
        out.flush();
    }

    private static List<Term> getParentTerms(String termID) {
        ArrayList<Term> childTerms = new ArrayList<Term>();
        RepositoryConnection con = null;
        try {
            con = RDFREpository.getInstance().getOWLConnection();
            TupleQuery query = termID == null ? QueryBank.getInstance().getTreeTopQuery(con) : QueryBank.getInstance().getTreeNextLayerQuery(termID, con);
            TupleQueryResult result = query.evaluate();
            while (result.hasNext()) {
                BindingSet bindingSet = (BindingSet)result.next();
                Term term = new Term(bindingSet.getValue("UID").stringValue(), bindingSet.getValue("TEXT").stringValue());
                if (childTerms.contains(term)) continue;
                childTerms.add(term);
            }
        }
        catch (QueryEvaluationException e) {
            log.error("Query evaluation exception", (Throwable)e);
        }
        catch (org.openrdf.repository.RepositoryException e) {
            log.error("RDFVocabulary repository exception", (Throwable)e);
        }
        Collections.sort(childTerms, new TermComparator());
        return childTerms;
    }
}

