/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.kea.tree;

import com.openkm.core.Config;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryBank {
    private static Logger log = LoggerFactory.getLogger(QueryBank.class);
    private static QueryBank instance;

    private QueryBank() {
    }

    public static synchronized QueryBank getInstance() {
        if (instance == null) {
            instance = new QueryBank();
        }
        return instance;
    }

    public TupleQuery getTreeTopQuery(RepositoryConnection con) {
        try {
            return con.prepareTupleQuery(QueryLanguage.SERQL, Config.KEA_THESAURUS_TREE_ROOT);
        }
        catch (RepositoryException e) {
            log.error("Error preparing tree top query", (Throwable)e);
        }
        catch (MalformedQueryException e) {
            log.error("malformed rMap query", (Throwable)e);
        }
        return null;
    }

    public TupleQuery getTreeNextLayerQuery(String RDFparentID, RepositoryConnection con) {
        try {
            return con.prepareTupleQuery(QueryLanguage.SERQL, Config.KEA_THESAURUS_TREE_CHILDS.replace("RDFparentID", RDFparentID));
        }
        catch (RepositoryException e) {
            log.error("Error preparing rMap query", (Throwable)e);
        }
        catch (MalformedQueryException e) {
            log.error("malformed next tree layer query", (Throwable)e);
        }
        return null;
    }
}

