/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.module.base;

import com.openkm.core.Config;
import com.openkm.principal.PrincipalAdapter;
import com.openkm.principal.PrincipalAdapterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseAuthModule {
    private static Logger log = LoggerFactory.getLogger(BaseAuthModule.class);
    private static PrincipalAdapter principalAdapter = null;

    public static PrincipalAdapter getPrincipalAdapter() throws PrincipalAdapterException {
        if (principalAdapter == null) {
            try {
                log.info("PrincipalAdapter: {}", (Object)Config.PRINCIPAL_ADAPTER);
                Object object = Class.forName(Config.PRINCIPAL_ADAPTER).newInstance();
                principalAdapter = (PrincipalAdapter)object;
            }
            catch (ClassNotFoundException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new PrincipalAdapterException(e.getMessage(), e);
            }
            catch (InstantiationException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new PrincipalAdapterException(e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new PrincipalAdapterException(e.getMessage(), e);
            }
        }
        return principalAdapter;
    }
}

