/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.module.base;

import com.openkm.bean.Document;
import com.openkm.bean.Folder;
import com.openkm.bean.Note;
import com.openkm.bean.Version;
import com.openkm.cache.UserItemsManager;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.UserQuotaExceededException;
import com.openkm.dao.UserConfigDAO;
import com.openkm.dao.bean.ProfileMisc;
import com.openkm.dao.bean.UserConfig;
import com.openkm.dao.bean.cache.UserItems;
import com.openkm.extractor.RegisteredExtractors;
import com.openkm.jcr.JCRUtils;
import com.openkm.module.base.BaseAuthModule;
import com.openkm.module.base.BaseFolderModule;
import com.openkm.principal.PrincipalAdapter;
import com.openkm.principal.PrincipalAdapterException;
import com.openkm.util.DocConverter;
import com.openkm.util.UserActivity;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.spi.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseDocumentModule {
    private static Logger log = LoggerFactory.getLogger(BaseDocumentModule.class);

    public static Node create(Session session, Node parentNode, String name, String title, String mimeType, String[] keywords, InputStream is) throws ItemExistsException, PathNotFoundException, AccessDeniedException, RepositoryException, IOException, DatabaseException, UserQuotaExceededException {
        return BaseDocumentModule.create(session, parentNode, name, title, mimeType, keywords, is, null);
    }

    public static Node create(Session session, Node parentNode, String name, String title, String mimeType, String[] keywords, InputStream is, Document flags) throws ItemExistsException, PathNotFoundException, AccessDeniedException, RepositoryException, IOException, DatabaseException, UserQuotaExceededException {
        log.debug("create({}, {}, {}, {}, {}, {}, {})", new Object[]{session, parentNode, name, title, mimeType, keywords, is});
        if (flags != null) {
            List<Object> userRoles = new ArrayList();
            try {
                PrincipalAdapter pa = BaseAuthModule.getPrincipalAdapter();
                userRoles = pa.getRolesByUser(session.getUserID());
            }
            catch (PrincipalAdapterException e) {
                log.debug("cannot get roles (for " + session.getUserID() + "): " + e.getMessage());
            }
            if (!userRoles.contains(Config.DEFAULT_ADMIN_ROLE)) {
                flags = null;
                log.debug("no admin - " + session.getUserID());
            }
        }
        String userId = session.getUserID();
        Calendar lastModified = Calendar.getInstance();
        if (flags != null) {
            if (flags.getAuthor() != null) {
                userId = flags.getAuthor();
            }
            if (flags.getLastModified() != null) {
                lastModified = flags.getLastModified();
            }
        }
        Node documentNode = parentNode.addNode(name, "okm:document");
        documentNode.setProperty("okm:keywords", keywords);
        documentNode.setProperty("okm:categories", new String[0], 9);
        documentNode.setProperty("okm:author", userId);
        documentNode.setProperty("okm:name", name);
        long size = is.available();
        UserConfig uc = UserConfigDAO.findByPk(session, userId);
        ProfileMisc pm = uc.getProfile().getMisc();
        if (!Config.SYSTEM_USER.equals(userId) && pm.getUserQuota() > 0L) {
            long currentQuota = 0L;
            if (Config.USER_ITEM_CACHE) {
                UserItems ui = UserItemsManager.get(userId);
                currentQuota = ui.getSize();
            } else {
                currentQuota = JCRUtils.calculateQuota(session);
            }
            if (currentQuota + size > pm.getUserQuota() * 1024L * 1024L) {
                throw new UserQuotaExceededException(Long.toString(currentQuota + size));
            }
        }
        Value[] usersReadParent = parentNode.getProperty("okm:authUsersRead").getValues();
        String[] usersRead = JCRUtils.usrValue2String(usersReadParent, userId);
        Value[] usersWriteParent = parentNode.getProperty("okm:authUsersWrite").getValues();
        String[] usersWrite = JCRUtils.usrValue2String(usersWriteParent, userId);
        Value[] usersDeleteParent = parentNode.getProperty("okm:authUsersDelete").getValues();
        String[] usersDelete = JCRUtils.usrValue2String(usersDeleteParent, userId);
        Value[] usersSecurityParent = parentNode.getProperty("okm:authUsersSecurity").getValues();
        String[] usersSecurity = JCRUtils.usrValue2String(usersSecurityParent, userId);
        Value[] rolesReadParent = parentNode.getProperty("okm:authRolesRead").getValues();
        String[] rolesRead = JCRUtils.rolValue2String(rolesReadParent);
        Value[] rolesWriteParent = parentNode.getProperty("okm:authRolesWrite").getValues();
        String[] rolesWrite = JCRUtils.rolValue2String(rolesWriteParent);
        Value[] rolesDeleteParent = parentNode.getProperty("okm:authRolesDelete").getValues();
        String[] rolesDelete = JCRUtils.rolValue2String(rolesDeleteParent);
        Value[] rolesSecurityParent = parentNode.getProperty("okm:authRolesSecurity").getValues();
        String[] rolesSecurity = JCRUtils.rolValue2String(rolesSecurityParent);
        documentNode.setProperty("okm:authUsersRead", usersRead);
        documentNode.setProperty("okm:authUsersWrite", usersWrite);
        documentNode.setProperty("okm:authUsersDelete", usersDelete);
        documentNode.setProperty("okm:authUsersSecurity", usersSecurity);
        documentNode.setProperty("okm:authRolesRead", rolesRead);
        documentNode.setProperty("okm:authRolesWrite", rolesWrite);
        documentNode.setProperty("okm:authRolesDelete", rolesDelete);
        documentNode.setProperty("okm:authRolesSecurity", rolesSecurity);
        if (flags != null) {
            log.debug("flags: {}", (Object)flags);
            if (flags.getLastModified() != null) {
                try {
                    documentNode.setProperty("jcr:lastModified", flags.getLastModified());
                }
                catch (Exception e) {
                    log.debug("documentNode.setProperty({}, {}) : " + e.getMessage(), (Object)"jcr:lastModified", (Object)flags.getLastModified());
                }
            }
            if (flags.getCreated() != null) {
                try {
                    documentNode.setProperty("jcr:created", flags.getCreated());
                }
                catch (Exception e) {
                    log.debug("documentNode.setProperty({}, {}) : " + e.getMessage(), (Object)"jcr:created", (Object)flags.getCreated());
                }
            }
        }
        Node contentNode = documentNode.addNode("okm:content", "okm:resource");
        contentNode.setProperty("okm:size", size);
        contentNode.setProperty("okm:author", userId);
        contentNode.setProperty("okm:versionComment", "");
        contentNode.setProperty("jcr:mimeType", mimeType);
        contentNode.setProperty("jcr:data", is);
        if (mimeType.startsWith("text/")) {
            contentNode.setProperty("jcr:encoding", "UTF-8");
        }
        if (Config.EXPERIMENTAL_TEXT_EXTRACTION) {
            RegisteredExtractors.index(documentNode, contentNode, mimeType);
        }
        contentNode.setProperty("jcr:lastModified", lastModified);
        parentNode.save();
        contentNode.checkin();
        if (Config.USER_ITEM_CACHE) {
            UserItemsManager.incSize(userId, size);
            UserItemsManager.incDocuments(userId, 1);
        }
        return documentNode;
    }

    public static Document getProperties(Session session, Node docNode) throws PathNotFoundException, RepositoryException {
        log.debug("getProperties({}, {})", (Object)session, (Object)docNode);
        Document doc = new Document();
        Node contentNode = docNode.getNode("okm:content");
        doc.setAuthor(docNode.getProperty("okm:author").getString());
        doc.setPath(docNode.getPath());
        doc.setLocked(docNode.isLocked());
        doc.setUuid(docNode.getUUID());
        if (doc.isLocked()) {
            doc.setLockInfo(BaseDocumentModule.getLock(session, docNode.getPath()));
        } else {
            doc.setLockInfo(null);
        }
        doc.setCheckedOut(contentNode.isCheckedOut());
        doc.setMimeType(contentNode.getProperty("jcr:mimeType").getString());
        doc.setLastModified(contentNode.getProperty("jcr:lastModified").getDate());
        if (docNode.isNodeType("okm:document")) {
            javax.jcr.version.Version ver = contentNode.getBaseVersion();
            Version version = new Version();
            version.setAuthor(contentNode.getProperty("okm:author").getString());
            version.setSize(contentNode.getProperty("okm:size").getLong());
            version.setComment(contentNode.getProperty("okm:versionComment").getString());
            version.setName(ver.getName());
            version.setCreated(ver.getCreated());
            version.setActual(true);
            doc.setActualVersion(version);
        }
        if (docNode.isNodeType("nt:frozenNode")) {
            Node node = docNode.getProperty("jcr:frozenUuid").getNode();
            doc.setCreated(node.getProperty("jcr:created").getDate());
        } else {
            doc.setCreated(docNode.getProperty("jcr:created").getDate());
        }
        if (Config.SYSTEM_READONLY) {
            doc.setPermissions((byte)0);
        } else {
            Path path;
            AccessManager am = ((SessionImpl)session).getAccessManager();
            if (am.isGranted(path = ((NodeImpl)docNode).getPrimaryPath(), 1)) {
                doc.setPermissions((byte)1);
            }
            if (am.isGranted(path, 4)) {
                doc.setPermissions((byte)(doc.getPermissions() | 2));
            }
            if (am.isGranted(path, 8)) {
                doc.setPermissions((byte)(doc.getPermissions() | 4));
            }
            if (am.isGranted(path, 64)) {
                doc.setPermissions((byte)(doc.getPermissions() | 8));
            }
        }
        HashSet<String> subscriptorSet = new HashSet<String>();
        if (docNode.isNodeType("mix:notification")) {
            Value[] subscriptors = docNode.getProperty("okm:subscriptors").getValues();
            for (int i = 0; i < subscriptors.length; ++i) {
                subscriptorSet.add(subscriptors[i].getString());
                if (!session.getUserID().equals(subscriptors[i].getString())) continue;
                doc.setSubscribed(true);
            }
        }
        doc.setSubscriptors(subscriptorSet);
        HashSet<String> keywordsSet = new HashSet<String>();
        Value[] keywords = docNode.getProperty("okm:keywords").getValues();
        for (int i = 0; i < keywords.length; ++i) {
            keywordsSet.add(keywords[i].getString());
        }
        doc.setKeywords(keywordsSet);
        HashSet<Folder> categoriesSet = new HashSet<Folder>();
        Value[] categories = docNode.getProperty("okm:categories").getValues();
        for (int i = 0; i < categories.length; ++i) {
            Node node = session.getNodeByUUID(categories[i].getString());
            categoriesSet.add(BaseFolderModule.getProperties(session, node));
        }
        doc.setCategories(categoriesSet);
        DocConverter convert = DocConverter.getInstance();
        doc.setConvertibleToPdf(convert.convertibleToPdf(doc.getMimeType()));
        doc.setConvertibleToSwf(convert.convertibleToSwf(doc.getMimeType()));
        doc.setConvertibleToDxf(convert.convertibleToDxf(doc.getMimeType()));
        if (docNode.isNodeType("mix:notes")) {
            ArrayList<Note> notes = new ArrayList<Note>();
            Node notesNode = docNode.getNode("okm:notes");
            NodeIterator nit = notesNode.getNodes();
            while (nit.hasNext()) {
                Node noteNode = nit.nextNode();
                Note note = new Note();
                note.setDate(noteNode.getProperty("okm:date").getDate());
                note.setUser(noteNode.getProperty("okm:user").getString());
                note.setText(noteNode.getProperty("okm:text").getString());
                note.setPath(noteNode.getPath());
                notes.add(note);
            }
            doc.setNotes(notes);
        }
        if (docNode.isNodeType("mix:encryption")) {
            String cipherName = docNode.getProperty("okm:cipherName").getString();
            doc.setCipherName(cipherName);
        }
        log.debug("Permisos: {} => {}", (Object)docNode.getPath(), (Object)doc.getPermissions());
        log.debug("getProperties[session]: {}", (Object)doc);
        return doc;
    }

    public static Document getProperties2(Session session, Node docNode) throws PathNotFoundException, RepositoryException {
        Document doc = new Document();
        Node contentNode = docNode.getNode("okm:content");
        doc.setAuthor(docNode.getProperty("okm:author").getString());
        doc.setPath(docNode.getPath());
        doc.setLocked(docNode.isLocked());
        doc.setUuid(docNode.getUUID());
        if (doc.isLocked()) {
            doc.setLockInfo(BaseDocumentModule.getLock(docNode));
        } else {
            doc.setLockInfo(null);
        }
        doc.setCheckedOut(contentNode.isCheckedOut());
        doc.setMimeType(contentNode.getProperty("jcr:mimeType").getString());
        doc.setLastModified(contentNode.getProperty("jcr:lastModified").getDate());
        if (docNode.isNodeType("okm:document")) {
            javax.jcr.version.Version ver = contentNode.getBaseVersion();
            Version version = new Version();
            version.setAuthor(contentNode.getProperty("okm:author").getString());
            version.setSize(contentNode.getProperty("okm:size").getLong());
            version.setComment(contentNode.getProperty("okm:versionComment").getString());
            version.setName(ver.getName());
            version.setCreated(ver.getCreated());
            version.setActual(true);
            doc.setActualVersion(version);
        }
        if (docNode.isNodeType("nt:frozenNode")) {
            Node node = docNode.getProperty("jcr:frozenUuid").getNode();
            doc.setCreated(node.getProperty("jcr:created").getDate());
        } else {
            doc.setCreated(docNode.getProperty("jcr:created").getDate());
        }
        HashSet<String> subscriptorSet = new HashSet<String>();
        if (docNode.isNodeType("mix:notification")) {
            Value[] subscriptors = docNode.getProperty("okm:subscriptors").getValues();
            for (int i = 0; i < subscriptors.length; ++i) {
                subscriptorSet.add(subscriptors[i].getString());
            }
        }
        doc.setSubscriptors(subscriptorSet);
        HashSet<String> keywordsSet = new HashSet<String>();
        Value[] keywords = docNode.getProperty("okm:keywords").getValues();
        for (int i = 0; i < keywords.length; ++i) {
            keywordsSet.add(keywords[i].getString());
        }
        doc.setKeywords(keywordsSet);
        HashSet<Folder> categoriesSet = new HashSet<Folder>();
        doc.setCategories(categoriesSet);
        DocConverter convert = DocConverter.getInstance();
        doc.setConvertibleToPdf(convert.convertibleToPdf(doc.getMimeType()));
        doc.setConvertibleToSwf(convert.convertibleToSwf(doc.getMimeType()));
        doc.setConvertibleToDxf(convert.convertibleToDxf(doc.getMimeType()));
        if (docNode.isNodeType("mix:notes")) {
            ArrayList<Note> notes = new ArrayList<Note>();
            Node notesNode = docNode.getNode("okm:notes");
            NodeIterator nit = notesNode.getNodes();
            while (nit.hasNext()) {
                Node noteNode = nit.nextNode();
                Note note = new Note();
                note.setDate(noteNode.getProperty("okm:date").getDate());
                note.setUser(noteNode.getProperty("okm:user").getString());
                note.setText(noteNode.getProperty("okm:text").getString());
                note.setPath(noteNode.getPath());
                notes.add(note);
            }
            doc.setNotes(notes);
        }
        return doc;
    }

    public static com.openkm.bean.Lock getLock(Session session, String docPath) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        log.debug("getLock({}, {})", (Object)session, (Object)docPath);
        Node documentNode = session.getRootNode().getNode(docPath.substring(1));
        com.openkm.bean.Lock lock = BaseDocumentModule.getLock(documentNode);
        log.debug("getLock: {}", (Object)lock);
        return lock;
    }

    public static com.openkm.bean.Lock getLock(Node documentNode) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        log.debug("getLock({})", (Object)documentNode.getUUID());
        com.openkm.bean.Lock lock = new com.openkm.bean.Lock();
        Lock lck = documentNode.getLock();
        lock.setOwner(lck.getLockOwner());
        lock.setNodePath(lck.getNode().getPath());
        String lockToken = lck.getLockToken();
        if (lockToken == null || "".equals(lockToken)) {
            lockToken = JCRUtils.getLockToken(documentNode.getUUID());
        }
        lock.setToken(lockToken);
        log.debug("getLock: {}", (Object)lock);
        return lock;
    }

    public static void setContent(Session session, Node docNode, InputStream is) throws PathNotFoundException, RepositoryException, IOException {
        long size = is.available();
        Node contentNode = docNode.getNode("okm:content");
        contentNode.setProperty("okm:size", size);
        contentNode.setProperty("jcr:data", is);
        if (Config.EXPERIMENTAL_TEXT_EXTRACTION) {
            String mimeType = contentNode.getProperty("jcr:mimeType").getString();
            RegisteredExtractors.index(docNode, contentNode, mimeType);
        }
        contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
        contentNode.save();
    }

    public static InputStream getContent(Session session, String docPath, boolean checkout) throws PathNotFoundException, RepositoryException, IOException {
        Node documentNode = session.getRootNode().getNode(docPath.substring(1));
        InputStream is = BaseDocumentModule.getContent(session, documentNode);
        UserActivity.log(session.getUserID(), checkout ? "GET_DOCUMENT_CONTENT_CHECKOUT" : "GET_DOCUMENT_CONTENT", documentNode.getUUID(), is.available() + ", " + docPath);
        return is;
    }

    public static InputStream getContent(Session session, Node docNode) throws PathNotFoundException, RepositoryException, IOException {
        log.debug("getContent({}, {})", (Object)session, (Object)docNode);
        Node contentNode = docNode.getNode("okm:content");
        InputStream is = contentNode.getProperty("jcr:data").getStream();
        log.debug("getContent: {}", (Object)is);
        return is;
    }

    public static void purge(Session session, Node parentNode, Node docNode) throws PathNotFoundException, RepositoryException {
        Node contentNode = docNode.getNode("okm:content");
        long size = contentNode.getProperty("okm:size").getLong();
        String author = contentNode.getProperty("okm:author").getString();
        VersionHistory vh = contentNode.getVersionHistory();
        log.debug("VersionHistory UUID: {}", (Object)vh.getUUID());
        new File(Config.CACHE_DXF + File.separator + docNode.getUUID() + ".dxf").delete();
        new File(Config.CACHE_PDF + File.separator + docNode.getUUID() + ".pdf").delete();
        new File(Config.CACHE_SWF + File.separator + docNode.getUUID() + ".swf").delete();
        docNode.remove();
        parentNode.save();
        VersionIterator vi = vh.getAllVersions();
        while (vi.hasNext()) {
            javax.jcr.version.Version ver = vi.nextVersion();
            String versionName = ver.getName();
            log.debug("Version: {}", (Object)versionName);
            if (versionName.equals("jcr:rootVersion")) continue;
            log.debug("vh.removeVersion({})", (Object)versionName);
            vh.removeVersion(versionName);
        }
        if (Config.USER_ITEM_CACHE) {
            UserItemsManager.decSize(author, size);
            UserItemsManager.decDocuments(author, 1);
        }
    }

    public static Node copy(Session session, Node srcDocumentNode, Node dstFolderNode) throws ValueFormatException, PathNotFoundException, RepositoryException, IOException, DatabaseException, UserQuotaExceededException {
        log.debug("copy({}, {}, {})", new Object[]{session, srcDocumentNode, dstFolderNode});
        Node srcDocumentContentNode = srcDocumentNode.getNode("okm:content");
        String mimeType = srcDocumentContentNode.getProperty("jcr:mimeType").getString();
        InputStream is = srcDocumentContentNode.getProperty("jcr:data").getStream();
        Node newDocument = BaseDocumentModule.create(session, dstFolderNode, srcDocumentNode.getName(), null, mimeType, new String[0], is);
        is.close();
        log.debug("copy: {}", (Object)newDocument);
        return newDocument;
    }

    public static void cleanPreviewCache(String uuid) {
        new File(Config.CACHE_DXF + File.separator + uuid + ".dxf").delete();
        new File(Config.CACHE_PDF + File.separator + uuid + ".pdf").delete();
        new File(Config.CACHE_SWF + File.separator + uuid + ".swf").delete();
    }
}

