/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.module.base;

import com.openkm.bean.ContentInfo;
import com.openkm.bean.Folder;
import com.openkm.bean.Note;
import com.openkm.cache.UserItemsManager;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.UserQuotaExceededException;
import com.openkm.jcr.JCRUtils;
import com.openkm.module.base.BaseDocumentModule;
import com.openkm.module.base.BaseMailModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.util.TraversingItemVisitor;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.spi.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseFolderModule {
    private static Logger log = LoggerFactory.getLogger(BaseFolderModule.class);

    public static Node create(Session session, Node parentNode, String name) throws ItemExistsException, javax.jcr.PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        Node folderNode = parentNode.addNode(name, "okm:folder");
        folderNode.setProperty("okm:author", session.getUserID());
        folderNode.setProperty("okm:name", name);
        Value[] usersReadParent = parentNode.getProperty("okm:authUsersRead").getValues();
        String[] usersRead = JCRUtils.usrValue2String(usersReadParent, session.getUserID());
        Value[] usersWriteParent = parentNode.getProperty("okm:authUsersWrite").getValues();
        String[] usersWrite = JCRUtils.usrValue2String(usersWriteParent, session.getUserID());
        Value[] usersDeleteParent = parentNode.getProperty("okm:authUsersDelete").getValues();
        String[] usersDelete = JCRUtils.usrValue2String(usersDeleteParent, session.getUserID());
        Value[] usersSecurityParent = parentNode.getProperty("okm:authUsersSecurity").getValues();
        String[] usersSecurity = JCRUtils.usrValue2String(usersSecurityParent, session.getUserID());
        Value[] rolesReadParent = parentNode.getProperty("okm:authRolesRead").getValues();
        String[] rolesRead = JCRUtils.rolValue2String(rolesReadParent);
        Value[] rolesWriteParent = parentNode.getProperty("okm:authRolesWrite").getValues();
        String[] rolesWrite = JCRUtils.rolValue2String(rolesWriteParent);
        Value[] rolesDeleteParent = parentNode.getProperty("okm:authRolesDelete").getValues();
        String[] rolesDelete = JCRUtils.rolValue2String(rolesDeleteParent);
        Value[] rolesSecurityParent = parentNode.getProperty("okm:authRolesSecurity").getValues();
        String[] rolesSecurity = JCRUtils.rolValue2String(rolesSecurityParent);
        folderNode.setProperty("okm:authUsersRead", usersRead);
        folderNode.setProperty("okm:authUsersWrite", usersWrite);
        folderNode.setProperty("okm:authUsersDelete", usersDelete);
        folderNode.setProperty("okm:authUsersSecurity", usersSecurity);
        folderNode.setProperty("okm:authRolesRead", rolesRead);
        folderNode.setProperty("okm:authRolesWrite", rolesWrite);
        folderNode.setProperty("okm:authRolesDelete", rolesDelete);
        folderNode.setProperty("okm:authRolesSecurity", rolesSecurity);
        parentNode.save();
        if (Config.USER_ITEM_CACHE) {
            UserItemsManager.incFolders(session.getUserID(), 1);
        }
        return folderNode;
    }

    public static Folder getProperties(Session session, Node fldNode) throws javax.jcr.PathNotFoundException, RepositoryException {
        log.debug("getProperties[session]({}, {})", (Object)session, (Object)fldNode);
        Folder fld = new Folder();
        fld.setPath(fldNode.getPath());
        fld.setHasChilds(false);
        fld.setCreated(fldNode.getProperty("jcr:created").getDate());
        fld.setAuthor(fldNode.getProperty("okm:author").getString());
        fld.setUuid(fldNode.getUUID());
        NodeIterator nit = fldNode.getNodes();
        while (nit.hasNext()) {
            Node node = nit.nextNode();
            if (!node.isNodeType("okm:folder")) continue;
            fld.setHasChilds(true);
            break;
        }
        if (Config.SYSTEM_READONLY) {
            fld.setPermissions((byte)0);
        } else {
            Path path;
            AccessManager am = ((SessionImpl)session).getAccessManager();
            if (am.isGranted(path = ((NodeImpl)fldNode).getPrimaryPath(), 1)) {
                fld.setPermissions((byte)1);
            }
            if (am.isGranted(path, 4)) {
                fld.setPermissions((byte)(fld.getPermissions() | 2));
            }
            if (am.isGranted(path, 8)) {
                fld.setPermissions((byte)(fld.getPermissions() | 4));
            }
            if (am.isGranted(path, 64)) {
                fld.setPermissions((byte)(fld.getPermissions() | 8));
            }
        }
        HashSet<String> subscriptorSet = new HashSet<String>();
        if (fldNode.isNodeType("mix:notification")) {
            Value[] subscriptors = fldNode.getProperty("okm:subscriptors").getValues();
            for (int i = 0; i < subscriptors.length; ++i) {
                subscriptorSet.add(subscriptors[i].getString());
                if (!session.getUserID().equals(subscriptors[i].getString())) continue;
                fld.setSubscribed(true);
            }
        }
        fld.setSubscriptors(subscriptorSet);
        if (fldNode.isNodeType("mix:notes")) {
            ArrayList<Note> notes = new ArrayList<Note>();
            Node notesNode = fldNode.getNode("okm:notes");
            NodeIterator nit2 = notesNode.getNodes();
            while (nit2.hasNext()) {
                Node noteNode = nit2.nextNode();
                Note note = new Note();
                note.setDate(noteNode.getProperty("okm:date").getDate());
                note.setUser(noteNode.getProperty("okm:user").getString());
                note.setText(noteNode.getProperty("okm:text").getString());
                note.setPath(noteNode.getPath());
                notes.add(note);
            }
            fld.setNotes(notes);
        }
        log.debug("Permisos: {} => {}", (Object)fldNode.getPath(), (Object)fld.getPermissions());
        log.debug("getProperties[session]: {}", (Object)fld);
        return fld;
    }

    public static void copy(Session session, Node srcFolderNode, Node dstFolderNode) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException, IOException, DatabaseException, UserQuotaExceededException {
        log.debug("copy({}, {}, {})", new Object[]{session, srcFolderNode.getPath(), dstFolderNode.getPath()});
        NodeIterator it = srcFolderNode.getNodes();
        while (it.hasNext()) {
            Node child = it.nextNode();
            if (child.isNodeType("okm:document")) {
                BaseDocumentModule.copy(session, child, dstFolderNode);
                dstFolderNode.save();
                continue;
            }
            if (child.isNodeType("okm:mail")) {
                BaseMailModule.copy(session, child, dstFolderNode);
                dstFolderNode.save();
                continue;
            }
            if (!child.isNodeType("okm:folder")) continue;
            Node newFolder = BaseFolderModule.create(session, dstFolderNode, child.getName());
            dstFolderNode.save();
            BaseFolderModule.copy(session, child, newFolder);
        }
        log.debug("copy: void");
    }

    public static ContentInfo getContentInfo(Node folderNode) throws com.openkm.core.AccessDeniedException, RepositoryException, PathNotFoundException {
        log.debug("getContentInfo({})", (Object)folderNode);
        ContentInfo contentInfo = new ContentInfo();
        try {
            NodeIterator ni = folderNode.getNodes();
            while (ni.hasNext()) {
                Node child = ni.nextNode();
                if (child.isNodeType("okm:folder")) {
                    ContentInfo ci = BaseFolderModule.getContentInfo(child);
                    contentInfo.setFolders(contentInfo.getFolders() + ci.getFolders() + 1L);
                    contentInfo.setDocuments(contentInfo.getDocuments() + ci.getDocuments());
                    contentInfo.setSize(contentInfo.getSize() + ci.getSize());
                    continue;
                }
                if (child.isNodeType("okm:document")) {
                    Node documentContentNode = child.getNode("okm:content");
                    long size = documentContentNode.getProperty("okm:size").getLong();
                    contentInfo.setDocuments(contentInfo.getDocuments() + 1L);
                    contentInfo.setSize(contentInfo.getSize() + size);
                    continue;
                }
                if (!child.isNodeType("okm:mail")) continue;
                long size = child.getProperty("okm:size").getLong();
                contentInfo.setMails(contentInfo.getMails() + 1L);
                contentInfo.setSize(contentInfo.getSize() + size);
            }
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        log.debug("getContentInfo: {}", (Object)contentInfo);
        return contentInfo;
    }

    public static boolean hasLockedNodes(Node node) throws RepositoryException {
        boolean hasLock = false;
        NodeIterator ni = node.getNodes();
        while (ni.hasNext()) {
            Node child = ni.nextNode();
            if (child.isNodeType("okm:document")) {
                hasLock |= child.isLocked();
                continue;
            }
            if (child.isNodeType("okm:folder")) {
                hasLock |= BaseFolderModule.hasLockedNodes(child);
                continue;
            }
            if (child.isNodeType("okm:mail") || child.isNodeType("okm:notes")) continue;
            throw new RepositoryException("Unknown node type: " + child.getPrimaryNodeType().getName() + "(" + child.getPath() + ")");
        }
        return hasLock;
    }

    public static boolean hasWriteAccess(Node node) throws RepositoryException {
        log.debug("hasWriteAccess({})", (Object)node.getPath());
        int REMOVE_NODE = 8;
        boolean canWrite = true;
        AccessManager am = ((SessionImpl)node.getSession()).getAccessManager();
        NodeIterator ni = node.getNodes();
        while (ni.hasNext()) {
            Node child = ni.nextNode();
            Path path = ((NodeImpl)node).getPrimaryPath();
            if (child.isNodeType("okm:document")) {
                canWrite &= am.isGranted(path, 8);
                continue;
            }
            if (child.isNodeType("okm:folder")) {
                canWrite &= am.isGranted(path, 8);
                canWrite &= BaseFolderModule.hasWriteAccess(child);
                continue;
            }
            if (child.isNodeType("okm:mail")) {
                canWrite &= am.isGranted(path, 8);
                continue;
            }
            if (child.isNodeType("okm:notes")) continue;
            throw new RepositoryException("Unknown node type: " + child.getPrimaryNodeType().getName() + "(" + child.getPath() + ")");
        }
        log.debug("hasWriteAccess: {}", (Object)canWrite);
        return canWrite;
    }

    public static void purge(Session session, Node fldNode) throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        NodeIterator nit = fldNode.getNodes();
        while (nit.hasNext()) {
            Node node = nit.nextNode();
            if (node.isNodeType("okm:document")) {
                BaseDocumentModule.purge(session, node.getParent(), node);
                continue;
            }
            if (!node.isNodeType("okm:folder")) continue;
            BaseFolderModule.purge(session, node);
        }
        String author = fldNode.getProperty("okm:author").getString();
        fldNode.remove();
        if (Config.USER_ITEM_CACHE) {
            UserItemsManager.decFolders(author, 1);
        }
    }

    public static void getContentInfoVisitor(Session session, Node node) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        log.debug("getContentInfoVisitor({}, {})", new Object[]{session, node});
        final ContentInfo ci = new ContentInfo();
        TraversingItemVisitor.Default visitor = new TraversingItemVisitor.Default(){

            protected void entering(Node node, int level) throws RepositoryException {
                if (node.isNodeType("okm:folder")) {
                    ci.setFolders(ci.getFolders() + 1L);
                } else if (node.isNodeType("okm:document")) {
                    Node docContent = node.getNode("okm:content");
                    long size = docContent.getProperty("okm:size").getLong();
                    ci.setDocuments(ci.getDocuments() + 1L);
                    ci.setSize(ci.getSize() + size);
                } else if (node.isNodeType("okm:mail")) {
                    long size = node.getProperty("okm:size").getLong();
                    ci.setMails(ci.getMails() + 1L);
                    ci.setSize(ci.getSize() + size);
                }
            }
        };
        node.accept((ItemVisitor)visitor);
    }
}

