/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.module.base;

import com.openkm.bean.Document;
import com.openkm.bean.Mail;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.UserQuotaExceededException;
import com.openkm.jcr.JCRUtils;
import com.openkm.module.base.BaseDocumentModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.spi.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseMailModule {
    private static Logger log = LoggerFactory.getLogger(BaseMailModule.class);

    public static Node create(Session session, Node parentNode, String name, long size, String from, String[] reply, String[] to, String[] cc, String[] bcc, Calendar sentDate, Calendar receivedDate, String subject, String content, String mimeType) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException, IOException, DatabaseException, UserQuotaExceededException {
        Node mailNode = parentNode.addNode(name, "okm:mail");
        mailNode.setProperty("okm:size", size);
        mailNode.setProperty("okm:from", from);
        mailNode.setProperty("okm:reply", reply);
        mailNode.setProperty("okm:to", to);
        mailNode.setProperty("okm:cc", cc);
        mailNode.setProperty("okm:bcc", bcc);
        mailNode.setProperty("okm:sentDate", sentDate);
        mailNode.setProperty("okm:receivedDate", receivedDate);
        mailNode.setProperty("okm:subject", subject);
        mailNode.setProperty("okm:content", content);
        mailNode.setProperty("okm:mimeType", mimeType);
        Value[] usersReadParent = parentNode.getProperty("okm:authUsersRead").getValues();
        String[] usersRead = JCRUtils.usrValue2String(usersReadParent, session.getUserID());
        Value[] usersWriteParent = parentNode.getProperty("okm:authUsersWrite").getValues();
        String[] usersWrite = JCRUtils.usrValue2String(usersWriteParent, session.getUserID());
        Value[] usersDeleteParent = parentNode.getProperty("okm:authUsersDelete").getValues();
        String[] usersDelete = JCRUtils.usrValue2String(usersDeleteParent, session.getUserID());
        Value[] usersSecurityParent = parentNode.getProperty("okm:authUsersSecurity").getValues();
        String[] usersSecurity = JCRUtils.usrValue2String(usersSecurityParent, session.getUserID());
        Value[] rolesReadParent = parentNode.getProperty("okm:authRolesRead").getValues();
        String[] rolesRead = JCRUtils.rolValue2String(rolesReadParent);
        Value[] rolesWriteParent = parentNode.getProperty("okm:authRolesWrite").getValues();
        String[] rolesWrite = JCRUtils.rolValue2String(rolesWriteParent);
        Value[] rolesDeleteParent = parentNode.getProperty("okm:authRolesDelete").getValues();
        String[] rolesDelete = JCRUtils.rolValue2String(rolesDeleteParent);
        Value[] rolesSecurityParent = parentNode.getProperty("okm:authRolesSecurity").getValues();
        String[] rolesSecurity = JCRUtils.rolValue2String(rolesSecurityParent);
        mailNode.setProperty("okm:authUsersRead", usersRead);
        mailNode.setProperty("okm:authUsersWrite", usersWrite);
        mailNode.setProperty("okm:authUsersDelete", usersDelete);
        mailNode.setProperty("okm:authUsersSecurity", usersSecurity);
        mailNode.setProperty("okm:authRolesRead", rolesRead);
        mailNode.setProperty("okm:authRolesWrite", rolesWrite);
        mailNode.setProperty("okm:authRolesDelete", rolesDelete);
        mailNode.setProperty("okm:authRolesSecurity", rolesSecurity);
        parentNode.save();
        return mailNode;
    }

    public static Mail getProperties(Session session, Node mailNode) throws PathNotFoundException, RepositoryException {
        log.debug("getProperties({}, {})", (Object)session, (Object)mailNode);
        Mail mail = new Mail();
        Value[] replyValues = mailNode.getProperty("okm:reply").getValues();
        String[] reply = JCRUtils.value2String(replyValues);
        Value[] toValues = mailNode.getProperty("okm:to").getValues();
        String[] to = JCRUtils.value2String(toValues);
        Value[] ccValues = mailNode.getProperty("okm:cc").getValues();
        String[] cc = JCRUtils.value2String(ccValues);
        Value[] bccValues = mailNode.getProperty("okm:bcc").getValues();
        String[] bcc = JCRUtils.value2String(bccValues);
        mail.setPath(mailNode.getPath());
        mail.setUuid(mailNode.getUUID());
        mail.setReply(reply);
        mail.setTo(to);
        mail.setCc(cc);
        mail.setBcc(bcc);
        mail.setFrom(mailNode.getProperty("okm:from").getString());
        mail.setSize(mailNode.getProperty("okm:size").getLong());
        mail.setSentDate(mailNode.getProperty("okm:sentDate").getDate());
        mail.setReceivedDate(mailNode.getProperty("okm:receivedDate").getDate());
        mail.setSubject(mailNode.getProperty("okm:subject").getString());
        mail.setContent(mailNode.getProperty("okm:content").getString());
        mail.setMimeType(mailNode.getProperty("okm:mimeType").getString());
        mail.setCreated(mailNode.getProperty("jcr:created").getDate());
        ArrayList<Document> attachments = new ArrayList<Document>();
        NodeIterator nit = mailNode.getNodes();
        while (nit.hasNext()) {
            Node node = nit.nextNode();
            if (!node.isNodeType("okm:document")) continue;
            Document attachment = BaseDocumentModule.getProperties(session, node);
            attachments.add(attachment);
        }
        mail.setAttachments(attachments);
        if (Config.SYSTEM_READONLY) {
            mail.setPermissions((byte)0);
        } else {
            Path path;
            AccessManager am = ((SessionImpl)session).getAccessManager();
            if (am.isGranted(path = ((NodeImpl)mailNode).getPrimaryPath(), 1)) {
                mail.setPermissions((byte)1);
            }
            if (am.isGranted(path, 4)) {
                mail.setPermissions((byte)(mail.getPermissions() | 2));
            }
            if (am.isGranted(path, 8)) {
                mail.setPermissions((byte)(mail.getPermissions() | 4));
            }
            if (am.isGranted(path, 64)) {
                mail.setPermissions((byte)(mail.getPermissions() | 8));
            }
        }
        log.debug("Permisos: {} => {}", (Object)mailNode.getPath(), (Object)mail.getPermissions());
        log.debug("getProperties[session]: {}", (Object)mail);
        return mail;
    }

    public static void copy(Session session, Node srcMailNode, Node dstFolderNode) throws ValueFormatException, PathNotFoundException, RepositoryException, IOException, DatabaseException, UserQuotaExceededException {
        log.debug("copy({}, {}, {})", new Object[]{session, srcMailNode, dstFolderNode});
        String name = srcMailNode.getName();
        long size = srcMailNode.getProperty("okm:size").getLong();
        String from = srcMailNode.getProperty("okm:from").getString();
        String[] reply = JCRUtils.value2String(srcMailNode.getProperty("okm:reply").getValues());
        String[] to = JCRUtils.value2String(srcMailNode.getProperty("okm:to").getValues());
        String[] cc = JCRUtils.value2String(srcMailNode.getProperty("okm:cc").getValues());
        String[] bcc = JCRUtils.value2String(srcMailNode.getProperty("okm:bcc").getValues());
        Calendar sentDate = srcMailNode.getProperty("okm:sentDate").getDate();
        Calendar receivedDate = srcMailNode.getProperty("okm:receivedDate").getDate();
        String subject = srcMailNode.getProperty("okm:subject").getString();
        String content = srcMailNode.getProperty("okm:content").getString();
        String mimeType = srcMailNode.getProperty("okm:mimeType").getString();
        Node mNode = BaseMailModule.create(session, dstFolderNode, name, size, from, reply, to, cc, bcc, sentDate, receivedDate, subject, content, mimeType);
        NodeIterator nit = srcMailNode.getNodes();
        while (nit.hasNext()) {
            Node node = nit.nextNode();
            if (!node.isNodeType("okm:document")) continue;
            BaseDocumentModule.copy(session, node, mNode);
        }
        log.debug("copy: void");
    }
}

