/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.module.base;

import com.openkm.bean.Note;
import java.util.Calendar;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseNoteModule {
    private static Logger log = LoggerFactory.getLogger(BaseNoteModule.class);

    public static Note add(Session session, Node node, String text) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, AccessDeniedException, ItemExistsException, InvalidItemStateException, ReferentialIntegrityException, RepositoryException {
        if (!node.isNodeType("mix:notes")) {
            log.debug("Adding mixing '{}' to {}", (Object)"mix:notes", (Object)node.getPath());
            node.addMixin("mix:notes");
            node.save();
        }
        Node notesNode = node.getNode("okm:notes");
        Calendar cal = Calendar.getInstance();
        Node noteNode = notesNode.addNode(cal.getTimeInMillis() + "", "okm:note");
        noteNode.setProperty("okm:date", cal);
        noteNode.setProperty("okm:user", session.getUserID());
        noteNode.setProperty("okm:text", text);
        notesNode.save();
        Note newNote = BaseNoteModule.get(noteNode);
        return newNote;
    }

    public static Note get(Node noteNode) throws PathNotFoundException, RepositoryException {
        Note note = new Note();
        note.setDate(noteNode.getProperty("okm:date").getDate());
        note.setUser(noteNode.getProperty("okm:user").getString());
        note.setText(noteNode.getProperty("okm:text").getString());
        note.setPath(noteNode.getPath());
        return note;
    }
}

