/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.module.base;

import com.openkm.core.Config;
import com.openkm.dao.TwitterAccountDAO;
import com.openkm.dao.bean.TwitterAccount;
import com.openkm.module.direct.DirectAuthModule;
import com.openkm.util.MailUtils;
import com.openkm.util.TemplateUtils;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.mail.MessagingException;
import org.apache.commons.httpclient.HttpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.Twitter;
import twitter4j.TwitterException;

public class BaseNotificationModule {
    private static Logger log = LoggerFactory.getLogger(BaseNotificationModule.class);

    public static void checkSubscriptions(Node node, String user, String eventType, String comment) {
        Template tpl;
        StringReader sr;
        HashMap<String, String> model;
        Configuration cfg;
        log.debug("checkSubscriptions({}, {}, {}, {})", new Object[]{node, user, eventType, comment});
        List<Object> users = new ArrayList();
        ArrayList<String> mails = new ArrayList<String>();
        try {
            users = BaseNotificationModule.checkSubscriptionsHelper(node);
        }
        catch (RepositoryException e1) {
            e1.printStackTrace();
        }
        try {
            for (String string : users) {
                String mail = new DirectAuthModule().getMail(null, string);
                if (mail == null || mail.isEmpty()) continue;
                mails.add(mail);
            }
            if (!mails.isEmpty()) {
                if (comment == null) {
                    comment = "";
                }
                StringWriter swSubject = new StringWriter();
                StringWriter stringWriter = new StringWriter();
                cfg = TemplateUtils.getConfig();
                model = new HashMap<String, String>();
                model.put("documentUrl", Config.APPLICATION_URL + "?docPath=" + URLEncoder.encode(node.getPath(), "UTF-8"));
                model.put("documentPath", node.getPath());
                model.put("documentName", node.getName());
                model.put("userId", user);
                model.put("eventType", eventType);
                model.put("subscriptionComment", comment);
                if (TemplateUtils.templateExists(Config.SUBSCRIPTION_MESSAGE_SUBJECT)) {
                    Template tpl2 = cfg.getTemplate(Config.SUBSCRIPTION_MESSAGE_SUBJECT);
                    tpl2.process(model, (Writer)swSubject);
                } else {
                    sr = new StringReader(Config.SUBSCRIPTION_MESSAGE_SUBJECT);
                    Template template = new Template("SubscriptionMessageSubject", (Reader)sr, cfg);
                    template.process(model, (Writer)swSubject);
                    sr.close();
                }
                if (TemplateUtils.templateExists(Config.SUBSCRIPTION_MESSAGE_BODY)) {
                    tpl = cfg.getTemplate(Config.SUBSCRIPTION_MESSAGE_BODY);
                    tpl.process(model, (Writer)stringWriter);
                } else {
                    sr = new StringReader(Config.SUBSCRIPTION_MESSAGE_BODY);
                    Template template = new Template("SubscriptionMessageBody", (Reader)sr, cfg);
                    template.process(model, (Writer)stringWriter);
                    sr.close();
                }
                MailUtils.sendMessage(mails, swSubject.toString(), stringWriter.toString());
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        catch (ValueFormatException e) {
            e.printStackTrace();
        }
        catch (PathNotFoundException e) {
            e.printStackTrace();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (!(users == null || users.isEmpty() || Config.SUBSCRIPTION_TWITTER_USER.equals("") || Config.SUBSCRIPTION_TWITTER_PASSWORD.equals(""))) {
                Twitter twitter = new Twitter(Config.SUBSCRIPTION_TWITTER_USER, Config.SUBSCRIPTION_TWITTER_PASSWORD);
                StringWriter stringWriter = new StringWriter();
                cfg = TemplateUtils.getConfig();
                model = new HashMap();
                model.put("documentUrl", MailUtils.getTinyUrl(Config.APPLICATION_URL + "?docPath=" + node.getPath()));
                model.put("documentPath", node.getPath());
                model.put("documentName", node.getName());
                model.put("userId", user);
                model.put("eventType", eventType);
                model.put("subscriptionComment", comment);
                if (TemplateUtils.templateExists(Config.SUBSCRIPTION_TWITTER_STATUS)) {
                    tpl = cfg.getTemplate(Config.SUBSCRIPTION_TWITTER_STATUS);
                    tpl.process(model, (Writer)stringWriter);
                } else {
                    sr = new StringReader(Config.SUBSCRIPTION_TWITTER_STATUS);
                    Template template = new Template("SubscriptionTwitterStatus", (Reader)sr, cfg);
                    template.process(model, (Writer)stringWriter);
                    sr.close();
                }
                for (String string : users) {
                    List<TwitterAccount> twitterAccounts = TwitterAccountDAO.findByUser(string, true);
                    for (TwitterAccount ta : twitterAccounts) {
                        log.info("Twitter Notify from {} to {} ({}) - {}", new Object[]{twitter.getUserId(), ta.getTwitterUser(), string, stringWriter.toString()});
                        twitter.sendDirectMessage(ta.getTwitterUser(), stringWriter.toString());
                    }
                }
            }
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (TwitterException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.debug("checkSubscriptions: void");
    }

    private static List<String> checkSubscriptionsHelper(Node node) throws RepositoryException {
        log.debug("checkSubscriptionsHelper: {}", (Object)node.getPath());
        ArrayList<String> al = new ArrayList<String>();
        if (node.isNodeType("okm:folder") || node.isNodeType("okm:document")) {
            if (node.isNodeType("mix:notification")) {
                Value[] subscriptors = node.getProperty("okm:subscriptors").getValues();
                for (int i = 0; i < subscriptors.length; ++i) {
                    al.add(subscriptors[i].getString());
                }
            }
            List<String> tmp = BaseNotificationModule.checkSubscriptionsHelper(node.getParent());
            for (String usr : tmp) {
                if (al.contains(usr)) continue;
                al.add(usr);
            }
        }
        return al;
    }
}

