/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.module.base;

import com.openkm.bean.form.CheckBox;
import com.openkm.bean.form.FormElement;
import com.openkm.bean.form.Input;
import com.openkm.bean.form.Option;
import com.openkm.bean.form.Select;
import com.openkm.bean.form.SuggestBox;
import com.openkm.bean.form.TextArea;
import com.openkm.core.ParseException;
import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePropertyGroupModule {
    private static Logger log = LoggerFactory.getLogger(BasePropertyGroupModule.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGroup(Session session, Node node, String grpName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        log.debug("addGroup({}, {}, {})", new Object[]{session, node, grpName});
        Node node2 = node;
        synchronized (node2) {
            node.addMixin(grpName);
            node.save();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setPropertyValue(Node node, PropertyDefinition pd, FormElement fe) throws PathNotFoundException, RepositoryException, ParseException {
        Property prop = node.getProperty(pd.getName());
        if (fe instanceof Select && ((Select)fe).getType().equals("multiple") && pd.isMultiple()) {
            ArrayList<String> tmp = new ArrayList<String>();
            for (Option opt : ((Select)fe).getOptions()) {
                if (!opt.isSelected()) continue;
                tmp.add(opt.getValue());
            }
            prop.setValue(tmp.toArray(new String[tmp.size()]));
            return;
        } else {
            if (pd.isMultiple()) throw new ParseException("Inconsistent property definition: " + pd.getName());
            if (fe instanceof Input) {
                prop.setValue(((Input)fe).getValue());
                return;
            } else if (fe instanceof SuggestBox) {
                prop.setValue(((SuggestBox)fe).getValue());
                return;
            } else if (fe instanceof CheckBox) {
                prop.setValue(Boolean.toString(((CheckBox)fe).getValue()));
                return;
            } else if (fe instanceof TextArea) {
                prop.setValue(((TextArea)fe).getValue());
                return;
            } else {
                if (!(fe instanceof Select)) throw new ParseException("Unknown property definition: " + pd.getName());
                for (Option opt : ((Select)fe).getOptions()) {
                    if (!opt.isSelected()) continue;
                    prop.setValue(opt.getValue());
                }
            }
        }
    }
}

