/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.module.base;

import com.openkm.core.Config;
import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePropertyModule {
    private static Logger log = LoggerFactory.getLogger(BasePropertyModule.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCategory(Session session, Node node, String catId) throws ValueFormatException, PathNotFoundException, RepositoryException {
        log.debug("addCategory({}, {}, {})", new Object[]{session, node, catId});
        Node node2 = node;
        synchronized (node2) {
            Value[] property = node.getProperty("okm:categories").getValues();
            Value[] newProperty = new Value[property.length + 1];
            boolean alreadyAdded = false;
            for (int i = 0; i < property.length; ++i) {
                newProperty[i] = property[i];
                if (!property[i].getString().equals(catId)) continue;
                alreadyAdded = true;
            }
            if (!alreadyAdded) {
                Node reference = session.getNodeByUUID(catId);
                newProperty[newProperty.length - 1] = session.getValueFactory().createValue(reference);
                node.setProperty("okm:categories", newProperty, 9);
                node.save();
            }
        }
        log.debug("addCategory: void");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCategory(Session session, Node node, String catId) throws ValueFormatException, PathNotFoundException, RepositoryException {
        log.debug("removeCategory({}, {}, {})", new Object[]{session, node, catId});
        boolean removed = false;
        Node node2 = node;
        synchronized (node2) {
            Value[] property = node.getProperty("okm:categories").getValues();
            ArrayList<Value> newProperty = new ArrayList<Value>();
            for (int i = 0; i < property.length; ++i) {
                if (!property[i].getString().equals(catId)) {
                    newProperty.add(property[i]);
                    continue;
                }
                removed = true;
            }
            if (removed) {
                node.setProperty("okm:categories", newProperty.toArray(new Value[newProperty.size()]), 9);
                node.save();
            }
        }
        log.debug("removeCategory: void");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String addKeyword(Session session, Node node, String keyword) throws ValueFormatException, PathNotFoundException, RepositoryException {
        log.debug("addKeyword({}, {}, {})", new Object[]{session, node, keyword});
        Node node2 = node;
        synchronized (node2) {
            Value[] property = node.getProperty("okm:keywords").getValues();
            Value[] newProperty = new Value[property.length + 1];
            boolean alreadyAdded = false;
            if (Config.SYSTEM_KEYWORD_LOWERCASE) {
                keyword = keyword.toLowerCase();
            }
            for (int i = 0; i < property.length; ++i) {
                newProperty[i] = property[i];
                if (!property[i].equals(keyword)) continue;
                alreadyAdded = true;
            }
            if (!alreadyAdded) {
                newProperty[newProperty.length - 1] = session.getValueFactory().createValue(keyword);
                node.setProperty("okm:keywords", newProperty);
                node.save();
            }
        }
        log.debug("addKeyword: {}", (Object)keyword);
        return keyword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeKeyword(Session session, Node node, String keyword) throws ValueFormatException, PathNotFoundException, RepositoryException {
        log.debug("removeKeyword({}, {}, {})", new Object[]{session, node, keyword});
        boolean removed = false;
        Node node2 = node;
        synchronized (node2) {
            Value[] property = node.getProperty("okm:keywords").getValues();
            ArrayList<Value> newProperty = new ArrayList<Value>();
            for (int i = 0; i < property.length; ++i) {
                if (!property[i].getString().equals(keyword)) {
                    newProperty.add(property[i]);
                    continue;
                }
                removed = true;
            }
            if (removed) {
                node.setProperty("okm:keywords", newProperty.toArray(new Value[newProperty.size()]));
                node.save();
            }
        }
        log.debug("removeKeyword: void");
    }
}

