/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.module.base;

import bsh.EvalError;
import bsh.Interpreter;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseScriptingModule {
    private static Logger log = LoggerFactory.getLogger(BaseScriptingModule.class);

    public static void checkScripts(Session session, Node scriptNode, Node eventNode, String eventType) {
        log.debug("checkScripts({}, {}, {}, {})", new Object[]{session, scriptNode, eventNode, eventType});
        try {
            BaseScriptingModule.checkScriptsHelper(session, scriptNode, eventNode, eventType);
        }
        catch (ValueFormatException e) {
            e.printStackTrace();
        }
        catch (PathNotFoundException e) {
            e.printStackTrace();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        log.debug("checkScripts: void");
    }

    private static void checkScriptsHelper(Session session, Node scriptNode, Node eventNode, String eventType) throws RepositoryException {
        log.debug("checkScriptsHelper({}, {}, {}, {})", new Object[]{session, scriptNode, eventNode, eventType});
        if (scriptNode.isNodeType("okm:folder") || scriptNode.isNodeType("okm:document")) {
            if (scriptNode.isNodeType("mix:scripting")) {
                String code = scriptNode.getProperty("okm:scriptCode").getString();
                Interpreter i = new Interpreter();
                try {
                    i.set("session", (Object)session);
                    i.set("scriptNode", (Object)scriptNode);
                    i.set("eventNode", (Object)eventNode);
                    i.set("eventType", (Object)eventType);
                    i.eval(code);
                }
                catch (EvalError e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            }
            BaseScriptingModule.checkScriptsHelper(session, scriptNode.getParent(), eventNode, eventType);
        }
        log.debug("checkScriptsHelper: void");
    }
}

