/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.module.base;

import com.openkm.bean.form.FormElement;
import com.openkm.bean.workflow.ProcessInstance;
import com.openkm.core.Config;
import com.openkm.util.WorkflowUtils;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Session;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.db.GraphSession;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseWorkflowModule {
    private static Logger log = LoggerFactory.getLogger(BaseWorkflowModule.class);

    public static ProcessInstance runProcessDefinition(Session session, JbpmContext jbpmContext, long processDefinitionId, String uuid, List<FormElement> variables) throws JbpmException {
        log.debug("runProcessDefinition({}, {}, {}, {})", new Object[]{session, processDefinitionId, uuid, variables});
        ProcessInstance vo = new ProcessInstance();
        jbpmContext.setActorId(session.getUserID());
        GraphSession graphSession = jbpmContext.getGraphSession();
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put(Config.WORKFLOW_PROCESS_INSTANCE_VARIABLE_UUID, uuid);
        for (FormElement fe : variables) {
            hm.put(fe.getName(), fe);
        }
        ProcessDefinition pd = graphSession.getProcessDefinition(processDefinitionId);
        org.jbpm.graph.exe.ProcessInstance pi = pd.createProcessInstance(hm);
        if (pi != null) {
            TaskMgmtInstance tmi = pi.getTaskMgmtInstance();
            if (tmi.getTaskMgmtDefinition().getStartTask() != null) {
                TaskInstance ti = tmi.createStartTaskInstance();
                if (Config.WORKFLOW_START_TASK_AUTO_RUN) {
                    ti.start();
                    ti.end();
                }
            } else {
                pi.getRootToken().signal();
            }
            jbpmContext.save(pi);
            vo = WorkflowUtils.copy(pi);
        }
        return vo;
    }
}

