/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.module.direct;

import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.JcrSessionManager;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.jcr.JCRUtils;
import com.openkm.module.AuthModule;
import com.openkm.module.base.BaseAuthModule;
import com.openkm.module.direct.DirectRepositoryModule;
import com.openkm.principal.PrincipalAdapter;
import com.openkm.principal.PrincipalAdapterException;
import com.openkm.util.UserActivity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectAuthModule
implements AuthModule {
    private static Logger log = LoggerFactory.getLogger(DirectAuthModule.class);

    @Override
    public void login() throws RepositoryException, DatabaseException {
        Session session = null;
        try {
            session = JCRUtils.getSession();
            UserActivity.log(session.getUserID(), "LOGIN", null, null);
        }
        catch (LoginException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            JCRUtils.logout(session);
        }
    }

    @Override
    public String login(String user, String password) throws com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        String token = null;
        try {
            if (Config.SYSTEM_MAINTENANCE) {
                throw new com.openkm.core.AccessDeniedException("System under maintenance");
            }
            Repository r = DirectRepositoryModule.getRepository();
            Session session = r.login((Credentials)new SimpleCredentials(user, password.toCharArray()), null);
            token = UUID.randomUUID().toString();
            JcrSessionManager.getInstance().add(token, session);
            UserActivity.log(session.getUserID(), "LOGIN", null, token);
            return token;
        }
        catch (LoginException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
    }

    @Override
    public void logout(String token) throws RepositoryException, DatabaseException {
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            if (session != null) {
                UserActivity.log(session.getUserID(), "LOGOUT", token, null);
                JcrSessionManager.getInstance().remove(token);
                session.logout();
            }
        }
        catch (LoginException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadUserData(Session session) throws DatabaseException, javax.jcr.RepositoryException {
        log.debug("loadUserData({}) -> {}", (Object)session.getUserID(), (Object)session);
        String string = session.getUserID();
        synchronized (string) {
            if (!session.itemExists("/okm:trash/" + session.getUserID())) {
                log.info("Create okm:trash/{}", (Object)session.getUserID());
                Node okmTrash = session.getRootNode().getNode("okm:trash");
                DirectAuthModule.createBase(session, okmTrash);
                okmTrash.save();
            }
            if (!session.itemExists("/okm:personal/" + session.getUserID())) {
                log.info("Create okm:personal/{}", (Object)session.getUserID());
                Node okmPersonal = session.getRootNode().getNode("okm:personal");
                DirectAuthModule.createBase(session, okmPersonal);
                okmPersonal.save();
            }
            if (!session.itemExists("/okm:mail/" + session.getUserID())) {
                log.info("Create okm:mail/{}", (Object)session.getUserID());
                Node okmMail = session.getRootNode().getNode("okm:mail");
                DirectAuthModule.createBase(session, okmMail);
                okmMail.save();
            }
        }
        log.debug("loadUserData: void");
    }

    private static Node createBase(Session session, Node root) throws javax.jcr.RepositoryException {
        Node base = root.addNode(session.getUserID(), "okm:folder");
        base.setProperty("okm:author", session.getUserID());
        base.setProperty("okm:name", session.getUserID());
        base.setProperty("okm:authUsersRead", new String[]{session.getUserID()});
        base.setProperty("okm:authUsersWrite", new String[]{session.getUserID()});
        base.setProperty("okm:authUsersDelete", new String[]{session.getUserID()});
        base.setProperty("okm:authUsersSecurity", new String[]{session.getUserID()});
        base.setProperty("okm:authRolesRead", new String[0]);
        base.setProperty("okm:authRolesWrite", new String[0]);
        base.setProperty("okm:authRolesDelete", new String[0]);
        base.setProperty("okm:authRolesSecurity", new String[0]);
        return base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantUser(String token, String nodePath, String user, int permissions, boolean recursive) throws PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("grantUser({}, {}, {}, {})", new Object[]{nodePath, user, permissions, recursive});
        Node node = null;
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            node = session.getRootNode().getNode(nodePath.substring(1));
            String property = null;
            if (permissions == 1) {
                property = "okm:authUsersRead";
            } else if (permissions == 2) {
                property = "okm:authUsersWrite";
            } else if (permissions == 4) {
                property = "okm:authUsersDelete";
            } else if (permissions == 8) {
                property = "okm:authUsersSecurity";
            }
            Node node2 = node;
            synchronized (node2) {
                if (recursive) {
                    this.grantUserInDepth(node, user, property);
                } else {
                    this.grantUser(node, user, property);
                }
            }
            UserActivity.log(session.getUserID(), "GRANT_USER", node.getUUID(), user + ", " + permissions + ", " + nodePath);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(node);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(node);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(node);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("grantUser: void");
    }

    private void grantUser(Node node, String user, String property) throws ValueFormatException, PathNotFoundException, javax.jcr.RepositoryException {
        Value[] actualUsers = node.getProperty(property).getValues();
        ArrayList<String> newUsers = new ArrayList<String>();
        for (int i = 0; i < actualUsers.length; ++i) {
            newUsers.add(actualUsers[i].getString());
        }
        if (!newUsers.contains(user)) {
            newUsers.add(user);
        }
        try {
            node.setProperty(property, newUsers.toArray(new String[newUsers.size()]));
            node.save();
        }
        catch (LockException e) {
            log.warn("grantUser -> LockException : {}", (Object)node.getPath());
            JCRUtils.discardsPendingChanges(node);
        }
        catch (AccessDeniedException e) {
            log.warn("grantUser -> AccessDeniedException : {}", (Object)node.getPath());
            JCRUtils.discardsPendingChanges(node);
        }
    }

    private void grantUserInDepth(Node node, String user, String property) throws ValueFormatException, PathNotFoundException, javax.jcr.RepositoryException {
        if (node.isNodeType("okm:document")) {
            this.grantUser(node, user, property);
        } else if (node.isNodeType("okm:folder")) {
            this.grantUser(node, user, property);
            NodeIterator it = node.getNodes();
            while (it.hasNext()) {
                Node child = it.nextNode();
                this.grantUserInDepth(child, user, property);
            }
        } else if (node.isNodeType("okm:mail")) {
            this.grantUser(node, user, property);
        } else if (node.isNodeType("okm:notes")) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeUser(String token, String nodePath, String user, int permissions, boolean recursive) throws PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("revokeUser({}, {}, {}, {})", new Object[]{nodePath, user, permissions, recursive});
        Node node = null;
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            node = session.getRootNode().getNode(nodePath.substring(1));
            String property = null;
            if (permissions == 1) {
                property = "okm:authUsersRead";
            } else if (permissions == 2) {
                property = "okm:authUsersWrite";
            } else if (permissions == 4) {
                property = "okm:authUsersDelete";
            } else if (permissions == 8) {
                property = "okm:authUsersSecurity";
            }
            Node node2 = node;
            synchronized (node2) {
                if (recursive) {
                    this.revokeUserInDepth(node, user, property);
                } else {
                    this.revokeUser(node, user, property);
                }
            }
            UserActivity.log(session.getUserID(), "REVOKE_USER", node.getUUID(), user + ", " + permissions + ", " + nodePath);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(node);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(node);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(node);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("revokeUser: void");
    }

    private void revokeUser(Node node, String user, String property) throws ValueFormatException, PathNotFoundException, javax.jcr.RepositoryException {
        Value[] actualUsers = node.getProperty(property).getValues();
        ArrayList<String> newUsers = new ArrayList<String>();
        for (int i = 0; i < actualUsers.length; ++i) {
            if (actualUsers[i].getString().equals(user)) continue;
            newUsers.add(actualUsers[i].getString());
        }
        try {
            node.setProperty(property, newUsers.toArray(new String[newUsers.size()]));
            node.save();
        }
        catch (LockException e) {
            log.warn("revokeUser -> LockException : " + node.getPath());
            JCRUtils.discardsPendingChanges(node);
        }
        catch (AccessDeniedException e) {
            log.warn("revokeUser -> AccessDeniedException : " + node.getPath());
            JCRUtils.discardsPendingChanges(node);
        }
    }

    private void revokeUserInDepth(Node node, String user, String property) throws ValueFormatException, PathNotFoundException, javax.jcr.RepositoryException {
        if (node.isNodeType("okm:document")) {
            this.revokeUser(node, user, property);
        } else if (node.isNodeType("okm:folder")) {
            this.revokeUser(node, user, property);
            NodeIterator it = node.getNodes();
            while (it.hasNext()) {
                Node child = it.nextNode();
                this.revokeUserInDepth(child, user, property);
            }
        } else if (node.isNodeType("okm:mail")) {
            this.revokeUser(node, user, property);
        } else if (node.isNodeType("okm:notes")) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantRole(String token, String nodePath, String role, int permissions, boolean recursive) throws PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("grantRole({}, {}, {}, {})", new Object[]{nodePath, role, permissions, recursive});
        Node node = null;
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            node = session.getRootNode().getNode(nodePath.substring(1));
            String property = null;
            if (permissions == 1) {
                property = "okm:authRolesRead";
            } else if (permissions == 2) {
                property = "okm:authRolesWrite";
            } else if (permissions == 4) {
                property = "okm:authRolesDelete";
            } else if (permissions == 8) {
                property = "okm:authRolesSecurity";
            }
            Node node2 = node;
            synchronized (node2) {
                if (recursive) {
                    this.grantRoleInDepth(node, role, property);
                } else {
                    this.grantRole(node, role, property);
                }
            }
            UserActivity.log(session.getUserID(), "GRANT_ROLE", node.getUUID(), role + ", " + permissions + ", " + nodePath);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(node);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(node);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(node);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("grantRole: void");
    }

    private void grantRole(Node node, String role, String property) throws ValueFormatException, PathNotFoundException, javax.jcr.RepositoryException {
        Value[] actualRoles = node.getProperty(property).getValues();
        ArrayList<String> newRoles = new ArrayList<String>();
        for (int i = 0; i < actualRoles.length; ++i) {
            newRoles.add(actualRoles[i].getString());
        }
        if (!newRoles.contains(role)) {
            newRoles.add(role);
        }
        try {
            node.setProperty(property, newRoles.toArray(new String[newRoles.size()]));
            node.save();
        }
        catch (LockException e) {
            log.warn("grantRole -> LockException : {}", (Object)node.getPath());
            JCRUtils.discardsPendingChanges(node);
        }
        catch (AccessDeniedException e) {
            log.warn("grantRole -> AccessDeniedException : {}", (Object)node.getPath());
            JCRUtils.discardsPendingChanges(node);
        }
    }

    private void grantRoleInDepth(Node node, String role, String property) throws ValueFormatException, PathNotFoundException, javax.jcr.RepositoryException {
        if (node.isNodeType("okm:document")) {
            this.grantRole(node, role, property);
        } else if (node.isNodeType("okm:folder")) {
            this.grantRole(node, role, property);
            NodeIterator it = node.getNodes();
            while (it.hasNext()) {
                Node child = it.nextNode();
                this.grantRoleInDepth(child, role, property);
            }
        } else if (node.isNodeType("okm:mail")) {
            this.grantRole(node, role, property);
        } else if (node.isNodeType("okm:notes")) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeRole(String token, String nodePath, String role, int permissions, boolean recursive) throws PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("revokeRole({}, {}, {}, {})", new Object[]{nodePath, role, permissions, recursive});
        Node node = null;
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            node = session.getRootNode().getNode(nodePath.substring(1));
            String property = null;
            if (permissions == 1) {
                property = "okm:authRolesRead";
            } else if (permissions == 2) {
                property = "okm:authRolesWrite";
            } else if (permissions == 4) {
                property = "okm:authRolesDelete";
            } else if (permissions == 8) {
                property = "okm:authRolesSecurity";
            }
            Node node2 = node;
            synchronized (node2) {
                if (recursive) {
                    this.revokeRoleInDepth(node, role, property);
                } else {
                    this.revokeRole(node, role, property);
                }
            }
            UserActivity.log(session.getUserID(), "REVOKE_ROLE", node.getUUID(), role + ", " + permissions + ", " + nodePath);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(node);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(node);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(node);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("revokeRole: void");
    }

    private void revokeRole(Node node, String role, String property) throws ValueFormatException, PathNotFoundException, javax.jcr.RepositoryException {
        Value[] actualRoles = node.getProperty(property).getValues();
        ArrayList<String> newRoles = new ArrayList<String>();
        for (int i = 0; i < actualRoles.length; ++i) {
            if (actualRoles[i].getString().equals(role)) continue;
            newRoles.add(actualRoles[i].getString());
        }
        try {
            node.setProperty(property, newRoles.toArray(new String[newRoles.size()]));
            node.save();
        }
        catch (LockException e) {
            log.warn("revokeRole -> LockException : " + node.getPath());
            JCRUtils.discardsPendingChanges(node);
        }
        catch (AccessDeniedException e) {
            log.warn("revokeRole -> AccessDeniedException : " + node.getPath());
            JCRUtils.discardsPendingChanges(node);
        }
    }

    private void revokeRoleInDepth(Node node, String role, String property) throws ValueFormatException, PathNotFoundException, javax.jcr.RepositoryException {
        if (node.isNodeType("okm:document")) {
            this.revokeRole(node, role, property);
        } else if (node.isNodeType("okm:folder")) {
            this.revokeRole(node, role, property);
            NodeIterator it = node.getNodes();
            while (it.hasNext()) {
                Node child = it.nextNode();
                this.revokeRoleInDepth(child, role, property);
            }
        } else if (node.isNodeType("okm:mail")) {
            this.revokeRole(node, role, property);
        } else if (node.isNodeType("okm:notes")) {
            // empty if block
        }
    }

    public HashMap<String, Byte> getGrantedUsers(String token, String nodePath) throws PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("getGrantedUsers({})", (Object)nodePath);
        HashMap<String, Byte> users = new HashMap();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node node = session.getRootNode().getNode(nodePath.substring(1));
            users = DirectAuthModule.getGrantedUsers(session, node);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getGrantedUsers: {}", users);
        return users;
    }

    public static HashMap<String, Byte> getGrantedUsers(Session session, Node node) throws PathNotFoundException, RepositoryException {
        try {
            Value[] usersRead = node.getProperty("okm:authUsersRead").getValues();
            HashMap<String, Byte> users = new HashMap<String, Byte>();
            for (int i = 0; i < usersRead.length; ++i) {
                users.put(usersRead[i].getString(), new Byte(1));
            }
            Value[] usersWrite = node.getProperty("okm:authUsersWrite").getValues();
            for (int i = 0; i < usersWrite.length; ++i) {
                Byte previous = (Byte)users.get(usersWrite[i].getString());
                if (previous != null) {
                    users.put(usersWrite[i].getString(), new Byte((byte)(previous | 2)));
                    continue;
                }
                users.put(usersWrite[i].getString(), new Byte(2));
            }
            Value[] usersDelete = node.getProperty("okm:authUsersDelete").getValues();
            for (int i = 0; i < usersDelete.length; ++i) {
                Byte previous = (Byte)users.get(usersDelete[i].getString());
                if (previous != null) {
                    users.put(usersDelete[i].getString(), new Byte((byte)(previous | 4)));
                    continue;
                }
                users.put(usersDelete[i].getString(), new Byte(4));
            }
            Value[] usersSecurity = node.getProperty("okm:authUsersSecurity").getValues();
            for (int i = 0; i < usersSecurity.length; ++i) {
                Byte previous = users.get(usersSecurity[i].getString());
                if (previous != null) {
                    users.put(usersSecurity[i].getString(), new Byte((byte)(previous | 8)));
                    continue;
                }
                users.put(usersSecurity[i].getString(), new Byte(8));
            }
            return users;
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
    }

    @Override
    public Map<String, Byte> getGrantedRoles(String token, String nodePath) throws PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("getGrantedRoles({})", (Object)nodePath);
        HashMap<String, Byte> roles = new HashMap();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node node = session.getRootNode().getNode(nodePath.substring(1));
            roles = DirectAuthModule.getGrantedRoles(session, node);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getGrantedRoles: {}", roles);
        return roles;
    }

    public static Map<String, Byte> getGrantedRoles(Session session, Node node) throws PathNotFoundException, RepositoryException {
        try {
            Value[] rolesRead = node.getProperty("okm:authRolesRead").getValues();
            HashMap<String, Byte> roles = new HashMap<String, Byte>();
            for (int i = 0; i < rolesRead.length; ++i) {
                roles.put(rolesRead[i].getString(), new Byte(1));
            }
            Value[] rolesWrite = node.getProperty("okm:authRolesWrite").getValues();
            for (int i = 0; i < rolesWrite.length; ++i) {
                Byte previous = (Byte)roles.get(rolesWrite[i].getString());
                if (previous != null) {
                    roles.put(rolesWrite[i].getString(), new Byte((byte)(previous | 2)));
                    continue;
                }
                roles.put(rolesWrite[i].getString(), new Byte(2));
            }
            Value[] rolesDelete = node.getProperty("okm:authRolesDelete").getValues();
            for (int i = 0; i < rolesDelete.length; ++i) {
                Byte previous = (Byte)roles.get(rolesDelete[i].getString());
                if (previous != null) {
                    roles.put(rolesDelete[i].getString(), new Byte((byte)(previous | 4)));
                    continue;
                }
                roles.put(rolesDelete[i].getString(), new Byte(4));
            }
            Value[] rolesSecurity = node.getProperty("okm:authRolesSecurity").getValues();
            for (int i = 0; i < rolesSecurity.length; ++i) {
                Byte previous = (Byte)roles.get(rolesSecurity[i].getString());
                if (previous != null) {
                    roles.put(rolesSecurity[i].getString(), new Byte((byte)(previous | 8)));
                    continue;
                }
                roles.put(rolesSecurity[i].getString(), new Byte(8));
            }
            return roles;
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
    }

    public void view(String token) throws RepositoryException, DatabaseException {
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            String[] atributes = session.getAttributeNames();
            log.info("** ATRIBUTES **");
            for (int i = 0; i < atributes.length; ++i) {
                log.info(atributes[i] + " -> " + session.getAttribute(atributes[i]));
            }
            String[] lockTokens = session.getLockTokens();
            log.info("** LOCK TOKENS **");
            for (int i = 0; i < lockTokens.length; ++i) {
                log.info(lockTokens[i]);
            }
        }
        catch (LoginException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
    }

    @Override
    public List<String> getUsers(String token) throws PrincipalAdapterException {
        log.debug("getUsers()");
        List<String> list = null;
        try {
            PrincipalAdapter principalAdapter = BaseAuthModule.getPrincipalAdapter();
            list = principalAdapter.getUsers();
        }
        catch (PrincipalAdapterException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        log.debug("getUsers: {}", list);
        return list;
    }

    @Override
    public List<String> getRoles(String token) throws PrincipalAdapterException {
        log.debug("getRoles()");
        List<String> list = null;
        try {
            PrincipalAdapter principalAdapter = BaseAuthModule.getPrincipalAdapter();
            list = principalAdapter.getRoles();
        }
        catch (PrincipalAdapterException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        log.debug("getRoles: {}", list);
        return list;
    }

    @Override
    public List<String> getUsersByRole(String token, String role) throws PrincipalAdapterException {
        log.debug("getUsersByRole({})", (Object)role);
        List<String> list = null;
        try {
            PrincipalAdapter principalAdapter = BaseAuthModule.getPrincipalAdapter();
            list = principalAdapter.getUsersByRole(role);
        }
        catch (PrincipalAdapterException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        log.debug("getUsersByRole: {}", list);
        return list;
    }

    @Override
    public List<String> getRolesByUser(String token, String user) throws PrincipalAdapterException {
        log.debug("getRolesByUser({})", (Object)user);
        List<String> list = null;
        try {
            PrincipalAdapter principalAdapter = BaseAuthModule.getPrincipalAdapter();
            list = principalAdapter.getRolesByUser(user);
        }
        catch (PrincipalAdapterException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        log.debug("getRolesByUser: {}", list);
        return list;
    }

    @Override
    public String getMail(String token, String user) throws PrincipalAdapterException {
        log.debug("getMail({}, {})", (Object)token, (Object)user);
        String mail = null;
        try {
            PrincipalAdapter principalAdapter = BaseAuthModule.getPrincipalAdapter();
            mail = principalAdapter.getMail(user);
        }
        catch (PrincipalAdapterException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        log.debug("getMail: {}", (Object)mail);
        return mail;
    }

    @Override
    public String getName(String token, String user) throws PrincipalAdapterException {
        log.debug("getName({}, {})", (Object)token, (Object)user);
        String name = null;
        try {
            PrincipalAdapter principalAdapter = BaseAuthModule.getPrincipalAdapter();
            name = principalAdapter.getName(user);
        }
        catch (PrincipalAdapterException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        log.debug("getName: {}", (Object)name);
        return name;
    }
}

