/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.module.direct;

import com.openkm.core.AccessDeniedException;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.JcrSessionManager;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.dao.BookmarkDAO;
import com.openkm.dao.bean.Bookmark;
import com.openkm.jcr.JCRUtils;
import com.openkm.module.BookmarkModule;
import com.openkm.util.UserActivity;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectBookmarkModule
implements BookmarkModule {
    private static Logger log = LoggerFactory.getLogger(DirectBookmarkModule.class);

    @Override
    public Bookmark add(String token, String nodePath, String name) throws AccessDeniedException, PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("add({}, {}, {})", new Object[]{token, nodePath, name});
        Bookmark newBookmark = null;
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node rootNode = session.getRootNode();
            Node node = rootNode.getNode(nodePath.substring(1));
            name = JCRUtils.escape(name);
            newBookmark = new Bookmark();
            newBookmark.setUser(session.getUserID());
            newBookmark.setName(name);
            newBookmark.setPath(nodePath);
            newBookmark.setUuid(node.getUUID());
            newBookmark.setType(JCRUtils.getNodeType(node));
            BookmarkDAO.create(newBookmark);
            UserActivity.log(session.getUserID(), "BOOKMARK_ADD", name, node.getUUID() + ", " + nodePath);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("add: {}", (Object)newBookmark);
        return newBookmark;
    }

    @Override
    public Bookmark get(String token, int bmId) throws AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("get({}, {})", (Object)token, (Object)bmId);
        Bookmark bookmark = null;
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            bookmark = BookmarkDAO.findByPk(session, bmId);
            UserActivity.log(session.getUserID(), "BOOKMARK_GET", Integer.toString(bmId), bookmark.toString());
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("get: {}", (Object)bookmark);
        return bookmark;
    }

    @Override
    public void remove(String token, int bmId) throws AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("remove({}, {})", (Object)token, (Object)bmId);
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            BookmarkDAO.delete(bmId);
            UserActivity.log(session.getUserID(), "BOOKMARK_REMOVE", Integer.toString(bmId), null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("remove: void");
    }

    @Override
    public Bookmark rename(String token, int bmId, String newName) throws AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("rename({}, {}, {})", new Object[]{token, bmId, newName});
        Bookmark renamedBookmark = null;
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Bookmark bm = BookmarkDAO.findByPk(session, bmId);
            bm.setName(newName);
            BookmarkDAO.update(bm);
            renamedBookmark = BookmarkDAO.findByPk(session, bmId);
            UserActivity.log(session.getUserID(), "BOOKMARK_RENAME", Integer.toString(bmId), newName);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("rename: {}", (Object)renamedBookmark);
        return renamedBookmark;
    }

    @Override
    public List<Bookmark> getAll(String token) throws RepositoryException, DatabaseException {
        log.debug("getAll({})", (Object)token);
        ArrayList<Bookmark> ret = new ArrayList();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            ret = BookmarkDAO.findByUser(session, session.getUserID());
            UserActivity.log(session.getUserID(), "BOOKMARK_GET_ALL", null, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getAll: {}", ret);
        return ret;
    }
}

