/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.module.direct;

import com.openkm.bean.DashboardDocumentResult;
import com.openkm.bean.DashboardFolderResult;
import com.openkm.bean.DashboardMailResult;
import com.openkm.bean.Document;
import com.openkm.bean.Folder;
import com.openkm.bean.Mail;
import com.openkm.cache.UserItemsManager;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.JcrSessionManager;
import com.openkm.core.ParseException;
import com.openkm.core.RepositoryException;
import com.openkm.dao.ActivityDAO;
import com.openkm.dao.DashboardDAO;
import com.openkm.dao.HibernateUtil;
import com.openkm.dao.QueryParamsDAO;
import com.openkm.dao.bean.Activity;
import com.openkm.dao.bean.Dashboard;
import com.openkm.dao.bean.QueryParams;
import com.openkm.dao.bean.cache.UserItems;
import com.openkm.jcr.JCRUtils;
import com.openkm.module.DashboardModule;
import com.openkm.module.base.BaseDocumentModule;
import com.openkm.module.base.BaseFolderModule;
import com.openkm.module.base.BaseMailModule;
import com.openkm.module.direct.DirectSearchModule;
import com.openkm.util.UserActivity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectDashboardModule
implements DashboardModule {
    private static Logger log = LoggerFactory.getLogger(DirectDashboardModule.class);
    private static final int MAX_RESULTS = 20;

    @Override
    public List<DashboardDocumentResult> getUserLockedDocuments(String token) throws RepositoryException, DatabaseException {
        log.debug("getUserLockedDocuments({})", (Object)token);
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            List<DashboardDocumentResult> al = this.getUserLockedDocuments(session);
            log.debug("getUserLockedDocuments: {}", al);
            List<DashboardDocumentResult> list = al;
            return list;
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
    }

    public List<DashboardDocumentResult> getUserLockedDocuments(Session session) throws javax.jcr.RepositoryException, DatabaseException {
        log.debug("getUserLockedDocuments({})", (Object)session);
        String qs = "/jcr:root/okm:root//element(*, okm:document)[@jcr:lockOwner='" + session.getUserID() + "' and okm:content/@jcr:isCheckedOut=false()]";
        List<DashboardDocumentResult> al = this.executeQueryDocument(session, qs, "LOCK_DOCUMENT", Integer.MAX_VALUE);
        this.checkVisitedDocuments(session.getUserID(), "UserLockedDocuments", al);
        log.debug("getUserLockedDocuments: {}", al);
        return al;
    }

    @Override
    public List<DashboardDocumentResult> getUserCheckedOutDocuments(String token) throws RepositoryException, DatabaseException {
        log.debug("getUserCheckedOutDocuments({})", (Object)token);
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            List<DashboardDocumentResult> al = this.getUserCheckedOutDocuments(session);
            log.debug("getUserCheckedOutDocuments: {}", al);
            List<DashboardDocumentResult> list = al;
            return list;
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
    }

    public List<DashboardDocumentResult> getUserCheckedOutDocuments(Session session) throws javax.jcr.RepositoryException, DatabaseException {
        log.debug("getUserCheckedOutDocuments({})", (Object)session);
        String qs = "/jcr:root/okm:root//element(*, okm:document)[@jcr:lockOwner='" + session.getUserID() + "' and okm:content/@jcr:isCheckedOut=true()]";
        List<DashboardDocumentResult> al = this.executeQueryDocument(session, qs, "CHECKOUT_DOCUMENT", Integer.MAX_VALUE);
        this.checkVisitedDocuments(session.getUserID(), "UserCheckedOutDocuments", al);
        log.debug("getUserCheckedOutDocuments: {}", al);
        return al;
    }

    @Override
    public List<DashboardDocumentResult> getUserSubscribedDocuments(String token) throws RepositoryException {
        log.debug("getUserSubscribedDocuments({})", (Object)token);
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            List<DashboardDocumentResult> al = this.getUserSubscribedDocuments(session);
            log.debug("getUserSubscribedDocuments: {}", al);
            List<DashboardDocumentResult> list = al;
            return list;
        }
        catch (DatabaseException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
    }

    public List<DashboardDocumentResult> getUserSubscribedDocuments(Session session) throws javax.jcr.RepositoryException, DatabaseException {
        log.debug("getUserSubscribedDocuments({})", (Object)session);
        String qs = "/jcr:root/okm:root//element(*, mix:notification)[@jcr:primaryType='okm:document' and @okm:subscriptors='" + session.getUserID() + "']";
        List<DashboardDocumentResult> al = this.executeQueryDocument(session, qs, "SUBSCRIBE_USER", Integer.MAX_VALUE);
        this.checkVisitedDocuments(session.getUserID(), "UserSubscribedDocuments", al);
        log.debug("getUserSubscribedDocuments: {}", al);
        return al;
    }

    @Override
    public List<DashboardFolderResult> getUserSubscribedFolders(String token) throws RepositoryException {
        log.debug("getUserSubscribedFolders({})", (Object)token);
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            List<DashboardFolderResult> al = this.getUserSubscribedFolders(session);
            log.debug("getUserSubscribedFolders: {}", al);
            List<DashboardFolderResult> list = al;
            return list;
        }
        catch (DatabaseException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
    }

    public List<DashboardFolderResult> getUserSubscribedFolders(Session session) throws javax.jcr.RepositoryException, DatabaseException {
        log.debug("getUserSubscribedFolders({})", (Object)session);
        String qs = "/jcr:root/okm:root//element(*, mix:notification)[@jcr:primaryType='okm:folder' and @okm:subscriptors='" + session.getUserID() + "']";
        ArrayList<DashboardFolderResult> al = this.executeQueryFolder(session, qs, "SUBSCRIBE_USER", Integer.MAX_VALUE);
        this.checkVisitedFolders(session.getUserID(), "UserSubscribedFolders", al);
        log.debug("getUserSubscribedFolders: {}", al);
        return al;
    }

    private List<DashboardDocumentResult> executeQueryDocument(Session session, String qs, String action, int maxResults) throws javax.jcr.RepositoryException, DatabaseException {
        ArrayList<DashboardDocumentResult> al = new ArrayList<DashboardDocumentResult>();
        Workspace workspace = session.getWorkspace();
        QueryManager queryManager = workspace.getQueryManager();
        javax.jcr.query.Query query = queryManager.createQuery(qs, "xpath");
        QueryResult result = query.execute();
        int i = 0;
        NodeIterator nit = result.getNodes();
        while (nit.hasNext() && i++ < maxResults) {
            Node node = nit.nextNode();
            Document doc = BaseDocumentModule.getProperties(session, node);
            DashboardDocumentResult vo = new DashboardDocumentResult();
            vo.setDocument(doc);
            vo.setDate(ActivityDAO.getActivityDate(session.getUserID(), action, node.getUUID()));
            vo.setVisited(false);
            al.add(vo);
        }
        Collections.sort(al, new Comparator<DashboardDocumentResult>(){

            @Override
            public int compare(DashboardDocumentResult doc1, DashboardDocumentResult doc2) {
                return doc2.getDate().compareTo(doc1.getDate());
            }
        });
        return al;
    }

    private ArrayList<DashboardFolderResult> executeQueryFolder(Session session, String qs, String action, int maxResults) throws javax.jcr.RepositoryException, DatabaseException {
        ArrayList<DashboardFolderResult> al = new ArrayList<DashboardFolderResult>();
        Workspace workspace = session.getWorkspace();
        QueryManager queryManager = workspace.getQueryManager();
        javax.jcr.query.Query query = queryManager.createQuery(qs, "xpath");
        QueryResult result = query.execute();
        int i = 0;
        NodeIterator nit = result.getNodes();
        while (nit.hasNext() && i++ < maxResults) {
            Node node = nit.nextNode();
            Folder fld = BaseFolderModule.getProperties(session, node);
            DashboardFolderResult vo = new DashboardFolderResult();
            vo.setFolder(fld);
            vo.setDate(ActivityDAO.getActivityDate(session.getUserID(), action, node.getUUID()));
            vo.setVisited(false);
            al.add(vo);
        }
        Collections.sort(al, new Comparator<DashboardFolderResult>(){

            @Override
            public int compare(DashboardFolderResult fld1, DashboardFolderResult fld2) {
                return fld2.getDate().compareTo(fld1.getDate());
            }
        });
        return al;
    }

    @Override
    public List<DashboardDocumentResult> getUserLastUploadedDocuments(String token) throws RepositoryException {
        log.debug("getUserLastUploadedDocuments({})", (Object)token);
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            List<DashboardDocumentResult> al = this.getUserLastUploadedDocuments(session);
            log.debug("getUserLastUploadedDocuments: {}", al);
            List<DashboardDocumentResult> list = al;
            return list;
        }
        catch (DatabaseException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
    }

    public List<DashboardDocumentResult> getUserLastUploadedDocuments(Session session) throws javax.jcr.RepositoryException, DatabaseException {
        log.debug("getUserLastUploadedDocuments({})", (Object)session);
        String qs = "select a.item, a.date from Activity a where a.action='CREATE_DOCUMENT' and a.user= :user order by a.date desc";
        ArrayList<DashboardDocumentResult> al = this.getDocuments(session, qs);
        this.checkVisitedDocuments(session.getUserID(), "UserLastUploadedDocuments", al);
        log.debug("getUserLastUploadedDocuments: {}", al);
        return al;
    }

    @Override
    public List<DashboardDocumentResult> getUserLastModifiedDocuments(String token) throws RepositoryException {
        log.debug("getUserLastModifiedDocuments({})", (Object)token);
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            List<DashboardDocumentResult> al = this.getUserLastModifiedDocuments(session);
            log.debug("getUserLastModifiedDocuments: {}", al);
            List<DashboardDocumentResult> list = al;
            return list;
        }
        catch (DatabaseException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
    }

    public List<DashboardDocumentResult> getUserLastModifiedDocuments(Session session) throws javax.jcr.RepositoryException, DatabaseException {
        log.debug("getUserLastModifiedDocuments({})", (Object)session);
        String qs = "select distinct a.item, max(a.date) from Activity a where a.action='SET_DOCUMENT_CONTENT' and a.user= :user group by a.item order by max(a.date) desc";
        ArrayList<DashboardDocumentResult> al = this.getDocuments(session, qs);
        this.checkVisitedDocuments(session.getUserID(), "UserLastModifiedDocuments", al);
        log.debug("getUserLastModifiedDocuments: {}", al);
        return al;
    }

    @Override
    public List<DashboardDocumentResult> getUserLastDownloadedDocuments(String token) throws RepositoryException {
        log.debug("getUserLastDownloadedDocuments({})", (Object)token);
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            List<DashboardDocumentResult> al = this.getUserLastDownloadedDocuments(session);
            log.debug("getUserLastDownloadedDocuments: {}", al);
            List<DashboardDocumentResult> list = al;
            return list;
        }
        catch (DatabaseException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
    }

    public List<DashboardDocumentResult> getUserLastDownloadedDocuments(Session session) throws javax.jcr.RepositoryException, DatabaseException {
        log.debug("getUserLastDownloadedDocuments({})", (Object)session);
        String qs = "select distinct a.item, max(a.date) from Activity a where a.action='GET_DOCUMENT_CONTENT' and a.user= :user group by a.item order by max(a.date) desc";
        ArrayList<DashboardDocumentResult> al = this.getDocuments(session, qs);
        this.checkVisitedDocuments(session.getUserID(), "UserLastDownloadedDocuments", al);
        log.debug("getUserLastDownloadedDocuments: {}", al);
        return al;
    }

    @Override
    public List<DashboardMailResult> getUserLastImportedMails(String token) throws RepositoryException {
        log.debug("getUserLastImportedMails({})", (Object)token);
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            List<DashboardMailResult> al = this.getUserLastImportedMails(session);
            log.debug("getUserLastImportedMails: {}", al);
            List<DashboardMailResult> list = al;
            return list;
        }
        catch (DatabaseException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
    }

    public List<DashboardMailResult> getUserLastImportedMails(Session session) throws javax.jcr.RepositoryException, DatabaseException {
        log.debug("getUserLastImportedMails({})", (Object)session);
        String sq = "from Activity a where a.action='CREATE_MAIL' and a.user= :user order by a.date desc";
        ArrayList<DashboardMailResult> al = this.getMails(session, sq);
        this.checkVisitedMails(session.getUserID(), "UserLastImportedMails", al);
        log.debug("getUserLastImportedMails: {}", al);
        return al;
    }

    @Override
    public List<DashboardDocumentResult> getUserLastImportedMailAttachments(String token) throws RepositoryException {
        log.debug("getUserLastImportedMailAttachments({})", (Object)token);
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            List<DashboardDocumentResult> al = this.getUserLastImportedMailAttachments(session);
            log.debug("getUserLastImportedMailAttachments: {}", al);
            List<DashboardDocumentResult> list = al;
            return list;
        }
        catch (DatabaseException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
    }

    public List<DashboardDocumentResult> getUserLastImportedMailAttachments(Session session) throws javax.jcr.RepositoryException, DatabaseException {
        log.debug("getUserLastImportedMailAttachments({})", (Object)session);
        String qs = "select a.item, a.date from Activity a where a.action='CREATE_MAIL_ATTACHMENT' and a.user= :user order by a.date desc";
        ArrayList<DashboardDocumentResult> al = this.getDocuments(session, qs);
        this.checkVisitedDocuments(session.getUserID(), "UserLastImportedMailAttachments", al);
        log.debug("getUserLastImportedMailAttachments: {}", al);
        return al;
    }

    private ArrayList<DashboardDocumentResult> getDocuments(Session session, String qs) throws javax.jcr.RepositoryException, DatabaseException {
        log.debug("getDocuments({}, {})", (Object)session, (Object)qs);
        ArrayList<DashboardDocumentResult> al = new ArrayList<DashboardDocumentResult>();
        log.debug("getDocuments: {}", al);
        return al;
    }

    private ArrayList<DashboardDocumentResult> getDocumentsOld(Session session, String qs) throws javax.jcr.RepositoryException, DatabaseException {
        log.debug("getDocuments({}, {})", (Object)session, (Object)qs);
        ArrayList<DashboardDocumentResult> al = new ArrayList<DashboardDocumentResult>();
        org.hibernate.classic.Session hSession = null;
        try {
            hSession = HibernateUtil.getSessionFactory().openSession();
            Query q = hSession.createQuery(qs);
            q.setString("user", session.getUserID());
            q.setMaxResults(20);
            for (Object[] actData : q.list()) {
                String actItem = (String)actData[0];
                Calendar actDate = (Calendar)actData[1];
                try {
                    Node node = session.getNodeByUUID(actItem);
                    Document doc = BaseDocumentModule.getProperties(session, node);
                    DashboardDocumentResult vo = new DashboardDocumentResult();
                    vo.setDocument(doc);
                    vo.setDate(actDate);
                    vo.setVisited(false);
                    al.add(vo);
                }
                catch (ItemNotFoundException e) {}
            }
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)hSession);
        }
        log.debug("getDocuments: {}", al);
        return al;
    }

    private ArrayList<DashboardMailResult> getMails(Session session, String qs) throws javax.jcr.RepositoryException, DatabaseException {
        log.debug("getMails({}, {})", (Object)session, (Object)qs);
        ArrayList<DashboardMailResult> al = new ArrayList<DashboardMailResult>();
        org.hibernate.classic.Session hSession = null;
        try {
            hSession = HibernateUtil.getSessionFactory().openSession();
            Query q = hSession.createQuery(qs);
            q.setString("user", session.getUserID());
            q.setMaxResults(20);
            for (Activity act : q.list()) {
                try {
                    Node node = session.getNodeByUUID(act.getItem());
                    Mail mail = BaseMailModule.getProperties(session, node);
                    DashboardMailResult vo = new DashboardMailResult();
                    vo.setMail(mail);
                    vo.setDate(act.getDate());
                    vo.setVisited(false);
                    al.add(vo);
                }
                catch (ItemNotFoundException e) {}
            }
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)hSession);
        }
        log.debug("getMails: {}", al);
        return al;
    }

    @Override
    public long getUserDocumentsSize(String token) throws RepositoryException, DatabaseException {
        log.debug("getUserDocumentsSize({})", (Object)token);
        long size = 0L;
        size = Config.USER_ITEM_CACHE ? this.getUserDocumentsSizeCached(token) : this.getUserDocumentsSizeLive(token);
        log.debug("getUserDocumentsSize: {}", (Object)size);
        return size;
    }

    private long getUserDocumentsSizeLive(String token) throws RepositoryException, DatabaseException {
        log.debug("getUserDocumentsSizeLive({})", (Object)token);
        long size = 0L;
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            size = JCRUtils.calculateQuota(session);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getUserDocumentsSizeLive: {}", (Object)size);
        return size;
    }

    private long getUserDocumentsSizeCached(String token) throws RepositoryException, DatabaseException {
        log.debug("getUserDocumentsSizeCached({})", (Object)token);
        Session session = null;
        UserItems usrItems = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            usrItems = UserItemsManager.get(session.getUserID());
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getUserDocumentsSizeCached: {}", (Object)usrItems.getSize());
        return usrItems.getSize();
    }

    @Override
    public List<QueryParams> getUserSearchs(String token) throws RepositoryException, DatabaseException {
        log.debug("getUserSearchs({})", (Object)token);
        ArrayList<QueryParams> ret = new ArrayList<QueryParams>();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            List<QueryParams> qParams = QueryParamsDAO.findByUser(session.getUserID());
            for (QueryParams qp : qParams) {
                if (!qp.isDashboard()) continue;
                qp.setLastModifiedFrom(null);
                qp.setLastModifiedTo(null);
                ret.add(qp);
            }
            UserActivity.log(session.getUserID(), "GET_DASHBOARD_USER_SEARCHS", null, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (DatabaseException e) {
            throw e;
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getUserSearchs: {}", ret);
        return ret;
    }

    @Override
    public List<DashboardDocumentResult> find(String token, int qpId) throws IOException, ParseException, RepositoryException, DatabaseException {
        log.debug("find({}, {})", (Object)token, (Object)qpId);
        ArrayList<DashboardDocumentResult> al = new ArrayList();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            al = this.find(session, qpId);
        }
        catch (DatabaseException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("find: {}", al);
        return al;
    }

    public List<DashboardDocumentResult> find(Session session, int qpId) throws javax.jcr.RepositoryException, DatabaseException, ParseException, IOException {
        log.debug("find({}, {})", (Object)session, (Object)qpId);
        ArrayList<DashboardDocumentResult> al = new ArrayList();
        DirectSearchModule directSearch = new DirectSearchModule();
        QueryParams params = QueryParamsDAO.findByPk(qpId);
        log.debug("PARAMS: {}", (Object)params.toString());
        if (params.getLastModifiedTo() == null) {
            Calendar firstExecution = Calendar.getInstance();
            firstExecution.add(2, -1);
            params.setLastModifiedTo(firstExecution);
        }
        Calendar lastExecution = this.resetHours(params.getLastModifiedTo());
        Calendar actualDate = this.resetHours(Calendar.getInstance());
        log.debug("lastExecution -> {}", (Object)lastExecution.getTime());
        log.debug("actualDate -> {}", (Object)actualDate.getTime());
        if (lastExecution.before(actualDate)) {
            params.setLastModifiedFrom(params.getLastModifiedTo());
        }
        params.setLastModifiedTo(Calendar.getInstance());
        log.debug("PARAMS {}", (Object)params);
        String qs = directSearch.prepareStatement(params);
        log.debug("STATEMENT {}", (Object)qs);
        al = this.executeQueryDocument(session, qs, null, 20);
        QueryParamsDAO.update(params);
        this.checkVisitedDocuments(session.getUserID(), Integer.toString(params.getId()), al);
        log.debug("find: {}", al);
        return al;
    }

    private Calendar resetHours(Calendar cal) {
        Calendar tmp = (Calendar)cal.clone();
        tmp.set(11, 0);
        tmp.set(12, 0);
        tmp.set(13, 0);
        tmp.set(14, 0);
        return tmp;
    }

    @Override
    public List<DashboardDocumentResult> getLastWeekTopDownloadedDocuments(String token) throws RepositoryException {
        log.debug("getLastWeekTopDownloadedDocuments({})", (Object)token);
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            List<DashboardDocumentResult> al = this.getLastWeekTopDownloadedDocuments(session);
            log.debug("getLastWeekTopDownloadedDocuments: {}", al);
            List<DashboardDocumentResult> list = al;
            return list;
        }
        catch (DatabaseException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
    }

    public List<DashboardDocumentResult> getLastWeekTopDownloadedDocuments(Session session) throws javax.jcr.RepositoryException, DatabaseException {
        log.debug("getLastWeekTopDownloadedDocuments({})", (Object)session);
        String qs = "select a.item, max(a.date) from Activity a where a.action='GET_DOCUMENT_CONTENT' and a.date>:date group by a.item order by count(a.item) desc";
        Calendar cal = Calendar.getInstance();
        cal.add(3, -1);
        ArrayList<DashboardDocumentResult> al = this.getTopDocuments(session, qs, cal);
        this.checkVisitedDocuments(session.getUserID(), "LastWeekTopDownloadedDocuments", al);
        log.debug("getLastWeekTopDownloadedDocuments: {}", al);
        return al;
    }

    @Override
    public List<DashboardDocumentResult> getLastMonthTopDownloadedDocuments(String token) throws RepositoryException {
        log.debug("getLastMonthTopDownloadedDocuments({})", (Object)token);
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            List<DashboardDocumentResult> al = this.getLastMonthTopDownloadedDocuments(session);
            log.debug("getLastMonthTopDownloadedDocuments: {}", al);
            List<DashboardDocumentResult> list = al;
            return list;
        }
        catch (DatabaseException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
    }

    public List<DashboardDocumentResult> getLastMonthTopDownloadedDocuments(Session session) throws javax.jcr.RepositoryException, DatabaseException {
        log.debug("getLastMonthTopDownloadedDocuments({})", (Object)session);
        String qs = "select a.item, max(a.date) from Activity a where a.action='GET_DOCUMENT_CONTENT' and a.date>:date group by a.item order by count(a.item) desc";
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        ArrayList<DashboardDocumentResult> al = this.getTopDocuments(session, qs, cal);
        this.checkVisitedDocuments(session.getUserID(), "LastMonthTopDownloadedDocuments", al);
        log.debug("getLastMonthTopDownloadedDocuments: {}", al);
        return al;
    }

    @Override
    public List<DashboardDocumentResult> getLastWeekTopModifiedDocuments(String token) throws RepositoryException {
        log.debug("getLastWeekTopModifiedDocuments({})", (Object)token);
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            List<DashboardDocumentResult> al = this.getLastWeekTopModifiedDocuments(session);
            log.debug("getLastWeekTopModifiedDocuments: {}", al);
            List<DashboardDocumentResult> list = al;
            return list;
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
    }

    public List<DashboardDocumentResult> getLastWeekTopModifiedDocuments(Session session) throws javax.jcr.RepositoryException, DatabaseException {
        log.debug("getLastWeekTopModifiedDocuments({})", (Object)session);
        String qs = "select a.item, max(a.date) from Activity a where a.action='SET_DOCUMENT_CONTENT' and a.date>:date group by a.item order by count(a.item) desc";
        Calendar cal = Calendar.getInstance();
        cal.add(3, -1);
        ArrayList<DashboardDocumentResult> al = this.getTopDocuments(session, qs, cal);
        this.checkVisitedDocuments(session.getUserID(), "LastWeekTopModifiedDocuments", al);
        log.debug("getLastWeekTopModifiedDocuments: {}", al);
        return al;
    }

    @Override
    public List<DashboardDocumentResult> getLastMonthTopModifiedDocuments(String token) throws RepositoryException {
        log.debug("getLastMonthTopModifiedDocuments({})", (Object)token);
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            List<DashboardDocumentResult> al = this.getLastMonthTopModifiedDocuments(session);
            log.debug("getLastMonthTopModifiedDocuments: {}", al);
            List<DashboardDocumentResult> list = al;
            return list;
        }
        catch (DatabaseException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
    }

    public List<DashboardDocumentResult> getLastMonthTopModifiedDocuments(Session session) throws javax.jcr.RepositoryException, DatabaseException {
        log.debug("getLastMonthTopModifiedDocuments({})", (Object)session);
        String qs = "select a.item, max(a.date) from Activity a where a.action='SET_DOCUMENT_CONTENT' and a.date>:date group by a.item order by count(a.item) desc";
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        ArrayList<DashboardDocumentResult> al = this.getTopDocuments(session, qs, cal);
        this.checkVisitedDocuments(session.getUserID(), "LastMonthTopModifiedDocuments", al);
        log.debug("getLastMonthTopModifiedDocuments: {}", al);
        return al;
    }

    @Override
    public List<DashboardDocumentResult> getLastModifiedDocuments(String token) throws RepositoryException {
        log.debug("getLastModifiedDocuments({})", (Object)token);
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            List<DashboardDocumentResult> al = this.getLastModifiedDocuments(session);
            log.debug("getLastModifiedDocuments: {}", al);
            List<DashboardDocumentResult> list = al;
            return list;
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
    }

    public List<DashboardDocumentResult> getLastModifiedDocuments(Session session) throws javax.jcr.RepositoryException, DatabaseException {
        log.debug("getLastModifiedDocuments({})", (Object)session);
        String qs = "select distinct a.item, max(a.date) from Activity a where a.action='SET_DOCUMENT_CONTENT' group by a.item order by max(a.date) desc";
        ArrayList<DashboardDocumentResult> al = this.getTopDocuments(session, qs, null);
        this.checkVisitedDocuments(session.getUserID(), "LastModifiedDocuments", al);
        log.debug("getLastModifiedDocuments: {}", al);
        return al;
    }

    @Override
    public List<DashboardDocumentResult> getLastUploadedDocuments(String token) throws RepositoryException {
        log.debug("getLastUploadedDocuments({})", (Object)token);
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            List<DashboardDocumentResult> al = this.getLastUploadedDocuments(session);
            log.debug("getLastUploadedDocuments: {}", al);
            List<DashboardDocumentResult> list = al;
            return list;
        }
        catch (DatabaseException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
    }

    public List<DashboardDocumentResult> getLastUploadedDocuments(Session session) throws javax.jcr.RepositoryException, DatabaseException {
        log.debug("getLastUploadedDocuments({})", (Object)session);
        String qs = "select distinct a.item, max(a.date) from Activity a where a.action='CREATE_DOCUMENT' group by a.item order by max(a.date) desc";
        ArrayList<DashboardDocumentResult> al = this.getTopDocuments(session, qs, null);
        this.checkVisitedDocuments(session.getUserID(), "LastUploadedDocuments", al);
        log.debug("getLastUploadedDocuments: {}", al);
        return al;
    }

    private ArrayList<DashboardDocumentResult> getTopDocuments(Session session, String qs, Calendar date) throws javax.jcr.RepositoryException, DatabaseException {
        log.debug("getTopDocuments({}, {}, {})", new Object[]{session, qs, date != null ? date.getTime() : "null"});
        ArrayList<DashboardDocumentResult> al = new ArrayList<DashboardDocumentResult>();
        log.debug("getTopDocuments: {}", al);
        return al;
    }

    private ArrayList<DashboardDocumentResult> getTopDocumentsOld(Session session, String qs, Calendar date) throws javax.jcr.RepositoryException, DatabaseException {
        log.debug("getTopDocuments({}, {}, {})", new Object[]{session, qs, date != null ? date.getTime() : "null"});
        ArrayList<DashboardDocumentResult> al = new ArrayList<DashboardDocumentResult>();
        org.hibernate.classic.Session hSession = null;
        int cont = 0;
        try {
            hSession = HibernateUtil.getSessionFactory().openSession();
            Query q = hSession.createQuery(qs);
            if (date != null) {
                q.setCalendar("date", date);
            }
            Iterator it = q.list().iterator();
            while (it.hasNext() && cont < 20) {
                Object[] obj = (Object[])it.next();
                String resItem = (String)obj[0];
                Calendar resDate = (Calendar)obj[1];
                try {
                    Node node = session.getNodeByUUID(resItem);
                    if (node.getPath().startsWith("/okm:root")) {
                        Document doc = BaseDocumentModule.getProperties(session, node);
                        DashboardDocumentResult vo = new DashboardDocumentResult();
                        vo.setDocument(doc);
                        vo.setDate(resDate);
                        vo.setVisited(false);
                        al.add(vo);
                        if (al.size() >= 20) {
                            break;
                        }
                    }
                }
                catch (ItemNotFoundException e) {
                    // empty catch block
                }
                ++cont;
            }
            log.debug("getTopDocuments: {}", al);
            ArrayList<DashboardDocumentResult> arrayList = al;
            return arrayList;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)hSession);
        }
    }

    @Override
    public void visiteNode(String token, String source, String node, Calendar date) throws RepositoryException {
        log.debug("visiteNode({}, {}, {}, {})", new Object[]{token, source, node, date == null ? null : date.getTime()});
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Dashboard vo = new Dashboard();
            vo.setUser(session.getUserID());
            vo.setSource(source);
            vo.setNode(node);
            vo.setDate(date);
            DashboardDAO.createIfNew(vo);
        }
        catch (DatabaseException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("visiteNode: void");
    }

    private void checkVisitedDocuments(String user, String source, List<DashboardDocumentResult> docResult) throws DatabaseException {
        List<Dashboard> visitedNodes = DashboardDAO.findByUserSource(user, source);
        for (DashboardDocumentResult dsDocResult : docResult) {
            for (Dashboard visitedNode : visitedNodes) {
                if (!visitedNode.getNode().equals(dsDocResult.getDocument().getPath()) || !visitedNode.getDate().equals(dsDocResult.getDate())) continue;
                dsDocResult.setVisited(true);
            }
        }
        for (Dashboard visitedNode : visitedNodes) {
            boolean old = true;
            for (DashboardDocumentResult dsDocResult : docResult) {
                if (!visitedNode.getNode().equals(dsDocResult.getDocument().getPath()) || !visitedNode.getDate().equals(dsDocResult.getDate())) continue;
                old = false;
            }
            if (!old) continue;
            DashboardDAO.purgeOldVisitedNode(user, source, visitedNode.getNode(), visitedNode.getDate());
        }
    }

    private void checkVisitedFolders(String user, String source, List<DashboardFolderResult> fldResult) throws DatabaseException {
        List<Dashboard> visitedNodes = DashboardDAO.findByUserSource(user, source);
        for (DashboardFolderResult dsFldResult : fldResult) {
            for (Dashboard visitedNode : visitedNodes) {
                if (!visitedNode.getNode().equals(dsFldResult.getFolder().getPath()) || !visitedNode.getDate().equals(dsFldResult.getDate())) continue;
                dsFldResult.setVisited(true);
            }
        }
        for (Dashboard visitedNode : visitedNodes) {
            boolean old = true;
            for (DashboardFolderResult dsFldResult : fldResult) {
                if (!visitedNode.getNode().equals(dsFldResult.getFolder().getPath()) || !visitedNode.getDate().equals(dsFldResult.getDate())) continue;
                old = false;
            }
            if (!old) continue;
            DashboardDAO.purgeOldVisitedNode(user, source, visitedNode.getNode(), visitedNode.getDate());
        }
    }

    private void checkVisitedMails(String user, String source, List<DashboardMailResult> mailResult) throws DatabaseException {
        List<Dashboard> visitedNodes = DashboardDAO.findByUserSource(user, source);
        for (DashboardMailResult dsMailResult : mailResult) {
            for (Dashboard visitedNode : visitedNodes) {
                if (!visitedNode.getNode().equals(dsMailResult.getMail().getPath()) || !visitedNode.getDate().equals(dsMailResult.getDate())) continue;
                dsMailResult.setVisited(true);
            }
        }
        for (Dashboard visitedNode : visitedNodes) {
            boolean old = true;
            for (DashboardMailResult dsMailResult : mailResult) {
                if (!visitedNode.getNode().equals(dsMailResult.getMail().getPath()) || !visitedNode.getDate().equals(dsMailResult.getDate())) continue;
                old = false;
            }
            if (!old) continue;
            DashboardDAO.purgeOldVisitedNode(user, source, visitedNode.getNode(), visitedNode.getDate());
        }
    }
}

