/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.module.direct;

import com.openkm.bean.Document;
import com.openkm.bean.Document2;
import com.openkm.bean.DocumentHash;
import com.openkm.bean.Version;
import com.openkm.bean.Version2;
import com.openkm.bean.kea.MetadataDTO;
import com.openkm.bean.kea.Term;
import com.openkm.cache.UserItemsManager;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.FileSizeExceededException;
import com.openkm.core.JcrSessionManager;
import com.openkm.core.LockException;
import com.openkm.core.Ref;
import com.openkm.core.RepositoryException;
import com.openkm.core.UnsupportedMimeTypeException;
import com.openkm.core.UserQuotaExceededException;
import com.openkm.core.VirusDetectedException;
import com.openkm.core.VirusDetection;
import com.openkm.dao.LockTokenDAO;
import com.openkm.dao.MimeTypeDAO;
import com.openkm.extension.core.DocumentExtensionManager;
import com.openkm.extension.core.ExtensionException;
import com.openkm.jcr.JCRUtils;
import com.openkm.kea.RDFREpository;
import com.openkm.kea.metadata.MetadataExtractionException;
import com.openkm.kea.metadata.MetadataExtractor;
import com.openkm.module.DocumentModule;
import com.openkm.module.base.BaseDocumentModule;
import com.openkm.module.base.BaseNoteModule;
import com.openkm.module.base.BaseNotificationModule;
import com.openkm.module.base.BaseScriptingModule;
import com.openkm.module.direct.DirectAuthModule;
import com.openkm.principal.PrincipalAdapterException;
import com.openkm.util.FileUtils;
import com.openkm.util.FormatUtil;
import com.openkm.util.PrincipalUtils;
import com.openkm.util.SecureStore;
import com.openkm.util.Transaction;
import com.openkm.util.UserActivity;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.jackrabbit.api.JackrabbitValue;
import org.apache.jackrabbit.api.XASession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectDocumentModule
implements DocumentModule {
    private static Logger log = LoggerFactory.getLogger(DirectDocumentModule.class);

    @Override
    public Document create(String token, Document doc, InputStream is) throws UnsupportedMimeTypeException, FileSizeExceededException, UserQuotaExceededException, VirusDetectedException, com.openkm.core.ItemExistsException, com.openkm.core.PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, IOException, DatabaseException, ExtensionException {
        log.debug("create({}, {}, {})", new Object[]{token, doc, is});
        return this.create(token, doc, is, null);
    }

    public Document create(String token, Document doc, InputStream is, String userId) throws UnsupportedMimeTypeException, FileSizeExceededException, UserQuotaExceededException, VirusDetectedException, com.openkm.core.ItemExistsException, com.openkm.core.PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, IOException, DatabaseException, ExtensionException {
        log.debug("create({}, {}, {}, {})", new Object[]{token, doc, is, userId});
        Document newDocument = null;
        Node parentNode = null;
        Session session = null;
        int size = is.available();
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        if (Config.MAX_FILE_SIZE > 0L && (long)size > Config.MAX_FILE_SIZE) {
            log.error("Uploaded file size: {} ({}), Max file size: {} ({})", new Object[]{FormatUtil.formatSize(size), size, FormatUtil.formatSize(Config.MAX_FILE_SIZE), Config.MAX_FILE_SIZE});
            throw new FileSizeExceededException(Integer.toString(size));
        }
        String parent = JCRUtils.getParent(doc.getPath());
        String name = JCRUtils.getName(doc.getPath());
        int idx = name.lastIndexOf(46);
        String fileExtension = idx > 0 ? name.substring(idx) : ".tmp";
        File tmp = File.createTempFile("okm", fileExtension);
        try {
            Collection<String> keywords;
            int read;
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            name = JCRUtils.escape(name);
            doc.setPath(parent + "/" + name);
            parentNode = session.getRootNode().getNode(parent.substring(1));
            String mimeType = Config.mimeTypes.getContentType(name.toLowerCase());
            doc.setMimeType(mimeType);
            if (Config.RESTRICT_FILE_MIME && MimeTypeDAO.findByName(mimeType) == null) {
                throw new UnsupportedMimeTypeException(mimeType);
            }
            byte[] buff = new byte[4096];
            FileOutputStream fos = new FileOutputStream(tmp);
            while ((read = is.read(buff)) != -1) {
                fos.write(buff, 0, read);
            }
            fos.flush();
            fos.close();
            is.close();
            is = new FileInputStream(tmp);
            if (!Config.SYSTEM_ANTIVIR.equals("")) {
                VirusDetection.detect(tmp);
            }
            Collection<String> collection = keywords = doc.getKeywords() != null ? doc.getKeywords() : new ArrayList();
            if (!Config.KEA_MODEL_FILE.equals("")) {
                MetadataExtractor mdExtractor = new MetadataExtractor(Config.KEA_AUTOMATIC_KEYWORD_EXTRACTION_NUMBER);
                MetadataDTO mdDTO = mdExtractor.extract(tmp);
                ListIterator<Term> it = mdDTO.getSubjectsAsTerms().listIterator();
                while (it.hasNext()) {
                    Term term = it.next();
                    log.info("Term:" + term.getText());
                    if (Config.KEA_AUTOMATIC_KEYWORD_EXTRACTION_RESTRICTION) {
                        if (!RDFREpository.getInstance().getKeywords().contains(term.getText())) continue;
                        keywords.add(term.getText().replace(" ", "_"));
                        continue;
                    }
                    keywords.add(term.getText().replace(" ", "_"));
                }
            }
            Ref<Node> refParentNode = new Ref<Node>(parentNode);
            Ref<File> refTmp = new Ref<File>(tmp);
            Ref<Document> refDoc = new Ref<Document>(doc);
            DocumentExtensionManager.getInstance().preCreate(session, refParentNode, refTmp, refDoc);
            parentNode = refParentNode.get();
            name = JCRUtils.escape(JCRUtils.getName(refDoc.get().getPath()));
            mimeType = refDoc.get().getMimeType();
            keywords = refDoc.get().getKeywords();
            Node documentNode = BaseDocumentModule.create(session, parentNode, name, null, mimeType, keywords.toArray(new String[keywords.size()]), is);
            Ref<Node> refDocumentNode = new Ref<Node>(documentNode);
            DocumentExtensionManager.getInstance().postCreate(session, refParentNode, refDocumentNode);
            newDocument = BaseDocumentModule.getProperties(session, documentNode);
            if (userId == null) {
                BaseNotificationModule.checkSubscriptions(documentNode, session.getUserID(), "CREATE_DOCUMENT", null);
                BaseScriptingModule.checkScripts(session, parentNode, documentNode, "CREATE_DOCUMENT");
                UserActivity.log(session.getUserID(), "CREATE_DOCUMENT", documentNode.getUUID(), mimeType + ", " + size + ", " + doc.getPath());
            } else {
                BaseNotificationModule.checkSubscriptions(documentNode, userId, "CREATE_MAIL_ATTACHMENT", null);
                BaseScriptingModule.checkScripts(session, parentNode, documentNode, "CREATE_MAIL_ATTACHMENT");
                UserActivity.log(userId, "CREATE_MAIL_ATTACHMENT", documentNode.getUUID(), mimeType + ", " + size + ", " + doc.getPath());
            }
        }
        catch (ItemExistsException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(parentNode);
            throw new com.openkm.core.ItemExistsException(e.getMessage(), e);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(parentNode);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(parentNode);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(parentNode);
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(parentNode);
            throw e;
        }
        catch (MetadataExtractionException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(parentNode);
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (VirusDetectedException e) {
            JCRUtils.discardsPendingChanges(parentNode);
            throw e;
        }
        catch (DatabaseException e) {
            JCRUtils.discardsPendingChanges(parentNode);
            throw e;
        }
        catch (ExtensionException e) {
            JCRUtils.discardsPendingChanges(parentNode);
            throw e;
        }
        finally {
            org.apache.commons.io.FileUtils.deleteQuietly((File)tmp);
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("create: {}", (Object)newDocument);
        return newDocument;
    }

    @Override
    public void delete(String token, String docPath) throws com.openkm.core.AccessDeniedException, RepositoryException, com.openkm.core.PathNotFoundException, LockException, DatabaseException, ExtensionException {
        log.debug("delete({}, {})", (Object)token, (Object)docPath);
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            String name = JCRUtils.getName(docPath);
            Node documentNode = session.getRootNode().getNode(docPath.substring(1));
            Node parentNode = documentNode.getParent();
            Node userTrash = session.getRootNode().getNode("okm:trash/" + session.getUserID());
            Ref<Node> refDocumentNode = new Ref<Node>(documentNode);
            DocumentExtensionManager.getInstance().preDelete(session, refDocumentNode);
            if (documentNode.isLocked()) {
                throw new LockException("Can't delete a locked node");
            }
            String destPath = userTrash.getPath() + "/";
            String testName = name;
            String fileName = FileUtils.getFileName(name);
            String fileExtension = FileUtils.getFileExtension(name);
            int i = 1;
            while (session.itemExists(destPath + testName)) {
                testName = fileName + " (" + i + ")." + fileExtension;
                ++i;
            }
            session.move(documentNode.getPath(), destPath + testName);
            session.getRootNode().save();
            DocumentExtensionManager.getInstance().postDelete(session, docPath);
            BaseScriptingModule.checkScripts(session, parentNode, documentNode, "DELETE_DOCUMENT");
            UserActivity.log(session.getUserID(), "DELETE_DOCUMENT", documentNode.getUUID(), docPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (ExtensionException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new ExtensionException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("delete: void");
    }

    @Override
    public Document getProperties(String token, String docPath) throws RepositoryException, com.openkm.core.PathNotFoundException, DatabaseException {
        log.debug("getProperties({}, {})", (Object)token, (Object)docPath);
        Document doc = null;
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node documentNode = session.getRootNode().getNode(docPath.substring(1));
            doc = BaseDocumentModule.getProperties(session, documentNode);
            UserActivity.log(session.getUserID(), "GET_DOCUMENT_PROPERTIES", documentNode.getUUID(), doc.getKeywords().toString() + ", " + docPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getProperties: {}", (Object)doc);
        return doc;
    }

    @Override
    public InputStream getContent(String token, String docPath, boolean checkout) throws com.openkm.core.PathNotFoundException, RepositoryException, IOException, DatabaseException {
        InputStream is;
        log.debug("getContent({}, {}, {})", new Object[]{token, docPath, checkout});
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            is = BaseDocumentModule.getContent(session, docPath, checkout);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getContent: {}", (Object)is);
        return is;
    }

    @Override
    public InputStream getContentByVersion(String token, String docPath, String versionId) throws RepositoryException, com.openkm.core.PathNotFoundException, IOException, DatabaseException {
        InputStream is;
        log.debug("getContentByVersion({}, {}, {})", new Object[]{token, docPath, versionId});
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node documentNode = session.getRootNode().getNode(docPath.substring(1));
            Node contentNode = documentNode.getNode("okm:content");
            VersionHistory vh = contentNode.getVersionHistory();
            javax.jcr.version.Version ver = vh.getVersion(versionId);
            Node frozenNode = ver.getNode("jcr:frozenNode");
            is = frozenNode.getProperty("jcr:data").getStream();
            UserActivity.log(session.getUserID(), "GET_DOCUMENT_CONTENT_BY_VERSION", documentNode.getUUID(), versionId + ", " + is.available() + ", " + docPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getContentByVersion: {}", (Object)is);
        return is;
    }

    @Override
    public void setContent(String token, String docPath, InputStream is, Long length) throws FileSizeExceededException, UserQuotaExceededException, VirusDetectedException, com.openkm.core.VersionException, LockException, com.openkm.core.PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, IOException, DatabaseException, ExtensionException {
        log.info("setContent({}, {}, {}, {})", new Object[]{token, docPath, is, length});
        Node contentNode = null;
        Session session = null;
        int size = is.available();
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        if (Config.MAX_FILE_SIZE > 0L && (long)size > Config.MAX_FILE_SIZE) {
            log.error("Uploaded file size: {} ({}), Max file size: {} ({})", new Object[]{FormatUtil.formatSize(size), size, FormatUtil.formatSize(Config.MAX_FILE_SIZE), Config.MAX_FILE_SIZE});
            throw new FileSizeExceededException(Integer.toString(size));
        }
        File tmpJcr = File.createTempFile("okm", ".jcr");
        File tmpAvr = File.createTempFile("okm", ".avr");
        try {
            int read;
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            byte[] buff = new byte[4096];
            FileOutputStream fosJcr = new FileOutputStream(tmpJcr);
            FileOutputStream fosAvr = new FileOutputStream(tmpAvr);
            int write = 0;
            while ((read = is.read(buff)) != -1) {
                fosJcr.write(buff, 0, read);
                write += read;
                if (Config.SYSTEM_ANTIVIR.equals("")) continue;
                fosAvr.write(buff, 0, read);
            }
            fosJcr.flush();
            fosJcr.close();
            fosAvr.flush();
            fosAvr.close();
            is.close();
            is = new FileInputStream(tmpJcr);
            size = is.available();
            log.info("data size in setContent({}, {}, {}, {}, {})", new Object[]{token, docPath, size, write, tmpJcr.getName()});
            if (length != null && length > 0L && length != (long)size) {
                log.warn("Temporary JCR document size is different from required document size -> document won't be created/updated ({}, {}, {}, {})", new Object[]{token, docPath, size, tmpJcr.getName()});
                String msg = String.format("Required document size %1$s is different from stream size %2$s", length, size);
                throw new IOException(msg);
            }
            if (!Config.SYSTEM_ANTIVIR.equals("")) {
                VirusDetection.detect(tmpAvr);
            }
            Node documentNode = session.getRootNode().getNode(docPath.substring(1));
            JCRUtils.loadLockToken(session, documentNode.getUUID());
            Ref<Node> refDocumentNode = new Ref<Node>(documentNode);
            DocumentExtensionManager.getInstance().preSetContent(session, refDocumentNode);
            BaseDocumentModule.setContent(session, documentNode, is);
            DocumentExtensionManager.getInstance().postSetContent(session, refDocumentNode);
            BaseScriptingModule.checkScripts(session, documentNode, documentNode, "SET_DOCUMENT_CONTENT");
            UserActivity.log(session.getUserID(), "SET_DOCUMENT_CONTENT", documentNode.getUUID(), size + ", " + docPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(contentNode);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(contentNode);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (VersionException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(contentNode);
            throw new com.openkm.core.VersionException(e.getMessage(), e);
        }
        catch (javax.jcr.lock.LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(contentNode);
            throw new LockException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(contentNode);
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(contentNode);
            throw e;
        }
        catch (ExtensionException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(contentNode);
            throw new ExtensionException(e.getMessage(), e);
        }
        finally {
            org.apache.commons.io.FileUtils.deleteQuietly((File)tmpJcr);
            org.apache.commons.io.FileUtils.deleteQuietly((File)tmpAvr);
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.info("setContent: void");
    }

    @Override
    public List<Document> getChilds(String token, String fldPath) throws com.openkm.core.PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getChilds({}, {})", (Object)token, (Object)fldPath);
        ArrayList<Document> childs = new ArrayList<Document>();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node folderNode = session.getRootNode().getNode(fldPath.substring(1));
            NodeIterator ni = folderNode.getNodes();
            while (ni.hasNext()) {
                Node child = ni.nextNode();
                log.debug("Child: " + child.getPath() + ", " + child.getPrimaryNodeType().getName());
                if (!child.isNodeType("okm:document")) continue;
                childs.add(BaseDocumentModule.getProperties(session, child));
            }
            UserActivity.log(session.getUserID(), "GET_CHILD_DOCUMENTS", folderNode.getUUID(), fldPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getChilds: {}", childs);
        return childs;
    }

    @Override
    public List<Document2> getChilds2(String token, String fldPath) throws com.openkm.core.PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getChilds2({}, {})", (Object)token, (Object)fldPath);
        ArrayList<Document2> childs = new ArrayList<Document2>();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node folderNode = session.getRootNode().getNode(fldPath.substring(1));
            NodeIterator ni = folderNode.getNodes();
            while (ni.hasNext()) {
                Document2 document;
                Node child = ni.nextNode();
                if (!child.isNodeType("okm:document") || (document = DirectDocumentModule.node2Document2(session, child)) == null) continue;
                childs.add(document);
            }
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getChilds2: {}", childs);
        return childs;
    }

    @Override
    public Document rename(String token, String docPath, String newName) throws com.openkm.core.AccessDeniedException, RepositoryException, com.openkm.core.PathNotFoundException, com.openkm.core.ItemExistsException, DatabaseException, ExtensionException {
        log.debug("rename:({}, {}, {})", new Object[]{token, docPath, newName});
        Document renamedDocument = null;
        Session session = null;
        Node documentNode = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            String parent = JCRUtils.getParent(docPath);
            String name = JCRUtils.getName(docPath);
            newName = JCRUtils.escape(newName);
            if (newName != null && !newName.equals("") && !newName.equals(name)) {
                String newPath = parent + "/" + newName;
                Ref<Node> refDocumentNode = new Ref<Node>(documentNode);
                DocumentExtensionManager.getInstance().preRename(session, docPath, newPath, refDocumentNode);
                session.move(docPath, newPath);
                documentNode = session.getRootNode().getNode(newPath.substring(1));
                documentNode.setProperty("okm:name", newName);
                session.save();
                renamedDocument = BaseDocumentModule.getProperties(session, documentNode);
                DocumentExtensionManager.getInstance().postRename(session, docPath, newPath, refDocumentNode);
            } else {
                documentNode = session.getRootNode().getNode(docPath.substring(1));
                renamedDocument = BaseDocumentModule.getProperties(session, documentNode);
            }
            UserActivity.log(session.getUserID(), "RENAME_DOCUMENT", documentNode.getUUID(), newName + ", " + docPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (ItemExistsException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new com.openkm.core.ItemExistsException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (ExtensionException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new ExtensionException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("rename: {}", (Object)renamedDocument);
        return renamedDocument;
    }

    @Override
    public void setProperties(String token, Document doc) throws com.openkm.core.VersionException, LockException, com.openkm.core.PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("setProperties({}, {})", (Object)token, (Object)doc);
        Node documentNode = null;
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            documentNode = session.getRootNode().getNode(doc.getPath().substring(1));
            BaseNotificationModule.checkSubscriptions(documentNode, session.getUserID(), "SET_DOCUMENT_PROPERTIES", null);
            BaseScriptingModule.checkScripts(session, documentNode, documentNode, "SET_DOCUMENT_PROPERTIES");
            UserActivity.log(session.getUserID(), "SET_DOCUMENT_PROPERTIES", documentNode.getUUID(), doc.getPath());
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(documentNode);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(documentNode);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (VersionException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(documentNode);
            throw new com.openkm.core.VersionException(e.getMessage(), e);
        }
        catch (javax.jcr.lock.LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(documentNode);
            throw new LockException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(documentNode);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("setProperties: void");
    }

    @Override
    public void checkout(String token, String docPath, Boolean ... lock) throws com.openkm.core.AccessDeniedException, RepositoryException, com.openkm.core.PathNotFoundException, LockException, DatabaseException {
        log.debug("checkout({}, {}, {})", new Object[]{token, docPath, lock});
        Transaction t = null;
        XASession session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            boolean lockNode;
            session = token == null ? (XASession)JCRUtils.getSession() : (XASession)JcrSessionManager.getInstance().get(token);
            Lock lck = null;
            t = new Transaction(session);
            t.start();
            Node documentNode = session.getRootNode().getNode(docPath.substring(1));
            Node contentNode = documentNode.getNode("okm:content");
            boolean bl = lockNode = lock.length == 0 || lock[0] != false;
            if (lockNode) {
                lck = documentNode.lock(true, false);
                JCRUtils.addLockToken((Session)session, documentNode);
            } else {
                JCRUtils.loadLockToken((Session)session, documentNode.getUUID());
            }
            contentNode.checkout();
            t.end();
            t.commit();
            BaseScriptingModule.checkScripts((Session)session, documentNode, documentNode, "CHECKOUT_DOCUMENT");
            UserActivity.log(session.getUserID(), "CHECKOUT_DOCUMENT", documentNode.getUUID(), lck != null ? lck.getLockToken() : "n/a, " + docPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            t.rollback();
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.lock.LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            t.rollback();
            throw new LockException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            t.rollback();
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            t.rollback();
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            t.rollback();
            throw e;
        }
        finally {
            if (token == null) {
                JCRUtils.logout((Session)session);
            }
        }
        log.debug("checkout: void");
    }

    @Override
    public void cancelCheckout(String token, String docPath) throws com.openkm.core.AccessDeniedException, RepositoryException, com.openkm.core.PathNotFoundException, LockException, DatabaseException {
        log.debug("cancelCheckout({}, {})", (Object)token, (Object)docPath);
        Transaction t = null;
        XASession session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? (XASession)JCRUtils.getSession() : (XASession)JcrSessionManager.getInstance().get(token);
            t = new Transaction(session);
            t.start();
            Node documentNode = session.getRootNode().getNode(docPath.substring(1));
            JCRUtils.loadLockToken((Session)session, documentNode.getUUID());
            Node contentNode = documentNode.getNode("okm:content");
            contentNode.restore(contentNode.getBaseVersion(), true);
            documentNode.unlock();
            JCRUtils.removeLockToken((Session)session, documentNode);
            t.end();
            t.commit();
            BaseNotificationModule.checkSubscriptions(documentNode, session.getUserID(), "CANCEL_DOCUMENT_CHECKOUT", null);
            BaseScriptingModule.checkScripts((Session)session, documentNode, documentNode, "CANCEL_DOCUMENT_CHECKOUT");
            UserActivity.log(session.getUserID(), "CANCEL_DOCUMENT_CHECKOUT", documentNode.getUUID(), docPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            t.rollback();
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.lock.LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            t.rollback();
            throw new LockException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            t.rollback();
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            t.rollback();
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            t.rollback();
            throw e;
        }
        finally {
            if (token == null) {
                JCRUtils.logout((Session)session);
            }
        }
        log.debug("cancelCheckout: void");
    }

    @Override
    public void forceCancelCheckout(String token, String docPath) throws com.openkm.core.AccessDeniedException, RepositoryException, com.openkm.core.PathNotFoundException, LockException, DatabaseException, PrincipalAdapterException {
        log.debug("forceCancelCheckout({}, {})", (Object)token, (Object)docPath);
        Transaction t = null;
        XASession session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? (XASession)JCRUtils.getSession() : (XASession)JcrSessionManager.getInstance().get(token);
            if (!PrincipalUtils.hasRole(Config.DEFAULT_ADMIN_ROLE)) {
                throw new com.openkm.core.AccessDeniedException("Only administrator use allowed");
            }
            t = new Transaction(session);
            t.start();
            Node documentNode = session.getRootNode().getNode(docPath.substring(1));
            JCRUtils.loadLockToken((Session)session, documentNode.getUUID());
            Node contentNode = documentNode.getNode("okm:content");
            Lock lock = documentNode.getLock();
            if (lock.getLockOwner().equals(session.getUserID())) {
                contentNode.restore(contentNode.getBaseVersion(), true);
                documentNode.unlock();
                JCRUtils.removeLockToken((Session)session, documentNode);
            } else {
                String lt = JCRUtils.getLockToken(documentNode.getUUID());
                session.addLockToken(lt);
                contentNode.restore(contentNode.getBaseVersion(), true);
                documentNode.unlock();
                LockTokenDAO.remove(lock.getLockOwner(), lt);
            }
            t.end();
            t.commit();
            BaseNotificationModule.checkSubscriptions(documentNode, session.getUserID(), "FORCE_CANCEL_DOCUMENT_CHECKOUT", null);
            BaseScriptingModule.checkScripts((Session)session, documentNode, documentNode, "FORCE_CANCEL_DOCUMENT_CHECKOUT");
            UserActivity.log(session.getUserID(), "FORCE_CANCEL_DOCUMENT_CHECKOUT", documentNode.getUUID(), docPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            t.rollback();
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.lock.LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            t.rollback();
            throw new LockException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            t.rollback();
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            t.rollback();
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            t.rollback();
            throw e;
        }
        finally {
            if (token == null) {
                JCRUtils.logout((Session)session);
            }
        }
        log.debug("forceCancelCheckout: void");
    }

    @Override
    public boolean isCheckedOut(String token, String docPath) throws RepositoryException, com.openkm.core.PathNotFoundException, DatabaseException {
        log.debug("isCheckedOut({}, {})", (Object)token, (Object)docPath);
        boolean checkedOut = false;
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node documentNode = session.getRootNode().getNode(docPath.substring(1));
            Node contentNode = documentNode.getNode("okm:content");
            checkedOut = contentNode.isCheckedOut();
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("isCheckedOut: {}", (Object)checkedOut);
        return checkedOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Version checkin(String token, String docPath, String comment, Boolean ... unlock) throws com.openkm.core.AccessDeniedException, RepositoryException, com.openkm.core.PathNotFoundException, LockException, com.openkm.core.VersionException, DatabaseException, ExtensionException {
        log.debug("checkin({}, {}, {})", new Object[]{token, docPath, comment});
        Version version = new Version();
        Transaction t = null;
        XASession session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? (XASession)JCRUtils.getSession() : (XASession)JcrSessionManager.getInstance().get(token);
            t = new Transaction(session);
            t.start();
            Node documentNode = session.getRootNode().getNode(docPath.substring(1));
            Node contentNode = null;
            Node node = documentNode;
            synchronized (node) {
                boolean unlockNode;
                Ref<Node> refDocumentNode = new Ref<Node>(documentNode);
                DocumentExtensionManager.getInstance().preCheckin(session, refDocumentNode);
                contentNode = documentNode.getNode("okm:content");
                JCRUtils.loadLockToken((Session)session, documentNode.getUUID());
                contentNode.setProperty("okm:author", session.getUserID());
                contentNode.setProperty("okm:versionComment", comment);
                contentNode.save();
                javax.jcr.version.Version ver = contentNode.checkin();
                version.setAuthor(contentNode.getProperty("okm:author").getString());
                version.setSize(contentNode.getProperty("okm:size").getLong());
                version.setComment(contentNode.getProperty("okm:versionComment").getString());
                version.setName(ver.getName());
                version.setCreated(ver.getCreated());
                version.setActual(true);
                boolean bl = unlockNode = unlock.length == 0 || unlock[0] != false;
                if (unlockNode) {
                    documentNode.unlock();
                    JCRUtils.removeLockToken((Session)session, documentNode);
                }
                Ref<Version> refVersion = new Ref<Version>(version);
                DocumentExtensionManager.getInstance().postCheckin(session, refDocumentNode, refVersion);
                version = refVersion.get();
                String text = "New version " + ver.getName() + " by " + session.getUserID() + ": " + comment;
                Session sysSession = JcrSessionManager.getInstance().getSystemSession();
                BaseNoteModule.add(sysSession, documentNode, text);
            }
            t.end();
            t.commit();
            if (Config.USER_ITEM_CACHE) {
                long size = contentNode.getProperty("okm:size").getLong();
                UserItemsManager.incSize(session.getUserID(), size);
            }
            BaseDocumentModule.cleanPreviewCache(documentNode.getUUID());
            BaseNotificationModule.checkSubscriptions(documentNode, session.getUserID(), "CHECKIN_DOCUMENT", comment);
            BaseScriptingModule.checkScripts((Session)session, documentNode, documentNode, "CHECKIN_DOCUMENT");
            UserActivity.log(session.getUserID(), "CHECKIN_DOCUMENT", documentNode.getUUID(), comment + ", " + docPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            t.rollback();
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.lock.LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            t.rollback();
            throw new LockException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            t.rollback();
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (VersionException e) {
            log.error(e.getMessage(), (Throwable)e);
            t.rollback();
            throw new com.openkm.core.VersionException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            t.rollback();
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            t.rollback();
            throw e;
        }
        catch (ExtensionException e) {
            log.error(e.getMessage(), (Throwable)e);
            t.rollback();
            throw e;
        }
        finally {
            if (token == null) {
                JCRUtils.logout((Session)session);
            }
        }
        log.debug("checkin: {}", (Object)version);
        return version;
    }

    @Override
    public List<Version> getVersionHistory(String token, String docPath) throws com.openkm.core.PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getVersionHistory({}, {})", (Object)token, (Object)docPath);
        ArrayList<Version> history = new ArrayList<Version>();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node documentNode = session.getRootNode().getNode(docPath.substring(1));
            Node contentNode = documentNode.getNode("okm:content");
            VersionHistory vh = contentNode.getVersionHistory();
            String baseVersion = contentNode.getBaseVersion().getName();
            VersionIterator vi = vh.getAllVersions();
            while (vi.hasNext()) {
                javax.jcr.version.Version ver = vi.nextVersion();
                String versionName = ver.getName();
                if (versionName.equals("jcr:rootVersion")) continue;
                Version version = new Version();
                Node frozenNode = ver.getNode("jcr:frozenNode");
                version.setAuthor(frozenNode.getProperty("okm:author").getString());
                version.setSize(frozenNode.getProperty("okm:size").getLong());
                version.setComment(frozenNode.getProperty("okm:versionComment").getString());
                version.setName(ver.getName());
                version.setCreated(ver.getCreated());
                if (versionName.equals(baseVersion)) {
                    version.setActual(true);
                } else {
                    version.setActual(false);
                }
                history.add(version);
            }
            Collections.reverse(history);
            UserActivity.log(session.getUserID(), "GET_DOCUMENT_VERSION_HISTORY", documentNode.getUUID(), docPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getVersionHistory: {}", history);
        return history;
    }

    private static List<Version2> getVersionHistory2(Session session, Node documentNode) throws com.openkm.core.PathNotFoundException, RepositoryException, DatabaseException {
        try {
            Node contentNode = documentNode.getNode("okm:content");
            VersionHistory vh = contentNode.getVersionHistory();
            String baseVersion = contentNode.getBaseVersion().getName();
            ArrayList<Version2> history = new ArrayList<Version2>();
            VersionIterator vi = vh.getAllVersions();
            while (vi.hasNext()) {
                javax.jcr.version.Version ver = vi.nextVersion();
                String versionName = ver.getName();
                if (versionName.equals("jcr:rootVersion")) continue;
                Version2 version2 = new Version2();
                Node frozenNode = ver.getNode("jcr:frozenNode");
                version2.setAuthor(frozenNode.getProperty("okm:author").getString());
                version2.setSize(frozenNode.getProperty("okm:size").getLong());
                version2.setComment(frozenNode.getProperty("okm:versionComment").getString());
                version2.setName(ver.getName());
                version2.setCreated(ver.getCreated());
                String fileUuid = DirectDocumentModule.getFileUuid(frozenNode);
                version2.setFileUuid(fileUuid);
                if (versionName.equals(baseVersion)) {
                    version2.setActual(true);
                } else {
                    version2.setActual(false);
                }
                history.add(version2);
            }
            return history;
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
    }

    private static String getFileUuid(Node node) {
        try {
            JackrabbitValue jrv = (JackrabbitValue)node.getProperty("jcr:data").getValue();
            return jrv.getContentIdentity();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public com.openkm.bean.Lock lock(String token, String docPath) throws com.openkm.core.AccessDeniedException, RepositoryException, com.openkm.core.PathNotFoundException, LockException, DatabaseException {
        log.debug("lock({}, {})", new Object[]{token, docPath});
        Session session = null;
        com.openkm.bean.Lock lock = new com.openkm.bean.Lock();
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node documentNode = session.getRootNode().getNode(docPath.substring(1));
            Lock lck = documentNode.lock(true, false);
            lock.setOwner(lck.getLockOwner());
            lock.setNodePath(lck.getNode().getPath());
            lock.setToken(lck.getLockToken());
            JCRUtils.addLockToken(session, documentNode);
            BaseNotificationModule.checkSubscriptions(documentNode, session.getUserID(), "LOCK_DOCUMENT", null);
            BaseScriptingModule.checkScripts(session, documentNode, documentNode, "LOCK_DOCUMENT");
            UserActivity.log(session.getUserID(), "LOCK_DOCUMENT", documentNode.getUUID(), lck.getLockToken() + ", " + docPath);
        }
        catch (javax.jcr.lock.LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new LockException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("lock: {}", (Object)lock);
        return lock;
    }

    @Override
    public void unlock(String token, String docPath) throws com.openkm.core.AccessDeniedException, RepositoryException, com.openkm.core.PathNotFoundException, LockException, DatabaseException {
        log.debug("unlock({}, {})", new Object[]{token, docPath});
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node documentNode = session.getRootNode().getNode(docPath.substring(1));
            JCRUtils.loadLockToken(session, documentNode.getUUID());
            documentNode.unlock();
            JCRUtils.removeLockToken(session, documentNode);
            BaseNotificationModule.checkSubscriptions(documentNode, session.getUserID(), "UNLOCK_DOCUMENT", null);
            BaseScriptingModule.checkScripts(session, documentNode, documentNode, "UNLOCK_DOCUMENT");
            UserActivity.log(session.getUserID(), "UNLOCK_DOCUMENT", documentNode.getUUID(), docPath);
        }
        catch (javax.jcr.lock.LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new LockException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("unlock: void");
    }

    @Override
    public void forceUnlock(String token, String docPath) throws LockException, com.openkm.core.PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException, PrincipalAdapterException {
        log.debug("forceUnlock({}, {})", (Object)token, (Object)docPath);
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            if (!PrincipalUtils.hasRole(Config.DEFAULT_ADMIN_ROLE)) {
                throw new com.openkm.core.AccessDeniedException("Only administrator use allowed");
            }
            Node documentNode = session.getRootNode().getNode(docPath.substring(1));
            Lock lock = documentNode.getLock();
            if (lock.getLockOwner().equals(session.getUserID())) {
                JCRUtils.loadLockToken(session, documentNode.getUUID());
                documentNode.unlock();
                JCRUtils.removeLockToken(session, documentNode);
            } else {
                String lt = JCRUtils.getLockToken(documentNode.getUUID());
                session.addLockToken(lt);
                documentNode.unlock();
                LockTokenDAO.remove(lock.getLockOwner(), lt);
            }
            BaseNotificationModule.checkSubscriptions(documentNode, session.getUserID(), "FORCE_UNLOCK", null);
            BaseScriptingModule.checkScripts(session, documentNode, documentNode, "FORCE_UNLOCK_DOCUMENT");
            UserActivity.log(session.getUserID(), "FORCE_UNLOCK_DOCUMENT", documentNode.getUUID(), docPath);
        }
        catch (javax.jcr.lock.LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new LockException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("forceUnlock: void");
    }

    @Override
    public boolean isLocked(String token, String docPath) throws RepositoryException, com.openkm.core.PathNotFoundException, DatabaseException {
        boolean locked;
        log.debug("isLocked({}, {})", (Object)token, (Object)docPath);
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node documentNode = session.getRootNode().getNode(docPath.substring(1));
            locked = documentNode.isLocked();
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("isLocked: {}", (Object)locked);
        return locked;
    }

    @Override
    public com.openkm.bean.Lock getLock(String token, String docPath) throws RepositoryException, com.openkm.core.PathNotFoundException, LockException, DatabaseException {
        log.debug("getLock({}, {})", (Object)token, (Object)docPath);
        com.openkm.bean.Lock lock = new com.openkm.bean.Lock();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            lock = BaseDocumentModule.getLock(session, docPath);
        }
        catch (javax.jcr.lock.LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new LockException(e.getMessage(), e);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getLock: {}", (Object)lock);
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge(String token, String docPath) throws com.openkm.core.AccessDeniedException, RepositoryException, com.openkm.core.PathNotFoundException, DatabaseException, ExtensionException {
        log.debug("purge({}, {})", (Object)token, (Object)docPath);
        Node parentNode = null;
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node documentNode = session.getRootNode().getNode(docPath.substring(1));
            String docUuid = documentNode.getUUID();
            Ref<Node> refDocumentNode = new Ref<Node>(documentNode);
            DocumentExtensionManager.getInstance().prePurge(session, refDocumentNode);
            Node node = documentNode;
            synchronized (node) {
                parentNode = documentNode.getParent();
                BaseDocumentModule.purge(session, parentNode, documentNode);
            }
            DocumentExtensionManager.getInstance().postPurge(session, docPath);
            BaseScriptingModule.checkScripts(session, parentNode, documentNode, "PURGE_DOCUMENT");
            UserActivity.log(session.getUserID(), "PURGE_DOCUMENT", docUuid, docPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(parentNode);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(parentNode);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(parentNode);
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (ExtensionException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(parentNode);
            throw new ExtensionException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("purge: void");
    }

    @Override
    public void move(String token, String docPath, String dstPath) throws com.openkm.core.PathNotFoundException, com.openkm.core.ItemExistsException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException, ExtensionException {
        log.debug("move({}, {}, {})", new Object[]{token, docPath, dstPath});
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            String name = JCRUtils.getName(docPath);
            String dstNodePath = dstPath + "/" + name;
            Node rootNode = session.getRootNode();
            Node srcDocNode = rootNode.getNode(docPath.substring(1));
            Node dstFldPath = rootNode.getNode(dstPath.substring(1));
            Ref<Node> refSrcDocumentNode = new Ref<Node>(srcDocNode);
            Ref<Node> refDstFolderNode = new Ref<Node>(dstFldPath);
            DocumentExtensionManager.getInstance().preMove(session, refSrcDocumentNode, refDstFolderNode);
            docPath = refSrcDocumentNode.get().getPath();
            dstNodePath = refDstFolderNode.get().getPath() + "/" + name;
            session.move(docPath, dstNodePath);
            session.save();
            String srcDocParent = JCRUtils.getParent(docPath);
            Node srcFldNode = rootNode.getNode(srcDocParent.substring(1));
            Node dstDocNode = rootNode.getNode(dstNodePath.substring(1));
            Ref<Node> refSrcFolderNode = new Ref<Node>(srcFldNode);
            Ref<Node> refDstDocumentNode = new Ref<Node>(dstDocNode);
            DocumentExtensionManager.getInstance().postMove(session, docPath, refSrcFolderNode, refDstDocumentNode);
            BaseScriptingModule.checkScripts(session, dstDocNode.getParent(), dstDocNode, "MOVE_DOCUMENT");
            UserActivity.log(session.getUserID(), "MOVE_DOCUMENT", dstDocNode.getUUID(), docPath + ", " + dstPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (ItemExistsException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new com.openkm.core.ItemExistsException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("move: void");
    }

    @Override
    public void copy(String token, String docPath, String dstPath) throws com.openkm.core.ItemExistsException, com.openkm.core.PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, IOException, DatabaseException, UserQuotaExceededException, ExtensionException {
        log.debug("copy({}, {}, {})", new Object[]{token, docPath, dstPath});
        Node dstFolderNode = null;
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node rootNode = session.getRootNode();
            Node srcDocumentNode = rootNode.getNode(docPath.substring(1));
            dstFolderNode = rootNode.getNode(dstPath.substring(1));
            Ref<Node> refSrcNode = new Ref<Node>(srcDocumentNode);
            Ref<Node> refDstFolderNode = new Ref<Node>(dstFolderNode);
            DocumentExtensionManager.getInstance().preCopy(session, refSrcNode, refDstFolderNode);
            Node newDocument = BaseDocumentModule.copy(session, srcDocumentNode, dstFolderNode);
            BaseNotificationModule.checkSubscriptions(dstFolderNode, session.getUserID(), "COPY_DOCUMENT", null);
            Ref<Node> refNewDocument = new Ref<Node>(newDocument);
            DocumentExtensionManager.getInstance().postCopy(session, refSrcNode, refNewDocument, refDstFolderNode);
            UserActivity.log(session.getUserID(), "COPY_DOCUMENT", newDocument.getUUID(), docPath + ", " + dstPath);
        }
        catch (ItemExistsException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(dstFolderNode);
            throw new com.openkm.core.ItemExistsException(e.getMessage(), e);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(dstFolderNode);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(dstFolderNode);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(dstFolderNode);
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(dstFolderNode);
            throw e;
        }
        catch (ExtensionException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(dstFolderNode);
            throw e;
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("copy: void");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreVersion(String token, String docPath, String versionId) throws com.openkm.core.AccessDeniedException, RepositoryException, com.openkm.core.PathNotFoundException, DatabaseException, ExtensionException {
        log.debug("restoreVersion({}, {}, {})", new Object[]{token, docPath, versionId});
        Node contentNode = null;
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node documentNode = session.getRootNode().getNode(docPath.substring(1));
            Ref<Node> refDocumentNode = new Ref<Node>(documentNode);
            DocumentExtensionManager.getInstance().preRestoreVersion(session, refDocumentNode);
            Node node = documentNode;
            synchronized (node) {
                contentNode = documentNode.getNode("okm:content");
                contentNode.restore(versionId, true);
                contentNode.save();
            }
            BaseDocumentModule.cleanPreviewCache(documentNode.getUUID());
            DocumentExtensionManager.getInstance().postRestoreVersion(session, refDocumentNode);
            UserActivity.log(session.getUserID(), "RESTORE_DOCUMENT_VERSION", documentNode.getUUID(), versionId + ", " + docPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(contentNode);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(contentNode);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(contentNode);
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (ExtensionException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(contentNode);
            throw new ExtensionException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("restoreVersion: void");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeVersionHistory(String token, String docPath) throws com.openkm.core.AccessDeniedException, RepositoryException, com.openkm.core.PathNotFoundException, DatabaseException {
        log.debug("purgeVersionHistory({}, {})", (Object)token, (Object)docPath);
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            Node documentNode;
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node node = documentNode = session.getRootNode().getNode(docPath.substring(1));
            synchronized (node) {
                Node contentNode = documentNode.getNode("okm:content");
                VersionHistory vh = contentNode.getVersionHistory();
                String baseVersion = contentNode.getBaseVersion().getName();
                VersionIterator vi = vh.getAllVersions();
                while (vi.hasNext()) {
                    javax.jcr.version.Version ver = vi.nextVersion();
                    String versionName = ver.getName();
                    if (versionName.equals("jcr:rootVersion") || versionName.equals(baseVersion)) continue;
                    vh.removeVersion(versionName);
                }
            }
            UserActivity.log(session.getUserID(), "PURGE_DOCUMENT_VERSION_HISTORY", documentNode.getUUID(), docPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("purgeVersionHistory: void");
    }

    @Override
    public long getVersionHistorySize(String token, String docPath) throws RepositoryException, com.openkm.core.PathNotFoundException, DatabaseException {
        log.debug("getVersionHistorySize({}, {})", (Object)token, (Object)docPath);
        long ret = 0L;
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node documentNode = session.getRootNode().getNode(docPath.substring(1));
            Node contentNode = documentNode.getNode("okm:content");
            VersionHistory vh = contentNode.getVersionHistory();
            VersionIterator vi = vh.getAllVersions();
            while (vi.hasNext()) {
                javax.jcr.version.Version ver = vi.nextVersion();
                String versionName = ver.getName();
                if (versionName.equals("jcr:rootVersion")) continue;
                Node frozenNode = ver.getNode("jcr:frozenNode");
                ret += frozenNode.getProperty("okm:size").getLong();
            }
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getVersionHistorySize: {}", (Object)ret);
        return ret;
    }

    @Override
    public boolean isValid(String token, String docPath) throws com.openkm.core.PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("isValid({}, {})", (Object)token, (Object)docPath);
        boolean valid = false;
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node node = session.getRootNode().getNode(docPath.substring(1));
            if (node.isNodeType("okm:document")) {
                valid = true;
            }
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("isValid: {}", (Object)valid);
        return valid;
    }

    @Override
    public String getPath(String token, String uuid) throws com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("getPath({}, {})", (Object)token, (Object)uuid);
        String path = null;
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node node = session.getNodeByUUID(uuid);
            if (node.isNodeType("okm:document")) {
                path = node.getPath();
            }
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getPath: {}", (Object)path);
        return path;
    }

    @Override
    public List<Document2> getDocuments(String token, List<DocumentHash> docs, String fldPath) throws com.openkm.core.PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getDocuments({}, {}, {})", new Object[]{token, docs, fldPath});
        ArrayList<Document2> documents = new ArrayList<Document2>();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            HashMap<String, String> docsHash = new HashMap<String, String>();
            for (DocumentHash dh : docs) {
                docsHash.put(dh.getUuid(), dh.getHash());
            }
            Node folderNode = session.getRootNode().getNode(fldPath.substring(1));
            NodeIterator ni = folderNode.getNodes();
            while (ni.hasNext()) {
                String hash;
                Node child = ni.nextNode();
                if (!child.isNodeType("okm:document")) continue;
                String childUuid = child.getUUID();
                boolean getDocument = true;
                if (docsHash.containsKey(childUuid) && (hash = DirectDocumentModule.getHash(session, child)).equals(docsHash.get(childUuid))) {
                    getDocument = false;
                }
                if (!getDocument) continue;
                Document2 document = DirectDocumentModule.node2Document2(session, child);
                documents.add(document);
            }
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getDocuments: {}", documents);
        return documents;
    }

    @Override
    public List<Document2> getDocuments(String token, String docsHash, String fldPath) throws com.openkm.core.PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getDocuments({}, {}, {})", new Object[]{token, docsHash, fldPath});
        ArrayList<Document2> documents = new ArrayList<Document2>();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            StringBuffer sbHash = new StringBuffer();
            Node folderNode = session.getRootNode().getNode(fldPath.substring(1));
            NodeIterator ni = folderNode.getNodes();
            while (ni.hasNext()) {
                Document2 document;
                Node child = ni.nextNode();
                if (!child.isNodeType("okm:document") || (document = DirectDocumentModule.node2Document2(session, child)) == null) continue;
                sbHash.append(document.getHash());
                documents.add(document);
            }
            String hash = SecureStore.md5Encode(sbHash);
            if (hash.equals(docsHash)) {
                log.debug("Documents not changed");
                documents.clear();
            }
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getDocuments: {}", documents);
        return documents;
    }

    private static String getHash(Session session, Node node) throws javax.jcr.RepositoryException, RepositoryException, com.openkm.core.PathNotFoundException {
        if (!node.isNodeType("okm:document")) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Node contentNode = node.getNode("okm:content");
        sb.append(node.getPath());
        sb.append(",");
        if (node.isLocked()) {
            sb.append(node.getLock().getLockOwner());
            sb.append(",");
        }
        javax.jcr.version.Version ver = contentNode.getBaseVersion();
        sb.append(ver.getName());
        sb.append(",");
        Map<String, Byte> roles = DirectAuthModule.getGrantedRoles(session, node);
        PrincipalUtils.repairPermissions(roles);
        sb.append(((Object)roles).hashCode());
        sb.append(",");
        HashMap<String, Byte> users = DirectAuthModule.getGrantedUsers(session, node);
        sb.append(((Object)users).hashCode());
        try {
            return SecureStore.md5Encode(sb);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RepositoryException(e);
        }
    }

    private static Document2 node2Document2(Session session, Node node) throws javax.jcr.RepositoryException, PathNotFoundException, RepositoryException, com.openkm.core.PathNotFoundException, DatabaseException {
        Document document = BaseDocumentModule.getProperties2(session, node);
        Document2 document2 = new Document2();
        document2.setDocument(document);
        Map<String, Byte> roles = DirectAuthModule.getGrantedRoles(session, node);
        PrincipalUtils.repairPermissions(roles);
        HashMap<String, Byte> users = DirectAuthModule.getGrantedUsers(session, node);
        document2.setGrantedRoles(roles);
        document2.setGrantedUsers(users);
        List<Version2> versions = DirectDocumentModule.getVersionHistory2(session, node);
        document2.setVersions(versions);
        Node documentNode = node.getNode("okm:content");
        String fileUuid = DirectDocumentModule.getFileUuid(documentNode);
        document2.setFileUuid(fileUuid);
        String hash = document2.computeHash();
        document2.setHash(hash);
        return document2;
    }
}

