/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.module.direct;

import com.openkm.bean.ContentInfo;
import com.openkm.bean.Folder;
import com.openkm.bean.Folder2;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.JcrSessionManager;
import com.openkm.core.LockException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.Ref;
import com.openkm.core.RepositoryException;
import com.openkm.core.UserQuotaExceededException;
import com.openkm.extension.core.ExtensionException;
import com.openkm.extension.core.FolderExtensionManager;
import com.openkm.jcr.JCRUtils;
import com.openkm.module.FolderModule;
import com.openkm.module.base.BaseFolderModule;
import com.openkm.module.base.BaseScriptingModule;
import com.openkm.module.direct.DirectAuthModule;
import com.openkm.util.UserActivity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.apache.jackrabbit.api.XASession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectFolderModule
implements FolderModule {
    private static Logger log = LoggerFactory.getLogger(DirectFolderModule.class);

    @Override
    public Folder create(String token, Folder fld) throws com.openkm.core.AccessDeniedException, RepositoryException, PathNotFoundException, com.openkm.core.ItemExistsException, DatabaseException, ExtensionException {
        log.debug("create({}, {})", (Object)token, (Object)fld);
        Folder newFolder = null;
        Node parentNode = null;
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            String parent = JCRUtils.getParent(fld.getPath());
            String name = JCRUtils.getName(fld.getPath());
            parentNode = session.getRootNode().getNode(parent.substring(1));
            name = JCRUtils.escape(name);
            fld.setPath(parent + "/" + name);
            Ref<Node> refParentNode = new Ref<Node>(parentNode);
            Ref<Folder> refFld = new Ref<Folder>(fld);
            FolderExtensionManager.getInstance().preCreate(session, refParentNode, refFld);
            parentNode = refParentNode.get();
            name = JCRUtils.escape(JCRUtils.getName(refFld.get().getPath()));
            Node folderNode = BaseFolderModule.create(session, parentNode, name);
            Ref<Node> refFolderNode = new Ref<Node>(folderNode);
            FolderExtensionManager.getInstance().postCreate(session, refParentNode, refFolderNode);
            newFolder = BaseFolderModule.getProperties(session, folderNode);
            BaseScriptingModule.checkScripts(session, parentNode, folderNode, "CREATE_FOLDER");
            UserActivity.log(session.getUserID(), "CREATE_FOLDER", folderNode.getUUID(), fld.getPath());
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (ItemExistsException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(parentNode);
            throw new com.openkm.core.ItemExistsException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(parentNode);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(parentNode);
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (DatabaseException e) {
            JCRUtils.discardsPendingChanges(parentNode);
            throw e;
        }
        catch (ExtensionException e) {
            JCRUtils.discardsPendingChanges(parentNode);
            throw e;
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("create: {}", (Object)newFolder);
        return newFolder;
    }

    @Override
    public Folder getProperties(String token, String fldPath) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getProperties({}, {})", (Object)token, (Object)fldPath);
        Folder fld = null;
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node folderNode = session.getRootNode().getNode(fldPath.substring(1));
            fld = BaseFolderModule.getProperties(session, folderNode);
            UserActivity.log(session.getUserID(), "GET_FOLDER_PROPERTIES", folderNode.getUUID(), fldPath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("get: {}", (Object)fld);
        return fld;
    }

    @Override
    public void delete(String token, String fldPath) throws com.openkm.core.AccessDeniedException, RepositoryException, PathNotFoundException, LockException, DatabaseException {
        log.debug("delete({}, {})", (Object)token, (Object)fldPath);
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            String name = JCRUtils.getName(fldPath);
            Node folderNode = session.getRootNode().getNode(fldPath.substring(1));
            Node parentNode = folderNode.getParent();
            Node userTrash = session.getRootNode().getNode("okm:trash/" + session.getUserID());
            if (BaseFolderModule.hasLockedNodes(folderNode)) {
                throw new LockException("Can't delete a folder with child locked nodes");
            }
            if (!BaseFolderModule.hasWriteAccess(folderNode)) {
                throw new com.openkm.core.AccessDeniedException("Can't delete a folder with readonly nodes");
            }
            if ("okm:root".equals(name) || "okm:categories".equals(name) || "okm:thesaurus".equals(name) || "okm:templates".equals(name) || "okm:personal".equals(name) || "okm:mail".equals(name) || "okm:trash".equals(name)) {
                throw new com.openkm.core.AccessDeniedException("Can't delete a required node");
            }
            String destPath = userTrash.getPath() + "/";
            String testName = name;
            int i = 1;
            while (session.itemExists(destPath + testName)) {
                testName = name + " (" + i + ")";
                ++i;
            }
            Ref<Node> refFolderNode = new Ref<Node>(folderNode);
            FolderExtensionManager.getInstance().preDelete(session, fldPath, refFolderNode);
            session.move(folderNode.getPath(), destPath + testName);
            session.getRootNode().save();
            FolderExtensionManager.getInstance().postDelete(session, fldPath, refFolderNode);
            BaseScriptingModule.checkScripts(session, parentNode, folderNode, "DELETE_FOLDER");
            UserActivity.log(session.getUserID(), "DELETE_FOLDER", folderNode.getUUID(), fldPath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("delete: void");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge(String token, String fldPath) throws com.openkm.core.AccessDeniedException, RepositoryException, PathNotFoundException, DatabaseException {
        log.debug("purge({}, {})", (Object)token, (Object)fldPath);
        Node parentNode = null;
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node folderNode = session.getRootNode().getNode(fldPath.substring(1));
            String fldUuid = folderNode.getUUID();
            Ref<Node> refFolderNode = new Ref<Node>(folderNode);
            FolderExtensionManager.getInstance().prePurge(session, fldPath, refFolderNode);
            Node node = folderNode;
            synchronized (node) {
                parentNode = folderNode.getParent();
                BaseFolderModule.purge(session, folderNode);
                parentNode.save();
            }
            FolderExtensionManager.getInstance().postPurge(session, fldPath);
            BaseScriptingModule.checkScripts(session, parentNode, folderNode, "PURGE_FOLDER");
            UserActivity.log(session.getUserID(), "PURGE_FOLDER", fldUuid, fldPath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(parentNode);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(parentNode);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(parentNode);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("purge: void");
    }

    @Override
    public Folder rename(String token, String fldPath, String newName) throws com.openkm.core.AccessDeniedException, RepositoryException, PathNotFoundException, com.openkm.core.ItemExistsException, DatabaseException {
        log.debug("rename({}, {}, {})", new Object[]{token, fldPath, newName});
        Folder renamedFolder = null;
        Session session = null;
        Node folderNode = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            String parent = JCRUtils.getParent(fldPath);
            String name = JCRUtils.getName(fldPath);
            newName = JCRUtils.escape(newName);
            if (newName != null && !newName.equals("") && !newName.equals(name)) {
                String newPath = parent + "/" + newName;
                Ref<Node> refFolderNode = new Ref<Node>(folderNode);
                FolderExtensionManager.getInstance().preRename(session, fldPath, newPath, refFolderNode);
                session.move(fldPath, newPath);
                folderNode = session.getRootNode().getNode(newPath.substring(1));
                folderNode.setProperty("okm:name", newName);
                session.save();
                renamedFolder = BaseFolderModule.getProperties(session, folderNode);
                refFolderNode = new Ref<Node>(folderNode);
                FolderExtensionManager.getInstance().postRename(session, fldPath, newPath, refFolderNode);
            } else {
                folderNode = session.getRootNode().getNode(fldPath.substring(1));
                renamedFolder = BaseFolderModule.getProperties(session, folderNode);
            }
            UserActivity.log(session.getUserID(), "RENAME_FOLDER", folderNode.getUUID(), newName + ", " + fldPath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (ItemExistsException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new com.openkm.core.ItemExistsException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("rename: {}", (Object)renamedFolder);
        return renamedFolder;
    }

    @Override
    public void move(String token, String fldPath, String dstPath) throws com.openkm.core.AccessDeniedException, RepositoryException, PathNotFoundException, com.openkm.core.ItemExistsException, DatabaseException {
        log.debug("move({}, {}, {})", new Object[]{token, fldPath, dstPath});
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            String name = JCRUtils.getName(fldPath);
            String dstNodePath = dstPath + "/" + name;
            FolderExtensionManager.getInstance().preMove(session, fldPath, dstNodePath);
            session.move(fldPath, dstNodePath);
            session.save();
            Node dstFldNode = session.getRootNode().getNode(dstNodePath.substring(1));
            Ref<Node> refDstFldNode = new Ref<Node>(dstFldNode);
            FolderExtensionManager.getInstance().postMove(session, fldPath, dstNodePath, refDstFldNode);
            BaseScriptingModule.checkScripts(session, dstFldNode.getParent(), dstFldNode, "MOVE_FOLDER");
            UserActivity.log(session.getUserID(), "MOVE_FOLDER", dstFldNode.getUUID(), fldPath + ", " + dstPath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (ItemExistsException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new com.openkm.core.ItemExistsException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("move: void");
    }

    @Override
    public void copy(String token, String fldPath, String dstPath) throws com.openkm.core.AccessDeniedException, RepositoryException, PathNotFoundException, com.openkm.core.ItemExistsException, IOException, DatabaseException, UserQuotaExceededException {
        log.debug("copy({}, {}, {})", new Object[]{token, fldPath, dstPath});
        XASession session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? (XASession)JCRUtils.getSession() : (XASession)JcrSessionManager.getInstance().get(token);
            String name = JCRUtils.getName(fldPath);
            Node srcFolderNode = session.getRootNode().getNode(fldPath.substring(1));
            Node dstFolderNode = session.getRootNode().getNode(dstPath.substring(1));
            Ref<Node> refSrcFolderNode = new Ref<Node>(srcFolderNode);
            Ref<Node> refDstFolderNode = new Ref<Node>(dstFolderNode);
            FolderExtensionManager.getInstance().preCopy(session, refSrcFolderNode, refDstFolderNode);
            Node newFolder = BaseFolderModule.create((Session)session, dstFolderNode, name);
            dstFolderNode.save();
            BaseFolderModule.copy((Session)session, srcFolderNode, newFolder);
            Ref<Node> refNewFolderNode = new Ref<Node>(newFolder);
            FolderExtensionManager.getInstance().postCopy(session, refSrcFolderNode, refNewFolderNode);
            UserActivity.log(session.getUserID(), "COPY_FOLDER", dstFolderNode.getUUID(), fldPath + ", " + dstPath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (ItemExistsException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.ItemExistsException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (token == null) {
                JCRUtils.logout((Session)session);
            }
        }
        log.debug("copy: void");
    }

    @Override
    public List<Folder> getChilds(String token, String fldPath) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("findChilds({}, {})", (Object)token, (Object)fldPath);
        ArrayList<Folder> childs = new ArrayList<Folder>();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node folderNode = session.getRootNode().getNode(fldPath.substring(1));
            NodeIterator ni = folderNode.getNodes();
            while (ni.hasNext()) {
                Node child = ni.nextNode();
                if (!child.isNodeType("okm:folder")) continue;
                childs.add(BaseFolderModule.getProperties(session, child));
            }
            UserActivity.log(session.getUserID(), "GET_CHILD_FOLDERS", folderNode.getUUID(), fldPath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("findChilds: {}", childs);
        return childs;
    }

    @Override
    public List<Folder2> getChilds2(String token, String fldPath) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("findChilds2({}, {})", (Object)token, (Object)fldPath);
        ArrayList<Folder2> childs = new ArrayList<Folder2>();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node folderNode = session.getRootNode().getNode(fldPath.substring(1));
            NodeIterator ni = folderNode.getNodes();
            while (ni.hasNext()) {
                Node child = ni.nextNode();
                if (!child.isNodeType("okm:folder")) continue;
                Folder folder = BaseFolderModule.getProperties(session, child);
                Folder2 folder2 = new Folder2();
                folder2.setFolder(folder);
                Map<String, Byte> roles = DirectAuthModule.getGrantedRoles(session, folderNode);
                HashMap<String, Byte> users = DirectAuthModule.getGrantedUsers(session, folderNode);
                folder2.setGrantedRoles(roles);
                folder2.setGrantedUsers(users);
                childs.add(folder2);
            }
            UserActivity.log(session.getUserID(), "GET_CHILD_FOLDERS_2", folderNode.getUUID(), fldPath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("findChilds2: {}", childs);
        return childs;
    }

    @Override
    public ContentInfo getContentInfo(String token, String fldPath) throws com.openkm.core.AccessDeniedException, RepositoryException, PathNotFoundException, DatabaseException {
        log.debug("getContentInfo({}, {})", (Object)token, (Object)fldPath);
        ContentInfo contentInfo = new ContentInfo();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node folderNode = session.getRootNode().getNode(fldPath.substring(1));
            contentInfo = BaseFolderModule.getContentInfo(folderNode);
            UserActivity.log(session.getUserID(), "GET_FOLDER_CONTENT_INFO", folderNode.getUUID(), contentInfo.toString() + ", " + fldPath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getContentInfo: {}", (Object)contentInfo);
        return contentInfo;
    }

    @Override
    public boolean isValid(String token, String fldPath) throws PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("isValid({}, {})", (Object)token, (Object)fldPath);
        boolean valid = false;
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node node = session.getRootNode().getNode(fldPath.substring(1));
            if (node.isNodeType("okm:folder")) {
                valid = true;
            }
        }
        catch (javax.jcr.PathNotFoundException e) {
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("isValid: {}", (Object)valid);
        return valid;
    }

    @Override
    public String getPath(String token, String uuid) throws com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("getPath({}, {})", (Object)token, (Object)uuid);
        String path = null;
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node node = session.getNodeByUUID(uuid);
            if (node.isNodeType("okm:folder")) {
                path = node.getPath();
            }
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getPath: {}", (Object)path);
        return path;
    }
}

