/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.module.direct;

import com.openkm.bean.Mail;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.JcrSessionManager;
import com.openkm.core.LockException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.core.UserQuotaExceededException;
import com.openkm.core.VirusDetectedException;
import com.openkm.jcr.JCRUtils;
import com.openkm.module.MailModule;
import com.openkm.module.base.BaseMailModule;
import com.openkm.module.base.BaseNotificationModule;
import com.openkm.module.base.BaseScriptingModule;
import com.openkm.util.Transaction;
import com.openkm.util.UserActivity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.apache.jackrabbit.api.XASession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectMailModule
implements MailModule {
    private static Logger log = LoggerFactory.getLogger(DirectMailModule.class);

    @Override
    public Mail create(String token, Mail mail) throws com.openkm.core.AccessDeniedException, RepositoryException, PathNotFoundException, com.openkm.core.ItemExistsException, VirusDetectedException, DatabaseException, UserQuotaExceededException {
        log.debug("create({}, {})", (Object)token, (Object)mail);
        return this.create(token, mail, null);
    }

    public Mail create(String token, Mail mail, String userId) throws com.openkm.core.AccessDeniedException, RepositoryException, PathNotFoundException, com.openkm.core.ItemExistsException, VirusDetectedException, DatabaseException, UserQuotaExceededException {
        log.debug("create({}, {}, {})", new Object[]{token, mail, userId});
        Mail newMail = null;
        Transaction t = null;
        XASession session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? (XASession)JCRUtils.getSession() : (XASession)JcrSessionManager.getInstance().get(token);
            String parent = JCRUtils.getParent(mail.getPath());
            String name = JCRUtils.getName(mail.getPath());
            Node parentNode = session.getRootNode().getNode(parent.substring(1));
            name = JCRUtils.escape(name);
            mail.setPath(parent + "/" + name);
            t = new Transaction(session);
            t.start();
            Node mailNode = BaseMailModule.create((Session)session, parentNode, name, mail.getSize(), mail.getFrom(), mail.getReply(), mail.getTo(), mail.getCc(), mail.getBcc(), mail.getSentDate(), mail.getReceivedDate(), mail.getSubject(), mail.getContent(), mail.getMimeType());
            newMail = BaseMailModule.getProperties((Session)session, mailNode);
            t.end();
            t.commit();
            if (userId == null) {
                userId = session.getUserID();
            }
            BaseNotificationModule.checkSubscriptions(mailNode, userId, "CREATE_MAIL", null);
            BaseScriptingModule.checkScripts((Session)session, parentNode, mailNode, "CREATE_MAIL");
            UserActivity.log(userId, "CREATE_MAIL", mailNode.getUUID(), mail.getPath());
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (ItemExistsException e) {
            log.warn(e.getMessage(), (Throwable)e);
            t.rollback();
            throw new com.openkm.core.ItemExistsException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            t.rollback();
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            t.rollback();
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            t.rollback();
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout((Session)session);
            }
        }
        log.debug("create: {}", (Object)newMail);
        return newMail;
    }

    @Override
    public Mail getProperties(String token, String mailPath) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getProperties({}, {})", (Object)token, (Object)mailPath);
        Mail mail = null;
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node mailNode = session.getRootNode().getNode(mailPath.substring(1));
            mail = BaseMailModule.getProperties(session, mailNode);
            UserActivity.log(session.getUserID(), "GET_MAIL_PROPERTIES", mailNode.getUUID(), mailPath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("get: {}", (Object)mail);
        return mail;
    }

    @Override
    public void delete(String token, String mailPath) throws com.openkm.core.AccessDeniedException, RepositoryException, PathNotFoundException, LockException, DatabaseException {
        log.debug("delete({}, {})", (Object)token, (Object)mailPath);
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            String name = JCRUtils.getName(mailPath);
            Node mailNode = session.getRootNode().getNode(mailPath.substring(1));
            Node parentNode = mailNode.getParent();
            Node userTrash = session.getRootNode().getNode("okm:trash/" + session.getUserID());
            String destPath = userTrash.getPath() + "/";
            String testName = name;
            int i = 1;
            while (session.itemExists(destPath + testName)) {
                testName = name + " (" + i + ")";
                ++i;
            }
            session.move(mailNode.getPath(), destPath + testName);
            session.getRootNode().save();
            BaseScriptingModule.checkScripts(session, parentNode, mailNode, "DELETE_MAIL");
            UserActivity.log(session.getUserID(), "DELETE_MAIL", mailNode.getUUID(), mailPath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("delete: void");
    }

    @Override
    public void purge(String token, String mailPath) throws com.openkm.core.AccessDeniedException, RepositoryException, PathNotFoundException, DatabaseException {
        log.debug("purge({}, {})", (Object)token, (Object)mailPath);
        Node parentNode = null;
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node mailNode = session.getRootNode().getNode(mailPath.substring(1));
            String mailUuid = mailNode.getUUID();
            parentNode = mailNode.getParent();
            mailNode.remove();
            parentNode.save();
            BaseScriptingModule.checkScripts(session, parentNode, mailNode, "PURGE_MAIL");
            UserActivity.log(session.getUserID(), "PURGE_MAIL", mailUuid, mailPath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(parentNode);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(parentNode);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(parentNode);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("purge: void");
    }

    @Override
    public Mail rename(String token, String mailPath, String newName) throws com.openkm.core.AccessDeniedException, RepositoryException, PathNotFoundException, com.openkm.core.ItemExistsException, DatabaseException {
        log.debug("rename({}, {}, {})", new Object[]{token, mailPath, newName});
        Mail renamedMail = null;
        Session session = null;
        Node mailNode = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            String parent = JCRUtils.getParent(mailPath);
            String name = JCRUtils.getName(mailPath);
            newName = JCRUtils.escape(newName);
            if (newName != null && !newName.equals("") && !newName.equals(name)) {
                String newPath = parent + "/" + newName;
                session.move(mailPath, newPath);
                mailNode = session.getRootNode().getNode(newPath.substring(1));
                mailNode.setProperty("okm:subject", newName);
                session.save();
                renamedMail = BaseMailModule.getProperties(session, mailNode);
            } else {
                mailNode = session.getRootNode().getNode(mailPath.substring(1));
                renamedMail = BaseMailModule.getProperties(session, mailNode);
            }
            UserActivity.log(session.getUserID(), "RENAME_MAIL", mailNode.getUUID(), newName + ", " + mailPath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (ItemExistsException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new com.openkm.core.ItemExistsException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("rename: {}", (Object)renamedMail);
        return renamedMail;
    }

    @Override
    public void move(String token, String mailPath, String dstPath) throws com.openkm.core.AccessDeniedException, RepositoryException, PathNotFoundException, com.openkm.core.ItemExistsException, DatabaseException {
        log.debug("move({}, {}, {})", new Object[]{token, mailPath, dstPath});
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            String name = JCRUtils.getName(mailPath);
            String dstNodePath = dstPath + "/" + name;
            session.move(mailPath, dstPath + "/" + name);
            session.save();
            Node dstMailNode = session.getRootNode().getNode(dstNodePath.substring(1));
            BaseScriptingModule.checkScripts(session, dstMailNode.getParent(), dstMailNode, "MOVE_MAIL");
            UserActivity.log(session.getUserID(), "MOVE_MAIL", dstMailNode.getUUID(), dstPath + ", " + mailPath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (ItemExistsException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new com.openkm.core.ItemExistsException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(session);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("move: void");
    }

    @Override
    public void copy(String token, String mailPath, String dstPath) throws com.openkm.core.AccessDeniedException, RepositoryException, PathNotFoundException, com.openkm.core.ItemExistsException, IOException, DatabaseException, UserQuotaExceededException {
        log.debug("copy({}, {}, {})", new Object[]{token, mailPath, dstPath});
        Transaction t = null;
        XASession session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? (XASession)JCRUtils.getSession() : (XASession)JcrSessionManager.getInstance().get(token);
            t = new Transaction(session);
            t.start();
            Node srcMailNode = session.getRootNode().getNode(mailPath.substring(1));
            Node dstFolderNode = session.getRootNode().getNode(dstPath.substring(1));
            BaseMailModule.copy((Session)session, srcMailNode, dstFolderNode);
            t.end();
            t.commit();
            BaseNotificationModule.checkSubscriptions(dstFolderNode, session.getUserID(), "COPY", null);
            UserActivity.log(session.getUserID(), "COPY_MAIL", srcMailNode.getUUID(), dstPath + ", " + mailPath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            t.rollback();
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (ItemExistsException e) {
            log.warn(e.getMessage(), (Throwable)e);
            t.rollback();
            throw new com.openkm.core.ItemExistsException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            t.rollback();
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            t.rollback();
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            t.rollback();
            throw e;
        }
        finally {
            if (token == null) {
                JCRUtils.logout((Session)session);
            }
        }
        log.debug("copy: void");
    }

    @Override
    public List<Mail> getChilds(String token, String fldPath) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("findChilds({}, {})", (Object)token, (Object)fldPath);
        ArrayList<Mail> childs = new ArrayList<Mail>();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node folderNode = session.getRootNode().getNode(fldPath.substring(1));
            NodeIterator ni = folderNode.getNodes();
            while (ni.hasNext()) {
                Node child = ni.nextNode();
                if (!child.isNodeType("okm:mail")) continue;
                childs.add(BaseMailModule.getProperties(session, child));
            }
            UserActivity.log(session.getUserID(), "GET_CHILD_MAILS", folderNode.getUUID(), fldPath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("findChilds: {}", childs);
        return childs;
    }

    @Override
    public boolean isValid(String token, String mailPath) throws PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("isValid({}, {})", (Object)token, (Object)mailPath);
        boolean valid = false;
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node node = session.getRootNode().getNode(mailPath.substring(1));
            if (node.isNodeType("okm:mail")) {
                valid = true;
            }
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("isValid: {}", (Object)valid);
        return valid;
    }

    @Override
    public String getPath(String token, String uuid) throws com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("getPath({}, {})", (Object)token, (Object)uuid);
        String path = null;
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node node = session.getNodeByUUID(uuid);
            if (node.isNodeType("okm:mail")) {
                path = node.getPath();
            }
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getPath: {}", (Object)path);
        return path;
    }
}

