/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.module.direct;

import com.openkm.bean.Note;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.JcrSessionManager;
import com.openkm.core.LockException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.jcr.JCRUtils;
import com.openkm.module.NoteModule;
import com.openkm.module.base.BaseNoteModule;
import com.openkm.module.base.BaseNotificationModule;
import com.openkm.util.UserActivity;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.apache.jackrabbit.core.NodeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectNoteModule
implements NoteModule {
    private static Logger log = LoggerFactory.getLogger(DirectNoteModule.class);

    @Override
    public Note add(String token, String nodePath, String text) throws LockException, PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("add({}, {}, {})", new Object[]{token, nodePath, text});
        Note newNote = null;
        Session session = null;
        Node node = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            node = session.getRootNode().getNode(nodePath.substring(1));
            newNote = BaseNoteModule.add(session, node, text);
            BaseNotificationModule.checkSubscriptions(node, session.getUserID(), "ADD_NOTE", text);
            UserActivity.log(session.getUserID(), "ADD_NOTE", node.getUUID(), text + ", " + nodePath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(node);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(node);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.lock.LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(node);
            throw new LockException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(node);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("add: {}", (Object)newNote);
        return newNote;
    }

    @Override
    public void remove(String token, String notePath) throws LockException, PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("remove({}, {})", (Object)token, (Object)notePath);
        Session session = null;
        Node parentNode = null;
        String nid = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node noteNode = session.getRootNode().getNode(notePath.substring(1));
            nid = ((NodeImpl)noteNode).getIdentifier();
            parentNode = noteNode.getParent();
            if (session.getUserID().equals(noteNode.getProperty("okm:user").getString()) || session.getUserID().equals(Config.ADMIN_USER)) {
                noteNode.remove();
                parentNode.save();
                if (!parentNode.hasNodes()) {
                    Node primary = parentNode.getParent();
                    log.info("Remove mixin '{}' from {}", (Object)"mix:notes", (Object)primary);
                    primary.removeMixin("mix:notes");
                    primary.save();
                }
            } else {
                throw new com.openkm.core.AccessDeniedException("Note can only be removed by its creator or " + Config.ADMIN_USER);
            }
            UserActivity.log(session.getUserID(), "REMOVE_NOTE", nid, notePath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(parentNode);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(parentNode);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.lock.LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(parentNode);
            throw new LockException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(parentNode);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("remove: void");
    }

    @Override
    public Note get(String token, String notePath) throws LockException, PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("get({}, {})", (Object)token, (Object)notePath);
        Session session = null;
        Note note = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node noteNode = session.getRootNode().getNode(notePath.substring(1));
            note = BaseNoteModule.get(noteNode);
            UserActivity.log(session.getUserID(), "GET_NOTE", ((NodeImpl)noteNode).getIdentifier(), notePath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.lock.LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new LockException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("get: {}", (Object)note);
        return note;
    }

    @Override
    public void set(String token, String notePath, String text) throws LockException, PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("set({}, {}, {})", new Object[]{token, notePath, text});
        Session session = null;
        Node noteNode = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            noteNode = session.getRootNode().getNode(notePath.substring(1));
            if (!session.getUserID().equals(noteNode.getProperty("okm:user").getString())) {
                throw new com.openkm.core.AccessDeniedException("Note can only be modified by its creator");
            }
            noteNode.setProperty("okm:text", text);
            noteNode.save();
            BaseNotificationModule.checkSubscriptions(noteNode, session.getUserID(), "SET_NOTE", null);
            UserActivity.log(session.getUserID(), "SET_NOTE", ((NodeImpl)noteNode).getIdentifier(), notePath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(noteNode);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(noteNode);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.lock.LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(noteNode);
            throw new LockException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(noteNode);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("set: void");
    }

    @Override
    public List<Note> list(String token, String nodePath) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("list({}, {})", (Object)token, (Object)nodePath);
        ArrayList<Note> notes = new ArrayList<Note>();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node nodeNode = session.getRootNode().getNode(nodePath.substring(1));
            Node notesNode = nodeNode.getNode("okm:notes");
            NodeIterator nit = notesNode.getNodes();
            while (nit.hasNext()) {
                Node noteNode = nit.nextNode();
                Note note = new Note();
                note.setDate(noteNode.getProperty("okm:date").getDate());
                note.setUser(noteNode.getProperty("okm:user").getString());
                note.setText(noteNode.getProperty("okm:text").getString());
                note.setPath(noteNode.getPath());
                notes.add(note);
            }
            UserActivity.log(session.getUserID(), "LIST_NOTES", nodeNode.getUUID(), nodePath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getChilds: {}", notes);
        return notes;
    }
}

