/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.module.direct;

import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.JcrSessionManager;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.jcr.JCRUtils;
import com.openkm.module.NotificationModule;
import com.openkm.module.direct.DirectAuthModule;
import com.openkm.module.direct.DirectRepositoryModule;
import com.openkm.util.MailUtils;
import com.openkm.util.TemplateUtils;
import com.openkm.util.UserActivity;
import freemarker.template.Template;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectNotificationModule
implements NotificationModule {
    private static Logger log = LoggerFactory.getLogger(DirectNotificationModule.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void subscribe(String token, String nodePath) throws PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        Session session;
        block14: {
            log.debug("subscribe({}, {})", (Object)token, (Object)nodePath);
            Node node = null;
            Node sNode = null;
            session = null;
            Session systemSession = null;
            String lt = null;
            if (Config.SYSTEM_READONLY) {
                throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
            }
            try {
                session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
                systemSession = DirectRepositoryModule.getSystemSession();
                node = session.getRootNode().getNode(nodePath.substring(1));
                sNode = systemSession.getNodeByUUID(node.getUUID());
                lt = JCRUtils.getLockToken(node.getUUID());
                systemSession.addLockToken(lt);
                if (node.isNodeType("mix:notification")) {
                    Value[] actualUsers = node.getProperty("okm:subscriptors").getValues();
                    String[] newUsers = new String[actualUsers.length + 1];
                    boolean alreadyAdded = false;
                    for (int i = 0; i < actualUsers.length; ++i) {
                        newUsers[i] = actualUsers[i].getString();
                        if (!actualUsers[i].getString().equals(session.getUserID())) continue;
                        alreadyAdded = true;
                    }
                    if (!alreadyAdded) {
                        newUsers[newUsers.length - 1] = session.getUserID();
                        sNode.setProperty("okm:subscriptors", newUsers);
                    }
                } else {
                    sNode.addMixin("mix:notification");
                    sNode.setProperty("okm:subscriptors", new String[]{session.getUserID()});
                }
                sNode.save();
                UserActivity.log(session.getUserID(), "SUBSCRIBE_USER", node.getUUID(), nodePath);
                if (lt == null) break block14;
            }
            catch (AccessDeniedException e) {
                try {
                    log.warn(e.getMessage(), (Throwable)e);
                    JCRUtils.discardsPendingChanges(sNode);
                    throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
                    catch (javax.jcr.PathNotFoundException e2) {
                        log.warn(e2.getMessage(), (Throwable)e2);
                        JCRUtils.discardsPendingChanges(sNode);
                        throw new PathNotFoundException(e2.getMessage(), e2);
                    }
                    catch (javax.jcr.RepositoryException e3) {
                        log.error(e3.getMessage(), (Throwable)e3);
                        JCRUtils.discardsPendingChanges(sNode);
                        throw new RepositoryException(e3.getMessage(), e3);
                    }
                }
                catch (Throwable throwable) {
                    if (lt != null) {
                        systemSession.removeLockToken(lt);
                    }
                    if (token == null) {
                        JCRUtils.logout(session);
                    }
                    throw throwable;
                }
            }
            systemSession.removeLockToken(lt);
        }
        if (token == null) {
            JCRUtils.logout(session);
        }
        log.debug("subscribe: void");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void unsubscribe(String token, String nodePath) throws PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        Session session;
        block14: {
            log.debug("unsubscribe({}, {})", (Object)token, (Object)nodePath);
            Node node = null;
            Node sNode = null;
            session = null;
            Session systemSession = null;
            String lt = null;
            if (Config.SYSTEM_READONLY) {
                throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
            }
            try {
                session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
                systemSession = DirectRepositoryModule.getSystemSession();
                node = session.getRootNode().getNode(nodePath.substring(1));
                sNode = systemSession.getNodeByUUID(node.getUUID());
                lt = JCRUtils.getLockToken(node.getUUID());
                systemSession.addLockToken(lt);
                if (node.isNodeType("mix:notification")) {
                    Value[] actualUsers = node.getProperty("okm:subscriptors").getValues();
                    ArrayList<String> newUsers = new ArrayList<String>();
                    for (int i = 0; i < actualUsers.length; ++i) {
                        if (actualUsers[i].getString().equals(session.getUserID())) continue;
                        newUsers.add(actualUsers[i].getString());
                    }
                    if (newUsers.isEmpty()) {
                        sNode.removeMixin("mix:notification");
                    } else {
                        sNode.setProperty("okm:subscriptors", newUsers.toArray(new String[newUsers.size()]));
                    }
                }
                sNode.save();
                UserActivity.log(session.getUserID(), "UNSUBSCRIBE_USER", node.getUUID(), nodePath);
                if (lt == null) break block14;
            }
            catch (AccessDeniedException e) {
                try {
                    log.warn(e.getMessage(), (Throwable)e);
                    JCRUtils.discardsPendingChanges(sNode);
                    throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
                    catch (javax.jcr.PathNotFoundException e2) {
                        log.warn(e2.getMessage(), (Throwable)e2);
                        JCRUtils.discardsPendingChanges(sNode);
                        throw new PathNotFoundException(e2.getMessage(), e2);
                    }
                    catch (javax.jcr.RepositoryException e3) {
                        log.error(e3.getMessage(), (Throwable)e3);
                        JCRUtils.discardsPendingChanges(sNode);
                        throw new RepositoryException(e3.getMessage(), e3);
                    }
                }
                catch (Throwable throwable) {
                    if (lt != null) {
                        systemSession.removeLockToken(lt);
                    }
                    if (token == null) {
                        JCRUtils.logout(session);
                    }
                    throw throwable;
                }
            }
            systemSession.removeLockToken(lt);
        }
        if (token == null) {
            JCRUtils.logout(session);
        }
        log.debug("unsubscribe: void");
    }

    @Override
    public List<String> getSubscriptors(String token, String nodePath) throws PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("getSusbcriptions({}, {})", (Object)token, (Object)nodePath);
        ArrayList<String> users = new ArrayList<String>();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node node = session.getRootNode().getNode(nodePath.substring(1));
            if (node.isNodeType("mix:notification")) {
                Value[] notifyUsers = node.getProperty("okm:subscriptors").getValues();
                for (int i = 0; i < notifyUsers.length; ++i) {
                    users.add(notifyUsers[i].getString());
                }
            }
        }
        catch (javax.jcr.PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getSusbcriptions: {}", users);
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void notify(String token, String nodePath, List<String> users, String message, boolean attachment) throws PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException {
        DirectNotificationModule.log.debug("notify({}, {}, {}, {})", new Object[]{token, nodePath, users, message});
        to = new ArrayList<String>();
        session = null;
        if (!users.isEmpty()) {
            try {
                DirectNotificationModule.log.debug("Nodo: {}, Message: {}", (Object)nodePath, (Object)message);
                session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
                for (String user : users) {
                    mail = new DirectAuthModule().getMail(token, user);
                    if (mail == null) continue;
                    to.add(mail);
                }
                from = new DirectAuthModule().getMail(token, session.getUserID());
                if (!to.isEmpty() && from != null && !from.isEmpty()) {
                    swSubject = new StringWriter();
                    swBody = new StringWriter();
                    cfg = TemplateUtils.getConfig();
                    model = new HashMap<String, String>();
                    model.put("documentUrl", Config.APPLICATION_URL + "?docPath=" + URLEncoder.encode(nodePath, "UTF-8"));
                    model.put("documentPath", nodePath);
                    model.put("documentName", JCRUtils.getName(nodePath));
                    model.put("userId", session.getUserID());
                    model.put("notificationMessage", message);
                    if (TemplateUtils.templateExists(Config.NOTIFICATION_MESSAGE_SUBJECT)) {
                        tpl = cfg.getTemplate(Config.NOTIFICATION_MESSAGE_SUBJECT);
                        tpl.process(model, (Writer)swSubject);
                    } else {
                        sr = new StringReader(Config.NOTIFICATION_MESSAGE_SUBJECT);
                        tpl = new Template("NotificationMessageSubject", (Reader)sr, cfg);
                        tpl.process(model, (Writer)swSubject);
                        sr.close();
                    }
                    if (TemplateUtils.templateExists(Config.NOTIFICATION_MESSAGE_BODY)) {
                        tpl = cfg.getTemplate(Config.NOTIFICATION_MESSAGE_BODY);
                        tpl.process(model, (Writer)swBody);
                    } else {
                        sr = new StringReader(Config.NOTIFICATION_MESSAGE_BODY);
                        tpl = new Template("NotificationMessageBody", (Reader)sr, cfg);
                        tpl.process(model, (Writer)swBody);
                        sr.close();
                    }
                    if (attachment) {
                        MailUtils.sendDocument(from, to, swSubject.toString(), swBody.toString(), nodePath);
                    } else {
                        MailUtils.sendMessage(from, to, swSubject.toString(), swBody.toString());
                    }
                }
                ** if (token != null) goto lbl-1000
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                ** if (token != null) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    JCRUtils.logout(session);
                }
lbl-1000:
                // 2 sources

                {
                }
                catch (MessagingException e) {
                    e.printStackTrace();
                    ** if (token != null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        JCRUtils.logout(session);
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                    catch (Exception e) {
                        try {
                            e.printStackTrace();
                            ** if (token != null) goto lbl-1000
                        }
                        catch (Throwable var15_18) {
                            if (token == null) {
                                JCRUtils.logout(session);
                            }
                            throw var15_18;
                        }
lbl-1000:
                        // 1 sources

                        {
                            JCRUtils.logout(session);
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                    }
                }
            }
lbl-1000:
            // 1 sources

            {
                JCRUtils.logout(session);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        DirectNotificationModule.log.debug("notify: void");
    }
}

