/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.module.direct;

import com.openkm.bean.PropertyGroup;
import com.openkm.bean.form.CheckBox;
import com.openkm.bean.form.FormElement;
import com.openkm.bean.form.Input;
import com.openkm.bean.form.Option;
import com.openkm.bean.form.Select;
import com.openkm.bean.form.SuggestBox;
import com.openkm.bean.form.TextArea;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.JcrSessionManager;
import com.openkm.core.LockException;
import com.openkm.core.NoSuchGroupException;
import com.openkm.core.NoSuchPropertyException;
import com.openkm.core.ParseException;
import com.openkm.core.Ref;
import com.openkm.core.RepositoryException;
import com.openkm.extension.core.ExtensionException;
import com.openkm.extension.core.PropertyGroupExtensionManager;
import com.openkm.jcr.JCRUtils;
import com.openkm.module.PropertyGroupModule;
import com.openkm.module.base.BasePropertyGroupModule;
import com.openkm.module.base.BaseScriptingModule;
import com.openkm.util.FormUtils;
import com.openkm.util.UserActivity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectPropertyGroupModule
implements PropertyGroupModule {
    private static Logger log = LoggerFactory.getLogger(DirectPropertyGroupModule.class);

    @Override
    public void addGroup(String token, String nodePath, String grpName) throws NoSuchGroupException, LockException, com.openkm.core.PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException, ExtensionException {
        log.debug("addGroup({}, {}, {})", new Object[]{token, nodePath, grpName});
        Node documentNode = null;
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            documentNode = session.getRootNode().getNode(nodePath.substring(1));
            Ref<Node> refDocumentNode = new Ref<Node>(documentNode);
            PropertyGroupExtensionManager.getInstance().preAddGroup(session, refDocumentNode, grpName);
            BasePropertyGroupModule.addGroup(session, documentNode, grpName);
            PropertyGroupExtensionManager.getInstance().postAddGroup(session, refDocumentNode, grpName);
            BaseScriptingModule.checkScripts(session, documentNode, documentNode, "ADD_GROUP");
            UserActivity.log(session.getUserID(), "ADD_PROPERTY_GROUP", documentNode.getUUID(), grpName + ", " + nodePath);
        }
        catch (NoSuchNodeTypeException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(documentNode);
            throw new NoSuchGroupException(e.getMessage(), e);
        }
        catch (javax.jcr.lock.LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(documentNode);
            throw new LockException(e.getMessage(), e);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(documentNode);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(documentNode);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(documentNode);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("addGroup: void");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGroup(String token, String nodePath, String grpName) throws com.openkm.core.AccessDeniedException, NoSuchGroupException, LockException, com.openkm.core.PathNotFoundException, RepositoryException, DatabaseException, ExtensionException {
        log.debug("removeGroup({}, {}, {})", new Object[]{token, nodePath, grpName});
        Node documentNode = null;
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            documentNode = session.getRootNode().getNode(nodePath.substring(1));
            Ref<Node> refDocumentNode = new Ref<Node>(documentNode);
            PropertyGroupExtensionManager.getInstance().preRemoveGroup(session, refDocumentNode, grpName);
            Node node = documentNode;
            synchronized (node) {
                documentNode.removeMixin(grpName);
                documentNode.save();
            }
            PropertyGroupExtensionManager.getInstance().postRemoveGroup(session, refDocumentNode, grpName);
            BaseScriptingModule.checkScripts(session, documentNode, documentNode, "REMOVE_GROUP");
            UserActivity.log(session.getUserID(), "REMOVE_PROPERTY_GROUP", documentNode.getUUID(), grpName + ", " + nodePath);
        }
        catch (NoSuchNodeTypeException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new NoSuchGroupException(e.getMessage(), e);
        }
        catch (javax.jcr.lock.LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new LockException(e.getMessage(), e);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("removeGroup: void");
    }

    @Override
    public List<PropertyGroup> getGroups(String token, String nodePath) throws IOException, ParseException, com.openkm.core.PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getGroups({}, {})", (Object)token, (Object)nodePath);
        ArrayList<PropertyGroup> ret = new ArrayList<PropertyGroup>();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node documentNode = session.getRootNode().getNode(nodePath.substring(1));
            NodeType[] nt = documentNode.getMixinNodeTypes();
            Map<PropertyGroup, List<FormElement>> pgf = FormUtils.parsePropertyGroupsForms(Config.PROPERTY_GROUPS_XML);
            for (int i = 0; i < nt.length; ++i) {
                if (!nt[i].getName().startsWith("okg:")) continue;
                for (PropertyGroup pg : pgf.keySet()) {
                    if (!pg.getName().equals(nt[i].getName())) continue;
                    ret.add(pg);
                }
            }
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getGroups: {}", ret);
        return ret;
    }

    @Override
    public List<PropertyGroup> getAllGroups(String token) throws IOException, ParseException, RepositoryException, DatabaseException {
        log.debug("getAllGroups({})", (Object)token);
        ArrayList<PropertyGroup> ret = new ArrayList<PropertyGroup>();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            NodeTypeManager ntm = session.getWorkspace().getNodeTypeManager();
            Map<PropertyGroup, List<FormElement>> pgf = FormUtils.parsePropertyGroupsForms(Config.PROPERTY_GROUPS_XML);
            NodeTypeIterator nti = ntm.getMixinNodeTypes();
            while (nti.hasNext()) {
                NodeType nt = nti.nextNodeType();
                if (!nt.getName().startsWith("okg:")) continue;
                for (PropertyGroup pg : pgf.keySet()) {
                    if (!pg.getName().equals(nt.getName())) continue;
                    ret.add(pg);
                }
            }
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getAllGroups: {}", ret);
        return ret;
    }

    @Override
    public List<FormElement> getProperties(String token, String nodePath, String grpName) throws IOException, ParseException, NoSuchGroupException, com.openkm.core.PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getProperties({}, {}, {})", new Object[]{token, nodePath, grpName});
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Map<PropertyGroup, List<FormElement>> pgfs = FormUtils.parsePropertyGroupsForms(Config.PROPERTY_GROUPS_XML);
            List<FormElement> pgf = FormUtils.getPropertyGroupForms(pgfs, grpName);
            Node documentNode = session.getRootNode().getNode(nodePath.substring(1));
            NodeTypeManager ntm = session.getWorkspace().getNodeTypeManager();
            NodeType nt = ntm.getNodeType(grpName);
            PropertyDefinition[] pd = nt.getDeclaredPropertyDefinitions();
            for (FormElement fe : pgf) {
                for (int i = 0; i < pd.length; ++i) {
                    if (!fe.getName().equals(pd[i].getName())) continue;
                    try {
                        Property prop = documentNode.getProperty(pd[i].getName());
                        if (fe instanceof Select && ((Select)fe).getType().equals("multiple") && pd[i].isMultiple()) {
                            Value[] values = prop.getValues();
                            Select select = (Select)fe;
                            for (Option opt : select.getOptions()) {
                                for (int j = 0; j < values.length; ++j) {
                                    if (!opt.getValue().equals(values[j].getString())) continue;
                                    select.setValue(select.getValue().concat(opt.getValue()).concat(","));
                                    opt.setSelected(true);
                                }
                            }
                            if (select.getValue().endsWith(",")) {
                                select.setValue(select.getValue().substring(0, select.getValue().length() - 1));
                            }
                            continue;
                        }
                        if (!pd[i].isMultiple()) {
                            Value value = prop.getValue();
                            if (fe instanceof Input) {
                                ((Input)fe).setValue(value.getString());
                                continue;
                            }
                            if (fe instanceof SuggestBox) {
                                ((SuggestBox)fe).setValue(value.getString());
                                continue;
                            }
                            if (fe instanceof CheckBox) {
                                ((CheckBox)fe).setValue(Boolean.parseBoolean(value.getString()));
                                continue;
                            }
                            if (fe instanceof TextArea) {
                                ((TextArea)fe).setValue(value.getString());
                                continue;
                            }
                            if (fe instanceof Select) {
                                if (!value.getString().equals("")) {
                                    for (Option opt : ((Select)fe).getOptions()) {
                                        if (opt.getValue().equals(value.getString())) {
                                            ((Select)fe).setValue(opt.getValue());
                                            opt.setSelected(true);
                                            continue;
                                        }
                                        opt.setSelected(false);
                                    }
                                }
                                continue;
                            }
                            throw new ParseException("Unknown property definition: " + pd[i].getName());
                        }
                        throw new ParseException("Inconsistent property definition: " + pd[i].getName());
                    }
                    catch (PathNotFoundException e) {
                        // empty catch block
                    }
                }
            }
            UserActivity.log(session.getUserID(), "GET_PROPERTY_GROUP_PROPERTIES", documentNode.getUUID(), grpName + ", " + pgf + ", " + nodePath);
            log.debug("getProperties: {}", pgf);
            List<FormElement> list = pgf;
            return list;
        }
        catch (NoSuchNodeTypeException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new NoSuchGroupException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperties(String token, String nodePath, String grpName, List<FormElement> properties) throws IOException, ParseException, NoSuchPropertyException, NoSuchGroupException, LockException, com.openkm.core.PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException, ExtensionException {
        log.debug("setProperties({}, {}, {}, {})", new Object[]{token, nodePath, grpName, properties});
        Node documentNode = null;
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            NodeTypeManager ntm = session.getWorkspace().getNodeTypeManager();
            NodeType nt = ntm.getNodeType(grpName);
            PropertyDefinition[] pd = nt.getDeclaredPropertyDefinitions();
            documentNode = session.getRootNode().getNode(nodePath.substring(1));
            Ref<Node> refDocumentNode = new Ref<Node>(documentNode);
            PropertyGroupExtensionManager.getInstance().preSetProperties(session, refDocumentNode, grpName, properties);
            Node node = documentNode;
            synchronized (node) {
                int i;
                for (FormElement fe : properties) {
                    for (i = 0; i < pd.length; ++i) {
                        if (!fe.getName().equals(pd[i].getName()) || !documentNode.isNodeType(grpName) || documentNode.hasProperty(pd[i].getName())) continue;
                        documentNode.removeMixin(grpName);
                        documentNode.addMixin(grpName);
                    }
                }
                for (FormElement fe : properties) {
                    for (i = 0; i < pd.length; ++i) {
                        if (!fe.getName().equals(pd[i].getName())) continue;
                        try {
                            BasePropertyGroupModule.setPropertyValue(documentNode, pd[i], fe);
                            continue;
                        }
                        catch (PathNotFoundException e) {
                            throw new RepositoryException("Requested property not found: " + e.getMessage());
                        }
                    }
                }
            }
            documentNode.save();
            PropertyGroupExtensionManager.getInstance().postSetProperties(session, refDocumentNode, grpName, properties);
            BaseScriptingModule.checkScripts(session, documentNode, documentNode, "SET_PROPERTIES");
            UserActivity.log(session.getUserID(), "SET_PROPERTY_GROUP_PROPERTIES", documentNode.getUUID(), grpName + ", " + properties + ", " + nodePath);
        }
        catch (NoSuchNodeTypeException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(documentNode);
            throw new NoSuchPropertyException(e.getMessage(), e);
        }
        catch (javax.jcr.lock.LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(documentNode);
            throw new LockException(e.getMessage(), e);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(documentNode);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(documentNode);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(documentNode);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("setProperties: void");
    }

    @Override
    public List<FormElement> getPropertyGroupForm(String token, String grpName) throws IOException, ParseException, RepositoryException, DatabaseException {
        log.debug("getPropertyGroupForm({}, {})", (Object)token, (Object)grpName);
        ArrayList<FormElement> ret = new ArrayList<FormElement>();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            NodeTypeManager ntm = session.getWorkspace().getNodeTypeManager();
            NodeType nt = ntm.getNodeType(grpName);
            PropertyDefinition[] pd = nt.getDeclaredPropertyDefinitions();
            Map<PropertyGroup, List<FormElement>> pgf = FormUtils.parsePropertyGroupsForms(Config.PROPERTY_GROUPS_XML);
            List<FormElement> tmp = FormUtils.getPropertyGroupForms(pgf, grpName);
            for (FormElement fe : tmp) {
                for (int i = 0; i < pd.length; ++i) {
                    if (!fe.getName().equals(pd[i].getName())) continue;
                    ret.add(fe);
                }
            }
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getPropertyGroupForm: {}", ret);
        return ret;
    }

    @Override
    public boolean hasGroup(String token, String nodePath, String grpName) throws IOException, ParseException, com.openkm.core.PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("hasGroup({}, {}, {})", new Object[]{token, nodePath, grpName});
        boolean ret = false;
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node documentNode = session.getRootNode().getNode(nodePath.substring(1));
            NodeType[] nt = documentNode.getMixinNodeTypes();
            Map<PropertyGroup, List<FormElement>> pgf = FormUtils.parsePropertyGroupsForms(Config.PROPERTY_GROUPS_XML);
            block6: for (int i = 0; i < nt.length; ++i) {
                if (!nt[i].getName().startsWith("okg:")) continue;
                for (PropertyGroup pg : pgf.keySet()) {
                    if (!pg.getName().equals(nt[i].getName()) || !pg.getName().equals(grpName)) continue;
                    ret = true;
                    continue block6;
                }
            }
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("hasGroup: {}", (Object)ret);
        return ret;
    }
}

