/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.module.direct;

import com.openkm.cache.UserDocumentKeywordsManager;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.JcrSessionManager;
import com.openkm.core.LockException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.jcr.JCRUtils;
import com.openkm.module.PropertyModule;
import com.openkm.module.base.BaseNotificationModule;
import com.openkm.module.base.BasePropertyModule;
import com.openkm.module.base.BaseScriptingModule;
import com.openkm.util.UserActivity;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.version.VersionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectPropertyModule
implements PropertyModule {
    private static Logger log = LoggerFactory.getLogger(DirectPropertyModule.class);

    @Override
    public void addCategory(String token, String nodePath, String catId) throws com.openkm.core.VersionException, LockException, PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("addCategory({}, {}, {})", new Object[]{token, nodePath, catId});
        Node documentNode = null;
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            documentNode = session.getRootNode().getNode(nodePath.substring(1));
            BasePropertyModule.addCategory(session, documentNode, catId);
            BaseNotificationModule.checkSubscriptions(documentNode, session.getUserID(), "ADD_CATEGORY", null);
            BaseScriptingModule.checkScripts(session, documentNode, documentNode, "ADD_CATEGORY");
            UserActivity.log(session.getUserID(), "ADD_CATEGORY", documentNode.getUUID(), catId + ", " + nodePath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (VersionException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new com.openkm.core.VersionException(e.getMessage(), e);
        }
        catch (javax.jcr.lock.LockException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new LockException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("addCategory: void");
    }

    @Override
    public void removeCategory(String token, String nodePath, String catId) throws com.openkm.core.VersionException, LockException, PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("removeCategory({}, {}, {})", new Object[]{token, nodePath, catId});
        Node documentNode = null;
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            documentNode = session.getRootNode().getNode(nodePath.substring(1));
            BasePropertyModule.removeCategory(session, documentNode, catId);
            BaseNotificationModule.checkSubscriptions(documentNode, session.getUserID(), "REMOVE_CATEGORY", null);
            BaseScriptingModule.checkScripts(session, documentNode, documentNode, "REMOVE_CATEGORY");
            UserActivity.log(session.getUserID(), "REMOVE_CATEGORY", documentNode.getUUID(), catId + ", " + nodePath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (VersionException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new com.openkm.core.VersionException(e.getMessage(), e);
        }
        catch (javax.jcr.lock.LockException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new LockException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("removeCategory: void");
    }

    @Override
    public String addKeyword(String token, String nodePath, String keyword) throws com.openkm.core.VersionException, LockException, PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("addKeyword({}, {}, {})", new Object[]{token, nodePath, keyword});
        Node documentNode = null;
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            documentNode = session.getRootNode().getNode(nodePath.substring(1));
            keyword = BasePropertyModule.addKeyword(session, documentNode, keyword);
            if (Config.USER_KEYWORDS_CACHE) {
                UserDocumentKeywordsManager.add(session.getUserID(), nodePath, keyword);
            }
            BaseNotificationModule.checkSubscriptions(documentNode, session.getUserID(), "ADD_KEYWORD", null);
            BaseScriptingModule.checkScripts(session, documentNode, documentNode, "ADD_KEYWORD");
            UserActivity.log(session.getUserID(), "ADD_KEYWORD", documentNode.getUUID(), keyword + ", " + nodePath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (VersionException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new com.openkm.core.VersionException(e.getMessage(), e);
        }
        catch (javax.jcr.lock.LockException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new LockException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("addKeyword: {}", (Object)keyword);
        return keyword;
    }

    @Override
    public void removeKeyword(String token, String nodePath, String keyword) throws com.openkm.core.VersionException, LockException, PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("removeKeyword({}, {}, {})", new Object[]{token, nodePath, keyword});
        Node documentNode = null;
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            documentNode = session.getRootNode().getNode(nodePath.substring(1));
            BasePropertyModule.removeKeyword(session, documentNode, keyword);
            if (Config.USER_KEYWORDS_CACHE) {
                UserDocumentKeywordsManager.remove(session.getUserID(), nodePath, keyword);
            }
            BaseNotificationModule.checkSubscriptions(documentNode, session.getUserID(), "REMOVE_KEYWORD", null);
            BaseScriptingModule.checkScripts(session, documentNode, documentNode, "REMOVE_KEYWORD");
            UserActivity.log(session.getUserID(), "REMOVE_KEYWORD", documentNode.getUUID(), keyword + ", " + nodePath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (VersionException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new com.openkm.core.VersionException(e.getMessage(), e);
        }
        catch (javax.jcr.lock.LockException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new LockException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("removeKeyword: void");
    }

    @Override
    public void setEncryption(String token, String nodePath, String cipherName) throws com.openkm.core.VersionException, LockException, PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("setEncryption({}, {}, {})", new Object[]{token, nodePath, cipherName});
        Node documentNode = null;
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            documentNode = session.getRootNode().getNode(nodePath.substring(1));
            if (!documentNode.isNodeType("mix:encryption") && cipherName != null) {
                documentNode.addMixin("mix:encryption");
                documentNode.setProperty("okm:cipherName", cipherName);
                documentNode.save();
            }
            BaseNotificationModule.checkSubscriptions(documentNode, session.getUserID(), "SET_ENCRYPTION", null);
            BaseScriptingModule.checkScripts(session, documentNode, documentNode, "SET_ENCRYPTION");
            UserActivity.log(session.getUserID(), "SET_ENCRYPTION", documentNode.getUUID(), cipherName + ", " + nodePath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (VersionException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new com.openkm.core.VersionException(e.getMessage(), e);
        }
        catch (javax.jcr.lock.LockException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new LockException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("setEncryption: void");
    }

    @Override
    public void unsetEncryption(String token, String nodePath) throws com.openkm.core.VersionException, LockException, PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("unsetEncryption({}, {})", new Object[]{token, nodePath});
        Node documentNode = null;
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            documentNode = session.getRootNode().getNode(nodePath.substring(1));
            if (documentNode.isNodeType("mix:encryption")) {
                documentNode.removeMixin("mix:encryption");
                documentNode.save();
            }
            BaseNotificationModule.checkSubscriptions(documentNode, session.getUserID(), "UNSET_ENCRYPTION", null);
            BaseScriptingModule.checkScripts(session, documentNode, documentNode, "UNSET_ENCRYPTION");
            UserActivity.log(session.getUserID(), "UNSET_ENCRYPTION", documentNode.getUUID(), nodePath);
        }
        catch (javax.jcr.PathNotFoundException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new PathNotFoundException(e.getMessage(), e);
        }
        catch (AccessDeniedException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (VersionException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new com.openkm.core.VersionException(e.getMessage(), e);
        }
        catch (javax.jcr.lock.LockException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new LockException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            JCRUtils.discardsPendingChanges(documentNode);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("unsetEncryption: void");
    }
}

