/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.module.direct;

import com.openkm.bean.Folder;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.JcrSessionManager;
import com.openkm.core.OKMSystemSession;
import com.openkm.core.RepositoryException;
import com.openkm.jcr.JCRUtils;
import com.openkm.module.RepositoryModule;
import com.openkm.module.base.BaseDocumentModule;
import com.openkm.module.base.BaseFolderModule;
import com.openkm.module.direct.DirectAuthModule;
import com.openkm.util.MailUtils;
import com.openkm.util.UserActivity;
import com.openkm.util.WarUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.UUID;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.compact.CompactNodeTypeDefReader;
import org.apache.jackrabbit.core.nodetype.compact.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectRepositoryModule
implements RepositoryModule {
    private static Logger log = LoggerFactory.getLogger(DirectRepositoryModule.class);
    private static Repository repository = null;
    private static Session systemSession = null;

    public static synchronized Repository getRepository() throws javax.jcr.RepositoryException {
        log.debug("getRepository()");
        WorkspaceConfig wc = null;
        if (repository == null) {
            try {
                RepositoryConfig config = DirectRepositoryModule.getRepositoryConfig();
                wc = config.getWorkspaceConfig(config.getDefaultWorkspaceName());
                repository = RepositoryImpl.create((RepositoryConfig)config);
            }
            catch (ConfigurationException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (javax.jcr.RepositoryException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        if (systemSession == null) {
            try {
                systemSession = OKMSystemSession.create((RepositoryImpl)repository, wc);
            }
            catch (LoginException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (NoSuchWorkspaceException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (javax.jcr.RepositoryException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        log.debug("getRepository: " + repository);
        return repository;
    }

    public static RepositoryConfig getRepositoryConfig() throws ConfigurationException {
        String repConfig = Config.REPOSITORY_CONFIG;
        String repHome = null;
        repHome = new File(Config.REPOSITORY_HOME).isAbsolute() ? Config.REPOSITORY_HOME : Config.HOME_DIR + File.separator + Config.REPOSITORY_HOME;
        return RepositoryConfig.create((String)repConfig, (String)repHome);
    }

    public static synchronized void shutdown() {
        log.debug("shutdownRepository()");
        if (systemSession != null && systemSession.isLive()) {
            systemSession.logout();
        }
        systemSession = null;
        ((RepositoryImpl)repository).shutdown();
        repository = null;
        log.debug("shutdownRepository: void");
    }

    public static Session getSystemSession() {
        log.debug("getSystemSession()");
        if (systemSession != null) {
            log.debug("systemSession.isLive() = " + systemSession.isLive());
            log.debug("systemSession.getUserID() = " + systemSession.getUserID());
            try {
                log.debug("systemSession.hasPendingChanges() = " + systemSession.hasPendingChanges());
            }
            catch (javax.jcr.RepositoryException e) {
                log.error("# MKK-1 # MKK-1 # MKK-1 # MKK-1 # MKK-1 # MKK-1 # MKK-1 #");
                log.error(e.getMessage(), (Throwable)e);
                log.error("# MKK-1 # MKK-1 # MKK-1 # MKK-1 # MKK-1 # MKK-1 # MKK-1 #");
            }
        } else {
            log.error("# MKK-2 # MKK-2 # MKK-2 # MKK-2 # MKK-2 # MKK-2 # MKK-2 #");
            log.error("systemSession is NULL");
            log.error("# MKK-2 # MKK-2 # MKK-2 # MKK-2 # MKK-2 # MKK-2 # MKK-2 #");
        }
        log.debug("getSystemSession: {}", (Object)systemSession);
        return systemSession;
    }

    public static synchronized String initialize() throws javax.jcr.RepositoryException, FileNotFoundException, InvalidNodeTypeDefException, ParseException, DatabaseException {
        log.debug("initialize()");
        DirectRepositoryModule.getRepository();
        Session systemSession = DirectRepositoryModule.getSystemSession();
        String okmRootPath = DirectRepositoryModule.create(systemSession);
        DirectAuthModule.loadUserData(systemSession);
        JcrSessionManager.getInstance().putSystemSession(systemSession);
        log.debug("*** System user created " + systemSession.getUserID());
        log.debug("initialize: {}", (Object)okmRootPath);
        return okmRootPath;
    }

    public static synchronized String create(Session session) throws javax.jcr.RepositoryException, FileNotFoundException, InvalidNodeTypeDefException, ParseException {
        String okmRootPath = null;
        Node rootNode = null;
        try {
            rootNode = session.getRootNode().getNode("okm:root");
        }
        catch (PathNotFoundException e) {
            log.info("No okm:root node found");
        }
        catch (javax.jcr.RepositoryException e) {
            log.info("No okm:root node found");
        }
        try {
            if (rootNode == null) {
                log.info("Repository creation");
                log.info("Register namespace");
                Workspace ws = session.getWorkspace();
                NamespaceRegistry nsr = ws.getNamespaceRegistry();
                nsr.registerNamespace("okm", "http://www.openkm.org/1.0");
                nsr.registerNamespace("okg", "http://www.openkm.org/group/1.0");
                nsr.registerNamespace("okp", "http://www.openkm.org/group/property/1.0");
                log.info("Register custom node types");
                InputStream is = DirectRepositoryModule.class.getResourceAsStream("CustomNodes.cnd");
                if (is == null) {
                    String msg = "Configuration error: CustomNodes.cnd not found";
                    log.debug(msg);
                    throw new javax.jcr.RepositoryException(msg);
                }
                DirectRepositoryModule.registerCustomNodeTypes(session, is);
                Node root = session.getRootNode();
                log.info("Create okm:root");
                Node okmRoot = DirectRepositoryModule.createBase(session, root, "okm:root");
                okmRootPath = okmRoot.getPath();
                log.info("Create okm:thesaurus");
                DirectRepositoryModule.createBase(session, root, "okm:thesaurus");
                log.info("Create okm:categories");
                DirectRepositoryModule.createBase(session, root, "okm:categories");
                log.info("Create okm:templates");
                DirectRepositoryModule.createBase(session, root, "okm:templates");
                log.info("Create okm:personal");
                DirectRepositoryModule.createBase(session, root, "okm:personal");
                log.info("Create okm:mail");
                DirectRepositoryModule.createBase(session, root, "okm:mail");
                log.info("Create okm:trash");
                DirectRepositoryModule.createBase(session, root, "okm:trash");
                log.info("Create okm:config");
                Node okmConfig = root.addNode("okm:config", "okm:sysConfig");
                String uuid = UUID.randomUUID().toString();
                okmConfig.setProperty("okm:uuid", uuid);
                com.openkm.bean.Repository.setUuid(uuid);
                okmConfig.setProperty("okm:version", WarUtils.getAppVersion().getMajor());
                root.save();
            } else {
                log.info("Repository already created");
                Node root = session.getRootNode();
                Node okmConfig = root.getNode("okm:config");
                String uuid = okmConfig.getProperty("okm:uuid").getString();
                com.openkm.bean.Repository.setUuid(uuid);
                String repoVer = okmConfig.getProperty("okm:version").getString();
                if (!WarUtils.getAppVersion().getMajor().equals(repoVer)) {
                    log.warn("### Actual repository version (" + repoVer + ") differs from application repository version (" + WarUtils.getAppVersion().getMajor() + ") ###");
                    log.warn("### You should upgrade the repository ###");
                }
            }
        }
        catch (NamespaceException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidNodeTypeDefException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return okmRootPath;
    }

    private static Node createBase(Session session, Node root, String name) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, javax.jcr.RepositoryException {
        Node base = root.addNode(name, "okm:folder");
        base.setProperty("okm:author", session.getUserID());
        base.setProperty("okm:name", name);
        base.setProperty("okm:authUsersRead", new String[]{session.getUserID()});
        base.setProperty("okm:authUsersWrite", new String[]{session.getUserID()});
        base.setProperty("okm:authUsersDelete", new String[]{session.getUserID()});
        base.setProperty("okm:authUsersSecurity", new String[]{session.getUserID()});
        base.setProperty("okm:authRolesRead", new String[]{Config.DEFAULT_USER_ROLE});
        base.setProperty("okm:authRolesWrite", new String[]{Config.DEFAULT_USER_ROLE});
        base.setProperty("okm:authRolesDelete", new String[]{Config.DEFAULT_USER_ROLE});
        base.setProperty("okm:authRolesSecurity", new String[]{Config.DEFAULT_USER_ROLE});
        return base;
    }

    public synchronized void remove() throws RepositoryException {
        log.debug("remove()");
        String repHome = null;
        repHome = new File(Config.REPOSITORY_HOME).isAbsolute() ? Config.REPOSITORY_HOME : Config.HOME_DIR + File.separator + Config.REPOSITORY_HOME;
        try {
            FileUtils.deleteDirectory((File)new File(repHome));
        }
        catch (IOException e) {
            System.err.println("No previous repository found");
        }
        log.debug("create: void");
    }

    @Override
    public Folder getRootFolder(String token) throws com.openkm.core.PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getRootFolder({})", (Object)token);
        Folder rootFolder = new Folder();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node rootNode = session.getRootNode().getNode("okm:root");
            rootFolder = BaseFolderModule.getProperties(session, rootNode);
            UserActivity.log(session.getUserID(), "GET_ROOT_FOLDER", rootNode.getUUID(), rootFolder.getPath());
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getRootFolder: {}", (Object)rootFolder);
        return rootFolder;
    }

    @Override
    public Folder getTrashFolder(String token) throws com.openkm.core.PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getTrashFolder({})", (Object)token);
        Folder trashFolder = new Folder();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node trashNode = session.getRootNode().getNode("okm:trash/" + session.getUserID());
            trashFolder = BaseFolderModule.getProperties(session, trashNode);
            UserActivity.log(session.getUserID(), "GET_TRASH_FOLDER", trashNode.getUUID(), trashFolder.getPath());
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getTrashFolder: {}", (Object)trashFolder);
        return trashFolder;
    }

    @Override
    public Folder getTrashFolderBase(String token) throws com.openkm.core.PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getTrashFolderBase({})", (Object)token);
        Folder trashFolder = new Folder();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node trashNode = session.getRootNode().getNode("okm:trash");
            trashFolder = BaseFolderModule.getProperties(session, trashNode);
            UserActivity.log(session.getUserID(), "GET_TRASH_FOLDER_BASE", trashNode.getUUID(), trashFolder.getPath());
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getTrashFolderBase: {}", (Object)trashFolder);
        return trashFolder;
    }

    @Override
    public Folder getTemplatesFolder(String token) throws com.openkm.core.PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getTemplatesFolder({})", (Object)token);
        Folder templatesFolder = new Folder();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node templatesNode = session.getRootNode().getNode("okm:templates");
            templatesFolder = BaseFolderModule.getProperties(session, templatesNode);
            UserActivity.log(session.getUserID(), "GET_TEMPLATES_FOLDER", templatesNode.getUUID(), templatesFolder.getPath());
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getTemplatesFolder: {}", (Object)templatesFolder);
        return templatesFolder;
    }

    @Override
    public Folder getPersonalFolder(String token) throws com.openkm.core.PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getPersonalFolder({})", (Object)token);
        Folder personalFolder = new Folder();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node personalNode = session.getRootNode().getNode("okm:personal/" + session.getUserID());
            personalFolder = BaseFolderModule.getProperties(session, personalNode);
            UserActivity.log(session.getUserID(), "GET_PERSONAL_FOLDER", personalNode.getUUID(), personalFolder.getPath());
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getPersonalFolder: {}", (Object)personalFolder);
        return personalFolder;
    }

    @Override
    public Folder getPersonalFolderBase(String token) throws com.openkm.core.PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getPersonalFolderBase({})", (Object)token);
        Folder personalFolder = new Folder();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node personalNode = session.getRootNode().getNode("okm:personal");
            personalFolder = BaseFolderModule.getProperties(session, personalNode);
            UserActivity.log(session.getUserID(), "GET_PERSONAL_FOLDER_BASE", personalNode.getUUID(), personalFolder.getPath());
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getPersonalFolderBase: {}", (Object)personalFolder);
        return personalFolder;
    }

    @Override
    public Folder getMailFolder(String token) throws com.openkm.core.PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getMailFolder({})", (Object)token);
        Folder mailFolder = new Folder();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            String mailPath = MailUtils.getUserMailPath(session.getUserID());
            Node mailNode = session.getRootNode().getNode(mailPath.substring(1));
            mailFolder = BaseFolderModule.getProperties(session, mailNode);
            UserActivity.log(session.getUserID(), "GET_MAIL_FOLDER", mailNode.getUUID(), mailFolder.getPath());
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getMailFolder: {}", (Object)mailFolder);
        return mailFolder;
    }

    @Override
    public Folder getMailFolderBase(String token) throws com.openkm.core.PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getMailFolderBase({})", (Object)token);
        Folder mailFolder = new Folder();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node mailNode = session.getRootNode().getNode("okm:mail");
            mailFolder = BaseFolderModule.getProperties(session, mailNode);
            UserActivity.log(session.getUserID(), "GET_MAIL_FOLDER_BASE", mailNode.getUUID(), mailFolder.getPath());
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getMailFolderBase: {}", (Object)mailFolder);
        return mailFolder;
    }

    @Override
    public Folder getThesaurusFolder(String token) throws com.openkm.core.PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getThesaurusFolder({})", (Object)token);
        Folder thesaurusFolder = new Folder();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node thesaurusNode = session.getRootNode().getNode("okm:thesaurus");
            thesaurusFolder = BaseFolderModule.getProperties(session, thesaurusNode);
            UserActivity.log(session.getUserID(), "GET_THESAURUS_FOLDER", thesaurusNode.getUUID(), thesaurusFolder.getPath());
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getThesaurusFolder: {}", (Object)thesaurusFolder);
        return thesaurusFolder;
    }

    @Override
    public Folder getCategoriesFolder(String token) throws com.openkm.core.PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getCategoriesFolder({})", (Object)token);
        Folder categoriesFolder = new Folder();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node categoriesNode = session.getRootNode().getNode("okm:categories");
            categoriesFolder = BaseFolderModule.getProperties(session, categoriesNode);
            UserActivity.log(session.getUserID(), "GET_CATEGORIES_FOLDER", categoriesNode.getUUID(), categoriesFolder.getPath());
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getCategoriesFolder: {}", (Object)categoriesFolder);
        return categoriesFolder;
    }

    public static synchronized void registerCustomNodeTypes(Session session, InputStream cndFile) throws FileNotFoundException, ParseException, javax.jcr.RepositoryException, InvalidNodeTypeDefException {
        log.debug("registerCustomNodeTypes({}, {})", (Object)session, (Object)cndFile);
        InputStreamReader fileReader = new InputStreamReader(cndFile);
        CompactNodeTypeDefReader cndReader = new CompactNodeTypeDefReader((Reader)fileReader, "CustomNodes.cnd");
        List ntdList = cndReader.getNodeTypeDefs();
        Workspace ws = session.getWorkspace();
        NodeTypeManagerImpl ntmgr = (NodeTypeManagerImpl)ws.getNodeTypeManager();
        NodeTypeRegistry ntreg = ntmgr.getNodeTypeRegistry();
        for (NodeTypeDef ntd : ntdList) {
            if (!ntreg.isRegistered(ntd.getName())) {
                log.info("Register type " + ntd.getName().toString());
                ntreg.registerNodeType(ntd);
                continue;
            }
            log.info("Reregister type " + ntd.getName().toString());
            ntreg.reregisterNodeType(ntd);
        }
        log.debug("registerCustomNodeTypes: void");
    }

    @Override
    public void purgeTrash(String token) throws com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("purgeTrash({})", (Object)token);
        Node userTrash = null;
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            userTrash = session.getRootNode().getNode("okm:trash/" + session.getUserID());
            NodeIterator it = userTrash.getNodes();
            while (it.hasNext()) {
                Node child = it.nextNode();
                if (child.isNodeType("okm:document")) {
                    BaseDocumentModule.purge(session, child.getParent(), child);
                    continue;
                }
                if (!child.isNodeType("okm:folder")) continue;
                BaseFolderModule.purge(session, child);
            }
            userTrash.save();
            UserActivity.log(session.getUserID(), "PURGE_TRASH", null, null);
        }
        catch (AccessDeniedException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(userTrash);
            throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            JCRUtils.discardsPendingChanges(userTrash);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("purgeTrash: void");
    }

    @Override
    public String getUpdateMessage(String token) throws RepositoryException {
        return com.openkm.bean.Repository.getUpdateMsg();
    }

    @Override
    public String getRepositoryUuid(String token) throws RepositoryException {
        return com.openkm.bean.Repository.getUuid();
    }

    @Override
    public boolean hasNode(String token, String path) throws RepositoryException, DatabaseException {
        log.debug("hasNode({}, {})", (Object)token, (Object)path);
        boolean ret = false;
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            ret = session.getRootNode().hasNode(path.substring(1));
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("hasNode: {}", (Object)ret);
        return ret;
    }

    @Override
    public String getNodePath(String token, String uuid) throws com.openkm.core.PathNotFoundException, RepositoryException, DatabaseException {
        String ret;
        log.debug("getNodePath({}, {})", (Object)token, (Object)uuid);
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            ret = session.getNodeByUUID(uuid).getPath();
        }
        catch (ItemNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getNodePath: {}", (Object)ret);
        return ret;
    }

    @Override
    public String getNodeUuid(String token, String path) throws com.openkm.core.PathNotFoundException, RepositoryException, DatabaseException {
        String ret;
        log.debug("getNodeUuid({}, {})", (Object)token, (Object)path);
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            ret = session.getRootNode().getNode(path.substring(1)).getUUID();
        }
        catch (ItemNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getNodeUuid: {}", (Object)ret);
        return ret;
    }
}

