/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.module.direct;

import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.JcrSessionManager;
import com.openkm.core.RepositoryException;
import com.openkm.jcr.JCRUtils;
import com.openkm.module.ScriptingModule;
import com.openkm.module.direct.DirectRepositoryModule;
import com.openkm.util.PrincipalUtils;
import com.openkm.util.UserActivity;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectScriptingModule
implements ScriptingModule {
    private static Logger log = LoggerFactory.getLogger(DirectScriptingModule.class);

    @Override
    public void setScript(String token, String nodePath, String code) throws com.openkm.core.PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        block10: {
            log.debug("setScript({}, {}, {})", new Object[]{token, nodePath, code});
            Node node = null;
            Node sNode = null;
            Session session = null;
            if (Config.SYSTEM_READONLY) {
                throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
            }
            try {
                session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
                if (PrincipalUtils.hasRole(Config.DEFAULT_ADMIN_ROLE)) {
                    Session systemSession = DirectRepositoryModule.getSystemSession();
                    node = session.getRootNode().getNode(nodePath.substring(1));
                    sNode = systemSession.getNodeByUUID(node.getUUID());
                    sNode.addMixin("mix:scripting");
                    sNode.setProperty("okm:scriptCode", code);
                    sNode.save();
                    UserActivity.log(session.getUserID(), "SET_SCRIPT", node.getUUID(), nodePath);
                    break block10;
                }
                throw new com.openkm.core.AccessDeniedException("Sorry, only for admin user");
            }
            catch (AccessDeniedException e) {
                log.warn(e.getMessage(), (Throwable)e);
                JCRUtils.discardsPendingChanges(sNode);
                throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
            }
            catch (PathNotFoundException e) {
                log.warn(e.getMessage(), (Throwable)e);
                JCRUtils.discardsPendingChanges(sNode);
                throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
            }
            catch (javax.jcr.RepositoryException e) {
                log.error(e.getMessage(), (Throwable)e);
                JCRUtils.discardsPendingChanges(sNode);
                throw new RepositoryException(e.getMessage(), e);
            }
            finally {
                if (token == null) {
                    JCRUtils.logout(session);
                }
            }
        }
        log.debug("setScript: void");
    }

    @Override
    public void removeScript(String token, String nodePath) throws com.openkm.core.PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        block11: {
            log.debug("removeScript({}, {})", (Object)token, (Object)nodePath);
            Node node = null;
            Node sNode = null;
            Session session = null;
            if (Config.SYSTEM_READONLY) {
                throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
            }
            try {
                session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
                if (PrincipalUtils.hasRole(Config.DEFAULT_ADMIN_ROLE)) {
                    Session systemSession = DirectRepositoryModule.getSystemSession();
                    sNode = systemSession.getNodeByUUID((node = session.getRootNode().getNode(nodePath.substring(1))).getUUID());
                    if (sNode.isNodeType("mix:scripting")) {
                        sNode.removeMixin("mix:scripting");
                        sNode.save();
                    }
                    UserActivity.log(session.getUserID(), "REMOVE_SCRIPT", node.getUUID(), nodePath);
                    break block11;
                }
                throw new com.openkm.core.AccessDeniedException("Sorry, only for admin user");
            }
            catch (AccessDeniedException e) {
                log.warn(e.getMessage(), (Throwable)e);
                JCRUtils.discardsPendingChanges(sNode);
                throw new com.openkm.core.AccessDeniedException(e.getMessage(), e);
            }
            catch (PathNotFoundException e) {
                log.warn(e.getMessage(), (Throwable)e);
                JCRUtils.discardsPendingChanges(sNode);
                throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
            }
            catch (javax.jcr.RepositoryException e) {
                log.error(e.getMessage(), (Throwable)e);
                JCRUtils.discardsPendingChanges(sNode);
                throw new RepositoryException(e.getMessage(), e);
            }
            finally {
                if (token == null) {
                    JCRUtils.logout(session);
                }
            }
        }
        log.debug("removeScript: void");
    }

    @Override
    public String getScript(String token, String nodePath) throws com.openkm.core.PathNotFoundException, com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        String code;
        block9: {
            log.debug("getScript({}, {})", (Object)token, (Object)nodePath);
            code = null;
            Session session = null;
            try {
                session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
                if (PrincipalUtils.hasRole(Config.DEFAULT_ADMIN_ROLE)) {
                    Node node = session.getRootNode().getNode(nodePath.substring(1));
                    if (node.isNodeType("mix:scripting")) {
                        code = node.getProperty("okm:scriptCode").getString();
                    }
                    break block9;
                }
                throw new com.openkm.core.AccessDeniedException("Sorry, only for admin user");
            }
            catch (PathNotFoundException e) {
                log.warn(e.getMessage(), (Throwable)e);
                throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
            }
            catch (javax.jcr.RepositoryException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new RepositoryException(e.getMessage(), e);
            }
            finally {
                if (token == null) {
                    JCRUtils.logout(session);
                }
            }
        }
        log.debug("getScript: {}", (Object)code);
        return code;
    }
}

