/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.module.direct;

import com.openkm.bean.Document;
import com.openkm.bean.Folder;
import com.openkm.bean.Mail;
import com.openkm.bean.PropertyGroup;
import com.openkm.bean.ResultSet;
import com.openkm.bean.form.FormElement;
import com.openkm.bean.form.Input;
import com.openkm.bean.form.Select;
import com.openkm.cache.UserDocumentKeywordsManager;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.JcrSessionManager;
import com.openkm.core.ParseException;
import com.openkm.core.RepositoryException;
import com.openkm.dao.DashboardDAO;
import com.openkm.dao.QueryParamsDAO;
import com.openkm.dao.bean.QueryParams;
import com.openkm.dao.bean.cache.UserDocumentKeywords;
import com.openkm.jcr.JCRUtils;
import com.openkm.module.SearchModule;
import com.openkm.module.base.BaseDocumentModule;
import com.openkm.module.base.BaseFolderModule;
import com.openkm.module.base.BaseMailModule;
import com.openkm.util.FormUtils;
import com.openkm.util.UserActivity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.core.query.QueryImpl;
import org.apache.jackrabbit.core.query.lucene.QueryResultImpl;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.util.ISO9075;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectSearchModule
implements SearchModule {
    private static Logger log = LoggerFactory.getLogger(DirectSearchModule.class);

    @Override
    public List<com.openkm.bean.QueryResult> findByContent(String token, String words) throws IOException, ParseException, RepositoryException, DatabaseException {
        log.debug("findByContent({}, {})", (Object)token, (Object)words);
        QueryParams params = new QueryParams();
        params.setContent(words);
        List<com.openkm.bean.QueryResult> ret = this.find(token, params);
        log.debug("findByContent: {}", ret);
        return ret;
    }

    @Override
    public List<com.openkm.bean.QueryResult> findByName(String token, String words) throws IOException, ParseException, RepositoryException, DatabaseException {
        log.debug("findByName({}, {})", (Object)token, (Object)words);
        QueryParams params = new QueryParams();
        params.setName(words);
        List<com.openkm.bean.QueryResult> ret = this.find(token, params);
        log.debug("findByName: {}", ret);
        return ret;
    }

    @Override
    public List<com.openkm.bean.QueryResult> findByKeywords(String token, Set<String> words) throws IOException, ParseException, RepositoryException, DatabaseException {
        log.debug("findByKeywords({}, {})", (Object)token, words);
        QueryParams params = new QueryParams();
        params.setKeywords(words);
        List<com.openkm.bean.QueryResult> ret = this.find(token, params);
        log.debug("findByKeywords: {}", ret);
        return ret;
    }

    @Override
    public List<com.openkm.bean.QueryResult> find(String token, QueryParams params) throws IOException, ParseException, RepositoryException, DatabaseException {
        log.debug("find({}, {})", (Object)token, (Object)params);
        List<com.openkm.bean.QueryResult> ret = this.findPaginated(token, params, 0, Config.MAX_SEARCH_RESULTS).getResults();
        log.debug("find: {}", ret);
        return ret;
    }

    @Override
    public long findCount(String token, QueryParams params) throws IOException, ParseException, RepositoryException, DatabaseException {
        log.debug("findCount({}, {})", (Object)token, (Object)params);
        String type = null;
        String query = null;
        if (!"".equals(params.getStatementQuery()) && ("xpath".equals(params.getStatementType()) || "sql".equals(params.getStatementType()))) {
            query = params.getStatementQuery();
            type = params.getStatementType();
        } else {
            query = this.prepareStatement(params);
            type = "xpath";
        }
        long count = this.findByStatementCount(token, query, type);
        log.debug("findCount: {}", (Object)count);
        return count;
    }

    private long findByStatementCount(String token, String statement, String type) throws RepositoryException, DatabaseException {
        long count = 0L;
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            if (statement != null && !statement.equals("")) {
                Workspace workspace = session.getWorkspace();
                QueryManager queryManager = workspace.getQueryManager();
                Query query = queryManager.createQuery(statement, type);
                count = this.executeQueryCount(session, query);
            }
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        return count;
    }

    private long executeQueryCount(Session session, Query query) throws RepositoryException {
        long count = 0L;
        try {
            count = DirectSearchModule.executeQueryImplCount(session, (QueryImpl)query);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        return count;
    }

    private static long executeQueryImplCount(Session session, QueryImpl query) throws javax.jcr.RepositoryException {
        QueryResultImpl result = (QueryResultImpl)query.execute();
        return result.getTotalSize();
    }

    @Override
    public ResultSet findPaginated(String token, QueryParams params, int offset, int limit) throws IOException, ParseException, RepositoryException, DatabaseException {
        log.debug("findPaginated({}, {}, {}, {})", new Object[]{token, params, offset, limit});
        String type = null;
        String query = null;
        if (!"".equals(params.getStatementQuery()) && "xpath".equals(params.getStatementType()) | "sql".equals(params.getStatementType())) {
            query = params.getStatementQuery();
            type = params.getStatementType();
        } else {
            query = this.prepareStatement(params);
            type = "xpath";
        }
        ResultSet rs = this.findByStatementPaginated(token, query, type, offset, limit);
        log.debug("findPaginated: {}", (Object)rs);
        return rs;
    }

    private String escapeContains(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '!' || c == '(' || c == ':' || c == '^' || c == '\"' || c == '[' || c == ']' || c == '{' || c == '}' || c == '?') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString().replace("'", "''");
    }

    private String escapeXPath(String str) {
        String ret = str.replace("'", "''");
        return ret;
    }

    public String prepareStatement(QueryParams params) throws IOException, ParseException {
        log.debug("prepareStatement({})", (Object)params);
        StringBuffer sb = new StringBuffer();
        params.setName(params.getName() != null ? params.getName().trim() : "");
        params.setContent(params.getContent() != null ? params.getContent().trim() : "");
        params.setKeywords(params.getKeywords() != null ? params.getKeywords() : new HashSet<String>());
        params.setCategories(params.getCategories() != null ? params.getCategories() : new HashSet<String>());
        params.setMimeType(params.getMimeType() != null ? params.getMimeType().trim() : "");
        params.setAuthor(params.getAuthor() != null ? params.getAuthor().trim() : "");
        params.setPath(params.getPath() != null ? params.getPath().trim() : "");
        params.setMailSubject(params.getMailSubject() != null ? params.getMailSubject().trim() : "");
        params.setMailFrom(params.getMailFrom() != null ? params.getMailFrom().trim() : "");
        params.setMailTo(params.getMailTo() != null ? params.getMailTo().trim() : "");
        params.setProperties(params.getProperties() != null ? params.getProperties() : new HashMap<String, String>());
        boolean document = (params.getDomain() & 1L) != 0L;
        boolean folder = (params.getDomain() & 2L) != 0L;
        boolean mail = (params.getDomain() & 4L) != 0L;
        log.debug("doc={}, fld={}, mail={}", new Object[]{document, folder, mail});
        if (!params.getName().equals("")) {
            params.setName(this.escapeContains(params.getName()));
        }
        if (!params.getContent().equals("")) {
            params.setContent(this.escapeContains(params.getContent()));
        }
        if (!(params.getContent().equals("") && params.getName().equals("") && ((Object)params.getKeywords()).equals("") && params.getMimeType().equals("") && params.getAuthor().equals("") && params.getProperties().isEmpty() && params.getMailSubject().equals("") && params.getMailFrom().equals("") && params.getMailTo().equals("") && (params.getLastModifiedFrom() == null || params.getLastModifiedTo() == null))) {
            sb.append("/jcr:root" + ISO9075.encodePath((String)params.getPath()) + "//*[@jcr:primaryType eq 'okm:void'");
            if (document) {
                Iterator<String> it;
                sb.append(" or (@jcr:primaryType eq 'okm:document'");
                if (!params.getContent().equals("")) {
                    sb.append(" " + params.getOperator() + " ");
                    sb.append("jcr:contains(okm:content,'" + params.getContent() + "')");
                }
                if (!params.getName().equals("")) {
                    sb.append(" " + params.getOperator() + " ");
                    sb.append("jcr:contains(@okm:name,'" + params.getName() + "')");
                }
                if (!params.getKeywords().isEmpty()) {
                    it = params.getKeywords().iterator();
                    while (it.hasNext()) {
                        sb.append(" " + params.getOperator() + " ");
                        sb.append("@okm:keywords='" + this.escapeContains(it.next()) + "'");
                    }
                }
                if (!params.getCategories().isEmpty()) {
                    it = params.getCategories().iterator();
                    while (it.hasNext()) {
                        sb.append(" " + params.getOperator() + " ");
                        sb.append("@okm:categories='" + it.next() + "'");
                    }
                }
                if (!params.getMimeType().equals("")) {
                    sb.append(" " + params.getOperator() + " ");
                    sb.append("@okm:content/jcr:mimeType='" + params.getMimeType() + "'");
                }
                if (!params.getAuthor().equals("")) {
                    sb.append(" " + params.getOperator() + " ");
                    sb.append("@okm:content/okm:author='" + params.getAuthor() + "'");
                }
                if (params.getLastModifiedFrom() != null && params.getLastModifiedTo() != null) {
                    sb.append(" " + params.getOperator() + " ");
                    sb.append("(");
                    sb.append("@okm:content/jcr:lastModified >= xs:dateTime('" + ISO8601.format((Calendar)params.getLastModifiedFrom()) + "')");
                    sb.append(" and ");
                    sb.append("@okm:content/jcr:lastModified <= xs:dateTime('" + ISO8601.format((Calendar)params.getLastModifiedTo()) + "')");
                    sb.append(")");
                }
                sb.append(this.preparePropertyGroups(params));
                sb.append(")");
            }
            if (folder) {
                sb.append(" or (@jcr:primaryType eq 'okm:folder'");
                if (!params.getName().equals("")) {
                    sb.append(" " + params.getOperator() + " ");
                    sb.append("jcr:contains(@okm:name,'" + params.getName() + "')");
                }
                if (params.getLastModifiedFrom() != null && params.getLastModifiedTo() != null) {
                    sb.append(" " + params.getOperator() + " ");
                    sb.append("(");
                    sb.append("@jcr:created >= xs:dateTime('" + ISO8601.format((Calendar)params.getLastModifiedFrom()) + "')");
                    sb.append(" and ");
                    sb.append("@jcr:created <= xs:dateTime('" + ISO8601.format((Calendar)params.getLastModifiedTo()) + "')");
                    sb.append(")");
                }
                sb.append(this.preparePropertyGroups(params));
                sb.append(")");
            }
            if (mail) {
                sb.append(" or (@jcr:primaryType eq 'okm:mail'");
                if (!params.getContent().equals("")) {
                    sb.append(" and jcr:contains(.,'" + params.getContent() + "')");
                }
                if (!params.getMailSubject().equals("")) {
                    sb.append(" " + params.getOperator() + " ");
                    sb.append("jcr:contains(@okm:subject,'" + params.getMailSubject() + "')");
                }
                if (!params.getMailFrom().equals("")) {
                    sb.append(" " + params.getOperator() + " ");
                    sb.append("jcr:contains(@okm:from,'" + params.getMailFrom() + "')");
                }
                if (!params.getMailTo().equals("")) {
                    sb.append(" " + params.getOperator() + " ");
                    sb.append("jcr:contains(@okm:to,'" + params.getMailTo() + "')");
                }
                if (!params.getMimeType().equals("")) {
                    sb.append(" " + params.getOperator() + " ");
                    sb.append("@okm:content/jcr:mimeType='" + params.getMimeType() + "'");
                }
                sb.append(this.preparePropertyGroups(params));
                sb.append(")");
            }
            sb.append("] order by @jcr:score descending");
        }
        log.debug("prepareStatement: {}", (Object)sb.toString());
        return sb.toString();
    }

    private Object preparePropertyGroups(QueryParams params) throws IOException, ParseException {
        StringBuilder sb = new StringBuilder();
        if (!params.getProperties().isEmpty()) {
            Map<PropertyGroup, List<FormElement>> formsElements = FormUtils.parsePropertyGroupsForms(Config.PROPERTY_GROUPS_XML);
            for (Map.Entry<String, String> ent : params.getProperties().entrySet()) {
                String valueTrimmed;
                FormElement fe = FormUtils.getFormElement(formsElements, ent.getKey());
                if (fe == null || ent.getValue() == null || (valueTrimmed = ent.getValue().trim()).equals("")) continue;
                sb.append(" " + params.getOperator() + " ");
                if (fe instanceof Select) {
                    sb.append("@" + ent.getKey() + "='" + this.escapeXPath(valueTrimmed) + "'");
                    continue;
                }
                if (fe instanceof Input && ((Input)fe).getType().equals("date")) {
                    String[] date = valueTrimmed.split(",");
                    if (date.length != 2) continue;
                    sb.append("@" + ent.getKey() + " >= '" + date[0] + "'");
                    sb.append(" and ");
                    sb.append("@" + ent.getKey() + " <= '" + date[1] + "'");
                    continue;
                }
                sb.append("jcr:contains(@" + ent.getKey() + ",'" + this.escapeContains(valueTrimmed) + "')");
            }
        }
        return sb.toString();
    }

    @Override
    public List<com.openkm.bean.QueryResult> findByStatement(String token, String statement, String type) throws RepositoryException, DatabaseException {
        log.debug("findByStatement({}, {})", (Object)token, (Object)statement);
        List<com.openkm.bean.QueryResult> ret = this.findByStatementPaginated(token, statement, type, 0, Config.MAX_SEARCH_RESULTS).getResults();
        log.debug("findByStatement: {}", ret);
        return ret;
    }

    @Override
    public ResultSet findByStatementPaginated(String token, String statement, String type, int offset, int limit) throws RepositoryException, DatabaseException {
        log.debug("findByStatement({}, {}, {}, {}, {})", new Object[]{token, statement, type, offset, limit});
        ResultSet rs = new ResultSet();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            if (statement != null && !statement.equals("")) {
                Workspace workspace = session.getWorkspace();
                QueryManager queryManager = workspace.getQueryManager();
                Query query = queryManager.createQuery(statement, type);
                rs = this.executeQuery(session, query, offset, limit);
            }
            UserActivity.log(session.getUserID(), "FIND_BY_STATEMENT", null, type + ", " + statement);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("findByStatement: {}", (Object)rs);
        return rs;
    }

    private ResultSet executeQuery(Session session, Query query, int offset, int limit) throws RepositoryException {
        log.debug("executeQuery({}, {}, {}, {})", new Object[]{session, query, offset, limit});
        ResultSet rs = new ResultSet();
        ArrayList<com.openkm.bean.QueryResult> al = new ArrayList<com.openkm.bean.QueryResult>();
        try {
            ((QueryImpl)query).setLimit((long)limit);
            ((QueryImpl)query).setOffset((long)offset);
            QueryResultImpl result = (QueryResultImpl)query.execute();
            RowIterator it = result.getRows();
            rs.setTotal(result.getTotalSize());
            while (it.hasNext()) {
                Row row = it.nextRow();
                try {
                    com.openkm.bean.QueryResult qr;
                    block13: {
                        String path = row.getValue("jcr:path").getString();
                        Node node = session.getRootNode().getNode(path.substring(1));
                        qr = new com.openkm.bean.QueryResult();
                        if (node.isNodeType("okm:document")) {
                            Document doc = BaseDocumentModule.getProperties(session, node);
                            try {
                                if (node.getParent().isNodeType("okm:mail")) {
                                    qr.setAttachment(doc);
                                    break block13;
                                }
                                qr.setDocument(doc);
                            }
                            catch (AccessDeniedException e) {
                                qr.setDocument(doc);
                            }
                        } else if (node.isNodeType("okm:folder")) {
                            Folder fld = BaseFolderModule.getProperties(session, node);
                            qr.setFolder(fld);
                        } else if (node.isNodeType("okm:mail")) {
                            Mail mail = BaseMailModule.getProperties(session, node);
                            qr.setMail(mail);
                        }
                    }
                    qr.setScore(row.getValue("jcr:score").getLong());
                    al.add(qr);
                }
                catch (PathNotFoundException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                rs.setResults(al);
            }
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        log.debug("executeQuery: {}", (Object)rs);
        return rs;
    }

    @Override
    public int saveSearch(String token, QueryParams params) throws com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("saveSearch({}, {})", (Object)token, (Object)params);
        Session session = null;
        int id = 0;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            params.setUser(session.getUserID());
            id = QueryParamsDAO.create(params);
            UserActivity.log(session.getUserID(), "SAVE_SEARCH", params.getName(), params.toString());
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (DatabaseException e) {
            throw e;
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("saveSearch: {}", (Object)id);
        return id;
    }

    @Override
    public void updateSearch(String token, QueryParams params) throws com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("updateSearch({}, {})", (Object)token, (Object)params);
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            params.setUser(session.getUserID());
            QueryParamsDAO.update(params);
            UserActivity.log(session.getUserID(), "UPDATE_SEARCH", params.getName(), params.toString());
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (DatabaseException e) {
            throw e;
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("updateSearch: void");
    }

    @Override
    public QueryParams getSearch(String token, int qpId) throws com.openkm.core.PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getSearch({}, {})", (Object)token, (Object)qpId);
        QueryParams qp = new QueryParams();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            qp = QueryParamsDAO.findByPk(qpId);
            if (qp.isDashboard()) {
                qp.setLastModifiedFrom(null);
                qp.setLastModifiedTo(null);
            }
            UserActivity.log(session.getUserID(), "GET_SAVED_SEARCH", Integer.toString(qpId), qp.toString());
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new com.openkm.core.PathNotFoundException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getSearch: {}", (Object)qp);
        return qp;
    }

    @Override
    public List<QueryParams> getAllSearchs(String token) throws RepositoryException, DatabaseException {
        log.debug("getAllSearchs({})", (Object)token);
        ArrayList<QueryParams> ret = new ArrayList<QueryParams>();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            List<QueryParams> qParams = QueryParamsDAO.findByUser(session.getUserID());
            for (QueryParams qp : qParams) {
                if (qp.isDashboard()) continue;
                ret.add(qp);
            }
            UserActivity.log(session.getUserID(), "GET_ALL_SEARCHS", null, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (DatabaseException e) {
            throw e;
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getAllSearchs: {}", ret);
        return ret;
    }

    @Override
    public void deleteSearch(String token, int qpId) throws com.openkm.core.AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("deleteSearch({}, {})", (Object)token, (Object)qpId);
        Session session = null;
        if (Config.SYSTEM_READONLY) {
            throw new com.openkm.core.AccessDeniedException("System is in read-only mode");
        }
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            QueryParams qp = QueryParamsDAO.findByPk(qpId);
            QueryParamsDAO.delete(qpId);
            if (qp.isDashboard()) {
                DashboardDAO.deleteVisitedNodes(session.getUserID(), qp.getName());
            }
            UserActivity.log(session.getUserID(), "DELETE_SAVED_SEARCH", Integer.toString(qpId), null);
        }
        catch (DatabaseException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("deleteSearch: void");
    }

    @Override
    public Map<String, Integer> getKeywordMap(String token, List<String> filter) throws RepositoryException, DatabaseException {
        log.debug("getKeywordMap({}, {})", (Object)token, filter);
        Map<String, Integer> cloud = null;
        cloud = Config.USER_KEYWORDS_CACHE ? this.getKeywordMapCached(token, filter) : this.getKeywordMapLive(token, filter);
        log.debug("getKeywordMap: {}", cloud);
        return cloud;
    }

    private Map<String, Integer> getKeywordMapLive(String token, List<String> filter) throws RepositoryException, DatabaseException {
        HashMap<String, Integer> cloud = new HashMap<String, Integer>();
        if (!Config.KEY_WORD_MAP_SEARCH) {
            log.debug("Keyword map search is disabled");
            return cloud;
        }
        log.debug("getKeywordMapLive({}, {})", (Object)token, filter);
        String statement = "/jcr:root//element(*,okm:document)";
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Workspace workspace = session.getWorkspace();
            QueryManager queryManager = workspace.getQueryManager();
            Query query = queryManager.createQuery(statement, "xpath");
            QueryResult qResult = query.execute();
            NodeIterator nit = qResult.getNodes();
            while (nit.hasNext()) {
                Node doc = nit.nextNode();
                Value[] keywordsValue = doc.getProperty("okm:keywords").getValues();
                ArrayList<String> keywordCollection = new ArrayList<String>();
                for (int i = 0; i < keywordsValue.length; ++i) {
                    keywordCollection.add(keywordsValue[i].getString());
                }
                if (filter == null || !keywordCollection.containsAll(filter)) continue;
                for (String keyword : keywordCollection) {
                    if (filter.contains(keyword)) continue;
                    Integer occurs = cloud.get(keyword) != null ? cloud.get(keyword) : 0;
                    cloud.put(keyword, occurs + 1);
                }
            }
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getKeywordMapLive: {}", cloud);
        return cloud;
    }

    private Map<String, Integer> getKeywordMapCached(String token, List<String> filter) throws RepositoryException, DatabaseException {
        log.debug("getKeywordMapCached({}, {})", (Object)token, filter);
        HashMap<String, Integer> keywordMap = new HashMap<String, Integer>();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Collection<UserDocumentKeywords> userDocKeywords = UserDocumentKeywordsManager.get(session.getUserID()).values();
            Iterator<UserDocumentKeywords> kwIt = userDocKeywords.iterator();
            while (kwIt.hasNext()) {
                Set<String> docKeywords = kwIt.next().getKeywords();
                if (filter == null || !docKeywords.containsAll(filter)) continue;
                for (String keyword : docKeywords) {
                    if (filter.contains(keyword)) continue;
                    Integer occurs = keywordMap.get(keyword) != null ? keywordMap.get(keyword) : 0;
                    keywordMap.put(keyword, occurs + 1);
                }
            }
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getKeywordMapCached: {}", keywordMap);
        return keywordMap;
    }

    @Override
    public List<Document> getCategorizedDocuments(String token, String categoryId) throws RepositoryException, DatabaseException {
        log.debug("getCategorizedDocuments({}, {})", (Object)token, (Object)categoryId);
        ArrayList<Document> documents = new ArrayList<Document>();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node category = session.getNodeByUUID(categoryId);
            PropertyIterator it = category.getReferences();
            while (it.hasNext()) {
                Property refProp = it.nextProperty();
                if (!"okm:categories".equals(refProp.getName())) continue;
                Node node = refProp.getParent();
                Document doc = BaseDocumentModule.getProperties(session, node);
                documents.add(doc);
            }
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getCategorizedDocuments: {}", documents);
        return documents;
    }
}

