/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.module.direct;

import com.openkm.bean.StatsInfo;
import com.openkm.core.DatabaseException;
import com.openkm.core.JcrSessionManager;
import com.openkm.core.RepositoryException;
import com.openkm.jcr.JCRUtils;
import com.openkm.module.StatsModule;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectStatsModule
implements StatsModule {
    private static Logger log = LoggerFactory.getLogger(DirectStatsModule.class);
    private static String TAXONOMY_DOCUMENTS = "/jcr:root/okm:root//element(*,okm:document)";
    private static String TAXONOMY_FOLDERS = "/jcr:root/okm:root//element(*,okm:folder)";
    private static String TEMPLATES_DOCUMENTS = "/jcr:root/okm:templates//element(*,okm:document)";
    private static String TEMPLATES_FOLDERS = "/jcr:root/okm:templates//element(*,okm:folder)";
    private static String PERSONAL_DOCUMENTS = "/jcr:root/okm:personal//element(*,okm:document)";
    private static String PERSONAL_FOLDERS = "/jcr:root/okm:personal//element(*,okm:folder)";
    private static String TRASH_DOCUMENTS = "/jcr:root/okm:trash//element(*,okm:document)";
    private static String TRASH_FOLDERS = "/jcr:root/okm:trash//element(*,okm:folder)";

    @Override
    public StatsInfo getDocumentsByContext(String token) throws RepositoryException, DatabaseException {
        log.debug("getDocumentsByContext({})", (Object)token);
        StatsInfo si = new StatsInfo();
        double[] percents = new double[4];
        long[] sizes = new long[4];
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Workspace workspace = session.getWorkspace();
            QueryManager queryManager = workspace.getQueryManager();
            long taxonomyDocuments = this.getCount(queryManager, TAXONOMY_DOCUMENTS);
            long personalDocuments = this.getCount(queryManager, PERSONAL_DOCUMENTS);
            long templatesDocuments = this.getCount(queryManager, TEMPLATES_DOCUMENTS);
            long trashDocuments = this.getCount(queryManager, TRASH_DOCUMENTS);
            long totalDocuments = taxonomyDocuments + personalDocuments + templatesDocuments + trashDocuments;
            sizes[0] = taxonomyDocuments;
            sizes[1] = personalDocuments;
            sizes[2] = templatesDocuments;
            sizes[3] = trashDocuments;
            si.setSizes(sizes);
            percents[0] = totalDocuments > 0L ? (double)taxonomyDocuments / (double)totalDocuments : 0.0;
            percents[1] = totalDocuments > 0L ? (double)personalDocuments / (double)totalDocuments : 0.0;
            percents[2] = totalDocuments > 0L ? (double)templatesDocuments / (double)totalDocuments : 0.0;
            percents[3] = totalDocuments > 0L ? (double)trashDocuments / (double)totalDocuments : 0.0;
            si.setPercents(percents);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getDocumentsByContext: {}", (Object)si);
        return si;
    }

    @Override
    public StatsInfo getFoldersByContext(String token) throws RepositoryException, DatabaseException {
        log.debug("getFoldersByContext({})", (Object)token);
        StatsInfo si = new StatsInfo();
        double[] percents = new double[4];
        long[] sizes = new long[4];
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Workspace workspace = session.getWorkspace();
            QueryManager queryManager = workspace.getQueryManager();
            long taxonomyFolders = this.getCount(queryManager, TAXONOMY_FOLDERS);
            long personalFolders = this.getCount(queryManager, PERSONAL_FOLDERS);
            long templatesFolders = this.getCount(queryManager, TEMPLATES_FOLDERS);
            long trashFolders = this.getCount(queryManager, TRASH_FOLDERS);
            long totalFolders = taxonomyFolders + personalFolders + templatesFolders + trashFolders;
            sizes[0] = taxonomyFolders;
            sizes[1] = personalFolders;
            sizes[2] = templatesFolders;
            sizes[3] = trashFolders;
            si.setSizes(sizes);
            percents[0] = totalFolders > 0L ? (double)taxonomyFolders / (double)totalFolders : 0.0;
            percents[1] = totalFolders > 0L ? (double)personalFolders / (double)totalFolders : 0.0;
            percents[2] = totalFolders > 0L ? (double)templatesFolders / (double)totalFolders : 0.0;
            percents[3] = totalFolders > 0L ? (double)trashFolders / (double)totalFolders : 0.0;
            si.setPercents(percents);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getFoldersByContext: {}", (Object)si);
        return si;
    }

    private long getCount(QueryManager queryManager, String statement) throws InvalidQueryException, javax.jcr.RepositoryException {
        Query query = queryManager.createQuery(statement, "xpath");
        QueryResult result = query.execute();
        return result.getRows().getSize();
    }

    @Override
    public StatsInfo getDocumentsSizeByContext(String token) throws RepositoryException, DatabaseException {
        log.debug("getDocumentsSizeByContext({})", (Object)token);
        StatsInfo si = new StatsInfo();
        double[] percents = new double[4];
        long[] sizes = new long[4];
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Workspace workspace = session.getWorkspace();
            QueryManager queryManager = workspace.getQueryManager();
            long taxonomyDocumentSize = this.getSize(queryManager, TAXONOMY_DOCUMENTS);
            long personalDocumentSize = this.getSize(queryManager, PERSONAL_DOCUMENTS);
            long templatesDocumentSize = this.getSize(queryManager, TEMPLATES_DOCUMENTS);
            long trashDocumentSize = this.getSize(queryManager, TRASH_DOCUMENTS);
            long totalDocumentSize = taxonomyDocumentSize + personalDocumentSize + templatesDocumentSize + trashDocumentSize;
            sizes[0] = taxonomyDocumentSize;
            sizes[1] = personalDocumentSize;
            sizes[2] = templatesDocumentSize;
            sizes[3] = trashDocumentSize;
            si.setSizes(sizes);
            percents[0] = totalDocumentSize > 0L ? (double)taxonomyDocumentSize / (double)totalDocumentSize : 0.0;
            percents[1] = totalDocumentSize > 0L ? (double)personalDocumentSize / (double)totalDocumentSize : 0.0;
            percents[2] = totalDocumentSize > 0L ? (double)templatesDocumentSize / (double)totalDocumentSize : 0.0;
            percents[3] = totalDocumentSize > 0L ? (double)trashDocumentSize / (double)totalDocumentSize : 0.0;
            si.setPercents(percents);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getDocumentsSizeByContext: {}", (Object)si);
        return si;
    }

    private long getSize(QueryManager queryManager, String statement) throws InvalidQueryException, javax.jcr.RepositoryException {
        Query query = queryManager.createQuery(statement, "xpath");
        QueryResult result = query.execute();
        long size = 0L;
        NodeIterator nit = result.getNodes();
        while (nit.hasNext()) {
            Node docNode = nit.nextNode();
            Node docContentNode = docNode.getNode("okm:content");
            size += docContentNode.getProperty("okm:size").getLong();
        }
        return size;
    }
}

