/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.module.direct;

import com.openkm.bean.form.FormElement;
import com.openkm.bean.workflow.Token;
import com.openkm.core.DatabaseException;
import com.openkm.core.JcrSessionManager;
import com.openkm.core.ParseException;
import com.openkm.core.RepositoryException;
import com.openkm.core.WorkflowException;
import com.openkm.jcr.JCRUtils;
import com.openkm.module.WorkflowModule;
import com.openkm.module.base.BaseWorkflowModule;
import com.openkm.util.FormUtils;
import com.openkm.util.JBPMUtils;
import com.openkm.util.UserActivity;
import com.openkm.util.WorkflowUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.db.GraphSession;
import org.jbpm.db.TaskMgmtSession;
import org.jbpm.file.def.FileDefinition;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.Comment;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectWorkflowModule
implements WorkflowModule {
    private static Logger log = LoggerFactory.getLogger(DirectWorkflowModule.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void registerProcessDefinition(String token, InputStream is) throws ParseException, RepositoryException, WorkflowException, DatabaseException, IOException {
        ZipInputStream zis;
        InputStream isForms;
        JbpmContext jbpmContext;
        block6: {
            log.debug("registerProcessDefinition({}, {})", (Object)token, (Object)is);
            jbpmContext = JBPMUtils.getConfig().createJbpmContext();
            isForms = null;
            zis = null;
            Session session = null;
            try {
                session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
                zis = new ZipInputStream(is);
                ProcessDefinition processDefinition = ProcessDefinition.parseParZipInputStream((ZipInputStream)zis);
                FileDefinition fileDef = processDefinition.getFileDefinition();
                isForms = fileDef.getInputStream("forms.xml");
                FormUtils.parseWorkflowForms(isForms);
                jbpmContext.deployProcessDefinition(processDefinition);
                UserActivity.log(session.getUserID(), "REGISTER_PROCESS_DEFINITION", null, null);
                if (token != null) break block6;
            }
            catch (javax.jcr.RepositoryException e) {
                try {
                    throw new RepositoryException(e.getMessage(), e);
                    catch (JbpmException e2) {
                        throw new WorkflowException(e2.getMessage(), e2);
                    }
                }
                catch (Throwable throwable) {
                    if (token == null) {
                        JCRUtils.logout(session);
                    }
                    IOUtils.closeQuietly(isForms);
                    IOUtils.closeQuietly(zis);
                    jbpmContext.close();
                    throw throwable;
                }
            }
            JCRUtils.logout(session);
        }
        IOUtils.closeQuietly((InputStream)isForms);
        IOUtils.closeQuietly((InputStream)zis);
        jbpmContext.close();
        log.debug("registerProcessDefinition: void");
    }

    @Override
    public void deleteProcessDefinition(String token, long processDefinitionId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("deleteProcessDefinition({}, {})", (Object)token, (Object)processDefinitionId);
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            GraphSession graphSession = jbpmContext.getGraphSession();
            graphSession.deleteProcessDefinition(processDefinitionId);
            jbpmContext.getSession().flush();
            UserActivity.log(session.getUserID(), "DELETE_PROCESS_DEFINITION", "" + processDefinitionId, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("deleteProcessDefinition: void");
    }

    @Override
    public com.openkm.bean.workflow.ProcessDefinition getProcessDefinition(String token, long processDefinitionId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("getProcessDefinition({}, {})", (Object)token, (Object)processDefinitionId);
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        com.openkm.bean.workflow.ProcessDefinition vo = new com.openkm.bean.workflow.ProcessDefinition();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            GraphSession graphSession = jbpmContext.getGraphSession();
            ProcessDefinition pd = graphSession.getProcessDefinition(processDefinitionId);
            vo = WorkflowUtils.copy(pd);
            UserActivity.log(session.getUserID(), "GET_PROCESS_DEFINITION", "" + processDefinitionId, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("getProcessDefinition: {}", (Object)vo);
        return vo;
    }

    @Override
    public byte[] getProcessDefinitionImage(String token, long processDefinitionId, String node) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("getProcessDefinitionImage({}, {}, {})", new Object[]{token, processDefinitionId, node});
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        byte[] image = null;
        Session session = null;
        try {
            int fix;
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            GraphSession graphSession = jbpmContext.getGraphSession();
            ProcessDefinition pd = graphSession.getProcessDefinition(processDefinitionId);
            FileDefinition fileDef = pd.getFileDefinition();
            WorkflowUtils.DiagramInfo dInfo = WorkflowUtils.getDiagramInfo(fileDef.getInputStream("gpd.xml"));
            WorkflowUtils.DiagramNodeInfo dNodeInfo = dInfo.getNodeMap().get(node);
            BufferedImage img = ImageIO.read(fileDef.getInputStream("processimage.jpg"));
            ArrayList<Integer> ordenadas = new ArrayList<Integer>();
            for (WorkflowUtils.DiagramNodeInfo nodeInfo : dInfo.getNodeMap().values()) {
                ordenadas.add(nodeInfo.getY());
            }
            Collections.sort(ordenadas);
            int n = fix = (Integer)ordenadas.get(0) < 0 ? (Integer)ordenadas.get(0) : 0;
            if (dNodeInfo != null) {
                log.debug("DiagramNodeInfo: {}", (Object)dNodeInfo);
                Graphics g = img.getGraphics();
                Graphics2D g2d = (Graphics2D)g;
                g2d.setComposite(AlphaComposite.getInstance(3, 0.25f));
                g2d.setColor(Color.blue);
                g2d.fillRect(dNodeInfo.getX(), dNodeInfo.getY() - fix, dNodeInfo.getWidth(), dNodeInfo.getHeight());
                g.dispose();
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "jpg", baos);
            image = baos.toByteArray();
            baos.flush();
            baos.close();
            UserActivity.log(session.getUserID(), "GET_PROCESS_DEFINITION_IMAGE", "" + processDefinitionId, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("getProcessDefinitionImage: {}", (Object)image);
        return image;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, List<FormElement>> getProcessDefinitionForms(String token, long processDefinitionId) throws ParseException, RepositoryException, DatabaseException, WorkflowException {
        InputStream is;
        HashMap<String, List<FormElement>> forms;
        JbpmContext jbpmContext;
        block9: {
            log.debug("getProcessDefinitionForms({}, {})", (Object)token, (Object)processDefinitionId);
            jbpmContext = JBPMUtils.getConfig().createJbpmContext();
            forms = new HashMap();
            is = null;
            Session session = null;
            try {
                session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
                GraphSession graphSession = jbpmContext.getGraphSession();
                ProcessDefinition pd = graphSession.getProcessDefinition(processDefinitionId);
                FileDefinition fileDef = pd.getFileDefinition();
                is = fileDef.getInputStream("forms.xml");
                if (is != null) {
                    forms = FormUtils.parseWorkflowForms(is);
                    is.close();
                } else {
                    log.warn("Process definition '{}' has no forms.xml file", (Object)processDefinitionId);
                }
                UserActivity.log(session.getUserID(), "GET_PROCESS_DEFINITION_FORMS", processDefinitionId + "", null);
                if (token != null) break block9;
            }
            catch (javax.jcr.RepositoryException e) {
                try {
                    throw new RepositoryException(e.getMessage(), e);
                    catch (JbpmException e2) {
                        throw new WorkflowException(e2.getMessage(), e2);
                    }
                    catch (IOException e3) {
                        throw new WorkflowException(e3.getMessage(), e3);
                    }
                }
                catch (Throwable throwable) {
                    if (token == null) {
                        JCRUtils.logout(session);
                    }
                    IOUtils.closeQuietly(is);
                    jbpmContext.close();
                    throw throwable;
                }
            }
            JCRUtils.logout(session);
        }
        IOUtils.closeQuietly((InputStream)is);
        jbpmContext.close();
        log.debug("getProcessDefinitionForms: {}", forms);
        return forms;
    }

    @Override
    public com.openkm.bean.workflow.ProcessInstance runProcessDefinition(String token, long processDefinitionId, String uuid, List<FormElement> variables) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("runProcessDefinition({}, {}, {})", new Object[]{token, processDefinitionId, variables});
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        com.openkm.bean.workflow.ProcessInstance vo = new com.openkm.bean.workflow.ProcessInstance();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            vo = BaseWorkflowModule.runProcessDefinition(session, jbpmContext, processDefinitionId, uuid, variables);
            UserActivity.log(session.getUserID(), "RUN_PROCESS_DEFINITION", "" + processDefinitionId, variables.toString());
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("runProcessDefinition: {}", (Object)vo);
        return vo;
    }

    @Override
    public com.openkm.bean.workflow.ProcessInstance sendProcessInstanceSignal(String token, long processInstanceId, String transitionName) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("sendProcessInstanceSignal({}, {}, {})", new Object[]{token, processInstanceId, transitionName});
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        com.openkm.bean.workflow.ProcessInstance vo = new com.openkm.bean.workflow.ProcessInstance();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            GraphSession graphSession = jbpmContext.getGraphSession();
            ProcessInstance pi = graphSession.getProcessInstance(processInstanceId);
            org.jbpm.graph.exe.Token t = pi.getRootToken();
            if (transitionName != null && !transitionName.equals("")) {
                t.signal(transitionName);
            } else {
                t.signal();
            }
            jbpmContext.getSession().flush();
            vo = WorkflowUtils.copy(pi);
            UserActivity.log(session.getUserID(), "SEND_PROCESS_INSTANCE_SIGNAL", "" + processInstanceId, transitionName);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("sendProcessInstanceSignal: {}", (Object)vo);
        return vo;
    }

    @Override
    public void endProcessInstance(String token, long processInstanceId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("endProcessInstance({}, {})", (Object)token, (Object)processInstanceId);
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            GraphSession graphSession = jbpmContext.getGraphSession();
            graphSession.getProcessInstance(processInstanceId).end();
            jbpmContext.getSession().flush();
            UserActivity.log(session.getUserID(), "END_PROCESS_INSTANCE", "" + processInstanceId, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("endProcessInstance: void");
    }

    @Override
    public void deleteProcessInstance(String token, long processInstanceId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("deleteProcessInstance({}, {})", (Object)token, (Object)processInstanceId);
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            GraphSession graphSession = jbpmContext.getGraphSession();
            graphSession.deleteProcessInstance(processInstanceId);
            jbpmContext.getSession().flush();
            UserActivity.log(session.getUserID(), "DELETE_PROCESS_INSTANCE", "" + processInstanceId, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("deleteProcessInstance: void");
    }

    @Override
    public List<com.openkm.bean.workflow.ProcessInstance> findProcessInstances(String token, long processDefinitionId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("findProcessInstances({}, {})", (Object)token, (Object)processDefinitionId);
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        ArrayList<com.openkm.bean.workflow.ProcessInstance> al = new ArrayList<com.openkm.bean.workflow.ProcessInstance>();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            GraphSession graphSession = jbpmContext.getGraphSession();
            Iterator it = graphSession.findProcessInstances(processDefinitionId).iterator();
            while (it.hasNext()) {
                al.add(WorkflowUtils.copy((ProcessInstance)it.next()));
            }
            UserActivity.log(session.getUserID(), "FIND_PROCESS_INSTANCES", "" + processDefinitionId, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("findProcessInstances: {}", al);
        return al;
    }

    @Override
    public List<com.openkm.bean.workflow.ProcessDefinition> findAllProcessDefinitions(String token) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("findAllProcessDefinitions({})", (Object)token);
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        ArrayList<com.openkm.bean.workflow.ProcessDefinition> al = new ArrayList<com.openkm.bean.workflow.ProcessDefinition>();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            GraphSession graphSession = jbpmContext.getGraphSession();
            Iterator it = graphSession.findAllProcessDefinitions().iterator();
            while (it.hasNext()) {
                al.add(WorkflowUtils.copy((ProcessDefinition)it.next()));
            }
            UserActivity.log(session.getUserID(), "FIND_ALL_PROCESS_DEFINITIONS", null, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("findAllProcessDefinitions: {}", al);
        return al;
    }

    @Override
    public List<com.openkm.bean.workflow.ProcessDefinition> findLatestProcessDefinitions(String token) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("findLatestProcessDefinitions({})", (Object)token);
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        ArrayList<com.openkm.bean.workflow.ProcessDefinition> al = new ArrayList<com.openkm.bean.workflow.ProcessDefinition>();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            GraphSession graphSession = jbpmContext.getGraphSession();
            Iterator it = graphSession.findLatestProcessDefinitions().iterator();
            while (it.hasNext()) {
                al.add(WorkflowUtils.copy((ProcessDefinition)it.next()));
            }
            UserActivity.log(session.getUserID(), "FIND_LATEST_PROCESS_DEFINITIONS", null, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("findLatestProcessDefinitions: {}", al);
        return al;
    }

    @Override
    public com.openkm.bean.workflow.ProcessDefinition findLastProcessDefinition(String token, String name) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("findLastProcessDefinition({})", (Object)token);
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        com.openkm.bean.workflow.ProcessDefinition pd = new com.openkm.bean.workflow.ProcessDefinition();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            GraphSession graphSession = jbpmContext.getGraphSession();
            for (ProcessDefinition procDef : graphSession.findLatestProcessDefinitions()) {
                if (!procDef.getName().equals(name)) continue;
                pd = WorkflowUtils.copy(procDef);
            }
            UserActivity.log(session.getUserID(), "FIND_LAST_PROCESS_DEFINITION", name, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("findLastProcessDefinition: {}", (Object)pd);
        return pd;
    }

    @Override
    public List<com.openkm.bean.workflow.ProcessDefinition> findAllProcessDefinitionVersions(String token, String name) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("findAllProcessDefinitionVersions({}, {})", (Object)token, (Object)name);
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        ArrayList<com.openkm.bean.workflow.ProcessDefinition> al = new ArrayList<com.openkm.bean.workflow.ProcessDefinition>();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            GraphSession graphSession = jbpmContext.getGraphSession();
            Iterator it = graphSession.findAllProcessDefinitionVersions(name).iterator();
            while (it.hasNext()) {
                al.add(WorkflowUtils.copy((ProcessDefinition)it.next()));
            }
            UserActivity.log(session.getUserID(), "FIND_ALL_PROCESS_DEFINITION_VERSIONS", name, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("findAllProcessDefinitionVersions: {}", al);
        return al;
    }

    @Override
    public com.openkm.bean.workflow.ProcessInstance getProcessInstance(String token, long processInstanceId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("getProcessInstance({}, {})", (Object)token, (Object)processInstanceId);
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        com.openkm.bean.workflow.ProcessInstance vo = new com.openkm.bean.workflow.ProcessInstance();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            GraphSession graphSession = jbpmContext.getGraphSession();
            ProcessInstance pi = graphSession.getProcessInstance(processInstanceId);
            vo = WorkflowUtils.copy(pi);
            UserActivity.log(session.getUserID(), "GET_PROCESS_INSTANCE", "" + processInstanceId, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("getProcessInstance: {}", (Object)vo);
        return vo;
    }

    @Override
    public void suspendProcessInstance(String token, long processInstanceId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("suspendProcessInstance({}, {})", (Object)token, (Object)processInstanceId);
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            ProcessInstance pi = jbpmContext.getProcessInstance(processInstanceId);
            pi.suspend();
            jbpmContext.getSession().flush();
            UserActivity.log(session.getUserID(), "SUSPEND_PROCESS_INSTANCE", "" + processInstanceId, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("suspendProcessInstance: void");
    }

    @Override
    public void resumeProcessInstance(String token, long processInstanceId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("resumeProcessInstance({}, {})", (Object)token, (Object)processInstanceId);
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            ProcessInstance pi = jbpmContext.getProcessInstance(processInstanceId);
            pi.resume();
            jbpmContext.getSession().flush();
            UserActivity.log(session.getUserID(), "RESUME_PROCESS_INSTANCE", "" + processInstanceId, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("resumeProcessInstance: void");
    }

    @Override
    public void addProcessInstanceVariable(String token, long processInstanceId, String name, Object value) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("addProcessInstanceVariable({}, {}, {}, {})", new Object[]{token, processInstanceId, name, value});
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            ProcessInstance pi = jbpmContext.getProcessInstance(processInstanceId);
            pi.getContextInstance().setVariable(name, value);
            jbpmContext.getSession().flush();
            UserActivity.log(session.getUserID(), "ADD_PROCESS_INSTANCE_VARIABLE", "" + processInstanceId, name + ", " + value);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("addProcessInstanceVariable: void");
    }

    @Override
    public void deleteProcessInstanceVariable(String token, long processInstanceId, String name) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("deleteProcessInstanceVariable({}, {}, {})", new Object[]{token, processInstanceId, name});
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            ProcessInstance pi = jbpmContext.getProcessInstance(processInstanceId);
            pi.getContextInstance().deleteVariable(name);
            jbpmContext.getSession().flush();
            UserActivity.log(session.getUserID(), "DELETE_PROCESS_INSTANCE_VARIABLE", "" + processInstanceId, name);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("deleteProcessInstanceVariable: void");
    }

    @Override
    public List<com.openkm.bean.workflow.TaskInstance> findUserTaskInstances(String token) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("findUserTaskInstances({})", (Object)token);
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        ArrayList<com.openkm.bean.workflow.TaskInstance> al = new ArrayList<com.openkm.bean.workflow.TaskInstance>();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            TaskMgmtSession taskMgmtSession = jbpmContext.getTaskMgmtSession();
            for (TaskInstance ti : taskMgmtSession.findTaskInstances(session.getUserID())) {
                al.add(WorkflowUtils.copy(ti));
            }
            Collections.sort(al);
            UserActivity.log(session.getUserID(), "FIND_USER_TASK_INSTANCES", null, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("findUserTaskInstances: {}", al);
        return al;
    }

    @Override
    public List<com.openkm.bean.workflow.TaskInstance> findPooledTaskInstances(String token) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("findPooledTaskInstances({})", (Object)token);
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        ArrayList<com.openkm.bean.workflow.TaskInstance> al = new ArrayList<com.openkm.bean.workflow.TaskInstance>();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            TaskMgmtSession taskMgmtSession = jbpmContext.getTaskMgmtSession();
            for (TaskInstance ti : taskMgmtSession.findPooledTaskInstances(session.getUserID())) {
                al.add(WorkflowUtils.copy(ti));
            }
            Collections.sort(al);
            UserActivity.log(session.getUserID(), "FIND_POOLED_TASK_INSTANCES", null, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("findPooledTaskInstances: {}", al);
        return al;
    }

    @Override
    public List<com.openkm.bean.workflow.TaskInstance> findTaskInstances(String token, long processInstanceId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("findTaskInstances({})", (Object)token);
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        ArrayList<com.openkm.bean.workflow.TaskInstance> al = new ArrayList<com.openkm.bean.workflow.TaskInstance>();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            GraphSession graphSession = jbpmContext.getGraphSession();
            ProcessInstance pi = graphSession.getProcessInstance(processInstanceId);
            TaskMgmtInstance taskMgmtInstance = pi.getTaskMgmtInstance();
            if (taskMgmtInstance.getTaskInstances() != null) {
                for (TaskInstance ti : taskMgmtInstance.getTaskInstances()) {
                    al.add(WorkflowUtils.copy(ti));
                }
            }
            Collections.sort(al);
            UserActivity.log(session.getUserID(), "FIND_TASK_INSTANCES", "" + processInstanceId, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("findTaskInstances: {}", al);
        return al;
    }

    @Override
    public void setTaskInstanceValues(String token, long taskInstanceId, String transitionName, List<FormElement> values) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("setTaskInstanceValues({}, {}, {}, {})", new Object[]{token, taskInstanceId, transitionName, values});
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            TaskMgmtSession taskMgmtSession = jbpmContext.getTaskMgmtSession();
            HashMap<String, FormElement> hm = new HashMap<String, FormElement>();
            for (FormElement fe : values) {
                hm.put(fe.getName(), fe);
            }
            TaskInstance ti = taskMgmtSession.getTaskInstance(taskInstanceId);
            ti.setVariables(hm);
            if (transitionName != null && !transitionName.equals("")) {
                if (ti.getStart() == null) {
                    ti.start();
                }
                ti.end(transitionName);
            } else {
                if (ti.getStart() == null) {
                    ti.start();
                }
                ti.end();
            }
            UserActivity.log(session.getUserID(), "SET_TASK_INSTANCE_VALUES", "" + taskInstanceId, transitionName);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("setTaskInstanceValues: void");
    }

    @Override
    public void addTaskInstanceComment(String token, long taskInstanceId, String message) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("addTaskInstanceComment({}, {}, {})", new Object[]{token, taskInstanceId, message});
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            TaskMgmtSession taskMgmtSession = jbpmContext.getTaskMgmtSession();
            TaskInstance ti = taskMgmtSession.getTaskInstance(taskInstanceId);
            ti.addComment(new Comment(session.getUserID(), message));
            jbpmContext.getSession().flush();
            UserActivity.log(session.getUserID(), "ADD_TASK_INSTANCE_COMMENT", "" + taskInstanceId, message);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("addTaskInstanceComment: void");
    }

    @Override
    public com.openkm.bean.workflow.TaskInstance getTaskInstance(String token, long taskInstanceId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("getTaskInstance({}, {})", (Object)token, (Object)taskInstanceId);
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        com.openkm.bean.workflow.TaskInstance vo = new com.openkm.bean.workflow.TaskInstance();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            TaskMgmtSession taskMgmtSession = jbpmContext.getTaskMgmtSession();
            TaskInstance ti = taskMgmtSession.getTaskInstance(taskInstanceId);
            vo = WorkflowUtils.copy(ti);
            UserActivity.log(session.getUserID(), "GET_TASK_INSTANCE", "" + taskInstanceId, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("getTaskInstance: {}", (Object)vo);
        return vo;
    }

    @Override
    public void setTaskInstanceActorId(String token, long taskInstanceId, String actorId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("setTaskInstanceActorId({}, {}, {})", new Object[]{token, taskInstanceId, actorId});
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            TaskInstance ti = jbpmContext.getTaskInstance(taskInstanceId);
            ti.setActorId(actorId);
            jbpmContext.getSession().flush();
            UserActivity.log(session.getUserID(), "SET_TASK_INSTANCE_ACTOR_ID", "" + taskInstanceId, actorId);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("setTaskInstanceActorId: void");
    }

    @Override
    public void addTaskInstanceVariable(String token, long taskInstanceId, String name, Object value) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("addTaskInstanceVariable({}, {}, {}, {})", new Object[]{token, taskInstanceId, name, value});
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            TaskInstance ti = jbpmContext.getTaskInstance(taskInstanceId);
            ti.setVariable(name, value);
            jbpmContext.getSession().flush();
            UserActivity.log(session.getUserID(), "ADD_TASK_INSTANCE_VARIABLE", "" + taskInstanceId, name + ", " + value);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("addTaskInstanceVariable: void");
    }

    @Override
    public void deleteTaskInstanceVariable(String token, long taskInstanceId, String name) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("deleteTaskInstanceVariable({}, {}, {})", new Object[]{token, taskInstanceId, name});
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            TaskInstance ti = jbpmContext.getTaskInstance(taskInstanceId);
            ti.deleteVariable(name);
            jbpmContext.getSession().flush();
            UserActivity.log(session.getUserID(), "DELETE_TASK_INSTANCE_VARIABLE", "" + taskInstanceId, name);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("deleteTaskInstanceVariable: void");
    }

    @Override
    public void startTaskInstance(String token, long taskInstanceId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("startTaskInstance({}, {})", (Object)token, (Object)taskInstanceId);
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            TaskMgmtSession taskMgmtSession = jbpmContext.getTaskMgmtSession();
            TaskInstance ti = taskMgmtSession.getTaskInstance(taskInstanceId);
            ti.start();
            jbpmContext.getSession().flush();
            UserActivity.log(session.getUserID(), "START_TASK_INSTANCE", "" + taskInstanceId, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("startTaskInstance: void");
    }

    @Override
    public void endTaskInstance(String token, long taskInstanceId, String transitionName) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("endTaskInstance({}, {}, {})", new Object[]{token, taskInstanceId, transitionName});
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            TaskMgmtSession taskMgmtSession = jbpmContext.getTaskMgmtSession();
            TaskInstance ti = taskMgmtSession.getTaskInstance(taskInstanceId);
            if (transitionName != null && !transitionName.equals("")) {
                if (ti.getStart() == null) {
                    ti.start();
                }
                ti.end(transitionName);
            } else {
                if (ti.getStart() == null) {
                    ti.start();
                }
                ti.end();
            }
            jbpmContext.getSession().flush();
            UserActivity.log(session.getUserID(), "END_TASK_INSTANCE", "" + taskInstanceId, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("endTaskInstance: void");
    }

    @Override
    public void suspendTaskInstance(String token, long taskInstanceId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("suspendTaskInstance({}, {})", (Object)token, (Object)taskInstanceId);
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            TaskMgmtSession taskMgmtSession = jbpmContext.getTaskMgmtSession();
            TaskInstance ti = taskMgmtSession.getTaskInstance(taskInstanceId);
            ti.suspend();
            jbpmContext.getSession().flush();
            UserActivity.log(session.getUserID(), "SUSPEND_TASK_INSTANCE", "" + taskInstanceId, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("suspendTaskInstance: void");
    }

    @Override
    public void resumeTaskInstance(String token, long taskInstanceId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("resumeTaskInstance({}, {})", (Object)token, (Object)taskInstanceId);
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            TaskMgmtSession taskMgmtSession = jbpmContext.getTaskMgmtSession();
            TaskInstance ti = taskMgmtSession.getTaskInstance(taskInstanceId);
            ti.resume();
            jbpmContext.getSession().flush();
            UserActivity.log(session.getUserID(), "RESUME_TASK_INSTANCE", "" + taskInstanceId, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("resumeTaskInstance: void");
    }

    @Override
    public Token getToken(String token, long tokenId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("getToken({}, {})", (Object)token, (Object)tokenId);
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        Token vo = new Token();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            org.jbpm.graph.exe.Token t = jbpmContext.getToken(tokenId);
            vo = WorkflowUtils.copy(t);
            vo.setProcessInstance(WorkflowUtils.copy(t.getProcessInstance()));
            UserActivity.log(session.getUserID(), "GET_TOKEN", "" + tokenId, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("getToken: " + vo);
        return vo;
    }

    @Override
    public void addTokenComment(String token, long tokenId, String message) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("addTokenComment({}, {}, {})", new Object[]{token, tokenId, message});
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            org.jbpm.graph.exe.Token t = jbpmContext.getToken(tokenId);
            t.addComment(new Comment(session.getUserID(), message));
            jbpmContext.getSession().flush();
            UserActivity.log(session.getUserID(), "ADD_TOKEN_COMMENT", "" + tokenId, message);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("addTokenComment: void");
    }

    @Override
    public void suspendToken(String token, long tokenId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("suspendToken({}, {})", (Object)token, (Object)tokenId);
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            org.jbpm.graph.exe.Token t = jbpmContext.getToken(tokenId);
            t.suspend();
            jbpmContext.getSession().flush();
            UserActivity.log(session.getUserID(), "SUSPEND_TOKEN", "" + tokenId, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("suspendToken: void");
    }

    @Override
    public void resumeToken(String token, long tokenId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("resumeToken({}, {})", (Object)token, (Object)tokenId);
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            org.jbpm.graph.exe.Token t = jbpmContext.getToken(tokenId);
            t.resume();
            jbpmContext.getSession().flush();
            UserActivity.log(session.getUserID(), "RESUME_TOKEN", "" + tokenId, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("resumeToken: void");
    }

    @Override
    public Token sendTokenSignal(String token, long tokenId, String transitionName) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("sendTokenSignal({}, {}, {})", new Object[]{token, tokenId, transitionName});
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        Token vo = new Token();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            org.jbpm.graph.exe.Token t = jbpmContext.getToken(tokenId);
            if (transitionName != null && !transitionName.equals("")) {
                t.signal(transitionName);
            } else {
                t.signal();
            }
            jbpmContext.getSession().flush();
            vo = WorkflowUtils.copy(t);
            vo.setProcessInstance(WorkflowUtils.copy(t.getProcessInstance()));
            UserActivity.log(session.getUserID(), "SEND_TOKEN_SIGNAL", "" + tokenId, transitionName);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("sendTokenSignal: {}", (Object)vo);
        return vo;
    }

    @Override
    public void setTokenNode(String token, long tokenId, String nodeName) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("setTokenNode({}, {}, {})", new Object[]{token, tokenId, nodeName});
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            org.jbpm.graph.exe.Token t = jbpmContext.getToken(tokenId);
            Node node = t.getProcessInstance().getProcessDefinition().getNode(nodeName);
            t.setNode(node);
            jbpmContext.getSession().flush();
            UserActivity.log(session.getUserID(), "SEND_TOKEN_NODE", "" + tokenId, nodeName);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("setTokenNode: void");
    }

    @Override
    public void endToken(String token, long tokenId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("endToken({}, {})", (Object)token, (Object)tokenId);
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        Session session = null;
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            jbpmContext.getToken(tokenId).end();
            jbpmContext.getSession().flush();
            UserActivity.log(session.getUserID(), "END_TOKEN", "" + tokenId, null);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (JbpmException e) {
            throw new WorkflowException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
            jbpmContext.close();
        }
        log.debug("endToken: void");
    }
}

