/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.principal;

import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.dao.AuthDAO;
import com.openkm.dao.bean.Role;
import com.openkm.dao.bean.User;
import com.openkm.principal.PrincipalAdapter;
import com.openkm.principal.PrincipalAdapterException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabasePrincipalAdapter
implements PrincipalAdapter {
    private static Logger log = LoggerFactory.getLogger(DatabasePrincipalAdapter.class);

    @Override
    public List<String> getUsers() throws PrincipalAdapterException {
        log.debug("getUsers()");
        ArrayList<String> list = new ArrayList<String>();
        try {
            List<User> col = AuthDAO.findAllUsers(Config.PRINCIPAL_DATABASE_FILTER_INACTIVE_USERS);
            for (User dbUser : col) {
                list.add(dbUser.getId());
            }
        }
        catch (DatabaseException e) {
            throw new PrincipalAdapterException(e.getMessage(), e);
        }
        log.debug("getUsers: {}", list);
        return list;
    }

    @Override
    public List<String> getRoles() throws PrincipalAdapterException {
        log.debug("getRoles()");
        ArrayList<String> list = new ArrayList<String>();
        try {
            List<Role> col = AuthDAO.findAllRoles();
            for (Role dbRole : col) {
                list.add(dbRole.getId());
            }
        }
        catch (DatabaseException e) {
            throw new PrincipalAdapterException(e.getMessage(), e);
        }
        log.debug("getRoles: {}", list);
        return list;
    }

    @Override
    public List<String> getUsersByRole(String role) throws PrincipalAdapterException {
        log.debug("getUsersByRole({})", (Object)role);
        ArrayList<String> list = new ArrayList<String>();
        try {
            List<User> col = AuthDAO.findUsersByRole(role, true);
            for (User dbUser : col) {
                list.add(dbUser.getId());
            }
        }
        catch (DatabaseException e) {
            throw new PrincipalAdapterException(e.getMessage(), e);
        }
        log.debug("getUsersByRole: {}", list);
        return list;
    }

    @Override
    public List<String> getRolesByUser(String user) throws PrincipalAdapterException {
        log.debug("getRolesByUser({})", (Object)user);
        ArrayList<String> list = new ArrayList<String>();
        try {
            List<Role> col = AuthDAO.findRolesByUser(user, true);
            for (Role dbRole : col) {
                list.add(dbRole.getId());
            }
        }
        catch (DatabaseException e) {
            throw new PrincipalAdapterException(e.getMessage(), e);
        }
        log.debug("getRolesByUser: {}", list);
        return list;
    }

    @Override
    public String getMail(String user) throws PrincipalAdapterException {
        log.debug("getMail({})", (Object)user);
        String mail = null;
        try {
            User usr = AuthDAO.findUserByPk(user);
            if (usr != null && !usr.getEmail().equals("")) {
                mail = usr.getEmail();
            }
        }
        catch (DatabaseException e) {
            throw new PrincipalAdapterException(e.getMessage(), e);
        }
        log.debug("getMail: {}", mail);
        return mail;
    }

    @Override
    public String getName(String user) throws PrincipalAdapterException {
        log.debug("getName({})", (Object)user);
        String name = null;
        try {
            User usr = AuthDAO.findUserByPk(user);
            if (usr != null && !usr.getName().equals("")) {
                name = usr.getName();
            }
        }
        catch (DatabaseException e) {
            throw new PrincipalAdapterException(e.getMessage(), e);
        }
        log.debug("getName: {}", name);
        return name;
    }
}

